/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.ldap.handlers.sasl.cramMD5;

import javax.security.sasl.AuthorizeCallback;
import org.apache.directory.api.ldap.model.constants.AuthenticationLevel;
import org.apache.directory.api.ldap.model.cursor.Cursor;
import org.apache.directory.api.ldap.model.entry.Attribute;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.filter.ExprNode;
import org.apache.directory.api.ldap.model.filter.FilterParser;
import org.apache.directory.api.ldap.model.message.AliasDerefMode;
import org.apache.directory.api.ldap.model.message.BindRequest;
import org.apache.directory.api.ldap.model.message.SearchScope;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.ldap.model.schema.SchemaManager;
import org.apache.directory.server.core.api.CoreSession;
import org.apache.directory.server.core.api.LdapPrincipal;
import org.apache.directory.server.ldap.LdapSession;
import org.apache.directory.server.ldap.handlers.sasl.AbstractSaslCallbackHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CramMd5CallbackHandler
extends AbstractSaslCallbackHandler {
    private static final Logger LOG = LoggerFactory.getLogger(CramMd5CallbackHandler.class);
    private String bindDn;
    private SchemaManager schemaManager;

    public CramMd5CallbackHandler(LdapSession ldapSession, CoreSession adminSession, BindRequest bindRequest) {
        super(adminSession.getDirectoryService(), bindRequest);
        this.ldapSession = ldapSession;
        this.adminSession = adminSession;
        this.schemaManager = adminSession.getDirectoryService().getSchemaManager();
    }

    @Override
    protected Attribute lookupPassword(String username, String realm) {
        try {
            ExprNode filter = FilterParser.parse(this.schemaManager, "(uid=" + username + ")");
            this.bindDn = (String)this.ldapSession.getSaslProperty("userBaseDn");
            Dn baseDn = new Dn(this.bindDn);
            Cursor<Entry> cursor = this.adminSession.search(baseDn, SearchScope.SUBTREE, filter, AliasDerefMode.DEREF_ALWAYS, "userPassword");
            cursor.beforeFirst();
            Entry entry = null;
            while (cursor.next()) {
                entry = cursor.get();
                LdapPrincipal ldapPrincipal = new LdapPrincipal(this.schemaManager, entry.getDn(), AuthenticationLevel.STRONG, entry.get("userPassword").getBytes());
                this.ldapSession.putSaslProperty("saslAuthentUser", ldapPrincipal);
            }
            cursor.close();
            if (entry != null) {
                return entry.get("userPassword");
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    protected void authorize(AuthorizeCallback authorizeCB) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Converted username {} to Dn {}", (Object)this.getUsername(), (Object)this.bindDn);
        }
        this.ldapSession.putSaslProperty("java.naming.security.principal", this.bindDn);
        authorizeCB.setAuthorizedID(this.bindDn);
        authorizeCB.setAuthorized(true);
    }
}

