/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.kerberos.protocol;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import javax.security.auth.kerberos.KerberosPrincipal;
import org.apache.directory.api.ldap.model.constants.Loggers;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.kerberos.kdc.KdcServer;
import org.apache.directory.server.kerberos.kdc.authentication.AuthenticationContext;
import org.apache.directory.server.kerberos.kdc.authentication.AuthenticationService;
import org.apache.directory.server.kerberos.kdc.ticketgrant.TicketGrantingContext;
import org.apache.directory.server.kerberos.kdc.ticketgrant.TicketGrantingService;
import org.apache.directory.server.kerberos.shared.store.PrincipalStore;
import org.apache.directory.shared.kerberos.KerberosMessageType;
import org.apache.directory.shared.kerberos.KerberosTime;
import org.apache.directory.shared.kerberos.components.KdcReq;
import org.apache.directory.shared.kerberos.components.PrincipalName;
import org.apache.directory.shared.kerberos.exceptions.ErrorType;
import org.apache.directory.shared.kerberos.exceptions.KerberosException;
import org.apache.directory.shared.kerberos.messages.KrbError;
import org.apache.mina.core.service.IoHandlerAdapter;
import org.apache.mina.core.session.IdleStatus;
import org.apache.mina.core.session.IoSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KerberosProtocolHandler
extends IoHandlerAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(KerberosProtocolHandler.class);
    private static final Logger LOG_KRB = LoggerFactory.getLogger(Loggers.KERBEROS_LOG.getName());
    private KdcServer kdcServer;
    private PrincipalStore store;
    private static final String CONTEXT_KEY = "context";

    public KerberosProtocolHandler(KdcServer kdcServer, PrincipalStore store) {
        this.kdcServer = kdcServer;
        this.store = store;
    }

    @Override
    public void sessionCreated(IoSession session) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} CREATED:  {}", (Object)session.getRemoteAddress(), (Object)session.getTransportMetadata());
        }
        if (LOG_KRB.isDebugEnabled()) {
            LOG_KRB.debug("{} CREATED:  {}", (Object)session.getRemoteAddress(), (Object)session.getTransportMetadata());
        }
    }

    @Override
    public void sessionOpened(IoSession session) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} OPENED", (Object)session.getRemoteAddress());
        }
        if (LOG_KRB.isDebugEnabled()) {
            LOG_KRB.debug("{} OPENED", (Object)session.getRemoteAddress());
        }
    }

    @Override
    public void sessionClosed(IoSession session) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} CLOSED", (Object)session.getRemoteAddress());
        }
        if (LOG_KRB.isDebugEnabled()) {
            LOG_KRB.debug("{} CLOSED", (Object)session.getRemoteAddress());
        }
    }

    @Override
    public void sessionIdle(IoSession session, IdleStatus status) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} IDLE ({})", (Object)session.getRemoteAddress(), (Object)status);
        }
        if (LOG_KRB.isDebugEnabled()) {
            LOG_KRB.debug("{} IDLE ({})", (Object)session.getRemoteAddress(), (Object)status);
        }
    }

    @Override
    public void exceptionCaught(IoSession session, Throwable cause) {
        LOG.error("{} EXCEPTION", (Object)session.getRemoteAddress(), (Object)cause);
        LOG_KRB.error("{} EXCEPTION", (Object)session.getRemoteAddress(), (Object)cause);
        session.closeNow();
    }

    @Override
    public void messageReceived(IoSession session, Object message) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} RCVD: {}", (Object)session.getRemoteAddress(), message);
        }
        if (LOG_KRB.isDebugEnabled()) {
            LOG_KRB.debug("{} RCVD: {}", (Object)session.getRemoteAddress(), message);
        }
        InetAddress clientAddress = ((InetSocketAddress)session.getRemoteAddress()).getAddress();
        if (!(message instanceof KdcReq)) {
            LOG.error(I18n.err(I18n.ERR_152, ErrorType.KRB_AP_ERR_BADDIRECTION));
            LOG_KRB.error(I18n.err(I18n.ERR_152, ErrorType.KRB_AP_ERR_BADDIRECTION));
            session.write(this.getErrorMessage(this.kdcServer.getConfig().getServicePrincipal(), new KerberosException(ErrorType.KRB_AP_ERR_BADDIRECTION)));
            return;
        }
        KdcReq request = (KdcReq)message;
        KerberosMessageType messageType = request.getMessageType();
        try {
            switch (messageType) {
                case AS_REQ: {
                    AuthenticationContext authContext = new AuthenticationContext();
                    authContext.setConfig(this.kdcServer.getConfig());
                    authContext.setStore(this.store);
                    if (request.getKdcReqBody().getAddresses() != null) {
                        authContext.setClientAddress(clientAddress);
                    }
                    authContext.setRequest(request);
                    session.setAttribute(CONTEXT_KEY, authContext);
                    AuthenticationService.execute(authContext);
                    LOG_KRB.debug("AuthenticationContext for AS_REQ : \n{}", (Object)authContext);
                    session.write(authContext.getReply());
                    break;
                }
                case TGS_REQ: {
                    TicketGrantingContext tgsContext = new TicketGrantingContext();
                    tgsContext.setConfig(this.kdcServer.getConfig());
                    tgsContext.setReplayCache(this.kdcServer.getReplayCache());
                    tgsContext.setStore(this.store);
                    tgsContext.setClientAddress(clientAddress);
                    tgsContext.setRequest(request);
                    session.setAttribute(CONTEXT_KEY, tgsContext);
                    TicketGrantingService.execute(tgsContext);
                    LOG_KRB.debug("TGSContext for TGS_REQ : \n {}", (Object)tgsContext);
                    session.write(tgsContext.getReply());
                    break;
                }
                case AS_REP: 
                case TGS_REP: {
                    throw new KerberosException(ErrorType.KRB_AP_ERR_BADDIRECTION);
                }
                default: {
                    throw new KerberosException(ErrorType.KRB_AP_ERR_MSG_TYPE);
                }
            }
        }
        catch (KerberosException ke) {
            String messageText = ke.getLocalizedMessage() + " (" + ke.getErrorCode() + ")";
            LOG.warn(messageText);
            LOG_KRB.warn(messageText);
            KrbError error = this.getErrorMessage(this.kdcServer.getConfig().getServicePrincipal(), ke);
            this.logErrorMessage(error);
            session.write(error);
        }
        catch (Exception e) {
            LOG.error(I18n.err(I18n.ERR_152, e.getLocalizedMessage()), e);
            LOG_KRB.error(I18n.err(I18n.ERR_152, e.getLocalizedMessage()), e);
            session.write(this.getErrorMessage(this.kdcServer.getConfig().getServicePrincipal(), new KerberosException(ErrorType.KDC_ERR_SVC_UNAVAILABLE)));
        }
    }

    @Override
    public void messageSent(IoSession session, Object message) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} SENT:  {}", (Object)session.getRemoteAddress(), message);
        }
        if (LOG_KRB.isDebugEnabled()) {
            LOG_KRB.debug("{} SENT:  {}", (Object)session.getRemoteAddress(), message);
        }
    }

    protected KrbError getErrorMessage(KerberosPrincipal principal, KerberosException exception) {
        KrbError krbError = new KrbError();
        KerberosTime now = new KerberosTime();
        krbError.setErrorCode(ErrorType.getTypeByValue(exception.getErrorCode()));
        krbError.setEText(exception.getLocalizedMessage());
        krbError.setSName(new PrincipalName(principal));
        krbError.setRealm(principal.getRealm());
        krbError.setSTime(now);
        krbError.setSusec(0);
        krbError.setEData(exception.getExplanatoryData());
        return krbError;
    }

    protected void logErrorMessage(KrbError error) {
        try {
            StringBuilder sb = new StringBuilder();
            sb.append("Responding to request with error:");
            sb.append("\n\texplanatory text:      " + error.getEText());
            sb.append("\n\terror code:            " + error.getErrorCode());
            sb.append("\n\tclientPrincipal:       " + error.getCName()).append("@").append(error.getCRealm());
            sb.append("\n\tclient time:           " + error.getCTime());
            sb.append("\n\tserverPrincipal:       " + error.getSName()).append("@").append(error.getRealm());
            sb.append("\n\tserver time:           " + error.getSTime());
            String message = sb.toString();
            LOG.debug(message);
            LOG_KRB.debug(message);
        }
        catch (Exception e) {
            LOG.error(I18n.err(I18n.ERR_155, new Object[0]), e);
            LOG_KRB.error(I18n.err(I18n.ERR_155, new Object[0]), e);
        }
    }

    @Override
    public void inputClosed(IoSession session) {
        session.closeNow();
    }
}

