/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.partition.impl.btree;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.time.Duration;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.directory.api.ldap.model.cursor.Cursor;
import org.apache.directory.api.ldap.model.cursor.CursorException;
import org.apache.directory.api.ldap.model.entry.Attribute;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.entry.Modification;
import org.apache.directory.api.ldap.model.entry.Value;
import org.apache.directory.api.ldap.model.exception.LdapAliasDereferencingException;
import org.apache.directory.api.ldap.model.exception.LdapAliasException;
import org.apache.directory.api.ldap.model.exception.LdapContextNotEmptyException;
import org.apache.directory.api.ldap.model.exception.LdapEntryAlreadyExistsException;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.exception.LdapInvalidAttributeValueException;
import org.apache.directory.api.ldap.model.exception.LdapNoSuchAttributeException;
import org.apache.directory.api.ldap.model.exception.LdapNoSuchObjectException;
import org.apache.directory.api.ldap.model.exception.LdapOperationErrorException;
import org.apache.directory.api.ldap.model.exception.LdapOtherException;
import org.apache.directory.api.ldap.model.exception.LdapSchemaViolationException;
import org.apache.directory.api.ldap.model.exception.LdapUnwillingToPerformException;
import org.apache.directory.api.ldap.model.message.ResultCodeEnum;
import org.apache.directory.api.ldap.model.name.Ava;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.ldap.model.name.Rdn;
import org.apache.directory.api.ldap.model.schema.AttributeType;
import org.apache.directory.api.ldap.model.schema.MatchingRule;
import org.apache.directory.api.ldap.model.schema.Normalizer;
import org.apache.directory.api.ldap.model.schema.SchemaManager;
import org.apache.directory.api.util.Strings;
import org.apache.directory.api.util.exception.MultiException;
import org.apache.directory.server.core.api.DnFactory;
import org.apache.directory.server.core.api.entry.ClonedServerEntry;
import org.apache.directory.server.core.api.filtering.EntryFilteringCursor;
import org.apache.directory.server.core.api.filtering.EntryFilteringCursorImpl;
import org.apache.directory.server.core.api.interceptor.context.AddOperationContext;
import org.apache.directory.server.core.api.interceptor.context.DeleteOperationContext;
import org.apache.directory.server.core.api.interceptor.context.HasEntryOperationContext;
import org.apache.directory.server.core.api.interceptor.context.LookupOperationContext;
import org.apache.directory.server.core.api.interceptor.context.ModDnAva;
import org.apache.directory.server.core.api.interceptor.context.ModifyOperationContext;
import org.apache.directory.server.core.api.interceptor.context.MoveAndRenameOperationContext;
import org.apache.directory.server.core.api.interceptor.context.MoveOperationContext;
import org.apache.directory.server.core.api.interceptor.context.OperationContext;
import org.apache.directory.server.core.api.interceptor.context.RenameOperationContext;
import org.apache.directory.server.core.api.interceptor.context.SearchOperationContext;
import org.apache.directory.server.core.api.interceptor.context.UnbindOperationContext;
import org.apache.directory.server.core.api.partition.AbstractPartition;
import org.apache.directory.server.core.api.partition.Partition;
import org.apache.directory.server.core.api.partition.PartitionTxn;
import org.apache.directory.server.core.api.partition.PartitionWriteTxn;
import org.apache.directory.server.core.api.partition.Subordinates;
import org.apache.directory.server.core.partition.impl.btree.EntryCursorAdaptor;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.xdbm.Index;
import org.apache.directory.server.xdbm.IndexEntry;
import org.apache.directory.server.xdbm.IndexNotFoundException;
import org.apache.directory.server.xdbm.MasterTable;
import org.apache.directory.server.xdbm.ParentIdAndRdn;
import org.apache.directory.server.xdbm.Store;
import org.apache.directory.server.xdbm.search.Optimizer;
import org.apache.directory.server.xdbm.search.PartitionSearchResult;
import org.apache.directory.server.xdbm.search.SearchEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractBTreePartition
extends AbstractPartition
implements Store {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractBTreePartition.class);
    private SearchEngine searchEngine;
    private Optimizer optimizer;
    protected boolean optimizerEnabled = true;
    public static final int DEFAULT_CACHE_SIZE = 10000;
    protected int cacheSize = 10000;
    protected Cache<String, Dn> aliasCache;
    protected Cache<String, ParentIdAndRdn> piarCache;
    protected AtomicBoolean isSyncOnWrite = new AtomicBoolean(true);
    private volatile String suffixId;
    protected URI partitionPath;
    private Set<Index<?, String>> indexedAttributes;
    protected MasterTable master;
    protected Map<String, Index<?, String>> userIndices = new HashMap();
    protected Map<String, Index<?, String>> systemIndices = new HashMap();
    protected Index<ParentIdAndRdn, String> rdnIdx;
    protected Index<String, String> objectClassIdx;
    protected Index<String, String> presenceIdx;
    protected Index<String, String> entryCsnIdx;
    protected Index<Dn, String> aliasIdx;
    protected Index<String, String> subAliasIdx;
    protected Index<String, String> oneAliasIdx;
    protected Index<String, String> adminRoleIdx;
    protected AttributeType objectClassAT;
    private Normalizer objectClassNormalizer;
    protected AttributeType presenceAT;
    private Normalizer presenceNormalizer;
    protected AttributeType entryCsnAT;
    protected AttributeType entryDnAT;
    protected AttributeType entryUuidAT;
    protected AttributeType aliasedObjectNameAT;
    protected AttributeType administrativeRoleAT;
    protected AttributeType contextCsnAT;
    private Value topOCValue;
    private static final boolean NO_REVERSE = Boolean.FALSE;
    private static final boolean WITH_REVERSE = Boolean.TRUE;
    private static final boolean ADD_CACHE = Boolean.TRUE;
    private static final boolean DEL_CACHE = Boolean.FALSE;
    protected static final boolean ADD_CHILD = true;
    protected static final boolean REMOVE_CHILD = false;
    private ReadWriteLock rwLock;
    private Cache<String, Dn> entryDnCache;
    private Semaphore ctxCsnSemaphore = new Semaphore(1);

    protected AbstractBTreePartition(SchemaManager schemaManager) {
        this.schemaManager = schemaManager;
        this.initInstance();
    }

    protected AbstractBTreePartition(SchemaManager schemaManager, DnFactory dnFactory) {
        this.schemaManager = schemaManager;
        this.dnFactory = dnFactory;
        this.initInstance();
    }

    private void initInstance() {
        this.indexedAttributes = new HashSet();
        this.objectClassAT = this.schemaManager.getAttributeType("objectClass");
        this.objectClassNormalizer = this.objectClassAT.getEquality().getNormalizer();
        this.presenceAT = this.schemaManager.getAttributeType("ApachePresence");
        this.presenceNormalizer = this.presenceAT.getEquality().getNormalizer();
        this.aliasedObjectNameAT = this.schemaManager.getAttributeType("aliasedObjectName");
        this.entryCsnAT = this.schemaManager.getAttributeType("entryCSN");
        this.entryDnAT = this.schemaManager.getAttributeType("entryDN");
        this.entryUuidAT = this.schemaManager.getAttributeType("entryUUID");
        this.administrativeRoleAT = this.schemaManager.getAttributeType("administrativeRole");
        this.contextCsnAT = this.schemaManager.getAttributeType("contextCSN");
        try {
            this.topOCValue = new Value(this.schemaManager.getAttributeType("2.5.4.0"), "2.5.6.0");
        }
        catch (LdapInvalidAttributeValueException ldapInvalidAttributeValueException) {
            // empty catch block
        }
        this.entryDnAT.setRelaxed(true);
    }

    @Override
    public int getCacheSize() {
        return this.cacheSize;
    }

    @Override
    public void setCacheSize(int cacheSize) {
        this.cacheSize = cacheSize;
    }

    public boolean isOptimizerEnabled() {
        return this.optimizerEnabled;
    }

    public void setOptimizerEnabled(boolean optimizerEnabled) {
        this.optimizerEnabled = optimizerEnabled;
    }

    @Override
    public void setPartitionPath(URI partitionPath) {
        this.checkInitialized("partitionPath");
        this.partitionPath = partitionPath;
    }

    @Override
    public boolean isSyncOnWrite() {
        return this.isSyncOnWrite.get();
    }

    @Override
    public void setSyncOnWrite(boolean isSyncOnWrite) {
        this.checkInitialized("syncOnWrite");
        this.isSyncOnWrite.set(isSyncOnWrite);
    }

    protected void setupSystemIndices() throws LdapException {
        Index index;
        if (this.getPresenceIndex() == null) {
            index = this.createSystemIndex("1.3.6.1.4.1.18060.0.4.1.2.3", this.partitionPath, NO_REVERSE);
            this.addIndex(index);
        }
        if (this.getRdnIndex() == null) {
            index = this.createSystemIndex("1.3.6.1.4.1.18060.0.4.1.2.50", this.partitionPath, WITH_REVERSE);
            this.addIndex(index);
        }
        if (this.getAliasIndex() == null) {
            index = this.createSystemIndex("1.3.6.1.4.1.18060.0.4.1.2.7", this.partitionPath, WITH_REVERSE);
            this.addIndex(index);
        }
        if (this.getOneAliasIndex() == null) {
            index = this.createSystemIndex("1.3.6.1.4.1.18060.0.4.1.2.5", this.partitionPath, NO_REVERSE);
            this.addIndex(index);
        }
        if (this.getSubAliasIndex() == null) {
            index = this.createSystemIndex("1.3.6.1.4.1.18060.0.4.1.2.6", this.partitionPath, NO_REVERSE);
            this.addIndex(index);
        }
        if (this.getObjectClassIndex() == null) {
            index = this.createSystemIndex("2.5.4.0", this.partitionPath, NO_REVERSE);
            this.addIndex(index);
        }
        if (this.getEntryCsnIndex() == null) {
            index = this.createSystemIndex("1.3.6.1.4.1.4203.666.1.7", this.partitionPath, NO_REVERSE);
            this.addIndex(index);
        }
        if (this.getAdministrativeRoleIndex() == null) {
            index = this.createSystemIndex("2.5.18.5", this.partitionPath, NO_REVERSE);
            this.addIndex(index);
        }
        for (Map.Entry<String, Index<?, String>> elem : this.systemIndices.entrySet()) {
            Index<?, String> index2 = elem.getValue();
            index2 = this.convertAndInit(index2);
            this.systemIndices.put(elem.getKey(), index2);
        }
        this.rdnIdx = this.systemIndices.get("1.3.6.1.4.1.18060.0.4.1.2.50");
        this.presenceIdx = this.systemIndices.get("1.3.6.1.4.1.18060.0.4.1.2.3");
        this.aliasIdx = this.systemIndices.get("1.3.6.1.4.1.18060.0.4.1.2.7");
        this.oneAliasIdx = this.systemIndices.get("1.3.6.1.4.1.18060.0.4.1.2.5");
        this.subAliasIdx = this.systemIndices.get("1.3.6.1.4.1.18060.0.4.1.2.6");
        this.objectClassIdx = this.systemIndices.get("2.5.4.0");
        this.entryCsnIdx = this.systemIndices.get("1.3.6.1.4.1.4203.666.1.7");
        this.adminRoleIdx = this.systemIndices.get("2.5.18.5");
    }

    protected void setupUserIndices() throws LdapException {
        HashMap tmp = new HashMap();
        for (Map.Entry<String, Index<?, String>> elem : this.userIndices.entrySet()) {
            String oid = elem.getKey();
            AttributeType attributeType = this.schemaManager.lookupAttributeTypeRegistry(oid);
            MatchingRule mr = attributeType.getEquality();
            if (mr != null) {
                Index<?, String> index = elem.getValue();
                index = this.convertAndInit(index);
                tmp.put(oid, index);
                continue;
            }
            LOG.error(I18n.err(I18n.ERR_4, attributeType.getName()));
        }
        this.userIndices = tmp;
    }

    public SearchEngine getSearchEngine() {
        return this.searchEngine;
    }

    protected abstract Index<?, String> convertAndInit(Index<?, String> var1) throws LdapException;

    @Override
    public URI getPartitionPath() {
        return this.partitionPath;
    }

    @Override
    protected void doDestroy(PartitionTxn partitionTxn) throws LdapException {
        LOG.debug("destroy() called on store for {}", (Object)this.suffixDn);
        if (!this.initialized) {
            return;
        }
        this.initialized = false;
        this.aliasCache.invalidateAll();
        this.piarCache.invalidateAll();
        this.entryDnCache.invalidateAll();
        MultiException errors = new MultiException(I18n.err(I18n.ERR_577, new Object[0]));
        for (Index<?, String> index : this.userIndices.values()) {
            try {
                index.close(partitionTxn);
                LOG.debug("Closed {} user index for {} partition.", (Object)index.getAttributeId(), (Object)this.suffixDn);
            }
            catch (Throwable t) {
                LOG.error(I18n.err(I18n.ERR_124, new Object[0]), t);
                errors.addThrowable(t);
            }
        }
        for (Index<?, String> index : this.systemIndices.values()) {
            try {
                index.close(partitionTxn);
                LOG.debug("Closed {} system index for {} partition.", (Object)index.getAttributeId(), (Object)this.suffixDn);
            }
            catch (Throwable t) {
                LOG.error(I18n.err(I18n.ERR_124, new Object[0]), t);
                errors.addThrowable(t);
            }
        }
        try {
            this.master.close(partitionTxn);
            if (LOG.isDebugEnabled()) {
                LOG.debug(I18n.err(I18n.ERR_125, this.suffixDn));
            }
        }
        catch (Throwable t) {
            LOG.error(I18n.err(I18n.ERR_126, new Object[0]), t);
            errors.addThrowable(t);
        }
        if (errors.size() > 0) {
            throw new LdapOtherException(errors.getMessage(), errors);
        }
    }

    @Override
    public void repair() throws LdapException {
        this.doRepair();
    }

    @Override
    protected void doInit() throws LdapException {
        if (this.indexedAttributes != null && !this.indexedAttributes.isEmpty()) {
            for (Index<?, String> index : this.indexedAttributes) {
                this.addIndex(index);
            }
        }
        this.setupSystemIndices();
        this.setupUserIndices();
        this.aliasCache = Caffeine.newBuilder().maximumSize(this.cacheSize).expireAfterAccess(Duration.ofMinutes(20L)).build();
        this.piarCache = Caffeine.newBuilder().maximumSize((long)this.cacheSize * 3L).expireAfterAccess(Duration.ofMinutes(20L)).build();
        this.entryDnCache = Caffeine.newBuilder().maximumSize(this.cacheSize).expireAfterAccess(Duration.ofMinutes(20L)).build();
    }

    private void dumpAllRdnIdx(PartitionTxn partitionTxn) throws LdapException, CursorException, IOException {
        if (LOG.isDebugEnabled()) {
            this.dumpRdnIdx(partitionTxn, Partition.ROOT_ID, "");
            System.out.println("-----------------------------");
        }
    }

    private void dumpRdnIdx(PartitionTxn partitionTxn) throws LdapException, CursorException, IOException {
        if (LOG.isDebugEnabled()) {
            this.dumpRdnIdx(partitionTxn, Partition.ROOT_ID, 1, "");
            System.out.println("-----------------------------");
        }
    }

    public void dumpRdnIdx(PartitionTxn partitionTxn, String id, String tabs) throws LdapException, CursorException, IOException {
        Cursor<IndexEntry<ParentIdAndRdn, String>> cursor = this.rdnIdx.forwardCursor(partitionTxn);
        IndexEntry startingPos = new IndexEntry();
        startingPos.setKey(new ParentIdAndRdn(id, (Rdn[])null));
        cursor.before(startingPos);
        while (cursor.next()) {
            IndexEntry<ParentIdAndRdn, String> entry = cursor.get();
            System.out.println(tabs + entry);
        }
        cursor.close();
    }

    private void dumpRdnIdx(PartitionTxn partitionTxn, String id, int nbSibbling, String tabs) throws LdapException, CursorException, IOException {
        Cursor<IndexEntry<ParentIdAndRdn, String>> cursor = this.rdnIdx.forwardCursor(partitionTxn);
        IndexEntry startingPos = new IndexEntry();
        startingPos.setKey(new ParentIdAndRdn(id, (Rdn[])null));
        cursor.before(startingPos);
        for (int countChildren = 0; cursor.next() && countChildren < nbSibbling; ++countChildren) {
            IndexEntry<ParentIdAndRdn, String> entry = cursor.get();
            System.out.println(tabs + entry);
            int nbChildren = entry.getKey().getNbChildren();
            if (nbChildren <= 0) continue;
            this.dumpRdnIdx(partitionTxn, entry.getId(), nbChildren, tabs + "  ");
        }
        cursor.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ParentIdAndRdn getParentId(PartitionTxn partitionTxn, Dn entryDn) throws LdapException {
        ParentIdAndRdn key;
        if (entryDn.getNormName().equals(this.suffixDn.getNormName())) {
            key = new ParentIdAndRdn(Partition.ROOT_ID, this.suffixDn.getRdns());
        } else {
            String parentId = null;
            Dn parentDn = entryDn.getParent();
            this.lockRead();
            try {
                parentId = this.getEntryId(partitionTxn, parentDn);
            }
            finally {
                this.unlockRead();
            }
            if (parentId == null) {
                return null;
            }
            key = new ParentIdAndRdn(parentId, entryDn.getRdn());
        }
        return key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(AddOperationContext addContext) throws LdapException {
        PartitionTxn partitionTxn = addContext.getTransaction();
        assert (partitionTxn != null);
        assert (partitionTxn instanceof PartitionWriteTxn);
        try {
            Attribute entryCsn;
            Object normalizedOc;
            Attribute objectClass;
            this.setRWLock(addContext);
            Entry entry = ((ClonedServerEntry)addContext.getEntry()).getClonedEntry();
            Dn entryDn = entry.getDn();
            ParentIdAndRdn parentIdAndRdn = this.getParentId(partitionTxn, entryDn);
            if (parentIdAndRdn == null) {
                throw new LdapNoSuchObjectException(I18n.err(I18n.ERR_216_ID_FOR_PARENT_NOT_FOUND, parentIdAndRdn));
            }
            String parentId = parentIdAndRdn.getParentId();
            this.lockRead();
            try {
                if (this.rdnIdx.forwardLookup(partitionTxn, parentIdAndRdn) != null) {
                    throw new LdapEntryAlreadyExistsException(I18n.err(I18n.ERR_250_ENTRY_ALREADY_EXISTS, entryDn.getName()));
                }
            }
            finally {
                this.unlockRead();
            }
            Attribute entryUUID = entry.get(this.entryUuidAT);
            String id = entryUUID == null ? this.master.getNextId(entry) : entryUUID.getString();
            if (entryDn.getNormName().equals(this.suffixDn.getNormName())) {
                this.suffixId = id;
            }
            if ((objectClass = entry.get(this.objectClassAT)) == null) {
                String msg = I18n.err(I18n.ERR_217, entryDn.getName(), entry);
                ResultCodeEnum rc = ResultCodeEnum.OBJECT_CLASS_VIOLATION;
                throw new LdapSchemaViolationException(rc, msg);
            }
            for (Value value : objectClass) {
                if (value.equals(this.topOCValue)) continue;
                normalizedOc = this.objectClassNormalizer.normalize(value.getString());
                this.objectClassIdx.add(partitionTxn, (String)normalizedOc, id);
            }
            if (objectClass.contains("alias")) {
                Attribute aliasAttr = entry.get(this.aliasedObjectNameAT);
                this.addAliasIndices(partitionTxn, id, entryDn, new Dn(this.schemaManager, aliasAttr.getString()));
            }
            if ((entryCsn = entry.get(this.entryCsnAT)) == null) {
                String msg = I18n.err(I18n.ERR_219, entryDn.getName(), entry);
                throw new LdapSchemaViolationException(ResultCodeEnum.OBJECT_CLASS_VIOLATION, msg);
            }
            this.entryCsnIdx.add(partitionTxn, entryCsn.getString(), id);
            if (entry.containsAttribute(this.administrativeRoleAT)) {
                Attribute adminRoles = entry.get(this.administrativeRoleAT);
                normalizedOc = adminRoles.iterator();
                while (normalizedOc.hasNext()) {
                    Value value = (Value)normalizedOc.next();
                    this.adminRoleIdx.add(partitionTxn, value.getString(), id);
                }
                this.presenceIdx.add(partitionTxn, this.administrativeRoleAT.getOid(), id);
            }
            for (Attribute attribute : entry) {
                AttributeType attributeType = attribute.getAttributeType();
                String attributeOid = attributeType.getOid();
                if (!this.hasUserIndexOn(attributeType)) continue;
                Index<?, String> userIndex = this.getUserIndex(attributeType);
                for (Value value : attribute) {
                    String normalized = value.getNormalized();
                    userIndex.add(partitionTxn, normalized, id);
                }
                this.presenceIdx.add(partitionTxn, attributeOid, id);
            }
            entry.put("entryParentId", parentId);
            this.lockWrite();
            try {
                this.rdnIdx.add(partitionTxn, parentIdAndRdn, id);
                this.updatePiarCache(parentIdAndRdn, id, ADD_CACHE);
                if (parentId != Partition.ROOT_ID) {
                    this.updateRdnIdx(partitionTxn, parentId, true, 0);
                }
                entry.removeAttributes(this.entryDnAT);
                Attribute at = entry.get("entryCSN");
                this.setContextCsn(at.getString());
                this.master.put(partitionTxn, id, entry);
            }
            finally {
                this.unlockWrite();
            }
        }
        catch (LdapException le) {
            throw le;
        }
        catch (Exception e) {
            throw new LdapException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Entry delete(DeleteOperationContext deleteContext) throws LdapException {
        PartitionTxn partitionTxn = deleteContext.getTransaction();
        assert (partitionTxn != null);
        assert (partitionTxn instanceof PartitionWriteTxn);
        this.setRWLock(deleteContext);
        Dn dn = deleteContext.getDn();
        String id = null;
        this.lockRead();
        try {
            id = this.getEntryId(partitionTxn, dn);
        }
        finally {
            this.unlockRead();
        }
        if (id == null) {
            throw new LdapNoSuchObjectException(I18n.err(I18n.ERR_699, dn));
        }
        long childCount = this.getChildCount(partitionTxn, id);
        if (childCount > 0L) {
            throw new LdapContextNotEmptyException(I18n.err(I18n.ERR_700, dn));
        }
        Entry deletedEntry = this.delete(partitionTxn, id);
        this.updateCache(deleteContext);
        return deletedEntry;
    }

    protected void updateRdnIdx(PartitionTxn partitionTxn, String parentId, boolean addRemove, int nbDescendant) throws LdapException {
        boolean isFirst = true;
        if (parentId.equals(Partition.ROOT_ID)) {
            return;
        }
        ParentIdAndRdn parent = this.rdnIdx.reverseLookup(partitionTxn, parentId);
        while (parent != null) {
            this.rdnIdx.drop(partitionTxn, parentId);
            if (isFirst) {
                if (addRemove) {
                    parent.setNbChildren(parent.getNbChildren() + 1);
                } else {
                    parent.setNbChildren(parent.getNbChildren() - 1);
                }
                isFirst = false;
            }
            if (addRemove) {
                parent.setNbDescendants(parent.getNbDescendants() + (nbDescendant + 1));
            } else {
                parent.setNbDescendants(parent.getNbDescendants() - (nbDescendant + 1));
            }
            this.rdnIdx.add(partitionTxn, parent, parentId);
            parentId = parent.getParentId();
            parent = this.rdnIdx.reverseLookup(partitionTxn, parentId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Entry delete(PartitionTxn partitionTxn, String id) throws LdapException {
        try {
            Object normalizedOc;
            Entry entry = null;
            this.lockRead();
            try {
                entry = (Entry)this.master.get(partitionTxn, id);
            }
            finally {
                this.unlockRead();
            }
            if (entry == null) {
                throw new LdapNoSuchObjectException("Cannot find an entry for UUID " + id);
            }
            Attribute objectClass = entry.get(this.objectClassAT);
            if (objectClass.contains("alias")) {
                this.dropAliasIndices(partitionTxn, id);
            }
            for (Value value : objectClass) {
                if (value.equals(this.topOCValue)) continue;
                normalizedOc = this.objectClassNormalizer.normalize(value.getString());
                this.objectClassIdx.drop(partitionTxn, (String)normalizedOc, id);
            }
            ParentIdAndRdn parent = this.rdnIdx.reverseLookup(partitionTxn, id);
            this.updateRdnIdx(partitionTxn, parent.getParentId(), false, 0);
            this.entryCsnIdx.drop(partitionTxn, entry.get(this.entryCsnAT).getString(), id);
            if (entry.containsAttribute(this.administrativeRoleAT)) {
                Attribute adminRoles = entry.get(this.administrativeRoleAT);
                normalizedOc = adminRoles.iterator();
                while (normalizedOc.hasNext()) {
                    Value value = (Value)normalizedOc.next();
                    this.adminRoleIdx.drop(partitionTxn, value.getString(), id);
                }
                this.presenceIdx.drop(partitionTxn, this.administrativeRoleAT.getOid(), id);
            }
            for (Attribute attribute : entry) {
                AttributeType attributeType = attribute.getAttributeType();
                String attributeOid = attributeType.getOid();
                if (!this.hasUserIndexOn(attributeType)) continue;
                Index<?, String> userIndex = this.getUserIndex(attributeType);
                for (Value value : attribute) {
                    String normalized = value.getNormalized();
                    userIndex.drop(partitionTxn, normalized, id);
                }
                this.presenceIdx.drop(partitionTxn, attributeOid, id);
            }
            this.lockWrite();
            try {
                this.rdnIdx.drop(partitionTxn, id);
                this.updatePiarCache(parent, id, DEL_CACHE);
                this.entryDnCache.invalidate(id);
                Attribute csn = entry.get(this.entryCsnAT);
                if (csn != null) {
                    this.setContextCsn(csn.getString());
                }
                this.master.remove(partitionTxn, id);
            }
            finally {
                this.unlockWrite();
            }
            if (this.isSyncOnWrite.get()) {
                this.sync();
            }
            return entry;
        }
        catch (Exception e) {
            throw new LdapOperationErrorException(e.getMessage(), e);
        }
    }

    @Override
    public EntryFilteringCursor search(SearchOperationContext searchContext) throws LdapException {
        PartitionTxn partitionTxn = searchContext.getTransaction();
        assert (partitionTxn != null);
        try {
            this.setRWLock(searchContext);
            if (this.ctxCsnChanged && this.getSuffixDn().equals(searchContext.getDn())) {
                try {
                    this.ctxCsnSemaphore.acquire();
                    this.saveContextCsn(partitionTxn);
                    this.ctxCsnChanged = false;
                }
                catch (Exception e) {
                    throw new LdapOperationErrorException(e.getMessage(), e);
                }
                finally {
                    this.ctxCsnSemaphore.release();
                }
            }
            PartitionSearchResult searchResult = this.searchEngine.computeResult(partitionTxn, this.schemaManager, searchContext);
            EntryCursorAdaptor result = new EntryCursorAdaptor(partitionTxn, this, searchResult);
            return new EntryFilteringCursorImpl(result, searchContext, this.schemaManager);
        }
        catch (LdapException le) {
            throw le;
        }
        catch (Exception e) {
            throw new LdapOperationErrorException(e.getMessage(), e);
        }
    }

    @Override
    public Entry lookup(LookupOperationContext lookupContext) throws LdapException {
        PartitionTxn partitionTxn = lookupContext.getTransaction();
        assert (partitionTxn != null);
        try {
            this.setRWLock(lookupContext);
            String id = this.getEntryId(partitionTxn, lookupContext.getDn());
            if (id == null) {
                return null;
            }
            if (this.ctxCsnChanged && this.getSuffixDn().getNormName().equals(lookupContext.getDn().getNormName())) {
                try {
                    this.ctxCsnSemaphore.acquire();
                    this.saveContextCsn(partitionTxn);
                }
                catch (Exception e) {
                    throw new LdapOperationErrorException(e.getMessage(), e);
                }
                finally {
                    this.ctxCsnSemaphore.release();
                }
            }
            return this.fetch(partitionTxn, id, lookupContext.getDn());
        }
        catch (Exception e) {
            throw new LdapOperationErrorException(e.getMessage());
        }
    }

    @Override
    public Entry fetch(PartitionTxn partitionTxn, String id) throws LdapException {
        try {
            this.rwLock.readLock().lock();
            if (id == null) {
                id = "";
            }
            Dn dn = this.buildEntryDn(partitionTxn, id);
            Entry entry = this.fetch(partitionTxn, id, dn);
            return entry;
        }
        catch (Exception e) {
            throw new LdapOperationErrorException(e.getMessage(), e);
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Entry fetch(PartitionTxn partitionTxn, String id, Dn dn) throws LdapException {
        try {
            Entry entry = this.lookupCache(id);
            if (entry != null) {
                entry.setDn(dn);
                entry = new ClonedServerEntry(entry);
                Attribute entryDnAt = entry.get(this.entryDnAT);
                Value dnValue = new Value(this.entryDnAT, dn.getName(), dn.getNormName());
                if (entryDnAt == null) {
                    entry.add(this.entryDnAT, dnValue);
                } else {
                    entryDnAt.clear();
                    entryDnAt.add(dnValue);
                }
                return entry;
            }
            try {
                this.rwLock.readLock().lock();
                entry = (Entry)this.master.get(partitionTxn, id);
            }
            finally {
                this.rwLock.readLock().unlock();
            }
            if (entry != null) {
                entry.setDn(dn);
                this.addToCache(id, entry);
                entry = new ClonedServerEntry(entry);
                if (!entry.containsAttribute(this.entryDnAT)) {
                    entry.add(this.entryDnAT, dn.getName());
                }
                return entry;
            }
            return null;
        }
        catch (Exception e) {
            throw new LdapOperationErrorException(e.getMessage(), e);
        }
    }

    @Override
    public void modify(ModifyOperationContext modifyContext) throws LdapException {
        PartitionTxn partitionTxn = modifyContext.getTransaction();
        assert (partitionTxn != null);
        assert (partitionTxn instanceof PartitionWriteTxn);
        try {
            this.setRWLock(modifyContext);
            Entry modifiedEntry = this.modify(partitionTxn, modifyContext.getDn(), modifyContext.getModItems().toArray(new Modification[0]));
            modifyContext.setAlteredEntry(modifiedEntry);
            this.updateCache(modifyContext);
        }
        catch (Exception e) {
            throw new LdapOperationErrorException(e.getMessage(), e);
        }
    }

    @Override
    public final synchronized Entry modify(PartitionTxn partitionTxn, Dn dn, Modification ... mods) throws LdapException {
        String id = this.getEntryId(partitionTxn, dn);
        Entry entry = (Entry)this.master.get(partitionTxn, id);
        for (Modification mod : mods) {
            Attribute attrMods = mod.getAttribute();
            try {
                switch (mod.getOperation()) {
                    case ADD_ATTRIBUTE: {
                        this.modifyAdd(partitionTxn, id, entry, attrMods);
                        break;
                    }
                    case REMOVE_ATTRIBUTE: {
                        this.modifyRemove(partitionTxn, id, entry, attrMods);
                        break;
                    }
                    case REPLACE_ATTRIBUTE: {
                        this.modifyReplace(partitionTxn, id, entry, attrMods);
                        break;
                    }
                    case INCREMENT_ATTRIBUTE: {
                        this.modifyIncrement(partitionTxn, id, entry, attrMods);
                        break;
                    }
                    default: {
                        throw new LdapException(I18n.err(I18n.ERR_221, new Object[0]));
                    }
                }
            }
            catch (IndexNotFoundException infe) {
                throw new LdapOtherException(infe.getMessage(), infe);
            }
        }
        this.updateCsnIndex(partitionTxn, entry, id);
        entry.removeAttributes(this.entryDnAT);
        this.setContextCsn(entry.get(this.entryCsnAT).getString());
        this.master.put(partitionTxn, id, entry);
        return entry;
    }

    private void modifyAdd(PartitionTxn partitionTxn, String id, Entry entry, Attribute mods) throws LdapException, IndexNotFoundException {
        if (entry instanceof ClonedServerEntry) {
            throw new LdapOtherException(I18n.err(I18n.ERR_215_CANNOT_STORE_CLONED_SERVER_ENTRY, new Object[0]));
        }
        String modsOid = this.schemaManager.getAttributeTypeRegistry().getOidByName(mods.getId());
        String normalizedModsOid = this.presenceNormalizer.normalize(modsOid);
        AttributeType attributeType = mods.getAttributeType();
        if (modsOid.equals("2.5.4.0")) {
            for (Object value : mods) {
                if (((Value)value).equals(this.topOCValue)) continue;
                String normalizedOc = this.objectClassNormalizer.normalize(((Value)value).getString());
                this.objectClassIdx.add(partitionTxn, normalizedOc, id);
            }
        } else if (this.hasUserIndexOn(attributeType)) {
            Iterator userIndex = this.getUserIndex(attributeType);
            if (mods.size() > 0) {
                for (Value value : mods) {
                    String normalized = value.getNormalized();
                    userIndex.add(partitionTxn, normalized, id);
                }
            } else {
                userIndex.add(partitionTxn, null, id);
            }
            if (!this.presenceIdx.forward(partitionTxn, normalizedModsOid, id)) {
                this.presenceIdx.add(partitionTxn, normalizedModsOid, id);
            }
        } else if (modsOid.equals("2.5.18.5")) {
            for (Object value : mods) {
                this.adminRoleIdx.add(partitionTxn, ((Value)value).getString(), id);
            }
            if (!this.presenceIdx.forward(partitionTxn, normalizedModsOid, id)) {
                this.presenceIdx.add(partitionTxn, normalizedModsOid, id);
            }
        }
        if (mods.size() > 0) {
            for (Object value : mods) {
                entry.add(mods.getAttributeType(), new Value[]{value});
            }
        } else if (mods.getAttributeType().getSyntax().isHumanReadable()) {
            entry.add(mods.getAttributeType(), new Value(mods.getAttributeType(), (String)null));
        } else {
            entry.add(mods.getAttributeType(), new Value(mods.getAttributeType(), (byte[])null));
        }
        if (modsOid.equals("2.5.4.1")) {
            Dn ndn = this.getEntryDn(partitionTxn, id);
            this.addAliasIndices(partitionTxn, id, ndn, new Dn(this.schemaManager, mods.getString()));
        }
    }

    private void modifyReplace(PartitionTxn partitionTxn, String id, Entry entry, Attribute mods) throws LdapException, IndexNotFoundException {
        if (entry instanceof ClonedServerEntry) {
            throw new LdapOtherException(I18n.err(I18n.ERR_215_CANNOT_STORE_CLONED_SERVER_ENTRY, new Object[0]));
        }
        String modsOid = this.schemaManager.getAttributeTypeRegistry().getOidByName(mods.getId());
        AttributeType attributeType = mods.getAttributeType();
        if (attributeType.equals(this.objectClassAT)) {
            String normalizedOc;
            for (Value value : entry.get(this.objectClassAT)) {
                if (value.equals(this.topOCValue)) continue;
                normalizedOc = this.objectClassNormalizer.normalize(value.getString());
                this.objectClassIdx.drop(partitionTxn, normalizedOc, id);
            }
            for (Value value : mods) {
                if (value.equals(this.topOCValue)) continue;
                normalizedOc = this.objectClassNormalizer.normalize(value.getString());
                this.objectClassIdx.add(partitionTxn, normalizedOc, id);
            }
        } else if (this.hasUserIndexOn(attributeType)) {
            String normalized;
            Iterator userIndex = this.getUserIndex(attributeType);
            Attribute oldAttribute = entry.get(mods.getAttributeType());
            if (oldAttribute != null) {
                for (Value value : oldAttribute) {
                    normalized = value.getNormalized();
                    userIndex.drop(partitionTxn, normalized, id);
                }
            }
            for (Value value : mods) {
                normalized = value.getNormalized();
                userIndex.add(partitionTxn, normalized, id);
            }
            if (mods.size() == 0) {
                this.presenceIdx.drop(partitionTxn, modsOid, id);
            }
        } else if (attributeType.equals(this.administrativeRoleAT)) {
            for (Value value : entry.get(this.administrativeRoleAT)) {
                if (value.equals(this.topOCValue)) continue;
                String normalizedOc = this.objectClassNormalizer.normalize(value.getString());
                this.objectClassIdx.drop(partitionTxn, normalizedOc, id);
            }
            for (Value value : mods) {
                String valueStr = value.getString();
                if (valueStr.equals(this.topOCValue)) continue;
                this.adminRoleIdx.add(partitionTxn, valueStr, id);
            }
        }
        String aliasAttributeOid = this.schemaManager.getAttributeTypeRegistry().getOidByName("aliasedObjectName");
        if (mods.getAttributeType().equals(this.aliasedObjectNameAT)) {
            this.dropAliasIndices(partitionTxn, id);
        }
        if (mods.size() > 0) {
            entry.put(mods);
        } else {
            entry.remove(mods);
        }
        if (modsOid.equals(aliasAttributeOid) && mods.size() > 0) {
            Dn entryDn = this.getEntryDn(partitionTxn, id);
            this.addAliasIndices(partitionTxn, id, entryDn, new Dn(this.schemaManager, mods.getString()));
        }
    }

    private void modifyIncrement(PartitionTxn partitionTxn, String id, Entry entry, Attribute mods) throws LdapException, IndexNotFoundException {
        Object normalizedOc;
        if (entry instanceof ClonedServerEntry) {
            throw new LdapOtherException(I18n.err(I18n.ERR_215_CANNOT_STORE_CLONED_SERVER_ENTRY, new Object[0]));
        }
        String modsOid = this.schemaManager.getAttributeTypeRegistry().getOidByName(mods.getId());
        AttributeType attributeType = mods.getAttributeType();
        if (attributeType.equals(this.objectClassAT)) {
            for (Value value : entry.get(this.objectClassAT)) {
                if (value.equals(this.topOCValue)) continue;
                normalizedOc = this.objectClassNormalizer.normalize(value.getString());
                this.objectClassIdx.drop(partitionTxn, (String)normalizedOc, id);
            }
            for (Value value : mods) {
                if (value.equals(this.topOCValue)) continue;
                normalizedOc = this.objectClassNormalizer.normalize(value.getString());
                this.objectClassIdx.add(partitionTxn, (String)normalizedOc, id);
            }
        } else if (this.hasUserIndexOn(attributeType)) {
            String normalized;
            Iterator userIndex = this.getUserIndex(attributeType);
            Attribute oldAttribute = entry.get(mods.getAttributeType());
            if (oldAttribute != null) {
                for (Value value : oldAttribute) {
                    normalized = value.getNormalized();
                    userIndex.drop(partitionTxn, normalized, id);
                }
            }
            for (Value value : mods) {
                normalized = value.getNormalized();
                userIndex.add(partitionTxn, normalized, id);
            }
            if (mods.size() == 0) {
                this.presenceIdx.drop(partitionTxn, modsOid, id);
            }
        } else if (attributeType.equals(this.administrativeRoleAT)) {
            for (Value value : entry.get(this.administrativeRoleAT)) {
                if (value.equals(this.topOCValue)) continue;
                normalizedOc = this.objectClassNormalizer.normalize(value.getString());
                this.objectClassIdx.drop(partitionTxn, (String)normalizedOc, id);
            }
            for (Value value : mods) {
                String valueStr = value.getString();
                if (valueStr.equals(this.topOCValue)) continue;
                this.adminRoleIdx.add(partitionTxn, valueStr, id);
            }
        }
        String aliasAttributeOid = this.schemaManager.getAttributeTypeRegistry().getOidByName("aliasedObjectName");
        if (mods.getAttributeType().equals(this.aliasedObjectNameAT)) {
            this.dropAliasIndices(partitionTxn, id);
        }
        Attribute attribute = entry.get(mods.getAttributeType());
        Value[] newValues = new Value[attribute.size()];
        int increment = 1;
        int i = 0;
        if (mods.size() != 0) {
            increment = Integer.parseInt(mods.getString());
        }
        for (Value value : attribute) {
            int intValue = Integer.parseInt(value.getNormalized());
            if (intValue >= Integer.MAX_VALUE - increment) {
                throw new IllegalArgumentException("Increment operation overflow for attribute" + attributeType);
            }
            newValues[i++] = new Value(Integer.toString(intValue + increment));
            attribute.remove(value);
        }
        attribute.add(newValues);
        if (modsOid.equals(aliasAttributeOid) && mods.size() > 0) {
            Dn entryDn = this.getEntryDn(partitionTxn, id);
            this.addAliasIndices(partitionTxn, id, entryDn, new Dn(this.schemaManager, mods.getString()));
        }
    }

    private void modifyRemove(PartitionTxn partitionTxn, String id, Entry entry, Attribute mods) throws LdapException, IndexNotFoundException {
        if (entry instanceof ClonedServerEntry) {
            throw new LdapOtherException(I18n.err(I18n.ERR_215_CANNOT_STORE_CLONED_SERVER_ENTRY, new Object[0]));
        }
        String modsOid = this.schemaManager.getAttributeTypeRegistry().getOidByName(mods.getId());
        AttributeType attributeType = mods.getAttributeType();
        if (attributeType.equals(this.objectClassAT)) {
            if (mods.size() == 0) {
                for (Value value : entry.get(this.objectClassAT)) {
                    if (value.equals(this.topOCValue)) continue;
                    String normalizedOc = this.objectClassNormalizer.normalize(value.getString());
                    this.objectClassIdx.drop(partitionTxn, normalizedOc, id);
                }
            } else {
                for (Value value : mods) {
                    if (value.equals(this.topOCValue)) continue;
                    String normalizedOc = this.objectClassNormalizer.normalize(value.getString());
                    this.objectClassIdx.drop(partitionTxn, normalizedOc, id);
                }
            }
        } else if (this.hasUserIndexOn(attributeType)) {
            Index<?, String> userIndex = this.getUserIndex(attributeType);
            Attribute attribute = entry.get(attributeType).clone();
            int nbValues = 0;
            if (attribute != null) {
                nbValues = attribute.size();
            }
            if (mods.size() == 0) {
                userIndex.drop(partitionTxn, id);
                nbValues = 0;
            } else if (nbValues > 0) {
                for (Value value : mods) {
                    if (attribute.contains(value)) {
                        --nbValues;
                        attribute.remove(value);
                    }
                    String normalized = value.getNormalized();
                    userIndex.drop(partitionTxn, normalized, id);
                }
            }
            if (nbValues == 0) {
                this.presenceIdx.drop(partitionTxn, modsOid, id);
            }
        } else if (modsOid.equals("2.5.18.5")) {
            for (Value value : mods) {
                this.adminRoleIdx.drop(partitionTxn, value.getString(), id);
            }
            if (null == this.adminRoleIdx.reverseLookup(partitionTxn, id)) {
                this.presenceIdx.drop(partitionTxn, modsOid, id);
            }
        }
        if (mods.size() == 0) {
            entry.removeAttributes(mods.getAttributeType());
        } else {
            Attribute entryAttr = entry.get(mods.getAttributeType());
            if (entryAttr != null) {
                for (Value value : mods) {
                    entryAttr.remove(value);
                }
                if (entryAttr.size() == 0) {
                    entry.removeAttributes(entryAttr.getId());
                }
            }
        }
        if (mods.getAttributeType().equals(this.aliasedObjectNameAT)) {
            this.dropAliasIndices(partitionTxn, id);
        }
    }

    @Override
    public void move(MoveOperationContext moveContext) throws LdapException {
        if (moveContext.getNewSuperior().isDescendantOf(moveContext.getDn())) {
            throw new LdapUnwillingToPerformException(ResultCodeEnum.UNWILLING_TO_PERFORM, "cannot place an entry below itself");
        }
        PartitionTxn partitionTxn = moveContext.getTransaction();
        assert (partitionTxn != null);
        assert (partitionTxn instanceof PartitionWriteTxn);
        try {
            this.setRWLock(moveContext);
            Dn oldDn = moveContext.getDn();
            Dn newSuperior = moveContext.getNewSuperior();
            Dn newDn = moveContext.getNewDn();
            Entry modifiedEntry = moveContext.getModifiedEntry();
            this.move(partitionTxn, oldDn, newSuperior, newDn, modifiedEntry);
            this.updateCache(moveContext);
        }
        catch (Exception e) {
            throw new LdapOperationErrorException(e.getMessage(), e);
        }
    }

    @Override
    public final synchronized void move(PartitionTxn partitionTxn, Dn oldDn, Dn newSuperiorDn, Dn newDn, Entry modifiedEntry) throws LdapException {
        String newParentId = this.getEntryId(partitionTxn, newSuperiorDn);
        if (newParentId == null) {
            throw new LdapEntryAlreadyExistsException(I18n.err(I18n.ERR_256_NO_SUCH_OBJECT, newSuperiorDn.getName()));
        }
        String newId = this.getEntryId(partitionTxn, newDn);
        if (newId != null) {
            throw new LdapEntryAlreadyExistsException(I18n.err(I18n.ERR_250_ENTRY_ALREADY_EXISTS, newSuperiorDn.getName()));
        }
        String entryId = this.getEntryId(partitionTxn, oldDn);
        String oldParentId = this.getParentId(partitionTxn, entryId);
        this.dropMovedAliasIndices(partitionTxn, oldDn);
        ParentIdAndRdn movedEntry = this.rdnIdx.reverseLookup(partitionTxn, entryId);
        this.updateRdnIdx(partitionTxn, oldParentId, false, movedEntry.getNbDescendants());
        this.rdnIdx.drop(partitionTxn, entryId);
        this.updatePiarCache(movedEntry, entryId, DEL_CACHE);
        movedEntry.setParentId(newParentId);
        this.rdnIdx.add(partitionTxn, movedEntry, entryId);
        this.updatePiarCache(movedEntry, entryId, ADD_CACHE);
        this.updateRdnIdx(partitionTxn, newParentId, true, movedEntry.getNbDescendants());
        Dn aliasTarget = this.aliasIdx.reverseLookup(partitionTxn, entryId);
        if (null != aliasTarget) {
            if (!aliasTarget.isSchemaAware()) {
                aliasTarget = new Dn(this.schemaManager, aliasTarget);
            }
            this.addAliasIndices(partitionTxn, entryId, this.buildEntryDn(partitionTxn, entryId), aliasTarget);
        }
        if (modifiedEntry == null) {
            modifiedEntry = this.fetch(partitionTxn, entryId);
        }
        modifiedEntry.put("entryParentId", newParentId);
        modifiedEntry.removeAttributes(this.entryDnAT);
        this.entryDnCache.invalidateAll();
        this.setContextCsn(modifiedEntry.get(this.entryCsnAT).getString());
        this.master.put(partitionTxn, entryId, modifiedEntry);
        if (this.isSyncOnWrite.get()) {
            this.sync();
        }
    }

    @Override
    public void moveAndRename(MoveAndRenameOperationContext moveAndRenameContext) throws LdapException {
        if (moveAndRenameContext.getNewSuperiorDn().isDescendantOf(moveAndRenameContext.getDn())) {
            throw new LdapUnwillingToPerformException(ResultCodeEnum.UNWILLING_TO_PERFORM, "cannot place an entry below itself");
        }
        PartitionTxn partitionTxn = moveAndRenameContext.getTransaction();
        assert (partitionTxn != null);
        assert (partitionTxn instanceof PartitionWriteTxn);
        try {
            this.setRWLock(moveAndRenameContext);
            Dn oldDn = moveAndRenameContext.getDn();
            Dn newSuperiorDn = moveAndRenameContext.getNewSuperiorDn();
            Rdn newRdn = moveAndRenameContext.getNewRdn();
            Entry modifiedEntry = moveAndRenameContext.getModifiedEntry();
            Map<String, List<ModDnAva>> modAvas = moveAndRenameContext.getModifiedAvas();
            this.moveAndRename(partitionTxn, oldDn, newSuperiorDn, newRdn, modAvas, modifiedEntry);
            this.updateCache(moveAndRenameContext);
        }
        catch (LdapException le) {
            throw le;
        }
        catch (Exception e) {
            throw new LdapOperationErrorException(e.getMessage(), e);
        }
    }

    @Override
    public void moveAndRename(PartitionTxn partitionTxn, Dn oldDn, Dn newSuperiorDn, Rdn newRdn, Map<String, List<ModDnAva>> modAvas, Entry modifiedEntry) throws LdapException {
        Attribute entryIdAt = modifiedEntry.get("entryUUID");
        String entryId = entryIdAt == null ? this.getEntryId(partitionTxn, modifiedEntry.getDn()) : modifiedEntry.get("entryUUID").getString();
        Attribute oldParentIdAt = modifiedEntry.get("entryParentId");
        String oldParentId = oldParentIdAt == null ? this.getEntryId(partitionTxn, oldDn.getParent()) : oldParentIdAt.getString();
        String newParentId = this.getEntryId(partitionTxn, newSuperiorDn);
        ParentIdAndRdn movedEntry = this.rdnIdx.reverseLookup(partitionTxn, entryId);
        this.rdnIdx.drop(partitionTxn, entryId);
        this.updatePiarCache(movedEntry, entryId, DEL_CACHE);
        this.updateRdnIdx(partitionTxn, oldParentId, false, movedEntry.getNbDescendants());
        this.dropMovedAliasIndices(partitionTxn, oldDn);
        movedEntry.setParentId(newParentId);
        movedEntry.setRdns(newRdn);
        this.rdnIdx.add(partitionTxn, movedEntry, entryId);
        this.updatePiarCache(movedEntry, entryId, ADD_CACHE);
        this.updateRdnIdx(partitionTxn, newParentId, true, movedEntry.getNbDescendants());
        try {
            this.processModifiedAvas(partitionTxn, modAvas, entryId);
        }
        catch (IndexNotFoundException infe) {
            throw new LdapOtherException(infe.getMessage(), infe);
        }
        Dn aliasTarget = this.aliasIdx.reverseLookup(partitionTxn, entryId);
        if (null != aliasTarget) {
            if (!aliasTarget.isSchemaAware()) {
                aliasTarget = new Dn(this.schemaManager, aliasTarget);
            }
            this.addAliasIndices(partitionTxn, entryId, this.buildEntryDn(partitionTxn, entryId), aliasTarget);
        }
        modifiedEntry.removeAttributes(this.entryDnAT);
        modifiedEntry.removeAttributes("1.3.6.1.4.1.18060.0.4.1.2.51");
        modifiedEntry.add("1.3.6.1.4.1.18060.0.4.1.2.51", newParentId);
        this.entryDnCache.invalidateAll();
        this.setContextCsn(modifiedEntry.get(this.entryCsnAT).getString());
        this.master.put(partitionTxn, entryId, modifiedEntry);
    }

    private void processModifiedAvas(PartitionTxn partitionTxn, Map<String, List<ModDnAva>> modAvas, String entryId) throws LdapException, IndexNotFoundException {
        for (List<ModDnAva> modDnAvas : modAvas.values()) {
            ModDnAva modDnAva;
            AttributeType attributeType;
            Iterator<ModDnAva> iterator = modDnAvas.iterator();
            while (iterator.hasNext() && this.hasIndexOn(attributeType = (modDnAva = iterator.next()).getAva().getAttributeType())) {
                Index<?, String> index = this.getUserIndex(attributeType);
                switch (modDnAva.getType()) {
                    case ADD: 
                    case UPDATE_ADD: {
                        index.add(partitionTxn, modDnAva.getAva().getValue().getNormalized(), entryId);
                        if (null != index.reverseLookup(partitionTxn, entryId)) break;
                        this.presenceIdx.add(partitionTxn, attributeType.getOid(), entryId);
                        break;
                    }
                    case DELETE: 
                    case UPDATE_DELETE: {
                        index.drop(partitionTxn, modDnAva.getAva().getValue().getNormalized(), entryId);
                        if (null != index.reverseLookup(partitionTxn, entryId)) break;
                        this.presenceIdx.drop(partitionTxn, attributeType.getOid(), entryId);
                        break;
                    }
                }
            }
        }
    }

    @Override
    public void rename(RenameOperationContext renameContext) throws LdapException {
        PartitionTxn partitionTxn = renameContext.getTransaction();
        assert (partitionTxn != null);
        assert (partitionTxn instanceof PartitionWriteTxn);
        try {
            this.setRWLock(renameContext);
            Dn oldDn = renameContext.getDn();
            Rdn newRdn = renameContext.getNewRdn();
            boolean deleteOldRdn = renameContext.getDeleteOldRdn();
            if (renameContext.getEntry() != null) {
                Entry modifiedEntry = renameContext.getModifiedEntry();
                this.rename(partitionTxn, oldDn, newRdn, deleteOldRdn, modifiedEntry);
            } else {
                this.rename(partitionTxn, oldDn, newRdn, deleteOldRdn, null);
            }
            this.updateCache(renameContext);
        }
        catch (Exception e) {
            throw new LdapOperationErrorException(e.getMessage(), e);
        }
    }

    private void rename(PartitionTxn partitionTxn, String oldId, Rdn newRdn, boolean deleteOldRdn, Entry entry) throws LdapException, IndexNotFoundException {
        String normalized;
        Index<?, String> userIndex;
        if (entry == null) {
            entry = (Entry)this.master.get(partitionTxn, oldId);
        }
        Dn updn = entry.getDn();
        if (!newRdn.isSchemaAware()) {
            newRdn = new Rdn(this.schemaManager, newRdn);
        }
        for (Ava newAtav : newRdn) {
            String newNormType = newAtav.getNormType();
            String newNormValue = newAtav.getValue().getString();
            AttributeType newRdnAttrType = this.schemaManager.lookupAttributeTypeRegistry(newNormType);
            if (newRdnAttrType.isSingleValued() && entry.containsAttribute(newRdnAttrType)) {
                Attribute oldAttribute = entry.get(newRdnAttrType);
                AttributeType oldAttributeType = oldAttribute.getAttributeType();
                entry.removeAttributes(newRdnAttrType);
                if (this.hasUserIndexOn(newRdnAttrType)) {
                    userIndex = this.getUserIndex(newRdnAttrType);
                    normalized = oldAttributeType.getEquality().getNormalizer().normalize(oldAttribute.get().getString());
                    userIndex.drop(partitionTxn, normalized, this.id);
                    if (null == userIndex.reverseLookup(partitionTxn, oldId)) {
                        this.presenceIdx.drop(partitionTxn, newRdnAttrType.getOid(), oldId);
                    }
                }
            }
            if (newRdnAttrType.getSyntax().isHumanReadable()) {
                entry.add(newRdnAttrType, newAtav.getValue().getString());
            } else {
                entry.add(newRdnAttrType, (byte[][])new byte[][]{newAtav.getValue().getBytes()});
            }
            if (!this.hasUserIndexOn(newRdnAttrType)) continue;
            Index<?, String> userIndex2 = this.getUserIndex(newRdnAttrType);
            String normalized2 = newRdnAttrType.getEquality().getNormalizer().normalize(newNormValue);
            userIndex2.add(partitionTxn, normalized2, oldId);
            String normTypeOid = this.presenceNormalizer.normalize(newNormType);
            if (this.presenceIdx.forward(partitionTxn, normTypeOid, oldId)) continue;
            this.presenceIdx.add(partitionTxn, normTypeOid, oldId);
        }
        if (deleteOldRdn) {
            Rdn oldRdn = updn.getRdn();
            for (Ava oldAtav : oldRdn) {
                boolean mustRemove = true;
                for (Ava newAtav : newRdn) {
                    if (!oldAtav.equals(newAtav)) continue;
                    mustRemove = false;
                    break;
                }
                if (!mustRemove) continue;
                String oldNormType = oldAtav.getNormType();
                String oldNormValue = oldAtav.getValue().getString();
                AttributeType oldRdnAttrType = this.schemaManager.lookupAttributeTypeRegistry(oldNormType);
                entry.remove(oldRdnAttrType, oldNormValue);
                if (!this.hasUserIndexOn(oldRdnAttrType)) continue;
                userIndex = this.getUserIndex(oldRdnAttrType);
                normalized = oldRdnAttrType.getEquality().getNormalizer().normalize(oldNormValue);
                userIndex.drop(partitionTxn, normalized, this.id);
                if (null != userIndex.reverseLookup(partitionTxn, oldId)) continue;
                String oldNormTypeOid = this.presenceNormalizer.normalize(oldNormType);
                this.presenceIdx.drop(partitionTxn, oldNormTypeOid, oldId);
            }
        }
        entry.removeAttributes(this.entryDnAT);
        this.setContextCsn(entry.get(this.entryCsnAT).getString());
        this.master.put(partitionTxn, oldId, entry);
    }

    @Override
    public final synchronized void rename(PartitionTxn partitionTxn, Dn dn, Rdn newRdn, boolean deleteOldRdn, Entry entry) throws LdapException {
        String oldId = this.getEntryId(partitionTxn, dn);
        try {
            this.rename(partitionTxn, oldId, newRdn, deleteOldRdn, entry);
        }
        catch (IndexNotFoundException infe) {
            throw new LdapOtherException(infe.getMessage(), infe);
        }
        String parentId = this.getParentId(partitionTxn, oldId);
        ParentIdAndRdn parentIdAndRdn = this.rdnIdx.reverseLookup(partitionTxn, oldId);
        this.rdnIdx.drop(partitionTxn, oldId);
        this.updatePiarCache(parentIdAndRdn, oldId, DEL_CACHE);
        parentIdAndRdn.setParentId(parentId);
        parentIdAndRdn.setRdns(newRdn);
        this.rdnIdx.add(partitionTxn, parentIdAndRdn, oldId);
        this.updatePiarCache(parentIdAndRdn, oldId, ADD_CACHE);
        this.entryDnCache.invalidateAll();
        if (this.isSyncOnWrite.get()) {
            this.sync();
        }
    }

    @Override
    public final void unbind(UnbindOperationContext unbindContext) throws LdapException {
    }

    @Override
    public boolean hasEntry(HasEntryOperationContext entryContext) throws LdapException {
        PartitionTxn partitionTxn = entryContext.getTransaction();
        assert (partitionTxn != null);
        try {
            this.setRWLock(entryContext);
            String id = this.getEntryId(partitionTxn, entryContext.getDn());
            Entry entry = this.fetch(partitionTxn, id, entryContext.getDn());
            return entry != null;
        }
        catch (LdapException e) {
            return false;
        }
    }

    private void updateCsnIndex(PartitionTxn partitionTxn, Entry entry, String id) throws LdapException {
        String entryCsn = entry.get("entryCSN").getString();
        this.entryCsnIdx.drop(partitionTxn, id);
        this.entryCsnIdx.add(partitionTxn, entryCsn, id);
    }

    private void updatePiarCache(ParentIdAndRdn piar, String id, boolean add) {
        if (add == ADD_CACHE) {
            this.piarCache.put(id, piar);
        } else {
            this.piarCache.invalidate(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Dn buildEntryDn(PartitionTxn partitionTxn, String id) throws LdapException {
        String parentId = id;
        String rootId = Partition.ROOT_ID;
        Rdn[] rdnArray = new Rdn[10];
        int pos = 0;
        Dn dn = null;
        try {
            ParentIdAndRdn cur;
            Dn cachedDn;
            this.rwLock.readLock().lock();
            if (this.entryDnCache != null && (cachedDn = this.entryDnCache.getIfPresent(id)) != null) {
                Dn dn2 = cachedDn;
                return dn2;
            }
            do {
                Rdn[] rdns;
                Dn dn3;
                if (this.piarCache != null) {
                    cur = this.piarCache.getIfPresent(parentId);
                    if (cur == null) {
                        cur = this.rdnIdx.reverseLookup(partitionTxn, parentId);
                        if (cur == null) {
                            dn3 = null;
                            return dn3;
                        }
                        this.piarCache.put(parentId, cur);
                    }
                } else {
                    cur = this.rdnIdx.reverseLookup(partitionTxn, parentId);
                    if (cur == null) {
                        dn3 = null;
                        return dn3;
                    }
                }
                for (Rdn rdn : rdns = cur.getRdns()) {
                    if (pos > 0 && pos % 10 == 0) {
                        Rdn[] newRdnArray = new Rdn[pos + 10];
                        System.arraycopy(rdnArray, 0, newRdnArray, 0, pos);
                        rdnArray = newRdnArray;
                    }
                    rdnArray[pos++] = rdn;
                }
            } while (!(parentId = cur.getParentId()).equals(rootId));
            dn = new Dn(this.schemaManager, Arrays.copyOf(rdnArray, pos));
            this.entryDnCache.put(id, dn);
            Dn dn4 = dn;
            return dn4;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    @Override
    public long count(PartitionTxn partitionTxn) throws LdapException {
        return this.master.count(partitionTxn);
    }

    @Override
    public final long getChildCount(PartitionTxn partitionTxn, String id) throws LdapException {
        try {
            ParentIdAndRdn parentIdAndRdn = this.rdnIdx.reverseLookup(partitionTxn, id);
            return parentIdAndRdn.getNbChildren();
        }
        catch (Exception e) {
            throw new LdapOperationErrorException(e.getMessage(), e);
        }
    }

    @Override
    public final Dn getEntryDn(PartitionTxn partitionTxn, String id) throws LdapException {
        return this.buildEntryDn(partitionTxn, id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final String getEntryId(PartitionTxn partitionTxn, Dn dn) throws LdapException {
        if (Dn.isNullOrEmpty(dn)) {
            return Partition.ROOT_ID;
        }
        ParentIdAndRdn suffixKey = new ParentIdAndRdn(Partition.ROOT_ID, this.suffixDn.getRdns());
        try {
            this.rwLock.readLock().lock();
            String currentId = this.rdnIdx.forwardLookup(partitionTxn, suffixKey);
            for (int i = dn.size() - this.suffixDn.size(); i > 0; --i) {
                Rdn rdn = dn.getRdn(i - 1);
                ParentIdAndRdn currentRdn = new ParentIdAndRdn(currentId, rdn);
                if ((currentId = this.rdnIdx.forwardLookup(partitionTxn, currentRdn)) == null) break;
            }
            String string = currentId;
            this.rwLock.readLock().unlock();
            return string;
        }
        catch (Throwable throwable) {
            try {
                this.rwLock.readLock().unlock();
                throw throwable;
            }
            catch (Exception e) {
                throw new LdapException(e.getMessage(), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getParentId(PartitionTxn partitionTxn, String childId) throws LdapException {
        try {
            this.rwLock.readLock().lock();
            ParentIdAndRdn key = this.rdnIdx.reverseLookup(partitionTxn, childId);
            if (key == null) {
                String string = null;
                return string;
            }
            String string = key.getParentId();
            return string;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    @Override
    public String getSuffixId(PartitionTxn partitionTxn) throws LdapException {
        if (this.suffixId == null) {
            ParentIdAndRdn key = new ParentIdAndRdn(Partition.ROOT_ID, this.suffixDn.getRdns());
            try {
                this.rwLock.readLock().lock();
                this.suffixId = this.rdnIdx.forwardLookup(partitionTxn, key);
            }
            finally {
                this.rwLock.readLock().unlock();
            }
        }
        return this.suffixId;
    }

    @Override
    public void addIndex(Index<?, String> index) throws LdapException {
        this.checkInitialized("addIndex");
        AttributeType attributeType = null;
        try {
            attributeType = this.schemaManager.lookupAttributeTypeRegistry(index.getAttributeId());
        }
        catch (LdapNoSuchAttributeException lnsae) {
            LOG.error("Cannot initialize the index for AttributeType {}, this value does not exist", (Object)index.getAttributeId());
            return;
        }
        String oid = attributeType.getOid();
        if (SYS_INDEX_OIDS.contains(oid)) {
            if (!this.systemIndices.containsKey(oid)) {
                this.systemIndices.put(oid, index);
            }
        } else if (!this.userIndices.containsKey(oid)) {
            this.userIndices.put(oid, index);
        }
    }

    public void addIndexedAttributes(Index<?, String> ... indexes) {
        for (Index<?, String> index : indexes) {
            this.indexedAttributes.add(index);
        }
    }

    public void setIndexedAttributes(Set<Index<?, String>> indexedAttributes) {
        this.indexedAttributes = indexedAttributes;
    }

    public Set<Index<?, String>> getIndexedAttributes() {
        return this.indexedAttributes;
    }

    @Override
    public Iterator<String> getUserIndices() {
        return this.userIndices.keySet().iterator();
    }

    @Override
    public Iterator<String> getSystemIndices() {
        return this.systemIndices.keySet().iterator();
    }

    @Override
    public Index<?, String> getIndex(AttributeType attributeType) throws IndexNotFoundException {
        String id = attributeType.getOid();
        if (this.userIndices.containsKey(id)) {
            return this.userIndices.get(id);
        }
        if (this.systemIndices.containsKey(id)) {
            return this.systemIndices.get(id);
        }
        throw new IndexNotFoundException(I18n.err(I18n.ERR_3, id, id));
    }

    @Override
    public Index<?, String> getUserIndex(AttributeType attributeType) throws IndexNotFoundException {
        if (attributeType == null) {
            throw new IndexNotFoundException(I18n.err(I18n.ERR_3, attributeType, attributeType));
        }
        String oid = attributeType.getOid();
        if (this.userIndices.containsKey(oid)) {
            return this.userIndices.get(oid);
        }
        throw new IndexNotFoundException(I18n.err(I18n.ERR_3, attributeType, attributeType));
    }

    @Override
    public Index<?, String> getSystemIndex(AttributeType attributeType) throws IndexNotFoundException {
        if (attributeType == null) {
            throw new IndexNotFoundException(I18n.err(I18n.ERR_2, attributeType, attributeType));
        }
        String oid = attributeType.getOid();
        if (this.systemIndices.containsKey(oid)) {
            return this.systemIndices.get(oid);
        }
        throw new IndexNotFoundException(I18n.err(I18n.ERR_2, attributeType, attributeType));
    }

    @Override
    public Index<Dn, String> getAliasIndex() {
        return this.systemIndices.get("1.3.6.1.4.1.18060.0.4.1.2.7");
    }

    @Override
    public Index<String, String> getOneAliasIndex() {
        return this.systemIndices.get("1.3.6.1.4.1.18060.0.4.1.2.5");
    }

    @Override
    public Index<String, String> getSubAliasIndex() {
        return this.systemIndices.get("1.3.6.1.4.1.18060.0.4.1.2.6");
    }

    @Override
    public Index<String, String> getObjectClassIndex() {
        return this.systemIndices.get("2.5.4.0");
    }

    @Override
    public Index<String, String> getEntryCsnIndex() {
        return this.systemIndices.get("1.3.6.1.4.1.4203.666.1.7");
    }

    public Index<String, String> getAdministrativeRoleIndex() {
        return this.systemIndices.get("2.5.18.5");
    }

    @Override
    public Index<String, String> getPresenceIndex() {
        return this.systemIndices.get("1.3.6.1.4.1.18060.0.4.1.2.3");
    }

    @Override
    public Index<ParentIdAndRdn, String> getRdnIndex() {
        return this.systemIndices.get("1.3.6.1.4.1.18060.0.4.1.2.50");
    }

    @Override
    public boolean hasUserIndexOn(AttributeType attributeType) throws LdapException {
        String oid = attributeType.getOid();
        return this.userIndices.containsKey(oid);
    }

    @Override
    public boolean hasSystemIndexOn(AttributeType attributeType) throws LdapException {
        return this.systemIndices.containsKey(attributeType.getOid());
    }

    @Override
    public boolean hasIndexOn(AttributeType attributeType) throws LdapException {
        return this.hasUserIndexOn(attributeType) || this.hasSystemIndexOn(attributeType);
    }

    protected void addAliasIndices(PartitionTxn partitionTxn, String aliasId, Dn aliasDn, Dn aliasTarget) throws LdapException {
        if (!aliasTarget.isDescendantOf(this.suffixDn)) {
            String msg = I18n.err(I18n.ERR_225, this.suffixDn.getName());
            throw new LdapAliasDereferencingException(msg);
        }
        String targetId = this.getEntryId(partitionTxn, aliasTarget);
        if (null == targetId) {
            String msg = I18n.err(I18n.ERR_581, aliasDn.getName(), aliasTarget);
            throw new LdapAliasException(msg);
        }
        if (null != this.aliasIdx.reverseLookup(partitionTxn, targetId)) {
            String msg = I18n.err(I18n.ERR_227, new Object[0]);
            throw new LdapAliasDereferencingException(msg);
        }
        this.aliasIdx.add(partitionTxn, aliasTarget, aliasId);
        if (this.aliasCache != null) {
            this.aliasCache.put(aliasId, aliasTarget);
        }
        Dn ancestorDn = aliasDn.getParent();
        String ancestorId = this.getEntryId(partitionTxn, ancestorDn);
        Dn normalizedAliasTargetParentDn = aliasTarget.getParent();
        if (!aliasDn.isDescendantOf(normalizedAliasTargetParentDn)) {
            this.oneAliasIdx.add(partitionTxn, ancestorId, targetId);
        }
        while (!ancestorDn.equals(this.suffixDn) && null != ancestorId) {
            if (!aliasTarget.isDescendantOf(ancestorDn)) {
                this.subAliasIdx.add(partitionTxn, ancestorId, targetId);
            }
            ancestorDn = ancestorDn.getParent();
            ancestorId = this.getEntryId(partitionTxn, ancestorDn);
        }
    }

    protected void dropAliasIndices(PartitionTxn partitionTxn, String aliasId) throws LdapException {
        String targetId;
        Dn targetDn = this.aliasIdx.reverseLookup(partitionTxn, aliasId);
        if (!targetDn.isSchemaAware()) {
            targetDn = new Dn(this.schemaManager, targetDn);
        }
        if ((targetId = this.getEntryId(partitionTxn, targetDn)) == null) {
            return;
        }
        Dn aliasDn = this.getEntryDn(partitionTxn, aliasId);
        Dn ancestorDn = aliasDn.getParent();
        String ancestorId = this.getEntryId(partitionTxn, ancestorDn);
        this.oneAliasIdx.drop(partitionTxn, ancestorId, targetId);
        this.subAliasIdx.drop(partitionTxn, ancestorId, targetId);
        while (!ancestorDn.equals(this.suffixDn) && ancestorDn.size() > this.suffixDn.size()) {
            ancestorDn = ancestorDn.getParent();
            ancestorId = this.getEntryId(partitionTxn, ancestorDn);
            this.subAliasIdx.drop(partitionTxn, ancestorId, targetId);
        }
        this.aliasIdx.drop(partitionTxn, aliasId);
        if (this.aliasCache != null) {
            this.aliasCache.invalidate(aliasId);
        }
    }

    protected void dropMovedAliasIndices(PartitionTxn partitionTxn, Dn movedBase) throws LdapException {
        String movedBaseId = this.getEntryId(partitionTxn, movedBase);
        Dn targetDn = this.aliasIdx.reverseLookup(partitionTxn, movedBaseId);
        if (targetDn != null) {
            if (!targetDn.isSchemaAware()) {
                targetDn = new Dn(this.schemaManager, targetDn);
            }
            String targetId = this.getEntryId(partitionTxn, targetDn);
            Dn aliasDn = this.getEntryDn(partitionTxn, movedBaseId);
            Dn ancestorDn = movedBase.getParent();
            String ancestorId = this.getEntryId(partitionTxn, ancestorDn);
            if (aliasDn.equals(movedBase)) {
                this.oneAliasIdx.drop(partitionTxn, ancestorId, targetId);
            }
            this.subAliasIdx.drop(partitionTxn, ancestorId, targetId);
            while (!ancestorDn.equals(this.suffixDn)) {
                ancestorDn = ancestorDn.getParent();
                ancestorId = this.getEntryId(partitionTxn, ancestorDn);
                this.subAliasIdx.drop(partitionTxn, ancestorId, targetId);
            }
        }
    }

    private void dumpIndex(PartitionTxn partitionTxn, OutputStream stream, Index<?, String> index) {
        try {
            Cursor<IndexEntry<?, String>> cursor = index.forwardCursor(partitionTxn);
            while (cursor.next()) {
                IndexEntry<?, String> entry = cursor.get();
                System.out.println(entry);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void dumpIndex(PartitionTxn partitionTxn, OutputStream stream, String name) throws IOException {
        try {
            AttributeType attributeType = this.schemaManager.lookupAttributeTypeRegistry(name);
            if (attributeType == null) {
                stream.write(Strings.getBytesUtf8("Cannot find an index for AttributeType names " + name));
                return;
            }
            if (attributeType.getOid().equals("1.3.6.1.4.1.18060.0.4.1.2.50")) {
                this.dumpIndex(partitionTxn, stream, this.rdnIdx);
            }
        }
        catch (LdapException le) {
            stream.write(Strings.getBytesUtf8("Cannot find an index for AttributeType names " + name));
        }
    }

    public String toString() {
        return "Partition<" + this.id + ">";
    }

    protected abstract Index createSystemIndex(String var1, URI var2, boolean var3) throws LdapException;

    @Override
    public MasterTable getMasterTable() {
        return this.master;
    }

    private void lockRead() {
        this.rwLock.readLock().lock();
    }

    private void unlockRead() {
        this.rwLock.readLock().unlock();
    }

    private void lockWrite() {
        this.rwLock.writeLock().lock();
    }

    private void unlockWrite() {
        this.rwLock.writeLock().unlock();
    }

    public void updateCache(OperationContext opCtx) {
    }

    public Entry lookupCache(String id) {
        return null;
    }

    public void addToCache(String id, Entry entry) {
    }

    public Optimizer getOptimizer() {
        return this.optimizer;
    }

    public void setOptimizer(Optimizer optimizer) {
        this.optimizer = optimizer;
    }

    public void setSearchEngine(SearchEngine searchEngine) {
        this.searchEngine = searchEngine;
    }

    private void setRWLock(OperationContext operationContext) {
        if (operationContext.getSession() != null) {
            this.rwLock = operationContext.getSession().getDirectoryService().getOperationManager().getRWLock();
        } else if (this.rwLock == null) {
            this.rwLock = new ReentrantReadWriteLock();
        }
    }

    @Override
    public ReadWriteLock getReadWriteLock() {
        return this.rwLock;
    }

    @Override
    public Cache<String, Dn> getAliasCache() {
        return this.aliasCache;
    }

    @Override
    public String getContextCsn(PartitionTxn partitionTxn) {
        if (super.getContextCsn(partitionTxn) == null) {
            this.loadContextCsn(partitionTxn);
        }
        return super.getContextCsn(partitionTxn);
    }

    protected void loadContextCsn(PartitionTxn partitionTxn) {
        try {
            String contextEntryId;
            if (this.rwLock == null) {
                this.rwLock = new ReentrantReadWriteLock();
            }
            if ((contextEntryId = this.getEntryId(partitionTxn, this.getSuffixDn())) == null) {
                return;
            }
            Entry entry = this.fetch(partitionTxn, contextEntryId);
            Attribute ctxCsnAt = entry.get(this.contextCsnAT);
            if (ctxCsnAt != null) {
                this.setContextCsn(ctxCsnAt.getString());
                this.ctxCsnChanged = false;
            }
        }
        catch (LdapException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void saveContextCsn(PartitionTxn partitionTxn) throws LdapException {
        if (!this.ctxCsnChanged) {
            return;
        }
        String contextCsn = super.getContextCsn(partitionTxn);
        if (contextCsn == null) {
            return;
        }
        try {
            String contextEntryId = this.getEntryId(partitionTxn, this.getSuffixDn());
            Entry origEntry = this.fetch(partitionTxn, contextEntryId);
            if (origEntry == null) {
                return;
            }
            origEntry = ((ClonedServerEntry)origEntry).getOriginalEntry();
            origEntry.removeAttributes(this.contextCsnAT, this.entryDnAT);
            origEntry.add(this.contextCsnAT, contextCsn);
            this.master.put(partitionTxn, contextEntryId, origEntry);
            this.ctxCsnChanged = false;
            LOG.debug("Saved context CSN {} for the partition {}", (Object)contextCsn, (Object)this.suffixDn);
        }
        catch (Exception e) {
            throw new LdapOperationErrorException(e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Subordinates getSubordinates(PartitionTxn partitionTxn, Entry entry) throws LdapException {
        Subordinates subordinates = new Subordinates();
        try {
            try {
                this.rwLock.readLock().lock();
                ParentIdAndRdn parentIdAndRdn = this.rdnIdx.reverseLookup(partitionTxn, entry.get("entryUUID").getString());
                subordinates.setNbChildren(parentIdAndRdn.getNbChildren());
                subordinates.setNbSubordinates(parentIdAndRdn.getNbDescendants());
            }
            finally {
                this.rwLock.readLock().unlock();
            }
        }
        catch (Exception e) {
            throw new LdapException(e.getMessage(), e);
        }
        return subordinates;
    }
}

