/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.kerberos.codec.kdcReqBody.actions;

import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.asn1.ber.grammar.GrammarAction;
import org.apache.directory.api.asn1.ber.tlv.TLV;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.shared.kerberos.codec.kdcReqBody.KdcReqBodyContainer;
import org.apache.directory.shared.kerberos.components.KdcReqBody;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KdcReqBodyInit
extends GrammarAction<KdcReqBodyContainer> {
    private static final Logger LOG = LoggerFactory.getLogger(KdcReqBodyInit.class);
    private static final boolean IS_DEBUG = LOG.isDebugEnabled();

    public KdcReqBodyInit() {
        super("Creates a KdcReqBody instance");
    }

    @Override
    public void action(KdcReqBodyContainer kdcReqBodyContainer) throws DecoderException {
        TLV tlv = kdcReqBodyContainer.getCurrentTLV();
        if (tlv.getLength() == 0) {
            LOG.error(I18n.err(I18n.ERR_01308_ZERO_LENGTH_TLV, new Object[0]));
            throw new DecoderException(I18n.err(I18n.ERR_01309_EMPTY_TLV, new Object[0]));
        }
        KdcReqBody kdcReqBody = new KdcReqBody();
        kdcReqBodyContainer.setKdcReqBody(kdcReqBody);
        if (IS_DEBUG) {
            LOG.debug("KdcReqBody created");
        }
    }
}

