/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.util;

import java.text.ParseException;
import java.util.Date;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.util.GeneralizedTime;

public final class DateUtils {
    private DateUtils() {
    }

    public static Date getDate(String zuluTime) {
        try {
            return GeneralizedTime.getDate(zuluTime);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String getGeneralizedTime() {
        return new GeneralizedTime(new Date()).toGeneralizedTime();
    }

    public static String getGeneralizedTime(Date date) {
        return new GeneralizedTime(date).toGeneralizedTime();
    }

    public static String getGeneralizedTime(long time) {
        return DateUtils.getGeneralizedTime(new Date(time));
    }

    public static Date convertIntervalDate(String intervalDate) throws ParseException {
        if (intervalDate == null) {
            throw new ParseException(I18n.err(I18n.ERR_17043_GENERALIZED_TIME_NULL, new Object[0]), 0);
        }
        long offset = 11644473600000L;
        long javaTime = Long.parseLong(intervalDate) / 10000L - offset;
        return new Date(javaTime);
    }
}

