/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.schema.parsers;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.directory.api.asn1.util.Oid;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.model.exception.LdapSchemaException;
import org.apache.directory.api.ldap.model.schema.AttributeType;
import org.apache.directory.api.ldap.model.schema.DitContentRule;
import org.apache.directory.api.ldap.model.schema.DitStructureRule;
import org.apache.directory.api.ldap.model.schema.LdapSyntax;
import org.apache.directory.api.ldap.model.schema.MatchingRule;
import org.apache.directory.api.ldap.model.schema.MatchingRuleUse;
import org.apache.directory.api.ldap.model.schema.MutableAttributeType;
import org.apache.directory.api.ldap.model.schema.MutableMatchingRule;
import org.apache.directory.api.ldap.model.schema.MutableObjectClass;
import org.apache.directory.api.ldap.model.schema.NameForm;
import org.apache.directory.api.ldap.model.schema.ObjectClass;
import org.apache.directory.api.ldap.model.schema.ObjectClassTypeEnum;
import org.apache.directory.api.ldap.model.schema.SchemaObject;
import org.apache.directory.api.ldap.model.schema.UsageEnum;
import org.apache.directory.api.ldap.model.schema.parsers.LdapComparatorDescription;
import org.apache.directory.api.ldap.model.schema.parsers.NormalizerDescription;
import org.apache.directory.api.ldap.model.schema.parsers.SyntaxCheckerDescription;
import org.apache.directory.api.ldap.model.schema.syntaxCheckers.OpenLdapObjectIdentifierMacro;
import org.apache.directory.api.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenLdapSchemaParser {
    protected static final Logger LOG = LoggerFactory.getLogger(OpenLdapSchemaParser.class);
    private boolean isQuirksModeEnabled = false;
    protected int lineNumber;
    private List<Object> schemaDescriptions = new ArrayList<Object>();
    private List<MutableAttributeType> attributeTypes;
    private List<ObjectClass> objectClasses;
    private Map<String, OpenLdapObjectIdentifierMacro> objectIdentifierMacros = new HashMap<String, OpenLdapObjectIdentifierMacro>();
    private static final String APPLIES_STR = "APPLIES";
    private static final String ABSTRACT_STR = "ABSTRACT";
    private static final String AUX_STR = "AUX";
    private static final String AUXILIARY_STR = "AUXILIARY";
    private static final String BYTECODE_STR = "BYTECODE";
    private static final String COLLECTIVE_STR = "COLLECTIVE";
    private static final String DESC_STR = "DESC";
    private static final String EQUALITY_STR = "EQUALITY";
    private static final String FORM_STR = "FORM";
    private static final String FQCN_STR = "FQCN";
    private static final String MAY_STR = "MAY";
    private static final String MUST_STR = "MUST";
    private static final String NAME_STR = "NAME";
    private static final String NO_USER_MODIFICATION_STR = "NO-USER-MODIFICATION";
    private static final String NOT_STR = "NOT";
    private static final String OBSOLETE_STR = "OBSOLETE";
    private static final String OC_STR = "OC";
    private static final String ORDERING_STR = "ORDERING";
    private static final String SINGLE_VALUE_STR = "SINGLE-VALUE";
    private static final String STRUCTURAL_STR = "STRUCTURAL";
    private static final String SUBSTR_STR = "SUBSTR";
    private static final String SUP_STR = "SUP";
    private static final String SYNTAX_STR = "SYNTAX";
    private static final String USAGE_STR = "USAGE";
    private static final String EXTENSION_PREFIX = "X-";
    private static final String DIRECTORY_OPERATION_STR = "directoryOperation";
    private static final String DISTRIBUTED_OPERATION_STR = "distributedOperation";
    private static final String DSA_OPERATION_STR = "dSAOperation";
    private static final String USER_APPLICATIONS_STR = "userApplications";
    private static final char COLON = ':';
    private static final char DOLLAR = '$';
    private static final char DOT = '.';
    private static final char EQUAL = '=';
    private static final char ESCAPE = '\\';
    private static final char HYPHEN = '-';
    private static final char LBRACE = '{';
    private static final char LPAREN = '(';
    private static final char PLUS = '+';
    private static final char RBRACE = '}';
    private static final char RPAREN = ')';
    private static final char SEMI_COLON = ';';
    private static final char SHARP = '#';
    private static final char SLASH = '/';
    private static final char SQUOTE = '\'';
    private static final char UNDERSCORE = '_';
    private static final char DQUOTE = '\"';
    private boolean isResolveObjectIdentifierMacros = true;
    private static final boolean UN_QUOTED = false;
    private static final boolean STRICT = false;
    private static final boolean RELAXED = true;

    public void clear() {
        if (this.attributeTypes != null) {
            this.attributeTypes.clear();
        }
        if (this.objectClasses != null) {
            this.objectClasses.clear();
        }
        if (this.schemaDescriptions != null) {
            this.schemaDescriptions.clear();
        }
        if (this.objectIdentifierMacros != null) {
            this.objectIdentifierMacros.clear();
        }
    }

    public List<MutableAttributeType> getAttributeTypes() {
        return this.attributeTypes;
    }

    public List<ObjectClass> getObjectClasses() {
        return this.objectClasses;
    }

    public Map<String, OpenLdapObjectIdentifierMacro> getObjectIdentifierMacros() {
        return this.objectIdentifierMacros;
    }

    private void afterParse() throws ParseException {
        this.objectClasses = new ArrayList<ObjectClass>();
        this.attributeTypes = new ArrayList<MutableAttributeType>();
        for (Object obj : this.schemaDescriptions) {
            if (obj instanceof OpenLdapObjectIdentifierMacro) {
                OpenLdapObjectIdentifierMacro oid = (OpenLdapObjectIdentifierMacro)obj;
                this.objectIdentifierMacros.put(oid.getName(), oid);
                continue;
            }
            if (obj instanceof AttributeType) {
                MutableAttributeType attributeType = (MutableAttributeType)obj;
                this.attributeTypes.add(attributeType);
                continue;
            }
            if (!(obj instanceof ObjectClass)) continue;
            ObjectClass objectClass = (ObjectClass)obj;
            this.objectClasses.add(objectClass);
        }
        if (this.isResolveObjectIdentifierMacros()) {
            for (OpenLdapObjectIdentifierMacro oid : this.objectIdentifierMacros.values()) {
                this.resolveObjectIdentifierMacro(oid);
            }
            for (ObjectClass objectClass : this.objectClasses) {
                objectClass.setOid(this.getResolveOid(objectClass.getOid()));
            }
            for (MutableAttributeType attributeType : this.attributeTypes) {
                attributeType.setOid(this.getResolveOid(attributeType.getOid()));
                attributeType.setSyntaxOid(this.getResolveOid(attributeType.getSyntaxOid()));
            }
        }
    }

    private String getResolveOid(String oid) {
        String[] nameAndSuffix;
        if (oid != null && oid.indexOf(58) != -1 && this.objectIdentifierMacros.containsKey((nameAndSuffix = oid.split(":"))[0])) {
            OpenLdapObjectIdentifierMacro macro = this.objectIdentifierMacros.get(nameAndSuffix[0]);
            return macro.getResolvedOid() + "." + nameAndSuffix[1];
        }
        return oid;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void resolveObjectIdentifierMacro(OpenLdapObjectIdentifierMacro macro) throws ParseException {
        String rawOidOrNameSuffix = macro.getRawOidOrNameSuffix();
        if (macro.isResolved()) {
            return;
        }
        if (rawOidOrNameSuffix.indexOf(58) != -1) {
            String[] nameAndSuffix = rawOidOrNameSuffix.split(":");
            if (!this.objectIdentifierMacros.containsKey(nameAndSuffix[0])) throw new ParseException(I18n.err(I18n.ERR_13726_NO_OBJECT_IDENTIFIER_MACRO, nameAndSuffix[0]), 0);
            OpenLdapObjectIdentifierMacro parentMacro = this.objectIdentifierMacros.get(nameAndSuffix[0]);
            this.resolveObjectIdentifierMacro(parentMacro);
            macro.setResolvedOid(parentMacro.getResolvedOid() + "." + nameAndSuffix[1]);
            return;
        } else if (this.objectIdentifierMacros.containsKey(rawOidOrNameSuffix)) {
            OpenLdapObjectIdentifierMacro parentMacro = this.objectIdentifierMacros.get(rawOidOrNameSuffix);
            this.resolveObjectIdentifierMacro(parentMacro);
            macro.setResolvedOid(parentMacro.getResolvedOid());
            return;
        } else {
            macro.setResolvedOid(rawOidOrNameSuffix);
        }
    }

    public SchemaObject parse(String schemaObject) throws ParseException {
        if (schemaObject == null || Strings.isEmpty(schemaObject.trim())) {
            throw new ParseException(I18n.err(I18n.ERR_13716_NULL_OR_EMPTY_STRING_SCHEMA_OBJECT, new Object[0]), 0);
        }
        try (BufferedReader reader = new BufferedReader(new StringReader(schemaObject));){
            this.parse(reader);
            this.afterParse();
        }
        catch (IOException | LdapSchemaException e) {
            throw new ParseException(e.getMessage(), 0);
        }
        if (!this.schemaDescriptions.isEmpty()) {
            for (Object obj : this.schemaDescriptions) {
                if (!(obj instanceof SchemaObject)) continue;
                return (SchemaObject)obj;
            }
        }
        return null;
    }

    public void parse(InputStream schemaIn) throws ParseException, LdapSchemaException, IOException {
        try (InputStreamReader in = new InputStreamReader(schemaIn, Charset.defaultCharset());
             BufferedReader reader = new BufferedReader(in);){
            this.parse(reader);
            this.afterParse();
        }
    }

    private static void skipWhites(Reader reader, PosSchema pos, boolean mandatory) throws IOException, LdapSchemaException {
        boolean hasSpace = false;
        while (true) {
            if (OpenLdapSchemaParser.isEmpty(pos)) {
                OpenLdapSchemaParser.getLine(reader, pos);
                if (pos.line == null) {
                    return;
                }
                hasSpace = true;
                continue;
            }
            if (pos.line == null) {
                throw new LdapSchemaException(I18n.err(I18n.ERR_13782_END_OF_FILE, pos.lineNumber, pos.start));
            }
            while (Character.isWhitespace(pos.line.charAt(pos.start))) {
                hasSpace = true;
                ++pos.start;
                if (!OpenLdapSchemaParser.isEmpty(pos)) continue;
                OpenLdapSchemaParser.getLine(reader, pos);
                if (pos.line != null) continue;
                return;
            }
            if (pos.line.charAt(pos.start) != '#') break;
            OpenLdapSchemaParser.getLine(reader, pos);
            if (pos.line == null) {
                return;
            }
            hasSpace = true;
        }
        if (mandatory && !hasSpace) {
            throw new LdapSchemaException(I18n.err(I18n.ERR_13783_SPACE_EXPECTED, pos.lineNumber, pos.start));
        }
    }

    private static boolean isComment(PosSchema pos) {
        if (OpenLdapSchemaParser.isEmpty(pos)) {
            return true;
        }
        return pos.line.charAt(pos.start) == '#';
    }

    private static boolean isEmpty(PosSchema pos) {
        return pos.line == null || pos.start >= pos.line.length();
    }

    private static boolean startsWith(PosSchema pos, String text) {
        if (pos.line == null || pos.line.length() - pos.start < text.length()) {
            return false;
        }
        return text.equalsIgnoreCase(pos.line.substring(pos.start, pos.start + text.length()));
    }

    private static boolean startsWith(Reader reader, PosSchema pos, char c) throws IOException, LdapSchemaException {
        return OpenLdapSchemaParser.startsWith(reader, pos, c, false);
    }

    private static boolean startsWith(Reader reader, PosSchema pos, char c, boolean quoted) throws IOException, LdapSchemaException {
        if (pos.line == null || pos.line.length() - pos.start < 1) {
            return false;
        }
        if (quoted) {
            return pos.line.charAt(pos.start) == c;
        }
        while (OpenLdapSchemaParser.isEmpty(pos) || OpenLdapSchemaParser.isComment(pos)) {
            OpenLdapSchemaParser.getLine(reader, pos);
            if (pos.line == null) {
                return false;
            }
            OpenLdapSchemaParser.skipWhites(reader, pos, false);
            if (!OpenLdapSchemaParser.isComment(pos)) continue;
        }
        return pos.line.charAt(pos.start) == c;
    }

    private static boolean startsWith(PosSchema pos, char c) {
        if (pos.line == null || pos.line.length() - pos.start < 1) {
            return false;
        }
        return pos.line.charAt(pos.start) == c;
    }

    private static boolean isAlpha(PosSchema pos) {
        return Character.isAlphabetic(pos.line.charAt(pos.start));
    }

    private static boolean isDigit(PosSchema pos) {
        return Character.isDigit(pos.line.charAt(pos.start));
    }

    private static void getLine(Reader reader, PosSchema pos) throws IOException {
        pos.line = ((BufferedReader)reader).readLine();
        pos.start = 0;
        if (pos.line != null) {
            ++pos.lineNumber;
        }
    }

    private static String getNumericOid(PosSchema pos) throws LdapSchemaException {
        int start = pos.start;
        boolean isDot = false;
        boolean isFirstZero = false;
        boolean isFirstDigit = true;
        while (!OpenLdapSchemaParser.isEmpty(pos)) {
            char c = pos.line.charAt(pos.start);
            if (Character.isDigit(c)) {
                if (isFirstZero) {
                    throw new LdapSchemaException(I18n.err(I18n.ERR_13784_BAD_OID_TWO_ZEROES, pos.lineNumber, pos.start));
                }
                if (pos.line.charAt(pos.start) == '0' && isFirstDigit) {
                    isFirstZero = true;
                }
                isDot = false;
                ++pos.start;
                isFirstDigit = false;
                continue;
            }
            if (c != '.') break;
            if (isDot) {
                throw new LdapSchemaException(I18n.err(I18n.ERR_13785_BAD_OID_CONSECUTIVE_DOTS, pos.lineNumber, pos.start));
            }
            isFirstZero = false;
            isFirstDigit = true;
            ++pos.start;
            isDot = true;
        }
        if (isDot) {
            throw new LdapSchemaException(I18n.err(I18n.ERR_13786_BAD_OID_DOT_AT_THE_END, pos.lineNumber, pos.start));
        }
        String oidStr = pos.line.substring(start, pos.start);
        if (Oid.isOid(oidStr)) {
            return oidStr;
        }
        throw new LdapSchemaException(I18n.err(I18n.ERR_13787_OID_EXPECTED, pos.line, pos.start));
    }

    private static String getPartialNumericOid(PosSchema pos) throws LdapSchemaException {
        int start = pos.start;
        boolean isDot = false;
        boolean isFirstZero = false;
        boolean isFirstDigit = true;
        while (!OpenLdapSchemaParser.isEmpty(pos)) {
            if (OpenLdapSchemaParser.isDigit(pos)) {
                if (isFirstZero) {
                    throw new LdapSchemaException(I18n.err(I18n.ERR_13784_BAD_OID_TWO_ZEROES, pos.lineNumber, pos.start));
                }
                if (pos.line.charAt(pos.start) == '0' && isFirstDigit) {
                    isFirstZero = true;
                }
                isDot = false;
                ++pos.start;
                isFirstDigit = false;
                continue;
            }
            if (!OpenLdapSchemaParser.startsWith(pos, '.')) break;
            if (isDot) {
                throw new LdapSchemaException(I18n.err(I18n.ERR_13785_BAD_OID_CONSECUTIVE_DOTS, pos.lineNumber, pos.start));
            }
            isFirstZero = false;
            isFirstDigit = true;
            ++pos.start;
            isDot = true;
        }
        if (isDot) {
            throw new LdapSchemaException(I18n.err(I18n.ERR_13786_BAD_OID_DOT_AT_THE_END, pos.lineNumber, pos.start));
        }
        return pos.line.substring(start, pos.start);
    }

    private static String getOidAndMacroRelaxed(PosSchema pos, Map<String, OpenLdapObjectIdentifierMacro> objectIdentifierMacros) throws LdapSchemaException {
        String oidName;
        if (OpenLdapSchemaParser.isEmpty(pos)) {
            return "";
        }
        int start = pos.start;
        char c = pos.line.charAt(pos.start);
        boolean isDigit = Character.isDigit(c);
        while (isDigit || Character.isAlphabetic(c) || c == '-' || c == '_' || c == ';' || c == '.' || c == '#') {
            ++pos.start;
            if (OpenLdapSchemaParser.isEmpty(pos)) break;
            c = pos.line.charAt(pos.start);
            isDigit = Character.isDigit(c);
        }
        if (Strings.isEmpty(oidName = pos.line.substring(start, pos.start))) {
            throw new LdapSchemaException(I18n.err(I18n.ERR_13787_OID_EXPECTED, pos.lineNumber, pos.start));
        }
        if (OpenLdapSchemaParser.startsWith(pos, ':')) {
            ++pos.start;
            String oid = OpenLdapSchemaParser.getPartialNumericOid(pos);
            return objectIdentifierMacros.get(oidName).getRawOidOrNameSuffix() + '.' + oid;
        }
        OpenLdapObjectIdentifierMacro macro = objectIdentifierMacros.get(oidName);
        if (macro == null) {
            return oidName;
        }
        return macro.getRawOidOrNameSuffix();
    }

    private static String getOidStrict(PosSchema pos) throws LdapSchemaException {
        if (OpenLdapSchemaParser.isEmpty(pos)) {
            return "";
        }
        if (OpenLdapSchemaParser.isAlpha(pos)) {
            return OpenLdapSchemaParser.getDescrStrict(pos);
        }
        if (OpenLdapSchemaParser.isDigit(pos)) {
            return OpenLdapSchemaParser.getNumericOid(pos);
        }
        throw new LdapSchemaException(I18n.err(I18n.ERR_13787_OID_EXPECTED, pos.lineNumber, pos.start));
    }

    private static String getOidRelaxed(PosSchema pos, boolean hadQuote) throws LdapSchemaException {
        String oid;
        if (OpenLdapSchemaParser.isEmpty(pos)) {
            return "";
        }
        boolean hasQuote = false;
        char c = pos.line.charAt(pos.start);
        if (c == '\'') {
            if (hadQuote) {
                return "";
            }
            hasQuote = true;
            ++pos.start;
            if (OpenLdapSchemaParser.isEmpty(pos)) {
                return "";
            }
            c = pos.line.charAt(pos.start);
        }
        if (Character.isAlphabetic(c)) {
            oid = OpenLdapSchemaParser.getDescrRelaxed(pos);
        } else if (Character.isDigit(c)) {
            oid = OpenLdapSchemaParser.getNumericOid(pos);
        } else {
            throw new LdapSchemaException(I18n.err(I18n.ERR_13787_OID_EXPECTED, pos.lineNumber, pos.start));
        }
        if (OpenLdapSchemaParser.isEmpty(pos)) {
            if (hasQuote || hadQuote) {
                throw new LdapSchemaException(I18n.err(I18n.ERR_13792_SIMPLE_QUOTE_EXPECTED_AT_END, pos.lineNumber, pos.start));
            }
            return oid;
        }
        c = pos.line.charAt(pos.start);
        if (c == '\'' && !hadQuote) {
            if (hasQuote) {
                ++pos.start;
            } else {
                throw new LdapSchemaException(I18n.err(I18n.ERR_13792_SIMPLE_QUOTE_EXPECTED_AT_END, pos.lineNumber, pos.start));
            }
        }
        return oid;
    }

    private static String getDescrStrict(PosSchema pos) throws LdapSchemaException {
        int start = pos.start;
        boolean isFirst = true;
        while (!OpenLdapSchemaParser.isEmpty(pos)) {
            if (isFirst) {
                isFirst = false;
                if (OpenLdapSchemaParser.isAlpha(pos)) {
                    ++pos.start;
                    continue;
                }
                throw new LdapSchemaException(I18n.err(I18n.ERR_13788_LEAD_KEY_CHAR_EXPECTED, pos.lineNumber, pos.start));
            }
            char c = pos.line.charAt(pos.start);
            if (Character.isAlphabetic(c) || Character.isDigit(c) || c == '-') {
                ++pos.start;
                continue;
            }
            return pos.line.substring(start, pos.start);
        }
        return pos.line.substring(start, pos.start);
    }

    private static String getDescrRelaxed(PosSchema pos) throws LdapSchemaException {
        int start = pos.start;
        boolean isFirst = true;
        while (!OpenLdapSchemaParser.isEmpty(pos)) {
            char c;
            if (isFirst) {
                isFirst = false;
                c = pos.line.charAt(pos.start);
                if (Character.isAlphabetic(c) || c == '-' || c == '_' || c == ';' || c == '.' || c == ':' || c == '#') {
                    ++pos.start;
                    continue;
                }
                throw new LdapSchemaException(I18n.err(I18n.ERR_13788_LEAD_KEY_CHAR_EXPECTED, pos.lineNumber, pos.start));
            }
            c = pos.line.charAt(pos.start);
            if (Character.isAlphabetic(c) || Character.isDigit(c) || c == '-' || c == '_' || c == ';' || c == '.' || c == ':' || c == '#') {
                ++pos.start;
                continue;
            }
            return pos.line.substring(start, pos.start);
        }
        return pos.line.substring(start, pos.start);
    }

    private String getMacro(PosSchema pos) throws LdapSchemaException {
        if (this.isQuirksModeEnabled) {
            int start = pos.start;
            boolean isFirst = true;
            while (!OpenLdapSchemaParser.isEmpty(pos)) {
                char c;
                if (isFirst) {
                    isFirst = false;
                    c = pos.line.charAt(pos.start);
                    if (Character.isAlphabetic(c) || c == '-' || c == '_' || c == ';' || c == '.' || c == '#') {
                        ++pos.start;
                        continue;
                    }
                    throw new LdapSchemaException(I18n.err(I18n.ERR_13788_LEAD_KEY_CHAR_EXPECTED, pos.lineNumber, pos.start));
                }
                c = pos.line.charAt(pos.start);
                if (Character.isAlphabetic(c) || Character.isDigit(c) || c == '-' || c == '_' || c == ';' || c == '.' || c == '#') {
                    ++pos.start;
                    continue;
                }
                return pos.line.substring(start, pos.start);
            }
            return pos.line.substring(start, pos.start);
        }
        int start = pos.start;
        boolean isFirst = true;
        while (!OpenLdapSchemaParser.isEmpty(pos)) {
            if (isFirst) {
                isFirst = false;
                if (OpenLdapSchemaParser.isAlpha(pos)) {
                    ++pos.start;
                    continue;
                }
                throw new LdapSchemaException(I18n.err(I18n.ERR_13788_LEAD_KEY_CHAR_EXPECTED, pos.lineNumber, pos.start));
            }
            char c = pos.line.charAt(pos.start);
            if (Character.isAlphabetic(c) || Character.isDigit(c) || c == '-') {
                ++pos.start;
                continue;
            }
            return pos.line.substring(start, pos.start);
        }
        return pos.line.substring(start, pos.start);
    }

    private static String getQDescrStrict(Reader reader, PosSchema pos) throws LdapSchemaException, IOException {
        if (!OpenLdapSchemaParser.startsWith(reader, pos, '\'')) {
            throw new LdapSchemaException(I18n.err(I18n.ERR_13789_SIMPLE_QUOTE_EXPECTED_AT_START, pos.lineNumber, pos.start));
        }
        ++pos.start;
        int start = pos.start;
        boolean isFirst = true;
        while (!OpenLdapSchemaParser.startsWith(pos, '\'')) {
            if (isFirst) {
                isFirst = false;
                if (!OpenLdapSchemaParser.isEmpty(pos) && OpenLdapSchemaParser.isAlpha(pos)) {
                    ++pos.start;
                    continue;
                }
                throw new LdapSchemaException(I18n.err(I18n.ERR_13788_LEAD_KEY_CHAR_EXPECTED, pos.lineNumber, pos.start));
            }
            if (OpenLdapSchemaParser.isEmpty(pos)) {
                throw new LdapSchemaException(I18n.err(I18n.ERR_13792_SIMPLE_QUOTE_EXPECTED_AT_END, pos.lineNumber, pos.start));
            }
            char c = pos.line.charAt(pos.start);
            if (Character.isAlphabetic(c) || Character.isDigit(c) || c == '-') {
                ++pos.start;
                continue;
            }
            throw new LdapSchemaException(I18n.err(I18n.ERR_13791_KEYCHAR_EXPECTED, Character.valueOf(c), pos.lineNumber, pos.start));
        }
        if (OpenLdapSchemaParser.startsWith(pos, '\'')) {
            ++pos.start;
            return pos.line.substring(start, pos.start - 1);
        }
        throw new LdapSchemaException(I18n.err(I18n.ERR_13792_SIMPLE_QUOTE_EXPECTED_AT_END, pos.lineNumber, pos.start));
    }

    private static String getQDescrRelaxed(Reader reader, PosSchema pos) throws LdapSchemaException, IOException {
        char c;
        if (OpenLdapSchemaParser.startsWith(reader, pos, '\'')) {
            ++pos.start;
            int start = pos.start;
            while (!OpenLdapSchemaParser.startsWith(pos, '\'')) {
                if (OpenLdapSchemaParser.isEmpty(pos)) {
                    throw new LdapSchemaException(I18n.err(I18n.ERR_13789_SIMPLE_QUOTE_EXPECTED_AT_START, pos.lineNumber, pos.start));
                }
                char c2 = pos.line.charAt(pos.start);
                if (Character.isDigit(c2) || Character.isAlphabetic(c2) || c2 == '-' || c2 == '_' || c2 == ';' || c2 == '.' || c2 == ':' || c2 == '#') {
                    ++pos.start;
                    continue;
                }
                if (c2 == '\'') continue;
                throw new LdapSchemaException(I18n.err(I18n.ERR_13790_NOT_A_KEYSTRING, pos.lineNumber, pos.start));
            }
            ++pos.start;
            return pos.line.substring(start, pos.start - 1);
        }
        int start = pos.start;
        while (!OpenLdapSchemaParser.isEmpty(pos) && (Character.isDigit(c = pos.line.charAt(pos.start)) || Character.isAlphabetic(c) || c == '-' || c == '_' || c == ';' || c == '.' || c == ':' || c == '#')) {
            ++pos.start;
        }
        return pos.line.substring(start, pos.start);
    }

    private static String getQDString(Reader reader, PosSchema pos) throws LdapSchemaException, IOException {
        if (!OpenLdapSchemaParser.startsWith(reader, pos, '\'')) {
            throw new LdapSchemaException(I18n.err(I18n.ERR_13789_SIMPLE_QUOTE_EXPECTED_AT_START, pos.lineNumber, pos.start));
        }
        ++pos.start;
        int start = pos.start;
        int nbEscapes = 0;
        while (!OpenLdapSchemaParser.isEmpty(pos) && !OpenLdapSchemaParser.startsWith(pos, '\'')) {
            if (OpenLdapSchemaParser.startsWith(pos, '\\')) {
                ++nbEscapes;
            }
            ++pos.start;
        }
        if (OpenLdapSchemaParser.startsWith(pos, '\'')) {
            ++pos.start;
            char[] unescaped = new char[pos.start - 1 - start - nbEscapes * 2];
            int newPos = 0;
            for (int i = start; i < pos.start - 1; ++i) {
                char c = pos.line.charAt(i);
                if (c == '\\') {
                    if (i + 2 > pos.start) {
                        throw new LdapSchemaException(I18n.err(I18n.ERR_13792_SIMPLE_QUOTE_EXPECTED_AT_END, pos.lineNumber, pos.start));
                    }
                    int u = Character.digit(pos.line.charAt(i + 1), 16);
                    int l = Character.digit(pos.line.charAt(i + 2), 16);
                    unescaped[newPos] = (char)((u << 4) + l);
                    i += 2;
                } else {
                    unescaped[newPos] = c;
                }
                ++newPos;
            }
            return new String(unescaped);
        }
        throw new LdapSchemaException(I18n.err(I18n.ERR_13792_SIMPLE_QUOTE_EXPECTED_AT_END, pos.lineNumber, pos.start));
    }

    private static List<String> getQDescrs(Reader reader, PosSchema pos, boolean relaxed) throws LdapSchemaException, IOException {
        ArrayList<String> qdescrs = new ArrayList<String>();
        if (OpenLdapSchemaParser.startsWith(reader, pos, '(')) {
            ++pos.start;
            OpenLdapSchemaParser.skipWhites(reader, pos, false);
            while (!OpenLdapSchemaParser.startsWith(reader, pos, ')')) {
                String qdescr = relaxed ? OpenLdapSchemaParser.getQDescrRelaxed(reader, pos) : OpenLdapSchemaParser.getQDescrStrict(reader, pos);
                qdescrs.add(qdescr);
                if (OpenLdapSchemaParser.startsWith(reader, pos, ')')) break;
                OpenLdapSchemaParser.skipWhites(reader, pos, true);
            }
            if (!OpenLdapSchemaParser.startsWith(reader, pos, ')')) {
                throw new LdapSchemaException(I18n.err(I18n.ERR_13793_NO_CLOSING_PAREN, pos.lineNumber, pos.start));
            }
            ++pos.start;
        } else {
            String qDescr = relaxed ? OpenLdapSchemaParser.getQDescrRelaxed(reader, pos) : OpenLdapSchemaParser.getQDescrStrict(reader, pos);
            if (Strings.isEmpty(qDescr)) {
                throw new LdapSchemaException(I18n.err(I18n.ERR_13732_NAME_CANNOT_BE_NULL, pos.lineNumber, pos.start));
            }
            qdescrs.add(qDescr);
        }
        return qdescrs;
    }

    private static List<String> getQDStrings(Reader reader, PosSchema pos) throws LdapSchemaException, IOException {
        ArrayList<String> qdStrings = new ArrayList<String>();
        if (OpenLdapSchemaParser.startsWith(reader, pos, '(')) {
            ++pos.start;
            OpenLdapSchemaParser.skipWhites(reader, pos, false);
            while (!OpenLdapSchemaParser.startsWith(reader, pos, ')')) {
                qdStrings.add(OpenLdapSchemaParser.getQDString(reader, pos));
                if (OpenLdapSchemaParser.startsWith(reader, pos, ')')) break;
                OpenLdapSchemaParser.skipWhites(reader, pos, true);
            }
            if (!OpenLdapSchemaParser.startsWith(reader, pos, ')')) {
                throw new LdapSchemaException(I18n.err(I18n.ERR_13793_NO_CLOSING_PAREN, pos.lineNumber, pos.start));
            }
            ++pos.start;
        } else {
            qdStrings.add(OpenLdapSchemaParser.getQDString(reader, pos));
        }
        return qdStrings;
    }

    private static List<String> getOidsStrict(Reader reader, PosSchema pos) throws LdapSchemaException, IOException {
        ArrayList<String> oids = new ArrayList<String>();
        if (OpenLdapSchemaParser.startsWith(reader, pos, '(')) {
            ++pos.start;
            OpenLdapSchemaParser.skipWhites(reader, pos, false);
            boolean moreExpected = false;
            while (!OpenLdapSchemaParser.startsWith(reader, pos, ')')) {
                moreExpected = false;
                oids.add(OpenLdapSchemaParser.getOidStrict(pos));
                if (OpenLdapSchemaParser.startsWith(reader, pos, ')')) break;
                OpenLdapSchemaParser.skipWhites(reader, pos, false);
                if (OpenLdapSchemaParser.startsWith(reader, pos, '$')) {
                    ++pos.start;
                    moreExpected = true;
                }
                OpenLdapSchemaParser.skipWhites(reader, pos, false);
            }
            if (!OpenLdapSchemaParser.startsWith(reader, pos, ')')) {
                throw new LdapSchemaException(I18n.err(I18n.ERR_13793_NO_CLOSING_PAREN, pos.lineNumber, pos.start));
            }
            if (moreExpected) {
                throw new LdapSchemaException(I18n.err(I18n.ERR_13794_MORE_OIDS_EXPECTED, pos.lineNumber, pos.start));
            }
            ++pos.start;
        } else {
            oids.add(OpenLdapSchemaParser.getOidStrict(pos));
        }
        return oids;
    }

    private static List<String> getOidsRelaxed(Reader reader, PosSchema pos) throws LdapSchemaException, IOException {
        ArrayList<String> oids = new ArrayList<String>();
        if (OpenLdapSchemaParser.startsWith(reader, pos, '(')) {
            ++pos.start;
            OpenLdapSchemaParser.skipWhites(reader, pos, false);
            boolean moreExpected = false;
            while (!OpenLdapSchemaParser.startsWith(reader, pos, ')')) {
                moreExpected = false;
                oids.add(OpenLdapSchemaParser.getOidRelaxed(pos, false));
                if (OpenLdapSchemaParser.startsWith(reader, pos, ')')) break;
                OpenLdapSchemaParser.skipWhites(reader, pos, false);
                if (OpenLdapSchemaParser.startsWith(reader, pos, '$')) {
                    ++pos.start;
                    moreExpected = true;
                }
                OpenLdapSchemaParser.skipWhites(reader, pos, false);
            }
            if (!OpenLdapSchemaParser.startsWith(reader, pos, ')')) {
                throw new LdapSchemaException(I18n.err(I18n.ERR_13793_NO_CLOSING_PAREN, pos.lineNumber, pos.start));
            }
            if (moreExpected) {
                throw new LdapSchemaException(I18n.err(I18n.ERR_13794_MORE_OIDS_EXPECTED, pos.lineNumber, pos.start));
            }
            ++pos.start;
        } else {
            oids.add(OpenLdapSchemaParser.getOidRelaxed(pos, false));
        }
        return oids;
    }

    private static void getNoidLenStrict(MutableAttributeType attributeType, PosSchema pos) throws LdapSchemaException {
        String oid = OpenLdapSchemaParser.getOidStrict(pos);
        if (oid.length() == 0) {
            throw new LdapSchemaException(I18n.err(I18n.ERR_13828_MISSING_SYNTAX_OID, pos.line, pos.start));
        }
        attributeType.setSyntaxOid(oid);
        if (OpenLdapSchemaParser.startsWith(pos, '{')) {
            ++pos.start;
            int start = pos.start;
            while (!OpenLdapSchemaParser.isEmpty(pos) && OpenLdapSchemaParser.isDigit(pos)) {
                ++pos.start;
            }
            if (OpenLdapSchemaParser.startsWith(pos, '}')) {
                String lenStr = pos.line.substring(start, pos.start);
                if (lenStr.length() == 0) {
                    throw new LdapSchemaException(I18n.err(I18n.ERR_13827_EMPTY_SYNTAX_LEN, pos.line, pos.start));
                }
                ++pos.start;
                if (Strings.isEmpty(lenStr)) {
                    attributeType.setSyntaxLength(-1L);
                } else {
                    attributeType.setSyntaxLength(Long.parseLong(lenStr));
                }
            } else {
                throw new LdapSchemaException(I18n.err(I18n.ERR_13795_OPENED_BRACKET_NOT_CLOSED, pos.lineNumber, pos.start));
            }
        }
    }

    private static void getNoidLenRelaxed(MutableAttributeType attributeType, PosSchema pos) throws LdapSchemaException {
        String oid;
        boolean hasQuote = false;
        char c = pos.line.charAt(pos.start);
        if (c == '\'') {
            hasQuote = true;
            ++pos.start;
            if (OpenLdapSchemaParser.isEmpty(pos)) {
                throw new LdapSchemaException(I18n.err(I18n.ERR_13792_SIMPLE_QUOTE_EXPECTED_AT_END, pos.lineNumber, pos.start));
            }
        }
        if ((oid = OpenLdapSchemaParser.getOidRelaxed(pos, hasQuote)).length() == 0) {
            throw new LdapSchemaException(I18n.err(I18n.ERR_13828_MISSING_SYNTAX_OID, pos.line, pos.start));
        }
        attributeType.setSyntaxOid(oid);
        if (OpenLdapSchemaParser.startsWith(pos, '{')) {
            ++pos.start;
            int start = pos.start;
            while (!OpenLdapSchemaParser.isEmpty(pos) && OpenLdapSchemaParser.isDigit(pos)) {
                ++pos.start;
            }
            if (OpenLdapSchemaParser.startsWith(pos, '}')) {
                String lenStr = pos.line.substring(start, pos.start);
                ++pos.start;
                if (Strings.isEmpty(lenStr)) {
                    attributeType.setSyntaxLength(-1L);
                } else {
                    attributeType.setSyntaxLength(Long.parseLong(lenStr));
                }
            } else {
                throw new LdapSchemaException(I18n.err(I18n.ERR_13795_OPENED_BRACKET_NOT_CLOSED, pos.lineNumber, pos.start));
            }
        }
        if (hasQuote) {
            if (OpenLdapSchemaParser.isEmpty(pos)) {
                throw new LdapSchemaException(I18n.err(I18n.ERR_13792_SIMPLE_QUOTE_EXPECTED_AT_END, pos.lineNumber, pos.start));
            }
            c = pos.line.charAt(pos.start);
            if (c == '\'') {
                ++pos.start;
            } else {
                throw new LdapSchemaException(I18n.err(I18n.ERR_13792_SIMPLE_QUOTE_EXPECTED_AT_END, pos.lineNumber, pos.start));
            }
        }
    }

    private static int getRuleId(PosSchema pos) throws LdapSchemaException {
        int start = pos.start;
        while (!OpenLdapSchemaParser.isEmpty(pos) && OpenLdapSchemaParser.isDigit(pos)) {
            ++pos.start;
        }
        if (start == pos.start) {
            throw new LdapSchemaException(I18n.err(I18n.ERR_13811_INVALID_RULE_ID, pos.lineNumber, pos.start));
        }
        String lenStr = pos.line.substring(start, pos.start);
        return Integer.parseInt(lenStr);
    }

    private static List<Integer> getRuleIds(Reader reader, PosSchema pos) throws LdapSchemaException, IOException {
        ArrayList<Integer> ruleIds = new ArrayList<Integer>();
        if (OpenLdapSchemaParser.startsWith(reader, pos, '(')) {
            ++pos.start;
            OpenLdapSchemaParser.skipWhites(reader, pos, false);
            boolean moreExpected = false;
            while (!OpenLdapSchemaParser.startsWith(reader, pos, ')')) {
                moreExpected = false;
                ruleIds.add(OpenLdapSchemaParser.getRuleId(pos));
                if (OpenLdapSchemaParser.startsWith(reader, pos, ')')) break;
                OpenLdapSchemaParser.skipWhites(reader, pos, false);
                if (OpenLdapSchemaParser.startsWith(reader, pos, '$')) {
                    ++pos.start;
                    moreExpected = true;
                }
                OpenLdapSchemaParser.skipWhites(reader, pos, false);
            }
            if (!OpenLdapSchemaParser.startsWith(reader, pos, ')')) {
                throw new LdapSchemaException(I18n.err(I18n.ERR_13793_NO_CLOSING_PAREN, pos.lineNumber, pos.start));
            }
            if (moreExpected) {
                throw new LdapSchemaException(I18n.err(I18n.ERR_13813_MORE_RULE_IDS_EXPECTED, pos.lineNumber, pos.start));
            }
            ++pos.start;
        } else {
            ruleIds.add(OpenLdapSchemaParser.getRuleId(pos));
        }
        return ruleIds;
    }

    private static UsageEnum getUsageStrict(PosSchema pos) throws LdapSchemaException {
        if (OpenLdapSchemaParser.isEmpty(pos)) {
            throw new LdapSchemaException(I18n.err(I18n.ERR_13796_USAGE_EXPECTED, pos.lineNumber, pos.start));
        }
        if (OpenLdapSchemaParser.startsWith(pos, USER_APPLICATIONS_STR)) {
            pos.start += USER_APPLICATIONS_STR.length();
            return UsageEnum.USER_APPLICATIONS;
        }
        if (OpenLdapSchemaParser.startsWith(pos, DIRECTORY_OPERATION_STR)) {
            pos.start += DIRECTORY_OPERATION_STR.length();
            return UsageEnum.DIRECTORY_OPERATION;
        }
        if (OpenLdapSchemaParser.startsWith(pos, DISTRIBUTED_OPERATION_STR)) {
            pos.start += DISTRIBUTED_OPERATION_STR.length();
            return UsageEnum.DISTRIBUTED_OPERATION;
        }
        if (OpenLdapSchemaParser.startsWith(pos, DSA_OPERATION_STR)) {
            pos.start += DSA_OPERATION_STR.length();
            return UsageEnum.DSA_OPERATION;
        }
        throw new LdapSchemaException(I18n.err(I18n.ERR_13797_USAGE_UNKNOWN, pos.lineNumber, pos.start));
    }

    private static UsageEnum getUsageRelaxed(PosSchema pos) throws LdapSchemaException {
        if (OpenLdapSchemaParser.isEmpty(pos)) {
            throw new LdapSchemaException(I18n.err(I18n.ERR_13796_USAGE_EXPECTED, pos.lineNumber, pos.start));
        }
        boolean isSQuoted = false;
        boolean isDQuoted = false;
        if (pos.line.charAt(pos.start) == '\'') {
            isSQuoted = true;
            ++pos.start;
            if (OpenLdapSchemaParser.isEmpty(pos)) {
                throw new LdapSchemaException(I18n.err(I18n.ERR_13796_USAGE_EXPECTED, pos.lineNumber, pos.start));
            }
        } else if (pos.line.charAt(pos.start) == '\"') {
            isDQuoted = true;
            ++pos.start;
            if (OpenLdapSchemaParser.isEmpty(pos)) {
                throw new LdapSchemaException(I18n.err(I18n.ERR_13796_USAGE_EXPECTED, pos.lineNumber, pos.start));
            }
        }
        UsageEnum usage = UsageEnum.USER_APPLICATIONS;
        if (OpenLdapSchemaParser.startsWith(pos, USER_APPLICATIONS_STR)) {
            pos.start += USER_APPLICATIONS_STR.length();
            usage = UsageEnum.USER_APPLICATIONS;
        } else if (OpenLdapSchemaParser.startsWith(pos, DIRECTORY_OPERATION_STR)) {
            pos.start += DIRECTORY_OPERATION_STR.length();
            usage = UsageEnum.DIRECTORY_OPERATION;
        } else if (OpenLdapSchemaParser.startsWith(pos, DISTRIBUTED_OPERATION_STR)) {
            pos.start += DISTRIBUTED_OPERATION_STR.length();
            usage = UsageEnum.DISTRIBUTED_OPERATION;
        } else if (OpenLdapSchemaParser.startsWith(pos, DSA_OPERATION_STR)) {
            pos.start += DSA_OPERATION_STR.length();
            usage = UsageEnum.DSA_OPERATION;
        } else {
            throw new LdapSchemaException(I18n.err(I18n.ERR_13797_USAGE_UNKNOWN, pos.lineNumber, pos.start));
        }
        if (isSQuoted) {
            if (OpenLdapSchemaParser.isEmpty(pos)) {
                throw new LdapSchemaException(I18n.err(I18n.ERR_13796_USAGE_EXPECTED, pos.lineNumber, pos.start));
            }
            if (pos.line.charAt(pos.start) != '\'') {
                throw new LdapSchemaException(I18n.err(I18n.ERR_13792_SIMPLE_QUOTE_EXPECTED_AT_END, pos.lineNumber, pos.start));
            }
            ++pos.start;
        } else if (isDQuoted) {
            if (OpenLdapSchemaParser.isEmpty(pos)) {
                throw new LdapSchemaException(I18n.err(I18n.ERR_13796_USAGE_EXPECTED, pos.lineNumber, pos.start));
            }
            if (pos.line.charAt(pos.start) != '\"') {
                throw new LdapSchemaException(I18n.err(I18n.ERR_13792_SIMPLE_QUOTE_EXPECTED_AT_END, pos.lineNumber, pos.start));
            }
            ++pos.start;
        }
        return usage;
    }

    private static void processExtension(Reader reader, PosSchema pos, SchemaObject schemaObject) throws LdapSchemaException, IOException {
        String extensionKey = OpenLdapSchemaParser.getXString(pos);
        OpenLdapSchemaParser.skipWhites(reader, pos, true);
        List<String> extensionValues = OpenLdapSchemaParser.getQDStrings(reader, pos);
        if (schemaObject.hasExtension(extensionKey)) {
            throw new LdapSchemaException(I18n.err(I18n.ERR_13780_SCHEMA_OBJECT_DESCRIPTION_HAS_ELEMENT_TWICE, extensionKey, pos.lineNumber, pos.start));
        }
        schemaObject.addExtension(extensionKey, extensionValues);
    }

    private static String getXString(PosSchema pos) throws LdapSchemaException {
        int start = pos.start;
        if (OpenLdapSchemaParser.startsWith(pos, EXTENSION_PREFIX)) {
            pos.start += 2;
            while (!OpenLdapSchemaParser.isEmpty(pos) && (OpenLdapSchemaParser.isAlpha(pos) || OpenLdapSchemaParser.startsWith(pos, '-') || OpenLdapSchemaParser.startsWith(pos, '_'))) {
                ++pos.start;
            }
            return pos.line.substring(start, pos.start);
        }
        throw new LdapSchemaException(I18n.err(I18n.ERR_13802_EXTENSION_SHOULD_START_WITH_X, pos.lineNumber, pos.start));
    }

    private static String getFqcn(PosSchema pos) throws LdapSchemaException {
        if (pos.line == null || pos.line.length() - pos.start < 1) {
            return "";
        }
        int start = pos.start;
        boolean isFirst = true;
        boolean dotSeen = false;
        do {
            char c = pos.line.charAt(pos.start);
            if (isFirst) {
                if (!Character.isJavaIdentifierStart(c)) {
                    throw new LdapSchemaException(I18n.err(I18n.ERR_13822_INVALID_FQCN_BAD_IDENTIFIER_START, pos.lineNumber, pos.start));
                }
                isFirst = false;
                dotSeen = false;
                ++pos.start;
                continue;
            }
            if (c == '.') {
                if (dotSeen) {
                    throw new LdapSchemaException(I18n.err(I18n.ERR_13823_INVALID_FQCN_DOUBLE_DOT, pos.lineNumber, pos.start));
                }
                isFirst = true;
                dotSeen = true;
                ++pos.start;
                continue;
            }
            if (Character.isJavaIdentifierPart(c)) {
                ++pos.start;
                dotSeen = false;
                continue;
            }
            return pos.line.substring(start, pos.start);
        } while (pos.line.length() - pos.start >= 1);
        return pos.line.substring(start, pos.start);
    }

    private static String getByteCode(PosSchema pos) {
        if (pos.line == null || pos.line.length() - pos.start < 1) {
            return "";
        }
        int start = pos.start;
        while (!OpenLdapSchemaParser.isEmpty(pos) && (OpenLdapSchemaParser.isAlpha(pos) || OpenLdapSchemaParser.isDigit(pos) || OpenLdapSchemaParser.startsWith(pos, '+') || OpenLdapSchemaParser.startsWith(pos, '/') || OpenLdapSchemaParser.startsWith(pos, '='))) {
            ++pos.start;
            if (pos.line != null && pos.line.length() - pos.start >= 1) continue;
            return pos.line.substring(start, pos.start);
        }
        return pos.line.substring(start, pos.start);
    }

    private static int checkElement(int elementsSeen, SchemaObjectElements element, PosSchema pos) throws LdapSchemaException {
        if ((elementsSeen & element.getValue()) != 0) {
            throw new LdapSchemaException(I18n.err(I18n.ERR_13780_SCHEMA_OBJECT_DESCRIPTION_HAS_ELEMENT_TWICE, element, pos.lineNumber, pos.start));
        }
        return elementsSeen |= element.getValue();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public AttributeType parseAttributeType(String attributeTypeDescription) throws ParseException {
        if (attributeTypeDescription == null) throw new ParseException(I18n.err(I18n.ERR_13716_NULL_OR_EMPTY_STRING_SCHEMA_OBJECT, new Object[0]), 0);
        if (Strings.isEmpty(attributeTypeDescription.trim())) {
            throw new ParseException(I18n.err(I18n.ERR_13716_NULL_OR_EMPTY_STRING_SCHEMA_OBJECT, new Object[0]), 0);
        }
        try (BufferedReader reader = new BufferedReader(new StringReader(attributeTypeDescription));){
            PosSchema pos = new PosSchema();
            if (this.isQuirksModeEnabled) {
                AttributeType attributeType = OpenLdapSchemaParser.parseAttributeTypeRelaxed(reader, pos, this.objectIdentifierMacros);
                return attributeType;
            }
            AttributeType attributeType = OpenLdapSchemaParser.parseAttributeTypeStrict(reader, pos, this.objectIdentifierMacros);
            return attributeType;
        }
        catch (IOException | LdapSchemaException e) {
            LOG.trace("Error parsing attribute type {}: {}", attributeTypeDescription, e.getMessage(), e);
            throw new ParseException(e.getMessage(), 0);
        }
    }

    private static AttributeType parseAttributeTypeStrict(Reader reader, PosSchema pos, Map<String, OpenLdapObjectIdentifierMacro> objectIdentifierMacros) throws IOException, LdapSchemaException {
        boolean hasSyntax;
        boolean hasSup;
        MutableAttributeType attributeType;
        block21: {
            OpenLdapSchemaParser.skipWhites(reader, pos, false);
            if (pos.line.charAt(pos.start) != '(') {
                throw new LdapSchemaException(I18n.err(I18n.ERR_13829_NO_OPENING_PAREN, pos.lineNumber, pos.start));
            }
            ++pos.start;
            OpenLdapSchemaParser.skipWhites(reader, pos, false);
            String oid = OpenLdapSchemaParser.getOidAndMacroRelaxed(pos, objectIdentifierMacros);
            if (!Oid.isOid(oid)) {
                throw new LdapSchemaException(I18n.err(I18n.ERR_13787_OID_EXPECTED, pos.lineNumber, pos.start));
            }
            attributeType = new MutableAttributeType(oid);
            hasSup = false;
            hasSyntax = false;
            int elementsSeen = 0;
            while (true) {
                if (OpenLdapSchemaParser.startsWith(reader, pos, ')')) {
                    ++pos.start;
                    break block21;
                }
                OpenLdapSchemaParser.skipWhites(reader, pos, true);
                if (OpenLdapSchemaParser.startsWith(pos, NAME_STR)) {
                    elementsSeen = OpenLdapSchemaParser.checkElement(elementsSeen, AttributeTypeElements.NAME, pos);
                    pos.start += NAME_STR.length();
                    OpenLdapSchemaParser.skipWhites(reader, pos, true);
                    attributeType.setNames(OpenLdapSchemaParser.getQDescrs(reader, pos, false));
                    continue;
                }
                if (OpenLdapSchemaParser.startsWith(pos, DESC_STR)) {
                    elementsSeen = OpenLdapSchemaParser.checkElement(elementsSeen, AttributeTypeElements.DESC, pos);
                    pos.start += DESC_STR.length();
                    OpenLdapSchemaParser.skipWhites(reader, pos, true);
                    attributeType.setDescription(OpenLdapSchemaParser.getQDString(reader, pos));
                    continue;
                }
                if (OpenLdapSchemaParser.startsWith(pos, OBSOLETE_STR)) {
                    elementsSeen = OpenLdapSchemaParser.checkElement(elementsSeen, AttributeTypeElements.OBSOLETE, pos);
                    pos.start += OBSOLETE_STR.length();
                    attributeType.setObsolete(true);
                    continue;
                }
                if (OpenLdapSchemaParser.startsWith(pos, SUP_STR)) {
                    elementsSeen = OpenLdapSchemaParser.checkElement(elementsSeen, AttributeTypeElements.SUP, pos);
                    pos.start += SUP_STR.length();
                    OpenLdapSchemaParser.skipWhites(reader, pos, true);
                    String superiorOid = OpenLdapSchemaParser.getOidStrict(pos);
                    attributeType.setSuperiorOid(superiorOid);
                    hasSup = true;
                    continue;
                }
                if (OpenLdapSchemaParser.startsWith(pos, EQUALITY_STR)) {
                    elementsSeen = OpenLdapSchemaParser.checkElement(elementsSeen, AttributeTypeElements.EQUALITY, pos);
                    pos.start += EQUALITY_STR.length();
                    OpenLdapSchemaParser.skipWhites(reader, pos, true);
                    String equalityOid = OpenLdapSchemaParser.getOidStrict(pos);
                    attributeType.setEqualityOid(equalityOid);
                    continue;
                }
                if (OpenLdapSchemaParser.startsWith(pos, ORDERING_STR)) {
                    elementsSeen = OpenLdapSchemaParser.checkElement(elementsSeen, AttributeTypeElements.ORDERING, pos);
                    pos.start += ORDERING_STR.length();
                    OpenLdapSchemaParser.skipWhites(reader, pos, true);
                    String orderingOid = OpenLdapSchemaParser.getOidStrict(pos);
                    attributeType.setOrderingOid(orderingOid);
                    continue;
                }
                if (OpenLdapSchemaParser.startsWith(pos, SUBSTR_STR)) {
                    elementsSeen = OpenLdapSchemaParser.checkElement(elementsSeen, AttributeTypeElements.SUBSTR, pos);
                    pos.start += SUBSTR_STR.length();
                    OpenLdapSchemaParser.skipWhites(reader, pos, true);
                    String substrOid = OpenLdapSchemaParser.getOidStrict(pos);
                    attributeType.setSubstringOid(substrOid);
                    continue;
                }
                if (OpenLdapSchemaParser.startsWith(pos, SYNTAX_STR)) {
                    elementsSeen = OpenLdapSchemaParser.checkElement(elementsSeen, AttributeTypeElements.SYNTAX, pos);
                    pos.start += SYNTAX_STR.length();
                    OpenLdapSchemaParser.skipWhites(reader, pos, true);
                    OpenLdapSchemaParser.getNoidLenStrict(attributeType, pos);
                    hasSyntax = true;
                    continue;
                }
                if (OpenLdapSchemaParser.startsWith(pos, SINGLE_VALUE_STR)) {
                    elementsSeen = OpenLdapSchemaParser.checkElement(elementsSeen, AttributeTypeElements.SINGLE_VALUE, pos);
                    pos.start += SINGLE_VALUE_STR.length();
                    attributeType.setSingleValued(true);
                    continue;
                }
                if (OpenLdapSchemaParser.startsWith(pos, COLLECTIVE_STR)) {
                    elementsSeen = OpenLdapSchemaParser.checkElement(elementsSeen, AttributeTypeElements.COLLECTIVE, pos);
                    pos.start += COLLECTIVE_STR.length();
                    attributeType.setCollective(true);
                    continue;
                }
                if (OpenLdapSchemaParser.startsWith(pos, NO_USER_MODIFICATION_STR)) {
                    elementsSeen = OpenLdapSchemaParser.checkElement(elementsSeen, AttributeTypeElements.NO_USER_MODIFICATION, pos);
                    pos.start += NO_USER_MODIFICATION_STR.length();
                    attributeType.setUserModifiable(false);
                    continue;
                }
                if (OpenLdapSchemaParser.startsWith(pos, USAGE_STR)) {
                    elementsSeen = OpenLdapSchemaParser.checkElement(elementsSeen, AttributeTypeElements.USAGE, pos);
                    pos.start += USAGE_STR.length();
                    OpenLdapSchemaParser.skipWhites(reader, pos, true);
                    UsageEnum usage = OpenLdapSchemaParser.getUsageStrict(pos);
                    attributeType.setUsage(usage);
                    continue;
                }
                if (!OpenLdapSchemaParser.startsWith(pos, EXTENSION_PREFIX)) break;
                OpenLdapSchemaParser.processExtension(reader, pos, attributeType);
            }
            if (OpenLdapSchemaParser.startsWith(reader, pos, ')')) {
                ++pos.start;
            } else {
                throw new LdapSchemaException(I18n.err(I18n.ERR_13798_AT_DESCRIPTION_INVALID, pos.lineNumber, pos.start));
            }
        }
        if (!hasSup && !hasSyntax) {
            throw new LdapSchemaException(I18n.err(I18n.ERR_13799_SYNTAX_OR_SUP_REQUIRED, pos.lineNumber, pos.start));
        }
        if (attributeType.isCollective() && attributeType.getUsage() != UsageEnum.USER_APPLICATIONS) {
            throw new LdapSchemaException(I18n.err(I18n.ERR_13800_COLLECTIVE_REQUIRES_USER_APPLICATION, pos.lineNumber, pos.start));
        }
        if (!attributeType.isUserModifiable() && attributeType.getUsage() == UsageEnum.USER_APPLICATIONS) {
            throw new LdapSchemaException(I18n.err(I18n.ERR_13801_NO_USER_MOD_REQUIRE_OPERATIONAL, pos.lineNumber, pos.start));
        }
        return attributeType;
    }

    private static AttributeType parseAttributeTypeRelaxed(Reader reader, PosSchema pos, Map<String, OpenLdapObjectIdentifierMacro> objectIdentifierMacros) throws IOException, LdapSchemaException {
        MutableAttributeType attributeType;
        block17: {
            OpenLdapSchemaParser.skipWhites(reader, pos, false);
            if (pos.line.charAt(pos.start) != '(') {
                throw new LdapSchemaException(I18n.err(I18n.ERR_13829_NO_OPENING_PAREN, pos.lineNumber, pos.start));
            }
            ++pos.start;
            OpenLdapSchemaParser.skipWhites(reader, pos, false);
            String oid = OpenLdapSchemaParser.getOidAndMacroRelaxed(pos, objectIdentifierMacros);
            attributeType = new MutableAttributeType(oid);
            int elementsSeen = 0;
            while (true) {
                if (OpenLdapSchemaParser.startsWith(reader, pos, ')')) {
                    ++pos.start;
                    break block17;
                }
                OpenLdapSchemaParser.skipWhites(reader, pos, false);
                if (OpenLdapSchemaParser.startsWith(pos, NAME_STR)) {
                    elementsSeen = OpenLdapSchemaParser.checkElement(elementsSeen, AttributeTypeElements.NAME, pos);
                    pos.start += NAME_STR.length();
                    OpenLdapSchemaParser.skipWhites(reader, pos, true);
                    attributeType.setNames(OpenLdapSchemaParser.getQDescrs(reader, pos, true));
                    continue;
                }
                if (OpenLdapSchemaParser.startsWith(pos, DESC_STR)) {
                    elementsSeen = OpenLdapSchemaParser.checkElement(elementsSeen, AttributeTypeElements.DESC, pos);
                    pos.start += DESC_STR.length();
                    OpenLdapSchemaParser.skipWhites(reader, pos, true);
                    attributeType.setDescription(OpenLdapSchemaParser.getQDString(reader, pos));
                    continue;
                }
                if (OpenLdapSchemaParser.startsWith(pos, OBSOLETE_STR)) {
                    elementsSeen = OpenLdapSchemaParser.checkElement(elementsSeen, AttributeTypeElements.OBSOLETE, pos);
                    pos.start += OBSOLETE_STR.length();
                    attributeType.setObsolete(true);
                    continue;
                }
                if (OpenLdapSchemaParser.startsWith(pos, SUP_STR)) {
                    elementsSeen = OpenLdapSchemaParser.checkElement(elementsSeen, AttributeTypeElements.SUP, pos);
                    pos.start += SUP_STR.length();
                    OpenLdapSchemaParser.skipWhites(reader, pos, true);
                    String superiorOid = OpenLdapSchemaParser.getOidRelaxed(pos, false);
                    attributeType.setSuperiorOid(superiorOid);
                    continue;
                }
                if (OpenLdapSchemaParser.startsWith(pos, EQUALITY_STR)) {
                    elementsSeen = OpenLdapSchemaParser.checkElement(elementsSeen, AttributeTypeElements.EQUALITY, pos);
                    pos.start += EQUALITY_STR.length();
                    OpenLdapSchemaParser.skipWhites(reader, pos, true);
                    String equalityOid = OpenLdapSchemaParser.getOidRelaxed(pos, false);
                    attributeType.setEqualityOid(equalityOid);
                    continue;
                }
                if (OpenLdapSchemaParser.startsWith(pos, ORDERING_STR)) {
                    elementsSeen = OpenLdapSchemaParser.checkElement(elementsSeen, AttributeTypeElements.ORDERING, pos);
                    pos.start += ORDERING_STR.length();
                    OpenLdapSchemaParser.skipWhites(reader, pos, true);
                    String orderingOid = OpenLdapSchemaParser.getOidRelaxed(pos, false);
                    attributeType.setOrderingOid(orderingOid);
                    continue;
                }
                if (OpenLdapSchemaParser.startsWith(pos, SUBSTR_STR)) {
                    elementsSeen = OpenLdapSchemaParser.checkElement(elementsSeen, AttributeTypeElements.SUBSTR, pos);
                    pos.start += SUBSTR_STR.length();
                    OpenLdapSchemaParser.skipWhites(reader, pos, true);
                    String substrOid = OpenLdapSchemaParser.getOidRelaxed(pos, false);
                    attributeType.setSubstringOid(substrOid);
                    continue;
                }
                if (OpenLdapSchemaParser.startsWith(pos, SYNTAX_STR)) {
                    elementsSeen = OpenLdapSchemaParser.checkElement(elementsSeen, AttributeTypeElements.SYNTAX, pos);
                    pos.start += SYNTAX_STR.length();
                    OpenLdapSchemaParser.skipWhites(reader, pos, true);
                    OpenLdapSchemaParser.getNoidLenRelaxed(attributeType, pos);
                    continue;
                }
                if (OpenLdapSchemaParser.startsWith(pos, SINGLE_VALUE_STR)) {
                    elementsSeen = OpenLdapSchemaParser.checkElement(elementsSeen, AttributeTypeElements.SINGLE_VALUE, pos);
                    pos.start += SINGLE_VALUE_STR.length();
                    attributeType.setSingleValued(true);
                    continue;
                }
                if (OpenLdapSchemaParser.startsWith(pos, COLLECTIVE_STR)) {
                    elementsSeen = OpenLdapSchemaParser.checkElement(elementsSeen, AttributeTypeElements.COLLECTIVE, pos);
                    pos.start += COLLECTIVE_STR.length();
                    attributeType.setCollective(true);
                    continue;
                }
                if (OpenLdapSchemaParser.startsWith(pos, NO_USER_MODIFICATION_STR)) {
                    elementsSeen = OpenLdapSchemaParser.checkElement(elementsSeen, AttributeTypeElements.NO_USER_MODIFICATION, pos);
                    pos.start += NO_USER_MODIFICATION_STR.length();
                    attributeType.setUserModifiable(false);
                    continue;
                }
                if (OpenLdapSchemaParser.startsWith(pos, USAGE_STR)) {
                    elementsSeen = OpenLdapSchemaParser.checkElement(elementsSeen, AttributeTypeElements.USAGE, pos);
                    pos.start += USAGE_STR.length();
                    OpenLdapSchemaParser.skipWhites(reader, pos, true);
                    UsageEnum usage = OpenLdapSchemaParser.getUsageRelaxed(pos);
                    attributeType.setUsage(usage);
                    continue;
                }
                if (!OpenLdapSchemaParser.startsWith(pos, EXTENSION_PREFIX)) break;
                OpenLdapSchemaParser.processExtension(reader, pos, attributeType);
            }
            if (OpenLdapSchemaParser.startsWith(reader, pos, ')')) {
                ++pos.start;
            } else {
                throw new LdapSchemaException(I18n.err(I18n.ERR_13798_AT_DESCRIPTION_INVALID, pos.lineNumber, pos.start));
            }
        }
        return attributeType;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DitContentRule parseDitContentRule(String ditContentRuleDescription) throws ParseException {
        if (ditContentRuleDescription == null) throw new ParseException(I18n.err(I18n.ERR_13716_NULL_OR_EMPTY_STRING_SCHEMA_OBJECT, new Object[0]), 0);
        if (Strings.isEmpty(ditContentRuleDescription.trim())) {
            throw new ParseException(I18n.err(I18n.ERR_13716_NULL_OR_EMPTY_STRING_SCHEMA_OBJECT, new Object[0]), 0);
        }
        try (BufferedReader reader = new BufferedReader(new StringReader(ditContentRuleDescription));){
            PosSchema pos = new PosSchema();
            if (this.isQuirksModeEnabled) {
                DitContentRule ditContentRule = OpenLdapSchemaParser.parseDitContentRuleRelaxed(reader, pos, this.objectIdentifierMacros);
                return ditContentRule;
            }
            DitContentRule ditContentRule = OpenLdapSchemaParser.parseDitContentRuleStrict(reader, pos, this.objectIdentifierMacros);
            return ditContentRule;
        }
        catch (IOException | LdapSchemaException e) {
            throw new ParseException(e.getMessage(), 0);
        }
    }

    private static DitContentRule parseDitContentRuleStrict(Reader reader, PosSchema pos, Map<String, OpenLdapObjectIdentifierMacro> objectIdentifierMacros) throws IOException, LdapSchemaException {
        DitContentRule ditContentRule;
        block13: {
            OpenLdapSchemaParser.skipWhites(reader, pos, false);
            if (pos.line.charAt(pos.start) != '(') {
                throw new LdapSchemaException(I18n.err(I18n.ERR_13829_NO_OPENING_PAREN, pos.lineNumber, pos.start));
            }
            ++pos.start;
            OpenLdapSchemaParser.skipWhites(reader, pos, false);
            String oid = OpenLdapSchemaParser.getOidAndMacroRelaxed(pos, objectIdentifierMacros);
            if (!Oid.isOid(oid)) {
                throw new LdapSchemaException(I18n.err(I18n.ERR_13787_OID_EXPECTED, pos.lineNumber, pos.start));
            }
            ditContentRule = new DitContentRule(oid);
            int elementsSeen = 0;
            while (true) {
                if (OpenLdapSchemaParser.startsWith(reader, pos, ')')) {
                    ++pos.start;
                    break block13;
                }
                OpenLdapSchemaParser.skipWhites(reader, pos, true);
                if (OpenLdapSchemaParser.startsWith(pos, NAME_STR)) {
                    elementsSeen = OpenLdapSchemaParser.checkElement(elementsSeen, DitContentRuleElements.NAME, pos);
                    pos.start += NAME_STR.length();
                    OpenLdapSchemaParser.skipWhites(reader, pos, true);
                    ditContentRule.setNames(OpenLdapSchemaParser.getQDescrs(reader, pos, false));
                    continue;
                }
                if (OpenLdapSchemaParser.startsWith(pos, DESC_STR)) {
                    elementsSeen = OpenLdapSchemaParser.checkElement(elementsSeen, DitContentRuleElements.DESC, pos);
                    pos.start += DESC_STR.length();
                    OpenLdapSchemaParser.skipWhites(reader, pos, true);
                    ditContentRule.setDescription(OpenLdapSchemaParser.getQDString(reader, pos));
                    continue;
                }
                if (OpenLdapSchemaParser.startsWith(pos, OBSOLETE_STR)) {
                    elementsSeen = OpenLdapSchemaParser.checkElement(elementsSeen, DitContentRuleElements.OBSOLETE, pos);
                    pos.start += OBSOLETE_STR.length();
                    ditContentRule.setObsolete(true);
                    continue;
                }
                if (OpenLdapSchemaParser.startsWith(pos, AUX_STR)) {
                    elementsSeen = OpenLdapSchemaParser.checkElement(elementsSeen, DitContentRuleElements.AUX, pos);
                    pos.start += AUX_STR.length();
                    OpenLdapSchemaParser.skipWhites(reader, pos, true);
                    List<String> aux = OpenLdapSchemaParser.getOidsStrict(reader, pos);
                    ditContentRule.setAuxObjectClassOids(aux);
                    continue;
                }
                if (OpenLdapSchemaParser.startsWith(pos, MUST_STR)) {
                    elementsSeen = OpenLdapSchemaParser.checkElement(elementsSeen, DitContentRuleElements.MUST, pos);
                    pos.start += MUST_STR.length();
                    OpenLdapSchemaParser.skipWhites(reader, pos, true);
                    List<String> must = OpenLdapSchemaParser.getOidsStrict(reader, pos);
                    ditContentRule.setMustAttributeTypeOids(must);
                    continue;
                }
                if (OpenLdapSchemaParser.startsWith(pos, MAY_STR)) {
                    elementsSeen = OpenLdapSchemaParser.checkElement(elementsSeen, DitContentRuleElements.MAY, pos);
                    pos.start += MAY_STR.length();
                    OpenLdapSchemaParser.skipWhites(reader, pos, true);
                    List<String> may = OpenLdapSchemaParser.getOidsStrict(reader, pos);
                    ditContentRule.setMayAttributeTypeOids(may);
                    continue;
                }
                if (OpenLdapSchemaParser.startsWith(pos, NOT_STR)) {
                    elementsSeen = OpenLdapSchemaParser.checkElement(elementsSeen, DitContentRuleElements.NOT, pos);
                    pos.start += NOT_STR.length();
                    OpenLdapSchemaParser.skipWhites(reader, pos, true);
                    List<String> not = OpenLdapSchemaParser.getOidsStrict(reader, pos);
                    ditContentRule.setNotAttributeTypeOids(not);
                    continue;
                }
                if (!OpenLdapSchemaParser.startsWith(pos, EXTENSION_PREFIX)) break;
                OpenLdapSchemaParser.processExtension(reader, pos, ditContentRule);
            }
            if (OpenLdapSchemaParser.startsWith(reader, pos, ')')) {
                ++pos.start;
            } else {
                throw new LdapSchemaException(I18n.err(I18n.ERR_13809_DCR_DESCRIPTION_INVALID, pos.lineNumber, pos.start));
            }
        }
        return ditContentRule;
    }

    private static DitContentRule parseDitContentRuleRelaxed(Reader reader, PosSchema pos, Map<String, OpenLdapObjectIdentifierMacro> objectIdentifierMacros) throws IOException, LdapSchemaException {
        DitContentRule ditContentRule;
        block12: {
            OpenLdapSchemaParser.skipWhites(reader, pos, false);
            if (pos.line.charAt(pos.start) != '(') {
                throw new LdapSchemaException(I18n.err(I18n.ERR_13829_NO_OPENING_PAREN, pos.lineNumber, pos.start));
            }
            ++pos.start;
            OpenLdapSchemaParser.skipWhites(reader, pos, false);
            String oid = OpenLdapSchemaParser.getOidAndMacroRelaxed(pos, objectIdentifierMacros);
            ditContentRule = new DitContentRule(oid);
            int elementsSeen = 0;
            while (true) {
                if (OpenLdapSchemaParser.startsWith(reader, pos, ')')) {
                    ++pos.start;
                    break block12;
                }
                OpenLdapSchemaParser.skipWhites(reader, pos, true);
                if (OpenLdapSchemaParser.startsWith(pos, NAME_STR)) {
                    elementsSeen = OpenLdapSchemaParser.checkElement(elementsSeen, DitContentRuleElements.NAME, pos);
                    pos.start += NAME_STR.length();
                    OpenLdapSchemaParser.skipWhites(reader, pos, true);
                    ditContentRule.setNames(OpenLdapSchemaParser.getQDescrs(reader, pos, true));
                    continue;
                }
                if (OpenLdapSchemaParser.startsWith(pos, DESC_STR)) {
                    elementsSeen = OpenLdapSchemaParser.checkElement(elementsSeen, DitContentRuleElements.DESC, pos);
                    pos.start += DESC_STR.length();
                    OpenLdapSchemaParser.skipWhites(reader, pos, true);
                    ditContentRule.setDescription(OpenLdapSchemaParser.getQDString(reader, pos));
                    continue;
                }
                if (OpenLdapSchemaParser.startsWith(pos, OBSOLETE_STR)) {
                    elementsSeen = OpenLdapSchemaParser.checkElement(elementsSeen, DitContentRuleElements.OBSOLETE, pos);
                    pos.start += OBSOLETE_STR.length();
                    ditContentRule.setObsolete(true);
                    continue;
                }
                if (OpenLdapSchemaParser.startsWith(pos, AUX_STR)) {
                    elementsSeen = OpenLdapSchemaParser.checkElement(elementsSeen, DitContentRuleElements.AUX, pos);
                    pos.start += AUX_STR.length();
                    OpenLdapSchemaParser.skipWhites(reader, pos, true);
                    List<String> aux = OpenLdapSchemaParser.getOidsRelaxed(reader, pos);
                    ditContentRule.setAuxObjectClassOids(aux);
                    continue;
                }
                if (OpenLdapSchemaParser.startsWith(pos, MUST_STR)) {
                    elementsSeen = OpenLdapSchemaParser.checkElement(elementsSeen, DitContentRuleElements.MUST, pos);
                    pos.start += MUST_STR.length();
                    OpenLdapSchemaParser.skipWhites(reader, pos, true);
                    List<String> must = OpenLdapSchemaParser.getOidsRelaxed(reader, pos);
                    ditContentRule.setMustAttributeTypeOids(must);
                    continue;
                }
                if (OpenLdapSchemaParser.startsWith(pos, MAY_STR)) {
                    elementsSeen = OpenLdapSchemaParser.checkElement(elementsSeen, DitContentRuleElements.MAY, pos);
                    pos.start += MAY_STR.length();
                    OpenLdapSchemaParser.skipWhites(reader, pos, true);
                    List<String> may = OpenLdapSchemaParser.getOidsRelaxed(reader, pos);
                    ditContentRule.setMayAttributeTypeOids(may);
                    continue;
                }
                if (OpenLdapSchemaParser.startsWith(pos, NOT_STR)) {
                    elementsSeen = OpenLdapSchemaParser.checkElement(elementsSeen, DitContentRuleElements.NOT, pos);
                    pos.start += NOT_STR.length();
                    OpenLdapSchemaParser.skipWhites(reader, pos, true);
                    List<String> not = OpenLdapSchemaParser.getOidsRelaxed(reader, pos);
                    ditContentRule.setNotAttributeTypeOids(not);
                    continue;
                }
                if (!OpenLdapSchemaParser.startsWith(pos, EXTENSION_PREFIX)) break;
                OpenLdapSchemaParser.processExtension(reader, pos, ditContentRule);
            }
            if (OpenLdapSchemaParser.startsWith(reader, pos, ')')) {
                ++pos.start;
            } else {
                throw new LdapSchemaException(I18n.err(I18n.ERR_13809_DCR_DESCRIPTION_INVALID, pos.lineNumber, pos.start));
            }
        }
        return ditContentRule;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DitStructureRule parseDitStructureRule(String ditStructureRuleDescription) throws ParseException {
        if (ditStructureRuleDescription == null) throw new ParseException(I18n.err(I18n.ERR_13716_NULL_OR_EMPTY_STRING_SCHEMA_OBJECT, new Object[0]), 0);
        if (Strings.isEmpty(ditStructureRuleDescription.trim())) {
            throw new ParseException(I18n.err(I18n.ERR_13716_NULL_OR_EMPTY_STRING_SCHEMA_OBJECT, new Object[0]), 0);
        }
        try (BufferedReader reader = new BufferedReader(new StringReader(ditStructureRuleDescription));){
            PosSchema pos = new PosSchema();
            if (this.isQuirksModeEnabled) {
                DitStructureRule ditStructureRule = OpenLdapSchemaParser.parseDitStructureRuleRelaxed(reader, pos, this.objectIdentifierMacros);
                return ditStructureRule;
            }
            DitStructureRule ditStructureRule = OpenLdapSchemaParser.parseDitStructureRuleStrict(reader, pos);
            return ditStructureRule;
        }
        catch (IOException | LdapSchemaException e) {
            throw new ParseException(e.getMessage(), 0);
        }
    }

    private static DitStructureRule parseDitStructureRuleStrict(Reader reader, PosSchema pos) throws IOException, LdapSchemaException {
        boolean hasForm;
        DitStructureRule ditStructureRule;
        block11: {
            OpenLdapSchemaParser.skipWhites(reader, pos, false);
            if (pos.line.charAt(pos.start) != '(') {
                throw new LdapSchemaException(I18n.err(I18n.ERR_13829_NO_OPENING_PAREN, pos.lineNumber, pos.start));
            }
            ++pos.start;
            OpenLdapSchemaParser.skipWhites(reader, pos, false);
            int ruleId = OpenLdapSchemaParser.getRuleId(pos);
            ditStructureRule = new DitStructureRule(ruleId);
            int elementsSeen = 0;
            hasForm = false;
            while (true) {
                if (OpenLdapSchemaParser.startsWith(reader, pos, ')')) {
                    ++pos.start;
                    break block11;
                }
                OpenLdapSchemaParser.skipWhites(reader, pos, true);
                if (OpenLdapSchemaParser.startsWith(pos, NAME_STR)) {
                    elementsSeen = OpenLdapSchemaParser.checkElement(elementsSeen, DitStructureRuleElements.NAME, pos);
                    pos.start += NAME_STR.length();
                    OpenLdapSchemaParser.skipWhites(reader, pos, true);
                    ditStructureRule.setNames(OpenLdapSchemaParser.getQDescrs(reader, pos, false));
                    continue;
                }
                if (OpenLdapSchemaParser.startsWith(pos, DESC_STR)) {
                    elementsSeen = OpenLdapSchemaParser.checkElement(elementsSeen, DitStructureRuleElements.DESC, pos);
                    pos.start += DESC_STR.length();
                    OpenLdapSchemaParser.skipWhites(reader, pos, true);
                    ditStructureRule.setDescription(OpenLdapSchemaParser.getQDString(reader, pos));
                    continue;
                }
                if (OpenLdapSchemaParser.startsWith(pos, OBSOLETE_STR)) {
                    elementsSeen = OpenLdapSchemaParser.checkElement(elementsSeen, DitStructureRuleElements.OBSOLETE, pos);
                    pos.start += OBSOLETE_STR.length();
                    ditStructureRule.setObsolete(true);
                    continue;
                }
                if (OpenLdapSchemaParser.startsWith(pos, FORM_STR)) {
                    elementsSeen = OpenLdapSchemaParser.checkElement(elementsSeen, DitStructureRuleElements.FORM, pos);
                    pos.start += FORM_STR.length();
                    OpenLdapSchemaParser.skipWhites(reader, pos, true);
                    String form = OpenLdapSchemaParser.getOidStrict(pos);
                    ditStructureRule.setForm(form);
                    hasForm = true;
                    continue;
                }
                if (OpenLdapSchemaParser.startsWith(pos, SUP_STR)) {
                    elementsSeen = OpenLdapSchemaParser.checkElement(elementsSeen, DitStructureRuleElements.SUP, pos);
                    pos.start += SUP_STR.length();
                    OpenLdapSchemaParser.skipWhites(reader, pos, true);
                    List<Integer> superRules = OpenLdapSchemaParser.getRuleIds(reader, pos);
                    ditStructureRule.setSuperRules(superRules);
                    continue;
                }
                if (!OpenLdapSchemaParser.startsWith(pos, EXTENSION_PREFIX)) break;
                OpenLdapSchemaParser.processExtension(reader, pos, ditStructureRule);
            }
            if (OpenLdapSchemaParser.startsWith(reader, pos, ')')) {
                ++pos.start;
            } else {
                throw new LdapSchemaException(I18n.err(I18n.ERR_13809_DCR_DESCRIPTION_INVALID, pos.lineNumber, pos.start));
            }
        }
        if (!hasForm) {
            throw new LdapSchemaException(I18n.err(I18n.ERR_13812_FORM_REQUIRED, pos.lineNumber, pos.start));
        }
        return ditStructureRule;
    }

    private static DitStructureRule parseDitStructureRuleRelaxed(Reader reader, PosSchema pos, Map<String, OpenLdapObjectIdentifierMacro> objectIdentifierMacros) throws IOException, LdapSchemaException {
        boolean hasForm;
        DitStructureRule ditStructureRule;
        block11: {
            OpenLdapSchemaParser.skipWhites(reader, pos, false);
            if (pos.line.charAt(pos.start) != '(') {
                throw new LdapSchemaException(I18n.err(I18n.ERR_13829_NO_OPENING_PAREN, pos.lineNumber, pos.start));
            }
            ++pos.start;
            OpenLdapSchemaParser.skipWhites(reader, pos, false);
            int ruleId = OpenLdapSchemaParser.getRuleId(pos);
            ditStructureRule = new DitStructureRule(ruleId);
            int elementsSeen = 0;
            hasForm = false;
            while (true) {
                if (OpenLdapSchemaParser.startsWith(reader, pos, ')')) {
                    ++pos.start;
                    break block11;
                }
                OpenLdapSchemaParser.skipWhites(reader, pos, true);
                if (OpenLdapSchemaParser.startsWith(pos, NAME_STR)) {
                    elementsSeen = OpenLdapSchemaParser.checkElement(elementsSeen, DitStructureRuleElements.NAME, pos);
                    pos.start += NAME_STR.length();
                    OpenLdapSchemaParser.skipWhites(reader, pos, true);
                    ditStructureRule.setNames(OpenLdapSchemaParser.getQDescrs(reader, pos, true));
                    continue;
                }
                if (OpenLdapSchemaParser.startsWith(pos, DESC_STR)) {
                    elementsSeen = OpenLdapSchemaParser.checkElement(elementsSeen, DitStructureRuleElements.DESC, pos);
                    pos.start += DESC_STR.length();
                    OpenLdapSchemaParser.skipWhites(reader, pos, true);
                    ditStructureRule.setDescription(OpenLdapSchemaParser.getQDString(reader, pos));
                    continue;
                }
                if (OpenLdapSchemaParser.startsWith(pos, OBSOLETE_STR)) {
                    elementsSeen = OpenLdapSchemaParser.checkElement(elementsSeen, DitStructureRuleElements.OBSOLETE, pos);
                    pos.start += OBSOLETE_STR.length();
                    ditStructureRule.setObsolete(true);
                    continue;
                }
                if (OpenLdapSchemaParser.startsWith(pos, FORM_STR)) {
                    elementsSeen = OpenLdapSchemaParser.checkElement(elementsSeen, DitStructureRuleElements.FORM, pos);
                    pos.start += FORM_STR.length();
                    OpenLdapSchemaParser.skipWhites(reader, pos, true);
                    String form = OpenLdapSchemaParser.getOidRelaxed(pos, false);
                    ditStructureRule.setForm(form);
                    hasForm = true;
                    continue;
                }
                if (OpenLdapSchemaParser.startsWith(pos, SUP_STR)) {
                    elementsSeen = OpenLdapSchemaParser.checkElement(elementsSeen, DitStructureRuleElements.SUP, pos);
                    pos.start += SUP_STR.length();
                    OpenLdapSchemaParser.skipWhites(reader, pos, true);
                    List<Integer> superRules = OpenLdapSchemaParser.getRuleIds(reader, pos);
                    ditStructureRule.setSuperRules(superRules);
                    continue;
                }
                if (!OpenLdapSchemaParser.startsWith(pos, EXTENSION_PREFIX)) break;
                OpenLdapSchemaParser.processExtension(reader, pos, ditStructureRule);
            }
            if (OpenLdapSchemaParser.startsWith(reader, pos, ')')) {
                ++pos.start;
            } else {
                throw new LdapSchemaException(I18n.err(I18n.ERR_13809_DCR_DESCRIPTION_INVALID, pos.lineNumber, pos.start));
            }
        }
        if (!hasForm) {
            throw new LdapSchemaException(I18n.err(I18n.ERR_13812_FORM_REQUIRED, pos.lineNumber, pos.start));
        }
        return ditStructureRule;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public LdapComparatorDescription parseLdapComparator(String ldapComparatorDescription) throws ParseException {
        if (ldapComparatorDescription == null) throw new ParseException(I18n.err(I18n.ERR_13716_NULL_OR_EMPTY_STRING_SCHEMA_OBJECT, new Object[0]), 0);
        if (Strings.isEmpty(ldapComparatorDescription.trim())) {
            throw new ParseException(I18n.err(I18n.ERR_13716_NULL_OR_EMPTY_STRING_SCHEMA_OBJECT, new Object[0]), 0);
        }
        try (BufferedReader reader = new BufferedReader(new StringReader(ldapComparatorDescription));){
            PosSchema pos = new PosSchema();
            if (this.isQuirksModeEnabled) {
                LdapComparatorDescription ldapComparatorDescription2 = OpenLdapSchemaParser.parseLdapComparatorRelaxed(reader, pos, this.objectIdentifierMacros);
                return ldapComparatorDescription2;
            }
            LdapComparatorDescription ldapComparatorDescription3 = OpenLdapSchemaParser.parseLdapComparatorStrict(reader, pos, this.objectIdentifierMacros);
            return ldapComparatorDescription3;
        }
        catch (IOException | LdapSchemaException e) {
            throw new ParseException(e.getMessage(), 0);
        }
    }

    private static LdapComparatorDescription parseLdapComparatorStrict(Reader reader, PosSchema pos, Map<String, OpenLdapObjectIdentifierMacro> objectIdentifierMacros) throws IOException, LdapSchemaException {
        boolean hasByteCode;
        boolean hasFqcn;
        LdapComparatorDescription ldapComparator;
        block11: {
            OpenLdapSchemaParser.skipWhites(reader, pos, false);
            if (pos.line.charAt(pos.start) != '(') {
                throw new LdapSchemaException(I18n.err(I18n.ERR_13829_NO_OPENING_PAREN, pos.lineNumber, pos.start));
            }
            ++pos.start;
            OpenLdapSchemaParser.skipWhites(reader, pos, false);
            String oid = OpenLdapSchemaParser.getOidAndMacroRelaxed(pos, objectIdentifierMacros);
            if (!Oid.isOid(oid)) {
                throw new LdapSchemaException(I18n.err(I18n.ERR_13787_OID_EXPECTED, pos.lineNumber, pos.start));
            }
            ldapComparator = new LdapComparatorDescription(oid);
            int elementsSeen = 0;
            hasFqcn = false;
            hasByteCode = false;
            while (true) {
                if (OpenLdapSchemaParser.startsWith(reader, pos, ')')) {
                    ++pos.start;
                    break block11;
                }
                OpenLdapSchemaParser.skipWhites(reader, pos, true);
                if (OpenLdapSchemaParser.startsWith(pos, DESC_STR)) {
                    elementsSeen = OpenLdapSchemaParser.checkElement(elementsSeen, LdapComparatorElements.DESC, pos);
                    pos.start += DESC_STR.length();
                    OpenLdapSchemaParser.skipWhites(reader, pos, true);
                    ldapComparator.setDescription(OpenLdapSchemaParser.getQDString(reader, pos));
                    continue;
                }
                if (OpenLdapSchemaParser.startsWith(pos, FQCN_STR)) {
                    elementsSeen = OpenLdapSchemaParser.checkElement(elementsSeen, LdapComparatorElements.FQCN, pos);
                    pos.start += FQCN_STR.length();
                    OpenLdapSchemaParser.skipWhites(reader, pos, true);
                    String fqcn = OpenLdapSchemaParser.getFqcn(pos);
                    ldapComparator.setFqcn(fqcn);
                    hasFqcn = true;
                    continue;
                }
                if (OpenLdapSchemaParser.startsWith(pos, BYTECODE_STR)) {
                    elementsSeen = OpenLdapSchemaParser.checkElement(elementsSeen, LdapComparatorElements.BYTECODE, pos);
                    pos.start += BYTECODE_STR.length();
                    OpenLdapSchemaParser.skipWhites(reader, pos, true);
                    String byteCode = OpenLdapSchemaParser.getByteCode(pos);
                    ldapComparator.setBytecode(byteCode);
                    hasByteCode = true;
                    continue;
                }
                if (!OpenLdapSchemaParser.startsWith(pos, EXTENSION_PREFIX)) break;
                OpenLdapSchemaParser.processExtension(reader, pos, ldapComparator);
            }
            if (OpenLdapSchemaParser.startsWith(reader, pos, ')')) {
                ++pos.start;
            } else {
                throw new LdapSchemaException(I18n.err(I18n.ERR_13825_COMP_DESCRIPTION_INVALID, pos.lineNumber, pos.start));
            }
        }
        if (!hasFqcn) {
            throw new LdapSchemaException(I18n.err(I18n.ERR_13819_FQCN_REQUIRED, pos.lineNumber, pos.start));
        }
        if (hasByteCode && ldapComparator.getBytecode().length() % 4 != 0) {
            throw new LdapSchemaException(I18n.err(I18n.ERR_13820_BYTE_CODE_REQUIRED, pos.lineNumber, pos.start));
        }
        return ldapComparator;
    }

    private static LdapComparatorDescription parseLdapComparatorRelaxed(Reader reader, PosSchema pos, Map<String, OpenLdapObjectIdentifierMacro> objectIdentifierMacros) throws IOException, LdapSchemaException {
        LdapComparatorDescription ldapComparator;
        block8: {
            OpenLdapSchemaParser.skipWhites(reader, pos, false);
            if (pos.line.charAt(pos.start) != '(') {
                throw new LdapSchemaException(I18n.err(I18n.ERR_13829_NO_OPENING_PAREN, pos.lineNumber, pos.start));
            }
            ++pos.start;
            OpenLdapSchemaParser.skipWhites(reader, pos, false);
            String oid = OpenLdapSchemaParser.getOidAndMacroRelaxed(pos, objectIdentifierMacros);
            ldapComparator = new LdapComparatorDescription(oid);
            int elementsSeen = 0;
            while (true) {
                if (OpenLdapSchemaParser.startsWith(reader, pos, ')')) {
                    ++pos.start;
                    break block8;
                }
                OpenLdapSchemaParser.skipWhites(reader, pos, true);
                if (OpenLdapSchemaParser.startsWith(pos, DESC_STR)) {
                    elementsSeen = OpenLdapSchemaParser.checkElement(elementsSeen, LdapComparatorElements.DESC, pos);
                    pos.start += DESC_STR.length();
                    OpenLdapSchemaParser.skipWhites(reader, pos, true);
                    ldapComparator.setDescription(OpenLdapSchemaParser.getQDString(reader, pos));
                    continue;
                }
                if (OpenLdapSchemaParser.startsWith(pos, FQCN_STR)) {
                    elementsSeen = OpenLdapSchemaParser.checkElement(elementsSeen, LdapComparatorElements.FQCN, pos);
                    pos.start += FQCN_STR.length();
                    OpenLdapSchemaParser.skipWhites(reader, pos, true);
                    String fqcn = OpenLdapSchemaParser.getFqcn(pos);
                    ldapComparator.setFqcn(fqcn);
                    continue;
                }
                if (OpenLdapSchemaParser.startsWith(pos, BYTECODE_STR)) {
                    elementsSeen = OpenLdapSchemaParser.checkElement(elementsSeen, LdapComparatorElements.BYTECODE, pos);
                    pos.start += BYTECODE_STR.length();
                    OpenLdapSchemaParser.skipWhites(reader, pos, true);
                    String byteCode = OpenLdapSchemaParser.getByteCode(pos);
                    ldapComparator.setBytecode(byteCode);
                    continue;
                }
                if (!OpenLdapSchemaParser.startsWith(pos, EXTENSION_PREFIX)) break;
                OpenLdapSchemaParser.processExtension(reader, pos, ldapComparator);
            }
            if (OpenLdapSchemaParser.startsWith(reader, pos, ')')) {
                ++pos.start;
            } else {
                throw new LdapSchemaException(I18n.err(I18n.ERR_13825_COMP_DESCRIPTION_INVALID, pos.lineNumber, pos.start));
            }
        }
        return ldapComparator;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public LdapSyntax parseLdapSyntax(String ldapSyntaxDescription) throws ParseException {
        if (ldapSyntaxDescription == null) throw new ParseException(I18n.err(I18n.ERR_13716_NULL_OR_EMPTY_STRING_SCHEMA_OBJECT, new Object[0]), 0);
        if (Strings.isEmpty(ldapSyntaxDescription.trim())) {
            throw new ParseException(I18n.err(I18n.ERR_13716_NULL_OR_EMPTY_STRING_SCHEMA_OBJECT, new Object[0]), 0);
        }
        try (BufferedReader reader = new BufferedReader(new StringReader(ldapSyntaxDescription));){
            PosSchema pos = new PosSchema();
            if (this.isQuirksModeEnabled) {
                LdapSyntax ldapSyntax = OpenLdapSchemaParser.parseLdapSyntaxRelaxed(reader, pos, this.objectIdentifierMacros);
                return ldapSyntax;
            }
            LdapSyntax ldapSyntax = OpenLdapSchemaParser.parseLdapSyntaxStrict(reader, pos, this.objectIdentifierMacros);
            return ldapSyntax;
        }
        catch (IOException | LdapSchemaException e) {
            throw new ParseException(e.getMessage(), 0);
        }
    }

    private static LdapSyntax parseLdapSyntaxStrict(Reader reader, PosSchema pos, Map<String, OpenLdapObjectIdentifierMacro> objectIdentifierMacros) throws IOException, LdapSchemaException {
        LdapSyntax ldapSyntax;
        block7: {
            OpenLdapSchemaParser.skipWhites(reader, pos, false);
            if (pos.line.charAt(pos.start) != '(') {
                throw new LdapSchemaException(I18n.err(I18n.ERR_13829_NO_OPENING_PAREN, pos.lineNumber, pos.start));
            }
            ++pos.start;
            OpenLdapSchemaParser.skipWhites(reader, pos, false);
            String oid = OpenLdapSchemaParser.getOidAndMacroRelaxed(pos, objectIdentifierMacros);
            if (!Oid.isOid(oid)) {
                throw new LdapSchemaException(I18n.err(I18n.ERR_13787_OID_EXPECTED, pos.lineNumber, pos.start));
            }
            ldapSyntax = new LdapSyntax(oid);
            int elementsSeen = 0;
            while (true) {
                if (OpenLdapSchemaParser.startsWith(reader, pos, ')')) {
                    ++pos.start;
                    break block7;
                }
                OpenLdapSchemaParser.skipWhites(reader, pos, true);
                if (OpenLdapSchemaParser.startsWith(pos, DESC_STR)) {
                    elementsSeen = OpenLdapSchemaParser.checkElement(elementsSeen, LdapSyntaxElements.DESC, pos);
                    pos.start += DESC_STR.length();
                    OpenLdapSchemaParser.skipWhites(reader, pos, true);
                    ldapSyntax.setDescription(OpenLdapSchemaParser.getQDString(reader, pos));
                    continue;
                }
                if (!OpenLdapSchemaParser.startsWith(pos, EXTENSION_PREFIX)) break;
                OpenLdapSchemaParser.processExtension(reader, pos, ldapSyntax);
            }
            if (OpenLdapSchemaParser.startsWith(reader, pos, ')')) {
                ++pos.start;
            } else {
                throw new LdapSchemaException(I18n.err(I18n.ERR_13807_SYN_DESCRIPTION_INVALID, pos.lineNumber, pos.start));
            }
        }
        return ldapSyntax;
    }

    private static LdapSyntax parseLdapSyntaxRelaxed(Reader reader, PosSchema pos, Map<String, OpenLdapObjectIdentifierMacro> objectIdentifierMacros) throws IOException, LdapSchemaException {
        LdapSyntax ldapSyntax;
        block6: {
            OpenLdapSchemaParser.skipWhites(reader, pos, false);
            if (pos.line.charAt(pos.start) != '(') {
                throw new LdapSchemaException(I18n.err(I18n.ERR_13829_NO_OPENING_PAREN, pos.lineNumber, pos.start));
            }
            ++pos.start;
            OpenLdapSchemaParser.skipWhites(reader, pos, false);
            String oid = OpenLdapSchemaParser.getOidAndMacroRelaxed(pos, objectIdentifierMacros);
            ldapSyntax = new LdapSyntax(oid);
            int elementsSeen = 0;
            while (true) {
                if (OpenLdapSchemaParser.startsWith(reader, pos, ')')) {
                    ++pos.start;
                    break block6;
                }
                OpenLdapSchemaParser.skipWhites(reader, pos, true);
                if (OpenLdapSchemaParser.startsWith(pos, DESC_STR)) {
                    elementsSeen = OpenLdapSchemaParser.checkElement(elementsSeen, LdapSyntaxElements.DESC, pos);
                    pos.start += DESC_STR.length();
                    OpenLdapSchemaParser.skipWhites(reader, pos, true);
                    ldapSyntax.setDescription(OpenLdapSchemaParser.getQDString(reader, pos));
                    continue;
                }
                if (!OpenLdapSchemaParser.startsWith(pos, EXTENSION_PREFIX)) break;
                OpenLdapSchemaParser.processExtension(reader, pos, ldapSyntax);
            }
            if (OpenLdapSchemaParser.startsWith(reader, pos, ')')) {
                ++pos.start;
            } else {
                throw new LdapSchemaException(I18n.err(I18n.ERR_13807_SYN_DESCRIPTION_INVALID, pos.lineNumber, pos.start));
            }
        }
        return ldapSyntax;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public MatchingRule parseMatchingRule(String matchingRuleDescription) throws ParseException {
        if (matchingRuleDescription == null) throw new ParseException(I18n.err(I18n.ERR_13716_NULL_OR_EMPTY_STRING_SCHEMA_OBJECT, new Object[0]), 0);
        if (Strings.isEmpty(matchingRuleDescription.trim())) {
            throw new ParseException(I18n.err(I18n.ERR_13716_NULL_OR_EMPTY_STRING_SCHEMA_OBJECT, new Object[0]), 0);
        }
        try (BufferedReader reader = new BufferedReader(new StringReader(matchingRuleDescription));){
            PosSchema pos = new PosSchema();
            if (this.isQuirksModeEnabled) {
                MatchingRule matchingRule = OpenLdapSchemaParser.parseMatchingRuleRelaxed(reader, pos, this.objectIdentifierMacros);
                return matchingRule;
            }
            MatchingRule matchingRule = OpenLdapSchemaParser.parseMatchingRuleStrict(reader, pos, this.objectIdentifierMacros);
            return matchingRule;
        }
        catch (IOException | LdapSchemaException e) {
            throw new ParseException(e.getMessage(), 0);
        }
    }

    private static MatchingRule parseMatchingRuleStrict(Reader reader, PosSchema pos, Map<String, OpenLdapObjectIdentifierMacro> objectIdentifierMacros) throws IOException, LdapSchemaException {
        boolean hasSyntax;
        MutableMatchingRule matchingRule;
        block11: {
            OpenLdapSchemaParser.skipWhites(reader, pos, false);
            if (pos.line.charAt(pos.start) != '(') {
                throw new LdapSchemaException(I18n.err(I18n.ERR_13829_NO_OPENING_PAREN, pos.lineNumber, pos.start));
            }
            ++pos.start;
            OpenLdapSchemaParser.skipWhites(reader, pos, false);
            String oid = OpenLdapSchemaParser.getOidAndMacroRelaxed(pos, objectIdentifierMacros);
            if (!Oid.isOid(oid)) {
                throw new LdapSchemaException(I18n.err(I18n.ERR_13787_OID_EXPECTED, pos.lineNumber, pos.start));
            }
            matchingRule = new MutableMatchingRule(oid);
            int elementsSeen = 0;
            hasSyntax = false;
            while (true) {
                if (OpenLdapSchemaParser.startsWith(reader, pos, ')')) {
                    ++pos.start;
                    break block11;
                }
                OpenLdapSchemaParser.skipWhites(reader, pos, true);
                if (OpenLdapSchemaParser.startsWith(pos, NAME_STR)) {
                    elementsSeen = OpenLdapSchemaParser.checkElement(elementsSeen, MatchingRuleElements.NAME, pos);
                    pos.start += NAME_STR.length();
                    OpenLdapSchemaParser.skipWhites(reader, pos, true);
                    matchingRule.setNames(OpenLdapSchemaParser.getQDescrs(reader, pos, false));
                    continue;
                }
                if (OpenLdapSchemaParser.startsWith(pos, DESC_STR)) {
                    elementsSeen = OpenLdapSchemaParser.checkElement(elementsSeen, MatchingRuleElements.DESC, pos);
                    pos.start += DESC_STR.length();
                    OpenLdapSchemaParser.skipWhites(reader, pos, true);
                    matchingRule.setDescription(OpenLdapSchemaParser.getQDString(reader, pos));
                    continue;
                }
                if (OpenLdapSchemaParser.startsWith(pos, OBSOLETE_STR)) {
                    elementsSeen = OpenLdapSchemaParser.checkElement(elementsSeen, MatchingRuleElements.OBSOLETE, pos);
                    pos.start += OBSOLETE_STR.length();
                    matchingRule.setObsolete(true);
                    continue;
                }
                if (OpenLdapSchemaParser.startsWith(pos, SYNTAX_STR)) {
                    elementsSeen = OpenLdapSchemaParser.checkElement(elementsSeen, MatchingRuleElements.SYNTAX, pos);
                    pos.start += SYNTAX_STR.length();
                    OpenLdapSchemaParser.skipWhites(reader, pos, true);
                    String syntaxOid = OpenLdapSchemaParser.getNumericOid(pos);
                    matchingRule.setSyntaxOid(syntaxOid);
                    hasSyntax = true;
                    continue;
                }
                if (!OpenLdapSchemaParser.startsWith(pos, EXTENSION_PREFIX)) break;
                OpenLdapSchemaParser.processExtension(reader, pos, matchingRule);
            }
            if (OpenLdapSchemaParser.startsWith(reader, pos, ')')) {
                ++pos.start;
            } else {
                throw new LdapSchemaException(I18n.err(I18n.ERR_13781_MR_DESCRIPTION_INVALID, pos.lineNumber, pos.start));
            }
        }
        if (!hasSyntax) {
            throw new LdapSchemaException(I18n.err(I18n.ERR_13808_SYNTAX_REQUIRED, pos.lineNumber, pos.start));
        }
        return matchingRule;
    }

    private static MatchingRule parseMatchingRuleRelaxed(Reader reader, PosSchema pos, Map<String, OpenLdapObjectIdentifierMacro> objectIdentifierMacros) throws IOException, LdapSchemaException {
        MutableMatchingRule matchingRule;
        block9: {
            OpenLdapSchemaParser.skipWhites(reader, pos, false);
            if (pos.line.charAt(pos.start) != '(') {
                throw new LdapSchemaException(I18n.err(I18n.ERR_13829_NO_OPENING_PAREN, pos.lineNumber, pos.start));
            }
            ++pos.start;
            OpenLdapSchemaParser.skipWhites(reader, pos, false);
            String oid = OpenLdapSchemaParser.getOidAndMacroRelaxed(pos, objectIdentifierMacros);
            matchingRule = new MutableMatchingRule(oid);
            int elementsSeen = 0;
            while (true) {
                if (OpenLdapSchemaParser.startsWith(reader, pos, ')')) {
                    ++pos.start;
                    break block9;
                }
                OpenLdapSchemaParser.skipWhites(reader, pos, true);
                if (OpenLdapSchemaParser.startsWith(pos, NAME_STR)) {
                    elementsSeen = OpenLdapSchemaParser.checkElement(elementsSeen, MatchingRuleElements.NAME, pos);
                    pos.start += NAME_STR.length();
                    OpenLdapSchemaParser.skipWhites(reader, pos, true);
                    matchingRule.setNames(OpenLdapSchemaParser.getQDescrs(reader, pos, true));
                    continue;
                }
                if (OpenLdapSchemaParser.startsWith(pos, DESC_STR)) {
                    elementsSeen = OpenLdapSchemaParser.checkElement(elementsSeen, MatchingRuleElements.DESC, pos);
                    pos.start += DESC_STR.length();
                    OpenLdapSchemaParser.skipWhites(reader, pos, true);
                    matchingRule.setDescription(OpenLdapSchemaParser.getQDString(reader, pos));
                    continue;
                }
                if (OpenLdapSchemaParser.startsWith(pos, OBSOLETE_STR)) {
                    elementsSeen = OpenLdapSchemaParser.checkElement(elementsSeen, MatchingRuleElements.OBSOLETE, pos);
                    pos.start += OBSOLETE_STR.length();
                    matchingRule.setObsolete(true);
                    continue;
                }
                if (OpenLdapSchemaParser.startsWith(pos, SYNTAX_STR)) {
                    elementsSeen = OpenLdapSchemaParser.checkElement(elementsSeen, MatchingRuleElements.SYNTAX, pos);
                    pos.start += SYNTAX_STR.length();
                    OpenLdapSchemaParser.skipWhites(reader, pos, true);
                    String syntaxOid = OpenLdapSchemaParser.getNumericOid(pos);
                    matchingRule.setSyntaxOid(syntaxOid);
                    continue;
                }
                if (!OpenLdapSchemaParser.startsWith(pos, EXTENSION_PREFIX)) break;
                OpenLdapSchemaParser.processExtension(reader, pos, matchingRule);
            }
            if (OpenLdapSchemaParser.startsWith(reader, pos, ')')) {
                ++pos.start;
            } else {
                throw new LdapSchemaException(I18n.err(I18n.ERR_13781_MR_DESCRIPTION_INVALID, pos.lineNumber, pos.start));
            }
        }
        return matchingRule;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public MatchingRuleUse parseMatchingRuleUse(String matchingRuleUseDescription) throws ParseException {
        if (matchingRuleUseDescription == null) throw new ParseException(I18n.err(I18n.ERR_13716_NULL_OR_EMPTY_STRING_SCHEMA_OBJECT, new Object[0]), 0);
        if (Strings.isEmpty(matchingRuleUseDescription.trim())) {
            throw new ParseException(I18n.err(I18n.ERR_13716_NULL_OR_EMPTY_STRING_SCHEMA_OBJECT, new Object[0]), 0);
        }
        try (BufferedReader reader = new BufferedReader(new StringReader(matchingRuleUseDescription));){
            PosSchema pos = new PosSchema();
            if (this.isQuirksModeEnabled) {
                MatchingRuleUse matchingRuleUse = OpenLdapSchemaParser.parseMatchingRuleUseRelaxed(reader, pos, this.objectIdentifierMacros);
                return matchingRuleUse;
            }
            MatchingRuleUse matchingRuleUse = OpenLdapSchemaParser.parseMatchingRuleUseStrict(reader, pos, this.objectIdentifierMacros);
            return matchingRuleUse;
        }
        catch (IOException | LdapSchemaException e) {
            throw new ParseException(e.getMessage(), 0);
        }
    }

    private static MatchingRuleUse parseMatchingRuleUseStrict(Reader reader, PosSchema pos, Map<String, OpenLdapObjectIdentifierMacro> objectIdentifierMacros) throws IOException, LdapSchemaException {
        boolean hasApplies;
        MatchingRuleUse matchingRuleUse;
        block11: {
            OpenLdapSchemaParser.skipWhites(reader, pos, false);
            if (pos.line.charAt(pos.start) != '(') {
                throw new LdapSchemaException(I18n.err(I18n.ERR_13829_NO_OPENING_PAREN, pos.lineNumber, pos.start));
            }
            ++pos.start;
            OpenLdapSchemaParser.skipWhites(reader, pos, false);
            String oid = OpenLdapSchemaParser.getOidAndMacroRelaxed(pos, objectIdentifierMacros);
            if (!Oid.isOid(oid)) {
                throw new LdapSchemaException(I18n.err(I18n.ERR_13787_OID_EXPECTED, pos.lineNumber, pos.start));
            }
            matchingRuleUse = new MatchingRuleUse(oid);
            int elementsSeen = 0;
            hasApplies = false;
            while (true) {
                if (OpenLdapSchemaParser.startsWith(reader, pos, ')')) {
                    ++pos.start;
                    break block11;
                }
                OpenLdapSchemaParser.skipWhites(reader, pos, false);
                if (OpenLdapSchemaParser.startsWith(pos, NAME_STR)) {
                    elementsSeen = OpenLdapSchemaParser.checkElement(elementsSeen, MatchingRuleUseElements.NAME, pos);
                    pos.start += NAME_STR.length();
                    OpenLdapSchemaParser.skipWhites(reader, pos, true);
                    matchingRuleUse.setNames(OpenLdapSchemaParser.getQDescrs(reader, pos, false));
                    continue;
                }
                if (OpenLdapSchemaParser.startsWith(pos, DESC_STR)) {
                    elementsSeen = OpenLdapSchemaParser.checkElement(elementsSeen, MatchingRuleUseElements.DESC, pos);
                    pos.start += DESC_STR.length();
                    OpenLdapSchemaParser.skipWhites(reader, pos, true);
                    matchingRuleUse.setDescription(OpenLdapSchemaParser.getQDString(reader, pos));
                    continue;
                }
                if (OpenLdapSchemaParser.startsWith(pos, OBSOLETE_STR)) {
                    elementsSeen = OpenLdapSchemaParser.checkElement(elementsSeen, MatchingRuleUseElements.OBSOLETE, pos);
                    pos.start += OBSOLETE_STR.length();
                    matchingRuleUse.setObsolete(true);
                    continue;
                }
                if (OpenLdapSchemaParser.startsWith(pos, APPLIES_STR)) {
                    elementsSeen = OpenLdapSchemaParser.checkElement(elementsSeen, MatchingRuleUseElements.APPLIES, pos);
                    pos.start += APPLIES_STR.length();
                    OpenLdapSchemaParser.skipWhites(reader, pos, true);
                    List<String> oids = OpenLdapSchemaParser.getOidsStrict(reader, pos);
                    matchingRuleUse.setApplicableAttributeOids(oids);
                    hasApplies = true;
                    continue;
                }
                if (!OpenLdapSchemaParser.startsWith(pos, EXTENSION_PREFIX)) break;
                OpenLdapSchemaParser.processExtension(reader, pos, matchingRuleUse);
            }
            if (OpenLdapSchemaParser.startsWith(reader, pos, ')')) {
                ++pos.start;
            } else {
                throw new LdapSchemaException(I18n.err(I18n.ERR_13815_MRU_DESCRIPTION_INVALID, pos.lineNumber, pos.start));
            }
        }
        if (!hasApplies) {
            throw new LdapSchemaException(I18n.err(I18n.ERR_13814_APPLIES_REQUIRED, pos.lineNumber, pos.start));
        }
        return matchingRuleUse;
    }

    private static MatchingRuleUse parseMatchingRuleUseRelaxed(Reader reader, PosSchema pos, Map<String, OpenLdapObjectIdentifierMacro> objectIdentifierMacros) throws IOException, LdapSchemaException {
        MatchingRuleUse matchingRuleUse;
        block9: {
            OpenLdapSchemaParser.skipWhites(reader, pos, false);
            if (pos.line.charAt(pos.start) != '(') {
                throw new LdapSchemaException(I18n.err(I18n.ERR_13829_NO_OPENING_PAREN, pos.lineNumber, pos.start));
            }
            ++pos.start;
            OpenLdapSchemaParser.skipWhites(reader, pos, false);
            String oid = OpenLdapSchemaParser.getOidAndMacroRelaxed(pos, objectIdentifierMacros);
            matchingRuleUse = new MatchingRuleUse(oid);
            int elementsSeen = 0;
            while (true) {
                if (OpenLdapSchemaParser.startsWith(reader, pos, ')')) {
                    ++pos.start;
                    break block9;
                }
                OpenLdapSchemaParser.skipWhites(reader, pos, true);
                if (OpenLdapSchemaParser.startsWith(pos, NAME_STR)) {
                    elementsSeen = OpenLdapSchemaParser.checkElement(elementsSeen, MatchingRuleUseElements.NAME, pos);
                    pos.start += NAME_STR.length();
                    OpenLdapSchemaParser.skipWhites(reader, pos, true);
                    matchingRuleUse.setNames(OpenLdapSchemaParser.getQDescrs(reader, pos, true));
                    continue;
                }
                if (OpenLdapSchemaParser.startsWith(pos, DESC_STR)) {
                    elementsSeen = OpenLdapSchemaParser.checkElement(elementsSeen, MatchingRuleUseElements.DESC, pos);
                    pos.start += DESC_STR.length();
                    OpenLdapSchemaParser.skipWhites(reader, pos, true);
                    matchingRuleUse.setDescription(OpenLdapSchemaParser.getQDString(reader, pos));
                    continue;
                }
                if (OpenLdapSchemaParser.startsWith(pos, OBSOLETE_STR)) {
                    elementsSeen = OpenLdapSchemaParser.checkElement(elementsSeen, MatchingRuleUseElements.OBSOLETE, pos);
                    pos.start += OBSOLETE_STR.length();
                    matchingRuleUse.setObsolete(true);
                    continue;
                }
                if (OpenLdapSchemaParser.startsWith(pos, APPLIES_STR)) {
                    elementsSeen = OpenLdapSchemaParser.checkElement(elementsSeen, MatchingRuleUseElements.APPLIES, pos);
                    pos.start += APPLIES_STR.length();
                    OpenLdapSchemaParser.skipWhites(reader, pos, true);
                    List<String> oids = OpenLdapSchemaParser.getOidsRelaxed(reader, pos);
                    matchingRuleUse.setApplicableAttributeOids(oids);
                    continue;
                }
                if (!OpenLdapSchemaParser.startsWith(pos, EXTENSION_PREFIX)) break;
                OpenLdapSchemaParser.processExtension(reader, pos, matchingRuleUse);
            }
            if (OpenLdapSchemaParser.startsWith(reader, pos, ')')) {
                ++pos.start;
            } else {
                throw new LdapSchemaException(I18n.err(I18n.ERR_13815_MRU_DESCRIPTION_INVALID, pos.lineNumber, pos.start));
            }
        }
        return matchingRuleUse;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public NameForm parseNameForm(String nameFormDescription) throws ParseException {
        if (nameFormDescription == null) throw new ParseException(I18n.err(I18n.ERR_13716_NULL_OR_EMPTY_STRING_SCHEMA_OBJECT, new Object[0]), 0);
        if (Strings.isEmpty(nameFormDescription.trim())) {
            throw new ParseException(I18n.err(I18n.ERR_13716_NULL_OR_EMPTY_STRING_SCHEMA_OBJECT, new Object[0]), 0);
        }
        try (BufferedReader reader = new BufferedReader(new StringReader(nameFormDescription));){
            PosSchema pos = new PosSchema();
            if (this.isQuirksModeEnabled) {
                NameForm nameForm = OpenLdapSchemaParser.parseNameFormRelaxed(reader, pos, this.objectIdentifierMacros);
                return nameForm;
            }
            NameForm nameForm = OpenLdapSchemaParser.parseNameFormStrict(reader, pos, this.objectIdentifierMacros);
            return nameForm;
        }
        catch (IOException | LdapSchemaException e) {
            throw new ParseException(e.getMessage(), 0);
        }
    }

    private static NameForm parseNameFormStrict(Reader reader, PosSchema pos, Map<String, OpenLdapObjectIdentifierMacro> objectIdentifierMacros) throws IOException, LdapSchemaException {
        boolean hasMust;
        boolean hasOc;
        NameForm nameForm;
        block14: {
            OpenLdapSchemaParser.skipWhites(reader, pos, false);
            if (pos.line.charAt(pos.start) != '(') {
                throw new LdapSchemaException(I18n.err(I18n.ERR_13829_NO_OPENING_PAREN, pos.lineNumber, pos.start));
            }
            ++pos.start;
            OpenLdapSchemaParser.skipWhites(reader, pos, false);
            String oid = OpenLdapSchemaParser.getOidAndMacroRelaxed(pos, objectIdentifierMacros);
            if (!Oid.isOid(oid)) {
                throw new LdapSchemaException(I18n.err(I18n.ERR_13787_OID_EXPECTED, pos.lineNumber, pos.start));
            }
            nameForm = new NameForm(oid);
            int elementsSeen = 0;
            hasOc = false;
            hasMust = false;
            while (true) {
                if (OpenLdapSchemaParser.startsWith(reader, pos, ')')) {
                    ++pos.start;
                    break block14;
                }
                OpenLdapSchemaParser.skipWhites(reader, pos, true);
                if (OpenLdapSchemaParser.startsWith(pos, NAME_STR)) {
                    elementsSeen = OpenLdapSchemaParser.checkElement(elementsSeen, NameFormElements.NAME, pos);
                    pos.start += NAME_STR.length();
                    OpenLdapSchemaParser.skipWhites(reader, pos, true);
                    nameForm.setNames(OpenLdapSchemaParser.getQDescrs(reader, pos, false));
                    continue;
                }
                if (OpenLdapSchemaParser.startsWith(pos, DESC_STR)) {
                    elementsSeen = OpenLdapSchemaParser.checkElement(elementsSeen, NameFormElements.DESC, pos);
                    pos.start += DESC_STR.length();
                    OpenLdapSchemaParser.skipWhites(reader, pos, true);
                    nameForm.setDescription(OpenLdapSchemaParser.getQDString(reader, pos));
                    continue;
                }
                if (OpenLdapSchemaParser.startsWith(pos, OBSOLETE_STR)) {
                    elementsSeen = OpenLdapSchemaParser.checkElement(elementsSeen, NameFormElements.OBSOLETE, pos);
                    pos.start += OBSOLETE_STR.length();
                    nameForm.setObsolete(true);
                    continue;
                }
                if (OpenLdapSchemaParser.startsWith(pos, OC_STR)) {
                    elementsSeen = OpenLdapSchemaParser.checkElement(elementsSeen, NameFormElements.OC, pos);
                    pos.start += OC_STR.length();
                    OpenLdapSchemaParser.skipWhites(reader, pos, true);
                    String oc = OpenLdapSchemaParser.getOidStrict(pos);
                    nameForm.setStructuralObjectClassOid(oc);
                    hasOc = true;
                    continue;
                }
                if (OpenLdapSchemaParser.startsWith(pos, MUST_STR)) {
                    elementsSeen = OpenLdapSchemaParser.checkElement(elementsSeen, NameFormElements.MUST, pos);
                    pos.start += MUST_STR.length();
                    OpenLdapSchemaParser.skipWhites(reader, pos, true);
                    List<String> must = OpenLdapSchemaParser.getOidsStrict(reader, pos);
                    nameForm.setMustAttributeTypeOids(must);
                    hasMust = true;
                    continue;
                }
                if (OpenLdapSchemaParser.startsWith(pos, MAY_STR)) {
                    elementsSeen = OpenLdapSchemaParser.checkElement(elementsSeen, NameFormElements.MAY, pos);
                    pos.start += MAY_STR.length();
                    OpenLdapSchemaParser.skipWhites(reader, pos, true);
                    List<String> may = OpenLdapSchemaParser.getOidsStrict(reader, pos);
                    nameForm.setMayAttributeTypeOids(may);
                    continue;
                }
                if (!OpenLdapSchemaParser.startsWith(pos, EXTENSION_PREFIX)) break;
                OpenLdapSchemaParser.processExtension(reader, pos, nameForm);
            }
            if (OpenLdapSchemaParser.startsWith(reader, pos, ')')) {
                ++pos.start;
            } else {
                throw new LdapSchemaException(I18n.err(I18n.ERR_13816_NF_DESCRIPTION_INVALID, pos.lineNumber, pos.start));
            }
        }
        if (!hasOc) {
            throw new LdapSchemaException(I18n.err(I18n.ERR_13817_STRUCTURAL_OBJECT_CLASS_REQUIRED, pos.lineNumber, pos.start));
        }
        if (!hasMust) {
            throw new LdapSchemaException(I18n.err(I18n.ERR_13818_MUST_REQUIRED, pos.lineNumber, pos.start));
        }
        return nameForm;
    }

    private static NameForm parseNameFormRelaxed(Reader reader, PosSchema pos, Map<String, OpenLdapObjectIdentifierMacro> objectIdentifierMacros) throws IOException, LdapSchemaException {
        NameForm nameForm;
        block11: {
            OpenLdapSchemaParser.skipWhites(reader, pos, false);
            if (pos.line.charAt(pos.start) != '(') {
                throw new LdapSchemaException(I18n.err(I18n.ERR_13829_NO_OPENING_PAREN, pos.lineNumber, pos.start));
            }
            ++pos.start;
            OpenLdapSchemaParser.skipWhites(reader, pos, false);
            String oid = OpenLdapSchemaParser.getOidAndMacroRelaxed(pos, objectIdentifierMacros);
            nameForm = new NameForm(oid);
            int elementsSeen = 0;
            while (true) {
                if (OpenLdapSchemaParser.startsWith(reader, pos, ')')) {
                    ++pos.start;
                    break block11;
                }
                OpenLdapSchemaParser.skipWhites(reader, pos, true);
                if (OpenLdapSchemaParser.startsWith(pos, NAME_STR)) {
                    elementsSeen = OpenLdapSchemaParser.checkElement(elementsSeen, NameFormElements.NAME, pos);
                    pos.start += NAME_STR.length();
                    OpenLdapSchemaParser.skipWhites(reader, pos, true);
                    nameForm.setNames(OpenLdapSchemaParser.getQDescrs(reader, pos, true));
                    continue;
                }
                if (OpenLdapSchemaParser.startsWith(pos, DESC_STR)) {
                    elementsSeen = OpenLdapSchemaParser.checkElement(elementsSeen, NameFormElements.DESC, pos);
                    pos.start += DESC_STR.length();
                    OpenLdapSchemaParser.skipWhites(reader, pos, true);
                    nameForm.setDescription(OpenLdapSchemaParser.getQDString(reader, pos));
                    continue;
                }
                if (OpenLdapSchemaParser.startsWith(pos, OBSOLETE_STR)) {
                    elementsSeen = OpenLdapSchemaParser.checkElement(elementsSeen, NameFormElements.OBSOLETE, pos);
                    pos.start += OBSOLETE_STR.length();
                    nameForm.setObsolete(true);
                    continue;
                }
                if (OpenLdapSchemaParser.startsWith(pos, OC_STR)) {
                    elementsSeen = OpenLdapSchemaParser.checkElement(elementsSeen, NameFormElements.OC, pos);
                    pos.start += OC_STR.length();
                    OpenLdapSchemaParser.skipWhites(reader, pos, true);
                    String oc = OpenLdapSchemaParser.getOidRelaxed(pos, false);
                    nameForm.setStructuralObjectClassOid(oc);
                    continue;
                }
                if (OpenLdapSchemaParser.startsWith(pos, MUST_STR)) {
                    elementsSeen = OpenLdapSchemaParser.checkElement(elementsSeen, NameFormElements.MUST, pos);
                    pos.start += MUST_STR.length();
                    OpenLdapSchemaParser.skipWhites(reader, pos, true);
                    List<String> must = OpenLdapSchemaParser.getOidsRelaxed(reader, pos);
                    nameForm.setMustAttributeTypeOids(must);
                    continue;
                }
                if (OpenLdapSchemaParser.startsWith(pos, MAY_STR)) {
                    elementsSeen = OpenLdapSchemaParser.checkElement(elementsSeen, NameFormElements.MAY, pos);
                    pos.start += MAY_STR.length();
                    OpenLdapSchemaParser.skipWhites(reader, pos, true);
                    List<String> may = OpenLdapSchemaParser.getOidsRelaxed(reader, pos);
                    nameForm.setMayAttributeTypeOids(may);
                    continue;
                }
                if (!OpenLdapSchemaParser.startsWith(pos, EXTENSION_PREFIX)) break;
                OpenLdapSchemaParser.processExtension(reader, pos, nameForm);
            }
            if (OpenLdapSchemaParser.startsWith(reader, pos, ')')) {
                ++pos.start;
            } else {
                throw new LdapSchemaException(I18n.err(I18n.ERR_13816_NF_DESCRIPTION_INVALID, pos.lineNumber, pos.start));
            }
        }
        return nameForm;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public NormalizerDescription parseNormalizer(String normalizerDescription) throws ParseException {
        if (normalizerDescription == null) throw new ParseException(I18n.err(I18n.ERR_13716_NULL_OR_EMPTY_STRING_SCHEMA_OBJECT, new Object[0]), 0);
        if (Strings.isEmpty(normalizerDescription.trim())) {
            throw new ParseException(I18n.err(I18n.ERR_13716_NULL_OR_EMPTY_STRING_SCHEMA_OBJECT, new Object[0]), 0);
        }
        try (BufferedReader reader = new BufferedReader(new StringReader(normalizerDescription));){
            PosSchema pos = new PosSchema();
            if (this.isQuirksModeEnabled) {
                NormalizerDescription normalizerDescription2 = OpenLdapSchemaParser.parseNormalizerRelaxed(reader, pos, this.objectIdentifierMacros);
                return normalizerDescription2;
            }
            NormalizerDescription normalizerDescription3 = OpenLdapSchemaParser.parseNormalizerStrict(reader, pos, this.objectIdentifierMacros);
            return normalizerDescription3;
        }
        catch (IOException | LdapSchemaException e) {
            throw new ParseException(e.getMessage(), 0);
        }
    }

    private static NormalizerDescription parseNormalizerStrict(Reader reader, PosSchema pos, Map<String, OpenLdapObjectIdentifierMacro> objectIdentifierMacros) throws IOException, LdapSchemaException {
        boolean hasByteCode;
        boolean hasFqcn;
        NormalizerDescription normalizer;
        block11: {
            OpenLdapSchemaParser.skipWhites(reader, pos, false);
            if (pos.line.charAt(pos.start) != '(') {
                throw new LdapSchemaException(I18n.err(I18n.ERR_13829_NO_OPENING_PAREN, pos.lineNumber, pos.start));
            }
            ++pos.start;
            OpenLdapSchemaParser.skipWhites(reader, pos, false);
            String oid = OpenLdapSchemaParser.getOidAndMacroRelaxed(pos, objectIdentifierMacros);
            if (!Oid.isOid(oid)) {
                throw new LdapSchemaException(I18n.err(I18n.ERR_13787_OID_EXPECTED, pos.lineNumber, pos.start));
            }
            normalizer = new NormalizerDescription(oid);
            int elementsSeen = 0;
            hasFqcn = false;
            hasByteCode = false;
            while (true) {
                if (OpenLdapSchemaParser.startsWith(reader, pos, ')')) {
                    ++pos.start;
                    break block11;
                }
                OpenLdapSchemaParser.skipWhites(reader, pos, true);
                if (OpenLdapSchemaParser.startsWith(pos, DESC_STR)) {
                    elementsSeen = OpenLdapSchemaParser.checkElement(elementsSeen, NormalizerElements.DESC, pos);
                    pos.start += DESC_STR.length();
                    OpenLdapSchemaParser.skipWhites(reader, pos, true);
                    normalizer.setDescription(OpenLdapSchemaParser.getQDString(reader, pos));
                    continue;
                }
                if (OpenLdapSchemaParser.startsWith(pos, FQCN_STR)) {
                    elementsSeen = OpenLdapSchemaParser.checkElement(elementsSeen, NormalizerElements.FQCN, pos);
                    pos.start += FQCN_STR.length();
                    OpenLdapSchemaParser.skipWhites(reader, pos, true);
                    String fqcn = OpenLdapSchemaParser.getFqcn(pos);
                    normalizer.setFqcn(fqcn);
                    hasFqcn = true;
                    continue;
                }
                if (OpenLdapSchemaParser.startsWith(pos, BYTECODE_STR)) {
                    elementsSeen = OpenLdapSchemaParser.checkElement(elementsSeen, NormalizerElements.BYTECODE, pos);
                    pos.start += BYTECODE_STR.length();
                    OpenLdapSchemaParser.skipWhites(reader, pos, true);
                    String byteCode = OpenLdapSchemaParser.getByteCode(pos);
                    normalizer.setBytecode(byteCode);
                    hasByteCode = true;
                    continue;
                }
                if (!OpenLdapSchemaParser.startsWith(pos, EXTENSION_PREFIX)) break;
                OpenLdapSchemaParser.processExtension(reader, pos, normalizer);
            }
            if (OpenLdapSchemaParser.startsWith(reader, pos, ')')) {
                ++pos.start;
            } else {
                throw new LdapSchemaException(I18n.err(I18n.ERR_13821_NORM_DESCRIPTION_INVALID, pos.lineNumber, pos.start));
            }
        }
        if (!hasFqcn) {
            throw new LdapSchemaException(I18n.err(I18n.ERR_13819_FQCN_REQUIRED, pos.lineNumber, pos.start));
        }
        if (hasByteCode && normalizer.getBytecode().length() % 4 != 0) {
            throw new LdapSchemaException(I18n.err(I18n.ERR_13820_BYTE_CODE_REQUIRED, pos.lineNumber, pos.start));
        }
        return normalizer;
    }

    private static NormalizerDescription parseNormalizerRelaxed(Reader reader, PosSchema pos, Map<String, OpenLdapObjectIdentifierMacro> objectIdentifierMacros) throws IOException, LdapSchemaException {
        NormalizerDescription normalizer;
        block8: {
            OpenLdapSchemaParser.skipWhites(reader, pos, false);
            if (pos.line.charAt(pos.start) != '(') {
                throw new LdapSchemaException(I18n.err(I18n.ERR_13829_NO_OPENING_PAREN, pos.lineNumber, pos.start));
            }
            ++pos.start;
            OpenLdapSchemaParser.skipWhites(reader, pos, false);
            String oid = OpenLdapSchemaParser.getOidAndMacroRelaxed(pos, objectIdentifierMacros);
            normalizer = new NormalizerDescription(oid);
            int elementsSeen = 0;
            while (true) {
                if (OpenLdapSchemaParser.startsWith(reader, pos, ')')) {
                    ++pos.start;
                    break block8;
                }
                OpenLdapSchemaParser.skipWhites(reader, pos, true);
                if (OpenLdapSchemaParser.startsWith(pos, DESC_STR)) {
                    elementsSeen = OpenLdapSchemaParser.checkElement(elementsSeen, NormalizerElements.DESC, pos);
                    pos.start += DESC_STR.length();
                    OpenLdapSchemaParser.skipWhites(reader, pos, true);
                    normalizer.setDescription(OpenLdapSchemaParser.getQDString(reader, pos));
                    continue;
                }
                if (OpenLdapSchemaParser.startsWith(pos, FQCN_STR)) {
                    elementsSeen = OpenLdapSchemaParser.checkElement(elementsSeen, NormalizerElements.FQCN, pos);
                    pos.start += FQCN_STR.length();
                    OpenLdapSchemaParser.skipWhites(reader, pos, true);
                    String fqcn = OpenLdapSchemaParser.getFqcn(pos);
                    normalizer.setFqcn(fqcn);
                    continue;
                }
                if (OpenLdapSchemaParser.startsWith(pos, BYTECODE_STR)) {
                    elementsSeen = OpenLdapSchemaParser.checkElement(elementsSeen, NormalizerElements.BYTECODE, pos);
                    pos.start += BYTECODE_STR.length();
                    OpenLdapSchemaParser.skipWhites(reader, pos, true);
                    String byteCode = OpenLdapSchemaParser.getByteCode(pos);
                    normalizer.setBytecode(byteCode);
                    continue;
                }
                if (!OpenLdapSchemaParser.startsWith(pos, EXTENSION_PREFIX)) break;
                OpenLdapSchemaParser.processExtension(reader, pos, normalizer);
            }
            if (OpenLdapSchemaParser.startsWith(reader, pos, ')')) {
                ++pos.start;
            } else {
                throw new LdapSchemaException(I18n.err(I18n.ERR_13821_NORM_DESCRIPTION_INVALID, pos.lineNumber, pos.start));
            }
        }
        return normalizer;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ObjectClass parseObjectClass(String objectClassDescription) throws ParseException {
        if (objectClassDescription == null) throw new ParseException(I18n.err(I18n.ERR_13716_NULL_OR_EMPTY_STRING_SCHEMA_OBJECT, new Object[0]), 0);
        if (Strings.isEmpty(objectClassDescription.trim())) {
            throw new ParseException(I18n.err(I18n.ERR_13716_NULL_OR_EMPTY_STRING_SCHEMA_OBJECT, new Object[0]), 0);
        }
        try (BufferedReader reader = new BufferedReader(new StringReader(objectClassDescription));){
            PosSchema pos = new PosSchema();
            if (this.isQuirksModeEnabled) {
                ObjectClass objectClass = OpenLdapSchemaParser.parseObjectClassRelaxed(reader, pos, this.objectIdentifierMacros);
                return objectClass;
            }
            ObjectClass objectClass = OpenLdapSchemaParser.parseObjectClassStrict(reader, pos, this.objectIdentifierMacros);
            return objectClass;
        }
        catch (IOException | LdapSchemaException e) {
            throw new ParseException(e.getMessage(), 0);
        }
    }

    private static ObjectClass parseObjectClassStrict(Reader reader, PosSchema pos, Map<String, OpenLdapObjectIdentifierMacro> objectIdentifierMacros) throws IOException, LdapSchemaException {
        MutableObjectClass objectClass;
        block15: {
            OpenLdapSchemaParser.skipWhites(reader, pos, false);
            if (pos.line.charAt(pos.start) != '(') {
                throw new LdapSchemaException(I18n.err(I18n.ERR_13829_NO_OPENING_PAREN, pos.lineNumber, pos.start));
            }
            ++pos.start;
            OpenLdapSchemaParser.skipWhites(reader, pos, false);
            String oid = OpenLdapSchemaParser.getOidAndMacroRelaxed(pos, objectIdentifierMacros);
            if (!Oid.isOid(oid)) {
                throw new LdapSchemaException(I18n.err(I18n.ERR_13787_OID_EXPECTED, pos.lineNumber, pos.start));
            }
            objectClass = new MutableObjectClass(oid);
            int elementsSeen = 0;
            while (true) {
                if (OpenLdapSchemaParser.startsWith(reader, pos, ')')) {
                    ++pos.start;
                    break block15;
                }
                OpenLdapSchemaParser.skipWhites(reader, pos, true);
                if (OpenLdapSchemaParser.startsWith(pos, NAME_STR)) {
                    elementsSeen = OpenLdapSchemaParser.checkElement(elementsSeen, ObjectClassElements.NAME, pos);
                    pos.start += NAME_STR.length();
                    OpenLdapSchemaParser.skipWhites(reader, pos, true);
                    List<String> names = OpenLdapSchemaParser.getQDescrs(reader, pos, false);
                    objectClass.setNames(names);
                    continue;
                }
                if (OpenLdapSchemaParser.startsWith(pos, DESC_STR)) {
                    elementsSeen = OpenLdapSchemaParser.checkElement(elementsSeen, ObjectClassElements.DESC, pos);
                    pos.start += DESC_STR.length();
                    OpenLdapSchemaParser.skipWhites(reader, pos, true);
                    objectClass.setDescription(OpenLdapSchemaParser.getQDString(reader, pos));
                    continue;
                }
                if (OpenLdapSchemaParser.startsWith(pos, OBSOLETE_STR)) {
                    elementsSeen = OpenLdapSchemaParser.checkElement(elementsSeen, ObjectClassElements.OBSOLETE, pos);
                    pos.start += OBSOLETE_STR.length();
                    objectClass.setObsolete(true);
                    continue;
                }
                if (OpenLdapSchemaParser.startsWith(pos, SUP_STR)) {
                    elementsSeen = OpenLdapSchemaParser.checkElement(elementsSeen, ObjectClassElements.SUP, pos);
                    pos.start += SUP_STR.length();
                    OpenLdapSchemaParser.skipWhites(reader, pos, true);
                    List<String> superiorOids = OpenLdapSchemaParser.getOidsStrict(reader, pos);
                    objectClass.setSuperiorOids(superiorOids);
                    continue;
                }
                if (OpenLdapSchemaParser.startsWith(pos, ABSTRACT_STR)) {
                    elementsSeen = OpenLdapSchemaParser.checkElement(elementsSeen, ObjectClassElements.ABSTRACT, pos);
                    pos.start += ABSTRACT_STR.length();
                    objectClass.setType(ObjectClassTypeEnum.ABSTRACT);
                    continue;
                }
                if (OpenLdapSchemaParser.startsWith(pos, STRUCTURAL_STR)) {
                    elementsSeen = OpenLdapSchemaParser.checkElement(elementsSeen, ObjectClassElements.STRUCTURAL, pos);
                    pos.start += STRUCTURAL_STR.length();
                    objectClass.setType(ObjectClassTypeEnum.STRUCTURAL);
                    continue;
                }
                if (OpenLdapSchemaParser.startsWith(pos, AUXILIARY_STR)) {
                    elementsSeen = OpenLdapSchemaParser.checkElement(elementsSeen, ObjectClassElements.AUXILIARY, pos);
                    pos.start += AUXILIARY_STR.length();
                    objectClass.setType(ObjectClassTypeEnum.AUXILIARY);
                    continue;
                }
                if (OpenLdapSchemaParser.startsWith(pos, MUST_STR)) {
                    elementsSeen = OpenLdapSchemaParser.checkElement(elementsSeen, ObjectClassElements.MUST, pos);
                    pos.start += MUST_STR.length();
                    OpenLdapSchemaParser.skipWhites(reader, pos, true);
                    List<String> mustAttributeTypes = OpenLdapSchemaParser.getOidsStrict(reader, pos);
                    objectClass.setMustAttributeTypeOids(mustAttributeTypes);
                    continue;
                }
                if (OpenLdapSchemaParser.startsWith(pos, MAY_STR)) {
                    elementsSeen = OpenLdapSchemaParser.checkElement(elementsSeen, ObjectClassElements.MAY, pos);
                    pos.start += MAY_STR.length();
                    OpenLdapSchemaParser.skipWhites(reader, pos, true);
                    List<String> mayAttributeTypes = OpenLdapSchemaParser.getOidsStrict(reader, pos);
                    objectClass.setMayAttributeTypeOids(mayAttributeTypes);
                    continue;
                }
                if (!OpenLdapSchemaParser.startsWith(pos, EXTENSION_PREFIX)) break;
                OpenLdapSchemaParser.processExtension(reader, pos, objectClass);
            }
            if (OpenLdapSchemaParser.startsWith(reader, pos, ')')) {
                ++pos.start;
            } else {
                throw new LdapSchemaException(I18n.err(I18n.ERR_13803_OC_DESCRIPTION_INVALID, pos.lineNumber, pos.start));
            }
        }
        ++pos.start;
        return objectClass;
    }

    private static ObjectClass parseObjectClassRelaxed(Reader reader, PosSchema pos, Map<String, OpenLdapObjectIdentifierMacro> objectIdentifierMacros) throws IOException, LdapSchemaException {
        MutableObjectClass objectClass;
        block14: {
            OpenLdapSchemaParser.skipWhites(reader, pos, false);
            if (pos.line.charAt(pos.start) != '(') {
                throw new LdapSchemaException(I18n.err(I18n.ERR_13829_NO_OPENING_PAREN, pos.lineNumber, pos.start));
            }
            ++pos.start;
            OpenLdapSchemaParser.skipWhites(reader, pos, false);
            String oid = OpenLdapSchemaParser.getOidAndMacroRelaxed(pos, objectIdentifierMacros);
            objectClass = new MutableObjectClass(oid);
            int elementsSeen = 0;
            while (true) {
                if (OpenLdapSchemaParser.startsWith(reader, pos, ')')) {
                    ++pos.start;
                    break block14;
                }
                OpenLdapSchemaParser.skipWhites(reader, pos, true);
                if (OpenLdapSchemaParser.startsWith(pos, NAME_STR)) {
                    elementsSeen = OpenLdapSchemaParser.checkElement(elementsSeen, ObjectClassElements.NAME, pos);
                    pos.start += NAME_STR.length();
                    OpenLdapSchemaParser.skipWhites(reader, pos, true);
                    List<String> names = OpenLdapSchemaParser.getQDescrs(reader, pos, true);
                    objectClass.setNames(names);
                    continue;
                }
                if (OpenLdapSchemaParser.startsWith(pos, DESC_STR)) {
                    elementsSeen = OpenLdapSchemaParser.checkElement(elementsSeen, ObjectClassElements.DESC, pos);
                    pos.start += DESC_STR.length();
                    OpenLdapSchemaParser.skipWhites(reader, pos, true);
                    objectClass.setDescription(OpenLdapSchemaParser.getQDString(reader, pos));
                    continue;
                }
                if (OpenLdapSchemaParser.startsWith(pos, OBSOLETE_STR)) {
                    elementsSeen = OpenLdapSchemaParser.checkElement(elementsSeen, ObjectClassElements.OBSOLETE, pos);
                    pos.start += OBSOLETE_STR.length();
                    objectClass.setObsolete(true);
                    continue;
                }
                if (OpenLdapSchemaParser.startsWith(pos, SUP_STR)) {
                    elementsSeen = OpenLdapSchemaParser.checkElement(elementsSeen, ObjectClassElements.SUP, pos);
                    pos.start += SUP_STR.length();
                    OpenLdapSchemaParser.skipWhites(reader, pos, true);
                    List<String> superiorOids = OpenLdapSchemaParser.getOidsRelaxed(reader, pos);
                    objectClass.setSuperiorOids(superiorOids);
                    continue;
                }
                if (OpenLdapSchemaParser.startsWith(pos, ABSTRACT_STR)) {
                    elementsSeen = OpenLdapSchemaParser.checkElement(elementsSeen, ObjectClassElements.ABSTRACT, pos);
                    pos.start += ABSTRACT_STR.length();
                    objectClass.setType(ObjectClassTypeEnum.ABSTRACT);
                    continue;
                }
                if (OpenLdapSchemaParser.startsWith(pos, STRUCTURAL_STR)) {
                    elementsSeen = OpenLdapSchemaParser.checkElement(elementsSeen, ObjectClassElements.STRUCTURAL, pos);
                    pos.start += STRUCTURAL_STR.length();
                    objectClass.setType(ObjectClassTypeEnum.STRUCTURAL);
                    continue;
                }
                if (OpenLdapSchemaParser.startsWith(pos, AUXILIARY_STR)) {
                    elementsSeen = OpenLdapSchemaParser.checkElement(elementsSeen, ObjectClassElements.AUXILIARY, pos);
                    pos.start += AUXILIARY_STR.length();
                    objectClass.setType(ObjectClassTypeEnum.AUXILIARY);
                    continue;
                }
                if (OpenLdapSchemaParser.startsWith(pos, MUST_STR)) {
                    elementsSeen = OpenLdapSchemaParser.checkElement(elementsSeen, ObjectClassElements.MUST, pos);
                    pos.start += MUST_STR.length();
                    OpenLdapSchemaParser.skipWhites(reader, pos, true);
                    List<String> mustAttributeTypes = OpenLdapSchemaParser.getOidsRelaxed(reader, pos);
                    objectClass.setMustAttributeTypeOids(mustAttributeTypes);
                    continue;
                }
                if (OpenLdapSchemaParser.startsWith(pos, MAY_STR)) {
                    elementsSeen = OpenLdapSchemaParser.checkElement(elementsSeen, ObjectClassElements.MAY, pos);
                    pos.start += MAY_STR.length();
                    OpenLdapSchemaParser.skipWhites(reader, pos, true);
                    List<String> mayAttributeTypes = OpenLdapSchemaParser.getOidsRelaxed(reader, pos);
                    objectClass.setMayAttributeTypeOids(mayAttributeTypes);
                    continue;
                }
                if (!OpenLdapSchemaParser.startsWith(pos, EXTENSION_PREFIX)) break;
                OpenLdapSchemaParser.processExtension(reader, pos, objectClass);
            }
            if (OpenLdapSchemaParser.startsWith(reader, pos, ')')) {
                ++pos.start;
            } else {
                throw new LdapSchemaException(I18n.err(I18n.ERR_13803_OC_DESCRIPTION_INVALID, pos.lineNumber, pos.start));
            }
        }
        ++pos.start;
        return objectClass;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SyntaxCheckerDescription parseSyntaxChecker(String syntaxCheckerDescription) throws ParseException {
        if (syntaxCheckerDescription == null) throw new ParseException(I18n.err(I18n.ERR_13716_NULL_OR_EMPTY_STRING_SCHEMA_OBJECT, new Object[0]), 0);
        if (Strings.isEmpty(syntaxCheckerDescription.trim())) {
            throw new ParseException(I18n.err(I18n.ERR_13716_NULL_OR_EMPTY_STRING_SCHEMA_OBJECT, new Object[0]), 0);
        }
        try (BufferedReader reader = new BufferedReader(new StringReader(syntaxCheckerDescription));){
            PosSchema pos = new PosSchema();
            if (this.isQuirksModeEnabled) {
                SyntaxCheckerDescription syntaxCheckerDescription2 = OpenLdapSchemaParser.parseSyntaxCheckerRelaxed(reader, pos, this.objectIdentifierMacros);
                return syntaxCheckerDescription2;
            }
            SyntaxCheckerDescription syntaxCheckerDescription3 = OpenLdapSchemaParser.parseSyntaxCheckerStrict(reader, pos, this.objectIdentifierMacros);
            return syntaxCheckerDescription3;
        }
        catch (IOException | LdapSchemaException e) {
            throw new ParseException(e.getMessage(), 0);
        }
    }

    private static SyntaxCheckerDescription parseSyntaxCheckerStrict(Reader reader, PosSchema pos, Map<String, OpenLdapObjectIdentifierMacro> objectIdentifierMacros) throws IOException, LdapSchemaException {
        boolean hasByteCode;
        boolean hasFqcn;
        SyntaxCheckerDescription syntaxChecker;
        block11: {
            OpenLdapSchemaParser.skipWhites(reader, pos, false);
            if (pos.line.charAt(pos.start) != '(') {
                throw new LdapSchemaException(I18n.err(I18n.ERR_13829_NO_OPENING_PAREN, pos.lineNumber, pos.start));
            }
            ++pos.start;
            OpenLdapSchemaParser.skipWhites(reader, pos, false);
            String oid = OpenLdapSchemaParser.getOidAndMacroRelaxed(pos, objectIdentifierMacros);
            if (!Oid.isOid(oid)) {
                throw new LdapSchemaException(I18n.err(I18n.ERR_13787_OID_EXPECTED, pos.lineNumber, pos.start));
            }
            syntaxChecker = new SyntaxCheckerDescription(oid);
            int elementsSeen = 0;
            hasFqcn = false;
            hasByteCode = false;
            while (true) {
                if (OpenLdapSchemaParser.startsWith(reader, pos, ')')) {
                    ++pos.start;
                    break block11;
                }
                OpenLdapSchemaParser.skipWhites(reader, pos, true);
                if (OpenLdapSchemaParser.startsWith(pos, DESC_STR)) {
                    elementsSeen = OpenLdapSchemaParser.checkElement(elementsSeen, SyntaxCheckerElements.DESC, pos);
                    pos.start += DESC_STR.length();
                    OpenLdapSchemaParser.skipWhites(reader, pos, true);
                    syntaxChecker.setDescription(OpenLdapSchemaParser.getQDString(reader, pos));
                    continue;
                }
                if (OpenLdapSchemaParser.startsWith(pos, FQCN_STR)) {
                    elementsSeen = OpenLdapSchemaParser.checkElement(elementsSeen, SyntaxCheckerElements.FQCN, pos);
                    pos.start += FQCN_STR.length();
                    OpenLdapSchemaParser.skipWhites(reader, pos, true);
                    String fqcn = OpenLdapSchemaParser.getFqcn(pos);
                    syntaxChecker.setFqcn(fqcn);
                    hasFqcn = true;
                    continue;
                }
                if (OpenLdapSchemaParser.startsWith(pos, BYTECODE_STR)) {
                    elementsSeen = OpenLdapSchemaParser.checkElement(elementsSeen, SyntaxCheckerElements.BYTECODE, pos);
                    pos.start += BYTECODE_STR.length();
                    OpenLdapSchemaParser.skipWhites(reader, pos, true);
                    String byteCode = OpenLdapSchemaParser.getByteCode(pos);
                    syntaxChecker.setBytecode(byteCode);
                    hasByteCode = true;
                    continue;
                }
                if (!OpenLdapSchemaParser.startsWith(pos, EXTENSION_PREFIX)) break;
                OpenLdapSchemaParser.processExtension(reader, pos, syntaxChecker);
            }
            if (OpenLdapSchemaParser.startsWith(reader, pos, ')')) {
                ++pos.start;
            } else {
                throw new LdapSchemaException(I18n.err(I18n.ERR_13826_SC_DESCRIPTION_INVALID, pos.lineNumber, pos.start));
            }
        }
        if (!hasFqcn) {
            throw new LdapSchemaException(I18n.err(I18n.ERR_13819_FQCN_REQUIRED, pos.lineNumber, pos.start));
        }
        if (hasByteCode && syntaxChecker.getBytecode().length() % 4 != 0) {
            throw new LdapSchemaException(I18n.err(I18n.ERR_13820_BYTE_CODE_REQUIRED, pos.lineNumber, pos.start));
        }
        return syntaxChecker;
    }

    private static SyntaxCheckerDescription parseSyntaxCheckerRelaxed(Reader reader, PosSchema pos, Map<String, OpenLdapObjectIdentifierMacro> objectIdentifierMacros) throws IOException, LdapSchemaException {
        SyntaxCheckerDescription syntaxChecker;
        block8: {
            OpenLdapSchemaParser.skipWhites(reader, pos, false);
            if (pos.line.charAt(pos.start) != '(') {
                throw new LdapSchemaException(I18n.err(I18n.ERR_13829_NO_OPENING_PAREN, pos.lineNumber, pos.start));
            }
            ++pos.start;
            OpenLdapSchemaParser.skipWhites(reader, pos, false);
            String oid = OpenLdapSchemaParser.getOidAndMacroRelaxed(pos, objectIdentifierMacros);
            syntaxChecker = new SyntaxCheckerDescription(oid);
            int elementsSeen = 0;
            while (true) {
                if (OpenLdapSchemaParser.startsWith(reader, pos, ')')) {
                    ++pos.start;
                    break block8;
                }
                OpenLdapSchemaParser.skipWhites(reader, pos, true);
                if (OpenLdapSchemaParser.startsWith(pos, DESC_STR)) {
                    elementsSeen = OpenLdapSchemaParser.checkElement(elementsSeen, SyntaxCheckerElements.DESC, pos);
                    pos.start += DESC_STR.length();
                    OpenLdapSchemaParser.skipWhites(reader, pos, true);
                    syntaxChecker.setDescription(OpenLdapSchemaParser.getQDString(reader, pos));
                    continue;
                }
                if (OpenLdapSchemaParser.startsWith(pos, FQCN_STR)) {
                    elementsSeen = OpenLdapSchemaParser.checkElement(elementsSeen, SyntaxCheckerElements.FQCN, pos);
                    pos.start += FQCN_STR.length();
                    OpenLdapSchemaParser.skipWhites(reader, pos, true);
                    String fqcn = OpenLdapSchemaParser.getFqcn(pos);
                    syntaxChecker.setFqcn(fqcn);
                    continue;
                }
                if (OpenLdapSchemaParser.startsWith(pos, BYTECODE_STR)) {
                    elementsSeen = OpenLdapSchemaParser.checkElement(elementsSeen, SyntaxCheckerElements.BYTECODE, pos);
                    pos.start += BYTECODE_STR.length();
                    OpenLdapSchemaParser.skipWhites(reader, pos, true);
                    String byteCode = OpenLdapSchemaParser.getByteCode(pos);
                    syntaxChecker.setBytecode(byteCode);
                    continue;
                }
                if (!OpenLdapSchemaParser.startsWith(pos, EXTENSION_PREFIX)) break;
                OpenLdapSchemaParser.processExtension(reader, pos, syntaxChecker);
            }
            if (OpenLdapSchemaParser.startsWith(reader, pos, ')')) {
                ++pos.start;
            } else {
                throw new LdapSchemaException(I18n.err(I18n.ERR_13826_SC_DESCRIPTION_INVALID, pos.lineNumber, pos.start));
            }
        }
        return syntaxChecker;
    }

    private void processObjectIdentifier(Reader reader, PosSchema pos) throws IOException, LdapSchemaException {
        OpenLdapSchemaParser.skipWhites(reader, pos, false);
        String name = OpenLdapSchemaParser.getDescrStrict(pos);
        OpenLdapObjectIdentifierMacro macro = new OpenLdapObjectIdentifierMacro();
        OpenLdapSchemaParser.skipWhites(reader, pos, true);
        if (OpenLdapSchemaParser.isEmpty(pos)) {
            throw new LdapSchemaException(I18n.err(I18n.ERR_13805_OBJECT_IDENTIFIER_INVALID_OID, pos.lineNumber, pos.start));
        }
        if (OpenLdapSchemaParser.isAlpha(pos)) {
            String descr = this.getMacro(pos);
            if (OpenLdapSchemaParser.isEmpty(pos)) {
                throw new LdapSchemaException(I18n.err(I18n.ERR_13804_OBJECT_IDENTIFIER_HAS_NO_OID, pos.lineNumber, pos.start));
            }
            if (OpenLdapSchemaParser.startsWith(reader, pos, ':')) {
                ++pos.start;
                String numericOid = OpenLdapSchemaParser.getPartialNumericOid(pos);
                String realOid = this.objectIdentifierMacros.get(descr).getRawOidOrNameSuffix() + '.' + numericOid;
                macro.setName(name);
                macro.setRawOidOrNameSuffix(realOid);
                this.objectIdentifierMacros.put(name, macro);
            }
        } else if (OpenLdapSchemaParser.isDigit(pos)) {
            String numericOid = OpenLdapSchemaParser.getNumericOid(pos);
            macro.setRawOidOrNameSuffix(numericOid);
            macro.setName(name);
            this.objectIdentifierMacros.put(name, macro);
        } else {
            throw new LdapSchemaException(I18n.err(I18n.ERR_13805_OBJECT_IDENTIFIER_INVALID_OID, pos.lineNumber, pos.start));
        }
    }

    public void parse(Reader reader) throws LdapSchemaException, IOException {
        block3: {
            PosSchema pos = new PosSchema();
            while (true) {
                OpenLdapSchemaParser.skipWhites(reader, pos, false);
                if (pos.line == null) break block3;
                if (OpenLdapSchemaParser.startsWith(pos, "objectidentifier")) {
                    pos.start += "objectidentifier".length();
                    this.processObjectIdentifier(reader, pos);
                    continue;
                }
                if (OpenLdapSchemaParser.startsWith(pos, "attributetype")) {
                    pos.start += "attributetype".length();
                    AttributeType attributeType = OpenLdapSchemaParser.parseAttributeTypeStrict(reader, pos, this.objectIdentifierMacros);
                    this.schemaDescriptions.add(attributeType);
                    continue;
                }
                if (!OpenLdapSchemaParser.startsWith(pos, "objectclass")) break;
                pos.start += "objectclass".length();
                ObjectClass objectClass = OpenLdapSchemaParser.parseObjectClassStrict(reader, pos, this.objectIdentifierMacros);
                this.schemaDescriptions.add(objectClass);
            }
            throw new LdapSchemaException(I18n.err(I18n.ERR_13806_UNEXPECTED_ELEMENT_READ, pos.line.substring(pos.start), pos.lineNumber, pos.start));
        }
    }

    public void parse(File schemaFile) throws ParseException {
        try (InputStream is = Files.newInputStream(Paths.get(schemaFile.getPath(), new String[0]), new OpenOption[0]);){
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(is, Charset.defaultCharset()));){
                this.parse(reader);
                this.afterParse();
            }
            catch (IOException | LdapSchemaException e) {
                throw new ParseException(e.getMessage(), 0);
            }
        }
        catch (IOException e) {
            String msg = I18n.err(I18n.ERR_13443_CANNOT_FIND_FILE, schemaFile.getAbsoluteFile());
            LOG.error(msg);
            throw new ParseException(e.getMessage(), 0);
        }
    }

    public boolean isResolveObjectIdentifierMacros() {
        return this.isResolveObjectIdentifierMacros;
    }

    public void setResolveObjectIdentifierMacros(boolean resolveObjectIdentifierMacros) {
        this.isResolveObjectIdentifierMacros = resolveObjectIdentifierMacros;
    }

    public boolean isQuirksMode() {
        return this.isQuirksModeEnabled;
    }

    public void setQuirksMode(boolean enabled) {
        this.isQuirksModeEnabled = enabled;
    }

    private static enum SyntaxCheckerElements implements SchemaObjectElements
    {
        DESC(1),
        FQCN(2),
        BYTECODE(4);

        private int value;

        private SyntaxCheckerElements(int value) {
            this.value = value;
        }

        @Override
        public int getValue() {
            return this.value;
        }
    }

    private static enum ObjectClassElements implements SchemaObjectElements
    {
        NAME(1),
        DESC(2),
        OBSOLETE(4),
        SUP(8),
        MUST(16),
        MAY(32),
        ABSTRACT(64),
        STRUCTURAL(64),
        AUXILIARY(64);

        private int value;

        private ObjectClassElements(int value) {
            this.value = value;
        }

        @Override
        public int getValue() {
            return this.value;
        }
    }

    private static enum NormalizerElements implements SchemaObjectElements
    {
        DESC(1),
        FQCN(2),
        BYTECODE(4);

        private int value;

        private NormalizerElements(int value) {
            this.value = value;
        }

        @Override
        public int getValue() {
            return this.value;
        }
    }

    private static enum NameFormElements implements SchemaObjectElements
    {
        NAME(1),
        DESC(2),
        OBSOLETE(4),
        OC(8),
        MUST(16),
        MAY(32);

        private int value;

        private NameFormElements(int value) {
            this.value = value;
        }

        @Override
        public int getValue() {
            return this.value;
        }
    }

    private static enum MatchingRuleUseElements implements SchemaObjectElements
    {
        NAME(1),
        DESC(2),
        OBSOLETE(4),
        APPLIES(8);

        private int value;

        private MatchingRuleUseElements(int value) {
            this.value = value;
        }

        @Override
        public int getValue() {
            return this.value;
        }
    }

    private static enum MatchingRuleElements implements SchemaObjectElements
    {
        NAME(1),
        DESC(2),
        OBSOLETE(4),
        SYNTAX(8);

        private int value;

        private MatchingRuleElements(int value) {
            this.value = value;
        }

        @Override
        public int getValue() {
            return this.value;
        }
    }

    private static enum LdapSyntaxElements implements SchemaObjectElements
    {
        DESC(1);

        private int value;

        private LdapSyntaxElements(int value) {
            this.value = value;
        }

        @Override
        public int getValue() {
            return this.value;
        }
    }

    private static enum LdapComparatorElements implements SchemaObjectElements
    {
        DESC(1),
        FQCN(2),
        BYTECODE(4);

        private int value;

        private LdapComparatorElements(int value) {
            this.value = value;
        }

        @Override
        public int getValue() {
            return this.value;
        }
    }

    private static enum DitStructureRuleElements implements SchemaObjectElements
    {
        NAME(1),
        DESC(2),
        OBSOLETE(4),
        FORM(8),
        SUP(16);

        private int value;

        private DitStructureRuleElements(int value) {
            this.value = value;
        }

        @Override
        public int getValue() {
            return this.value;
        }
    }

    private static enum DitContentRuleElements implements SchemaObjectElements
    {
        NAME(1),
        DESC(2),
        OBSOLETE(4),
        AUX(8),
        MUST(16),
        MAY(32),
        NOT(64);

        private int value;

        private DitContentRuleElements(int value) {
            this.value = value;
        }

        @Override
        public int getValue() {
            return this.value;
        }
    }

    private static enum AttributeTypeElements implements SchemaObjectElements
    {
        NAME(1),
        DESC(2),
        OBSOLETE(4),
        SUP(8),
        EQUALITY(16),
        ORDERING(32),
        SUBSTR(64),
        SYNTAX(128),
        SINGLE_VALUE(256),
        COLLECTIVE(512),
        NO_USER_MODIFICATION(1024),
        USAGE(2048);

        private int value;

        private AttributeTypeElements(int value) {
            this.value = value;
        }

        @Override
        public int getValue() {
            return this.value;
        }
    }

    private static interface SchemaObjectElements {
        public int getValue();
    }

    private class PosSchema {
        int lineNumber;
        int start;
        String line;

        private PosSchema() {
        }

        public String toString() {
            if (this.line == null) {
                return "null";
            }
            if (this.line.length() < this.start) {
                return "EOL";
            }
            return this.line.substring(this.start);
        }
    }
}

