/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.codec.protocol.mina;

import java.nio.ByteBuffer;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.codec.api.LdapApiService;
import org.apache.directory.api.ldap.codec.api.LdapApiServiceFactory;
import org.apache.directory.api.ldap.codec.api.LdapEncoder;
import org.apache.directory.api.ldap.model.constants.Loggers;
import org.apache.directory.api.ldap.model.message.Message;
import org.apache.directory.api.util.Strings;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.codec.ProtocolEncoder;
import org.apache.mina.filter.codec.ProtocolEncoderOutput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LdapProtocolEncoder
implements ProtocolEncoder {
    private static final Logger CODEC_LOG = LoggerFactory.getLogger(Loggers.CODEC_LOG.getName());
    private LdapEncoder encoder;

    public LdapProtocolEncoder() {
        this(LdapApiServiceFactory.getSingleton());
    }

    public LdapProtocolEncoder(LdapApiService ldapApiService) {
        this.encoder = new LdapEncoder(ldapApiService);
    }

    @Override
    public void encode(IoSession session, Object message, ProtocolEncoderOutput out) throws Exception {
        ByteBuffer buffer = this.encoder.encodeMessage((Message)message);
        IoBuffer ioBuffer = IoBuffer.wrap(buffer);
        if (CODEC_LOG.isDebugEnabled()) {
            byte[] dumpBuffer = new byte[buffer.limit()];
            buffer.get(dumpBuffer);
            buffer.flip();
            CODEC_LOG.debug(I18n.msg(I18n.MSG_14003_ENCODED_LDAP_MESSAGE, message, Strings.dumpBytes(dumpBuffer)));
        }
        out.write(ioBuffer);
    }

    @Override
    public void dispose(IoSession session) throws Exception {
    }
}

