/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.codec.actions.request.add;

import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.asn1.ber.grammar.GrammarAction;
import org.apache.directory.api.asn1.ber.tlv.TLV;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.codec.api.LdapMessageContainer;
import org.apache.directory.api.ldap.codec.decorators.AddRequestDecorator;
import org.apache.directory.api.ldap.model.message.AddRequestImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InitAddRequest
extends GrammarAction<LdapMessageContainer<AddRequestDecorator>> {
    private static final Logger LOG = LoggerFactory.getLogger(InitAddRequest.class);

    public InitAddRequest() {
        super("Init AddRequest");
    }

    @Override
    public void action(LdapMessageContainer<AddRequestDecorator> container) throws DecoderException {
        int messageId = container.getMessageId();
        AddRequestImpl internalAddRequest = new AddRequestImpl();
        internalAddRequest.setMessageId(messageId);
        AddRequestDecorator addRequest = new AddRequestDecorator(container.getLdapCodecService(), internalAddRequest);
        container.setMessage(addRequest);
        TLV tlv = container.getCurrentTLV();
        if (tlv.getLength() == 0) {
            String msg = I18n.err(I18n.ERR_05145_NULL_ADD_REQUEST, new Object[0]);
            LOG.error(msg);
            throw new DecoderException(msg);
        }
    }
}

