/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.hash;

import java.util.List;
import org.apache.directory.api.ldap.model.constants.LdapSecurityConstants;
import org.apache.directory.api.ldap.model.entry.Attribute;
import org.apache.directory.api.ldap.model.entry.BinaryValue;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.entry.Modification;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.password.PasswordUtil;
import org.apache.directory.server.core.api.interceptor.BaseInterceptor;
import org.apache.directory.server.core.api.interceptor.context.AddOperationContext;
import org.apache.directory.server.core.api.interceptor.context.ModifyOperationContext;

public abstract class PasswordHashingInterceptor
extends BaseInterceptor {
    private LdapSecurityConstants algorithm;

    protected PasswordHashingInterceptor(String name, LdapSecurityConstants algorithm) {
        super(name);
        this.algorithm = algorithm;
    }

    @Override
    public void add(AddOperationContext addContext) throws LdapException {
        if (this.algorithm == null) {
            this.next(addContext);
            return;
        }
        Entry entry = addContext.getEntry();
        Attribute pwdAt = entry.get("userPassword");
        this.includeHashedPassword(pwdAt);
        this.next(addContext);
    }

    @Override
    public void modify(ModifyOperationContext modifyContext) throws LdapException {
        if (this.algorithm == null) {
            this.next(modifyContext);
            return;
        }
        List<Modification> mods = modifyContext.getModItems();
        for (Modification mod : mods) {
            String oid = mod.getAttribute().getAttributeType().getOid();
            if (!"2.5.4.35".equals(oid)) continue;
            this.includeHashedPassword(mod.getAttribute());
            break;
        }
        this.next(modifyContext);
    }

    private void includeHashedPassword(Attribute pwdAt) throws LdapException {
        if (pwdAt == null) {
            return;
        }
        BinaryValue userPassword = (BinaryValue)pwdAt.get();
        LdapSecurityConstants existingAlgo = PasswordUtil.findAlgorithm(userPassword.getValue());
        if (existingAlgo == null) {
            byte[] hashedPassword = PasswordUtil.createStoragePassword(userPassword.getValue(), this.algorithm);
            pwdAt.clear();
            pwdAt.add(new byte[][]{hashedPassword});
        }
    }
}

