/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.schema.syntaxCheckers;

import java.text.ParseException;
import org.apache.directory.api.ldap.model.schema.SyntaxChecker;
import org.apache.directory.api.ldap.model.schema.parsers.DitStructureRuleDescriptionSchemaParser;
import org.apache.directory.api.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DitStructureRuleDescriptionSyntaxChecker
extends SyntaxChecker {
    private static final Logger LOG = LoggerFactory.getLogger(DitStructureRuleDescriptionSyntaxChecker.class);
    private DitStructureRuleDescriptionSchemaParser schemaParser = new DitStructureRuleDescriptionSchemaParser();

    public DitStructureRuleDescriptionSyntaxChecker() {
        super("1.3.6.1.4.1.1466.115.121.1.17");
    }

    public boolean isValidSyntax(Object value) {
        String strValue = null;
        if (value == null) {
            LOG.debug("Syntax invalid for 'null'");
            return false;
        }
        strValue = value instanceof String ? (String)value : (value instanceof byte[] ? Strings.utf8ToString((byte[])value) : value.toString());
        try {
            this.schemaParser.parseDITStructureRuleDescription(strValue);
            LOG.debug("Syntax valid for '{}'", value);
            return true;
        }
        catch (ParseException pe) {
            LOG.debug("Syntax invalid for '{}'", value);
            return false;
        }
    }
}

