/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.actions.ldapResult;

import org.apache.directory.shared.asn1.DecoderException;
import org.apache.directory.shared.asn1.ber.grammar.GrammarAction;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.codec.api.LdapMessageContainer;
import org.apache.directory.shared.ldap.codec.api.MessageDecorator;
import org.apache.directory.shared.ldap.model.exception.LdapURLEncodingException;
import org.apache.directory.shared.ldap.model.message.LdapResult;
import org.apache.directory.shared.ldap.model.message.Message;
import org.apache.directory.shared.ldap.model.message.Referral;
import org.apache.directory.shared.ldap.model.message.ResultCodeEnum;
import org.apache.directory.shared.ldap.model.message.ResultResponse;
import org.apache.directory.shared.ldap.model.url.LdapUrl;
import org.apache.directory.shared.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddReferral
extends GrammarAction<LdapMessageContainer<MessageDecorator<? extends Message>>> {
    private static final Logger LOG = LoggerFactory.getLogger(AddReferral.class);
    private static final boolean IS_DEBUG = LOG.isDebugEnabled();

    public AddReferral() {
        super("Add a referral");
    }

    @Override
    public void action(LdapMessageContainer<MessageDecorator<? extends Message>> container) throws DecoderException {
        TLV tlv = container.getCurrentTLV();
        MessageDecorator<? extends Message> response = container.getMessage();
        LdapResult ldapResult = ((ResultResponse)((Object)response)).getLdapResult();
        Referral referral = ldapResult.getReferral();
        if (tlv.getLength() == 0) {
            referral.addLdapUrl("");
        } else if (ldapResult.getResultCode() == ResultCodeEnum.REFERRAL) {
            try {
                String url = Strings.utf8ToString(tlv.getValue().getData());
                referral.addLdapUrl(new LdapUrl(url).toString());
            }
            catch (LdapURLEncodingException luee) {
                String badUrl = Strings.utf8ToString(tlv.getValue().getData());
                LOG.error(I18n.err(I18n.ERR_04015, badUrl, luee.getMessage()));
                throw new DecoderException(I18n.err(I18n.ERR_04016, luee.getMessage()));
            }
        } else {
            LOG.warn("The Referral error message is not allowed when havind an error code no equals to REFERRAL");
            referral.addLdapUrl(LdapUrl.EMPTY_URL.toString());
        }
        if (IS_DEBUG) {
            StringBuffer sb = new StringBuffer();
            boolean isFirst = true;
            for (String url : ldapResult.getReferral().getLdapUrls()) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    sb.append(", ");
                }
                sb.append(url);
            }
            LOG.debug("The referral error message is set to " + sb.toString());
        }
        container.setGrammarEndAllowed(true);
    }
}

