/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.model.ldif;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.directory.shared.ldap.model.message.Control;
import org.apache.directory.shared.util.Strings;

public class LdifControl
implements Control,
Externalizable {
    private String oid;
    private boolean criticality = false;
    protected byte[] value;

    public LdifControl() {
    }

    public LdifControl(String oid) {
        this.oid = oid;
    }

    public String toString() {
        return "LdifControl : {" + this.getOid() + ", " + this.isCritical() + ", " + Strings.dumpBytes(this.getValue()) + "}";
    }

    public String getOid() {
        return this.oid;
    }

    public boolean isCritical() {
        return this.criticality;
    }

    public void setCritical(boolean criticality) {
        this.criticality = criticality;
    }

    public byte[] getValue() {
        return this.value;
    }

    public void setValue(byte[] value) {
        this.value = value;
    }

    public boolean hasValue() {
        return this.value != null;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeUTF(this.oid);
        out.writeBoolean(this.criticality);
        if (this.hasValue()) {
            out.writeBoolean(true);
            out.writeInt(this.value.length);
            if (this.value.length > 0) {
                out.write(this.value);
            }
        } else {
            out.writeBoolean(false);
        }
        out.flush();
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int valueLength;
        this.oid = in.readUTF();
        this.criticality = in.readBoolean();
        if (in.readBoolean() && (valueLength = in.readInt()) > 0) {
            this.value = new byte[valueLength];
            in.readFully(this.value);
        }
    }

    public int hashCode() {
        int h = 17;
        h = h * 37 + (this.criticality ? 1 : 0);
        h = h * 37 + (this.oid == null ? 0 : this.oid.hashCode());
        if (this.value != null) {
            for (byte v : this.value) {
                h = h * 37 + v;
            }
        }
        return h;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!(o instanceof Control)) {
            return false;
        }
        Control otherControl = (Control)o;
        if (!this.oid.equalsIgnoreCase(otherControl.getOid())) {
            return false;
        }
        return this.criticality == otherControl.isCritical();
    }
}

