/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.kerberos.shared.store;

import javax.security.auth.kerberos.KerberosPrincipal;
import org.apache.directory.server.core.api.CoreSession;
import org.apache.directory.server.core.api.DirectoryService;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.kerberos.shared.store.PrincipalStore;
import org.apache.directory.server.kerberos.shared.store.PrincipalStoreEntry;
import org.apache.directory.server.kerberos.shared.store.operations.ChangePassword;
import org.apache.directory.server.kerberos.shared.store.operations.GetPrincipal;
import org.apache.directory.server.protocol.shared.ServiceConfigurationException;
import org.apache.directory.shared.ldap.model.name.Dn;

class SingleBaseSearch
implements PrincipalStore {
    private final CoreSession session;
    private final Dn searchBaseDn;

    SingleBaseSearch(DirectoryService directoryService, Dn searchBaseDn) {
        try {
            this.session = directoryService.getAdminSession();
            this.searchBaseDn = searchBaseDn;
        }
        catch (Exception e) {
            throw new ServiceConfigurationException(I18n.err(I18n.ERR_627, new Object[0]), e);
        }
    }

    @Override
    public PrincipalStoreEntry getPrincipal(KerberosPrincipal principal) throws Exception {
        return (PrincipalStoreEntry)new GetPrincipal(principal).execute(this.session, this.searchBaseDn);
    }

    @Override
    public String changePassword(KerberosPrincipal principal, String newPassword) throws Exception {
        return (String)new ChangePassword(principal, newPassword).execute(this.session, this.searchBaseDn);
    }
}

