/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.util;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.directory.shared.i18n.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JoinIterator
implements Iterator<Object> {
    private final Iterator<?>[] iterators;
    private int index;

    public JoinIterator(Iterator<?>[] iterators) {
        if (iterators == null || iterators.length < 2) {
            throw new IllegalArgumentException(I18n.err(I18n.ERR_04397, new Object[0]));
        }
        this.iterators = new Iterator[iterators.length];
        System.arraycopy(iterators, 0, this.iterators, 0, iterators.length);
        this.index = 0;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean hasNext() {
        while (this.index < this.iterators.length) {
            if (this.iterators[this.index].hasNext()) {
                return true;
            }
            ++this.index;
        }
        return false;
    }

    @Override
    public Object next() {
        while (this.index < this.iterators.length) {
            if (this.iterators[this.index].hasNext()) {
                return this.iterators[this.index].next();
            }
            ++this.index;
        }
        throw new NoSuchElementException();
    }
}

