/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.osgi;

import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.naming.NamingException;
import javax.naming.ldap.BasicControl;
import javax.naming.ldap.ExtendedRequest;
import org.apache.directory.shared.asn1.DecoderException;
import org.apache.directory.shared.asn1.EncoderException;
import org.apache.directory.shared.asn1.ber.Asn1Container;
import org.apache.directory.shared.ldap.codec.BasicControlDecorator;
import org.apache.directory.shared.ldap.codec.api.CodecControl;
import org.apache.directory.shared.ldap.codec.api.ControlFactory;
import org.apache.directory.shared.ldap.codec.api.ExtendedRequestDecorator;
import org.apache.directory.shared.ldap.codec.api.ExtendedRequestFactory;
import org.apache.directory.shared.ldap.codec.api.ExtendedResponseDecorator;
import org.apache.directory.shared.ldap.codec.api.LdapApiService;
import org.apache.directory.shared.ldap.codec.api.LdapMessageContainer;
import org.apache.directory.shared.ldap.codec.api.UnsolicitedResponseFactory;
import org.apache.directory.shared.ldap.codec.controls.cascade.CascadeDecorator;
import org.apache.directory.shared.ldap.codec.controls.cascade.CascadeFactory;
import org.apache.directory.shared.ldap.codec.controls.manageDsaIT.ManageDsaITFactory;
import org.apache.directory.shared.ldap.codec.controls.search.entryChange.EntryChangeFactory;
import org.apache.directory.shared.ldap.codec.controls.search.pagedSearch.PagedResultsFactory;
import org.apache.directory.shared.ldap.codec.controls.search.persistentSearch.PersistentSearchFactory;
import org.apache.directory.shared.ldap.codec.controls.search.subentries.SubentriesFactory;
import org.apache.directory.shared.ldap.model.message.Control;
import org.apache.directory.shared.ldap.model.message.ExtendedRequestImpl;
import org.apache.directory.shared.ldap.model.message.ExtendedResponse;
import org.apache.directory.shared.ldap.model.message.ExtendedResponseImpl;
import org.apache.directory.shared.ldap.model.message.controls.Cascade;
import org.apache.directory.shared.ldap.model.message.controls.OpaqueControl;
import org.apache.directory.shared.util.Strings;
import org.apache.directory.shared.util.exception.NotImplementedException;
import org.apache.mina.filter.codec.ProtocolCodecFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultLdapCodecService
implements LdapApiService {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultLdapCodecService.class);
    private Map<String, ControlFactory<?, ?>> controlFactories = new HashMap();
    private Map<String, ExtendedRequestFactory<?, ?>> extReqFactories = new HashMap();
    private Map<String, UnsolicitedResponseFactory<?>> unsolicitedFactories = new HashMap();
    private ProtocolCodecFactory protocolCodecFactory;

    DefaultLdapCodecService() {
        this.loadStockControls();
    }

    private void loadStockControls() {
        ControlFactory<Cascade, CascadeDecorator> factory = new CascadeFactory(this);
        this.controlFactories.put(factory.getOid(), factory);
        LOG.info("Registered pre-bundled control factory: {}", (Object)factory.getOid());
        factory = new EntryChangeFactory(this);
        this.controlFactories.put(factory.getOid(), factory);
        LOG.info("Registered pre-bundled control factory: {}", (Object)factory.getOid());
        factory = new ManageDsaITFactory(this);
        this.controlFactories.put(factory.getOid(), factory);
        LOG.info("Registered pre-bundled control factory: {}", (Object)factory.getOid());
        factory = new PagedResultsFactory(this);
        this.controlFactories.put(factory.getOid(), factory);
        LOG.info("Registered pre-bundled control factory: {}", (Object)factory.getOid());
        factory = new PersistentSearchFactory(this);
        this.controlFactories.put(factory.getOid(), factory);
        LOG.info("Registered pre-bundled control factory: {}", (Object)factory.getOid());
        factory = new SubentriesFactory(this);
        this.controlFactories.put(factory.getOid(), factory);
        LOG.info("Registered pre-bundled control factory: {}", (Object)factory.getOid());
    }

    @Override
    public ControlFactory<?, ?> registerControl(ControlFactory<?, ?> factory) {
        return this.controlFactories.put(factory.getOid(), factory);
    }

    @Override
    public ControlFactory<?, ?> unregisterControl(String oid) {
        return this.controlFactories.remove(oid);
    }

    @Override
    public Iterator<String> registeredControls() {
        return Collections.unmodifiableSet(this.controlFactories.keySet()).iterator();
    }

    @Override
    public boolean isControlRegistered(String oid) {
        return this.controlFactories.containsKey(oid);
    }

    @Override
    public Iterator<String> registeredExtendedRequests() {
        return Collections.unmodifiableSet(this.extReqFactories.keySet()).iterator();
    }

    @Override
    public ExtendedRequestFactory<?, ?> registerExtendedRequest(ExtendedRequestFactory<?, ?> factory) {
        return this.extReqFactories.put(factory.getOid(), factory);
    }

    @Override
    public ProtocolCodecFactory getProtocolCodecFactory() {
        return this.protocolCodecFactory;
    }

    @Override
    public ProtocolCodecFactory registerProtocolCodecFactory(ProtocolCodecFactory protocolCodecFactory) {
        ProtocolCodecFactory oldFactory = this.protocolCodecFactory;
        this.protocolCodecFactory = protocolCodecFactory;
        return oldFactory;
    }

    @Override
    public CodecControl<? extends Control> newControl(String oid) {
        ControlFactory<?, ?> factory = this.controlFactories.get(oid);
        if (factory == null) {
            return new BasicControlDecorator((LdapApiService)this, new OpaqueControl(oid));
        }
        return factory.newCodecControl();
    }

    @Override
    public CodecControl<? extends Control> newControl(Control control) {
        if (control == null) {
            throw new NullPointerException("Control argument was null.");
        }
        if (control instanceof CodecControl) {
            return (CodecControl)control;
        }
        ControlFactory<?, ?> factory = this.controlFactories.get(control.getOid());
        if (factory == null) {
            return new BasicControlDecorator((LdapApiService)this, control);
        }
        return factory.newCodecControl(control);
    }

    @Override
    public javax.naming.ldap.Control toJndiControl(Control control) throws EncoderException {
        CodecControl<? extends Control> decorator = this.newControl(control);
        ByteBuffer bb = ByteBuffer.allocate(decorator.computeLength());
        decorator.encode(bb);
        bb.flip();
        BasicControl jndiControl = new BasicControl(control.getOid(), control.isCritical(), bb.array());
        return jndiControl;
    }

    @Override
    public Control fromJndiControl(javax.naming.ldap.Control control) throws DecoderException {
        ControlFactory<?, ?> factory = this.controlFactories.get(control.getID());
        if (factory == null) {
            OpaqueControl ourControl = new OpaqueControl(control.getID());
            ourControl.setCritical(control.isCritical());
            BasicControlDecorator decorator = new BasicControlDecorator((LdapApiService)this, ourControl);
            decorator.setValue(control.getEncodedValue());
            return decorator;
        }
        Object ourControl = factory.newCodecControl();
        ourControl.setCritical(control.isCritical());
        ourControl.setValue(control.getEncodedValue());
        ourControl.decode(control.getEncodedValue());
        return ourControl;
    }

    @Override
    public Asn1Container newMessageContainer() {
        return new LdapMessageContainer(this);
    }

    @Override
    public ExtendedRequestFactory<?, ?> unregisterExtendedRequest(String oid) {
        return this.extReqFactories.remove(oid);
    }

    @Override
    public Iterator<String> registeredUnsolicitedResponses() {
        return Collections.unmodifiableSet(this.unsolicitedFactories.keySet()).iterator();
    }

    @Override
    public UnsolicitedResponseFactory<?> registerUnsolicitedResponse(UnsolicitedResponseFactory<?> factory) {
        return this.unsolicitedFactories.put(factory.getOid(), factory);
    }

    @Override
    public UnsolicitedResponseFactory<?> unregisterUnsolicitedResponse(String oid) {
        return this.unsolicitedFactories.remove(oid);
    }

    @Override
    public javax.naming.ldap.ExtendedResponse toJndi(ExtendedResponse modelResponse) throws EncoderException {
        throw new NotImplementedException("Figure out how to transform");
    }

    @Override
    public ExtendedResponse fromJndi(javax.naming.ldap.ExtendedResponse jndiResponse) throws DecoderException {
        throw new NotImplementedException("Figure out how to transform");
    }

    @Override
    public org.apache.directory.shared.ldap.model.message.ExtendedRequest<?> fromJndi(ExtendedRequest jndiRequest) throws DecoderException {
        ExtendedRequestDecorator decorator = (ExtendedRequestDecorator)this.newExtendedRequest(jndiRequest.getID(), jndiRequest.getEncodedValue());
        return decorator;
    }

    @Override
    public ExtendedRequest toJndi(final org.apache.directory.shared.ldap.model.message.ExtendedRequest<?> modelRequest) throws EncoderException {
        byte[] value;
        final String oid = modelRequest.getRequestName();
        if (modelRequest instanceof ExtendedRequestDecorator) {
            ExtendedRequestDecorator decorator = (ExtendedRequestDecorator)modelRequest;
            value = decorator.getRequestValue();
        } else {
            ExtendedRequestFactory<?, ?> extendedRequestFactory = this.extReqFactories.get(modelRequest.getRequestName());
            ExtendedRequestDecorator<?, ?> decorator = extendedRequestFactory.decorate(modelRequest);
            value = decorator.getRequestValue();
        }
        ExtendedRequest jndiRequest = new ExtendedRequest(){
            private static final long serialVersionUID = -4160980385909987475L;

            public String getID() {
                return oid;
            }

            public byte[] getEncodedValue() {
                return value;
            }

            public javax.naming.ldap.ExtendedResponse createExtendedResponse(String id, byte[] berValue, int offset, int length) throws NamingException {
                ExtendedRequestFactory factory = (ExtendedRequestFactory)DefaultLdapCodecService.this.extReqFactories.get(modelRequest.getRequestName());
                try {
                    final ExtendedResponseDecorator resp = (ExtendedResponseDecorator)factory.newResponse(berValue);
                    javax.naming.ldap.ExtendedResponse jndiResponse = new javax.naming.ldap.ExtendedResponse(){
                        private static final long serialVersionUID = -7686354122066100703L;

                        public String getID() {
                            return oid;
                        }

                        public byte[] getEncodedValue() {
                            return resp.getResponseValue();
                        }
                    };
                    return jndiResponse;
                }
                catch (DecoderException e) {
                    NamingException ne = new NamingException("Unable to decode encoded response value: " + Strings.dumpBytes(berValue));
                    ne.setRootCause(e);
                    throw ne;
                }
            }
        };
        return jndiRequest;
    }

    @Override
    public <E extends ExtendedResponse> E newExtendedResponse(org.apache.directory.shared.ldap.model.message.ExtendedRequest<E> req, byte[] serializedResponse) throws DecoderException {
        ExtendedResponseDecorator<ExtendedResponseImpl> resp;
        ExtendedRequestFactory<?, ?> extendedRequestFactory = this.extReqFactories.get(req.getRequestName());
        if (extendedRequestFactory != null) {
            resp = (ExtendedResponseDecorator<ExtendedResponseImpl>)extendedRequestFactory.newResponse(serializedResponse);
        } else {
            resp = new ExtendedResponseDecorator<ExtendedResponseImpl>((LdapApiService)this, new ExtendedResponseImpl(req.getRequestName()));
            resp.setResponseValue(serializedResponse);
            resp.setResponseName(req.getRequestName());
        }
        resp.setMessageId(req.getMessageId());
        return (E)resp;
    }

    @Override
    public org.apache.directory.shared.ldap.model.message.ExtendedRequest<?> newExtendedRequest(String oid, byte[] value) {
        ExtendedRequestDecorator req = null;
        ExtendedRequestFactory<?, ?> extendedRequestFactory = this.extReqFactories.get(oid);
        if (extendedRequestFactory != null) {
            req = (ExtendedRequestDecorator)extendedRequestFactory.newRequest(value);
        } else {
            ExtendedRequestDecorator decorator = new ExtendedRequestDecorator((LdapApiService)this, new ExtendedRequestImpl());
            decorator.setRequestName(oid);
            decorator.setRequestValue(value);
            req = decorator;
        }
        return req;
    }

    @Override
    public ExtendedRequestDecorator<?, ?> decorate(org.apache.directory.shared.ldap.model.message.ExtendedRequest<?> decoratedMessage) {
        ExtendedRequestDecorator<Object, Object> req = null;
        ExtendedRequestFactory<?, ?> extendedRequestFactory = this.extReqFactories.get(decoratedMessage.getRequestName());
        req = extendedRequestFactory != null ? extendedRequestFactory.decorate(decoratedMessage) : new ExtendedRequestDecorator((LdapApiService)this, decoratedMessage);
        return req;
    }

    @Override
    public ExtendedResponseDecorator<?> decorate(ExtendedResponse decoratedMessage) {
        ExtendedResponseDecorator<Object> resp = null;
        UnsolicitedResponseFactory<?> unsolicitedResponseFactory = this.unsolicitedFactories.get(decoratedMessage.getResponseName());
        ExtendedRequestFactory<?, ?> extendedRequestFactory = this.extReqFactories.get(decoratedMessage.getResponseName());
        resp = extendedRequestFactory != null ? extendedRequestFactory.decorate(decoratedMessage) : (unsolicitedResponseFactory != null ? unsolicitedResponseFactory.decorate(decoratedMessage) : new ExtendedResponseDecorator<ExtendedResponse>((LdapApiService)this, decoratedMessage));
        return resp;
    }

    @Override
    public boolean isExtendedOperationRegistered(String oid) {
        return this.extReqFactories.containsKey(oid) || this.unsolicitedFactories.containsKey(oid);
    }
}

