/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.jndi;

import java.util.NoSuchElementException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.SearchResult;
import org.apache.directory.server.core.entry.ServerEntryUtils;
import org.apache.directory.server.core.filtering.EntryFilteringCursor;
import org.apache.directory.shared.ldap.model.entry.Entry;
import org.apache.directory.shared.ldap.util.JndiUtils;

public class NamingEnumerationAdapter
implements NamingEnumeration<SearchResult> {
    private final EntryFilteringCursor cursor;
    private boolean available = false;

    public NamingEnumerationAdapter(EntryFilteringCursor cursor) throws NamingException {
        this.cursor = cursor;
        try {
            if (!cursor.first()) {
                cursor.close();
                this.available = false;
            } else {
                this.available = true;
            }
        }
        catch (Exception e) {
            JndiUtils.wrap(e);
        }
    }

    @Override
    public void close() throws NamingException {
        try {
            this.cursor.close();
            this.available = false;
        }
        catch (Exception e) {
            JndiUtils.wrap(e);
        }
    }

    @Override
    public boolean hasMore() throws NamingException {
        return this.available;
    }

    @Override
    public SearchResult next() throws NamingException {
        Entry entry = null;
        try {
            entry = (Entry)this.cursor.get();
            if (this.cursor.next()) {
                this.available = true;
            } else {
                this.available = false;
                this.cursor.close();
            }
        }
        catch (Exception e) {
            JndiUtils.wrap(e);
        }
        SearchResult result = new SearchResult(entry.getDn().getName(), (Object)null, ServerEntryUtils.toBasicAttributes(entry));
        result.setRelative(false);
        return result;
    }

    @Override
    public boolean hasMoreElements() {
        return this.available;
    }

    @Override
    public SearchResult nextElement() {
        try {
            return this.next();
        }
        catch (NamingException e) {
            throw new NoSuchElementException(e.getLocalizedMessage());
        }
    }
}

