/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.authz;

import java.util.HashSet;
import java.util.Set;
import org.apache.directory.server.core.CoreSession;
import org.apache.directory.server.core.DefaultCoreSession;
import org.apache.directory.server.core.DirectoryService;
import org.apache.directory.server.core.LdapPrincipal;
import org.apache.directory.server.core.filtering.EntryFilter;
import org.apache.directory.server.core.filtering.EntryFilteringCursor;
import org.apache.directory.server.core.interceptor.BaseInterceptor;
import org.apache.directory.server.core.interceptor.NextInterceptor;
import org.apache.directory.server.core.interceptor.context.DeleteOperationContext;
import org.apache.directory.server.core.interceptor.context.ListOperationContext;
import org.apache.directory.server.core.interceptor.context.LookupOperationContext;
import org.apache.directory.server.core.interceptor.context.ModifyOperationContext;
import org.apache.directory.server.core.interceptor.context.MoveAndRenameOperationContext;
import org.apache.directory.server.core.interceptor.context.MoveOperationContext;
import org.apache.directory.server.core.interceptor.context.OperationContext;
import org.apache.directory.server.core.interceptor.context.RenameOperationContext;
import org.apache.directory.server.core.interceptor.context.SearchOperationContext;
import org.apache.directory.server.core.interceptor.context.SearchingOperationContext;
import org.apache.directory.server.core.partition.PartitionNexus;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.shared.ldap.model.constants.AuthenticationLevel;
import org.apache.directory.shared.ldap.model.entry.Attribute;
import org.apache.directory.shared.ldap.model.entry.Entry;
import org.apache.directory.shared.ldap.model.entry.Value;
import org.apache.directory.shared.ldap.model.exception.LdapException;
import org.apache.directory.shared.ldap.model.exception.LdapNoPermissionException;
import org.apache.directory.shared.ldap.model.name.Dn;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultAuthorizationInterceptor
extends BaseInterceptor {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultAuthorizationInterceptor.class);
    private static Dn ADMIN_SYSTEM_DN;
    private static Dn GROUP_BASE_DN;
    private static Dn ADMIN_GROUP_DN;
    private Set<String> administrators = new HashSet<String>(2);
    private PartitionNexus nexus;

    @Override
    public void init(DirectoryService directoryService) throws LdapException {
        super.init(directoryService);
        this.nexus = directoryService.getPartitionNexus();
        ADMIN_SYSTEM_DN = directoryService.getDnFactory().create("uid=admin,ou=system");
        GROUP_BASE_DN = directoryService.getDnFactory().create("ou=groups,ou=system");
        ADMIN_GROUP_DN = directoryService.getDnFactory().create("cn=Administrators,ou=groups,ou=system");
        this.loadAdministrators(directoryService);
    }

    private void loadAdministrators(DirectoryService directoryService) throws LdapException {
        HashSet<String> newAdministrators = new HashSet<String>(2);
        Dn adminDn = directoryService.getDnFactory().create("0.9.2342.19200300.100.1.1=admin,2.5.4.11=system");
        DefaultCoreSession adminSession = new DefaultCoreSession(new LdapPrincipal(this.schemaManager, adminDn, AuthenticationLevel.STRONG), directoryService);
        Entry adminGroup = this.nexus.lookup(new LookupOperationContext((CoreSession)adminSession, ADMIN_GROUP_DN));
        if (adminGroup == null) {
            return;
        }
        Attribute uniqueMember = adminGroup.get(UNIQUE_MEMBER_AT);
        for (Value value : uniqueMember) {
            Dn memberDn = directoryService.getDnFactory().create(value.getString());
            newAdministrators.add(memberDn.getNormName());
        }
        this.administrators = newAdministrators;
    }

    @Override
    public void delete(NextInterceptor nextInterceptor, DeleteOperationContext deleteContext) throws LdapException {
        if (deleteContext.getSession().getDirectoryService().isAccessControlEnabled()) {
            nextInterceptor.delete(deleteContext);
            return;
        }
        Dn dn = deleteContext.getDn();
        if (dn.isEmpty()) {
            String msg = I18n.err(I18n.ERR_12, new Object[0]);
            LOG.error(msg);
            throw new LdapNoPermissionException(msg);
        }
        if (dn.equals(ADMIN_GROUP_DN)) {
            String msg = I18n.err(I18n.ERR_13, new Object[0]);
            LOG.error(msg);
            throw new LdapNoPermissionException(msg);
        }
        Dn principalDn = DefaultAuthorizationInterceptor.getPrincipal().getDn();
        if (dn.equals(ADMIN_SYSTEM_DN)) {
            String msg = I18n.err(I18n.ERR_14, principalDn.getName());
            LOG.error(msg);
            throw new LdapNoPermissionException(msg);
        }
        if (dn.size() > 2 && !this.isAnAdministrator(principalDn)) {
            if (dn.isDescendantOf(ADMIN_SYSTEM_DN)) {
                String msg = I18n.err(I18n.ERR_15, principalDn.getName(), dn.getName());
                LOG.error(msg);
                throw new LdapNoPermissionException(msg);
            }
            if (dn.isDescendantOf(GROUP_BASE_DN)) {
                String msg = I18n.err(I18n.ERR_16, principalDn.getName(), dn.getName());
                LOG.error(msg);
                throw new LdapNoPermissionException(msg);
            }
        }
        nextInterceptor.delete(deleteContext);
    }

    private boolean isTheAdministrator(Dn dn) {
        return dn.equals(ADMIN_SYSTEM_DN);
    }

    private boolean isAnAdministrator(Dn dn) {
        return this.isTheAdministrator(dn) || this.administrators.contains(dn.getNormName());
    }

    @Override
    public void modify(NextInterceptor nextInterceptor, ModifyOperationContext modifyContext) throws LdapException {
        if (!modifyContext.getSession().getDirectoryService().isAccessControlEnabled()) {
            Dn dn = modifyContext.getDn();
            this.protectModifyAlterations(dn);
            nextInterceptor.modify(modifyContext);
            if (dn.equals(ADMIN_GROUP_DN)) {
                this.loadAdministrators(modifyContext.getSession().getDirectoryService());
            }
        } else {
            nextInterceptor.modify(modifyContext);
        }
    }

    private void protectModifyAlterations(Dn dn) throws LdapException {
        Dn principalDn = DefaultAuthorizationInterceptor.getPrincipal().getDn();
        if (dn.isEmpty()) {
            String msg = I18n.err(I18n.ERR_17, new Object[0]);
            LOG.error(msg);
            throw new LdapNoPermissionException(msg);
        }
        if (!this.isAnAdministrator(principalDn)) {
            if (dn.equals(DefaultAuthorizationInterceptor.getPrincipal())) {
                return;
            }
            if (dn.equals(ADMIN_SYSTEM_DN)) {
                String msg = I18n.err(I18n.ERR_18, principalDn.getName());
                LOG.error(msg);
                throw new LdapNoPermissionException(msg);
            }
            if (dn.size() > 2) {
                if (dn.isDescendantOf(ADMIN_SYSTEM_DN)) {
                    String msg = I18n.err(I18n.ERR_19, principalDn.getName(), dn.getName());
                    LOG.error(msg);
                    throw new LdapNoPermissionException(msg);
                }
                if (dn.isDescendantOf(GROUP_BASE_DN)) {
                    String msg = I18n.err(I18n.ERR_20, principalDn.getName(), dn.getName());
                    LOG.error(msg);
                    throw new LdapNoPermissionException(msg);
                }
            }
        }
    }

    @Override
    public void rename(NextInterceptor nextInterceptor, RenameOperationContext renameContext) throws LdapException {
        if (!renameContext.getSession().getDirectoryService().isAccessControlEnabled()) {
            this.protectDnAlterations(renameContext.getDn());
        }
        nextInterceptor.rename(renameContext);
    }

    @Override
    public void move(NextInterceptor nextInterceptor, MoveOperationContext moveContext) throws LdapException {
        if (!moveContext.getSession().getDirectoryService().isAccessControlEnabled()) {
            this.protectDnAlterations(moveContext.getDn());
        }
        nextInterceptor.move(moveContext);
    }

    @Override
    public void moveAndRename(NextInterceptor nextInterceptor, MoveAndRenameOperationContext moveAndRenameContext) throws LdapException {
        if (!moveAndRenameContext.getSession().getDirectoryService().isAccessControlEnabled()) {
            this.protectDnAlterations(moveAndRenameContext.getDn());
        }
        nextInterceptor.moveAndRename(moveAndRenameContext);
    }

    private void protectDnAlterations(Dn dn) throws LdapException {
        Dn principalDn = DefaultAuthorizationInterceptor.getPrincipal().getDn();
        if (dn.isEmpty()) {
            String msg = I18n.err(I18n.ERR_234, new Object[0]);
            LOG.error(msg);
            throw new LdapNoPermissionException(msg);
        }
        if (dn.equals(ADMIN_GROUP_DN)) {
            String msg = I18n.err(I18n.ERR_21, new Object[0]);
            LOG.error(msg);
            throw new LdapNoPermissionException(msg);
        }
        if (this.isTheAdministrator(dn)) {
            String msg = I18n.err(I18n.ERR_22, principalDn.getName(), dn.getName());
            LOG.error(msg);
            throw new LdapNoPermissionException(msg);
        }
        if (dn.size() > 2 && dn.isDescendantOf(ADMIN_SYSTEM_DN) && !this.isAnAdministrator(principalDn)) {
            String msg = I18n.err(I18n.ERR_23, principalDn.getName(), dn.getName());
            LOG.error(msg);
            throw new LdapNoPermissionException(msg);
        }
        if (dn.size() > 2 && dn.isDescendantOf(GROUP_BASE_DN) && !this.isAnAdministrator(principalDn)) {
            String msg = I18n.err(I18n.ERR_24, principalDn.getName(), dn.getName());
            LOG.error(msg);
            throw new LdapNoPermissionException(msg);
        }
    }

    @Override
    public Entry lookup(NextInterceptor nextInterceptor, LookupOperationContext lookupContext) throws LdapException {
        CoreSession session = lookupContext.getSession();
        Entry entry = nextInterceptor.lookup(lookupContext);
        if (session.getDirectoryService().isAccessControlEnabled()) {
            return entry;
        }
        this.protectLookUp(session.getEffectivePrincipal().getDn(), lookupContext.getDn());
        return entry;
    }

    private void protectLookUp(Dn principalDn, Dn normalizedDn) throws LdapException {
        if (!this.isAnAdministrator(principalDn)) {
            if (normalizedDn.size() > 2) {
                if (normalizedDn.isDescendantOf(ADMIN_SYSTEM_DN)) {
                    if (normalizedDn.getNormName().equals(principalDn.getNormName())) {
                        return;
                    }
                    String msg = I18n.err(I18n.ERR_25, normalizedDn.getName(), principalDn.getName());
                    LOG.error(msg);
                    throw new LdapNoPermissionException(msg);
                }
                if (normalizedDn.isDescendantOf(GROUP_BASE_DN)) {
                    if (normalizedDn.equals(principalDn)) {
                        return;
                    }
                    String msg = I18n.err(I18n.ERR_26, normalizedDn.getName(), principalDn.getName());
                    LOG.error(msg);
                    throw new LdapNoPermissionException(msg);
                }
            }
            if (this.isTheAdministrator(normalizedDn)) {
                if (normalizedDn.getNormName().equals(principalDn.getNormName())) {
                    return;
                }
                String msg = I18n.err(I18n.ERR_27, principalDn.getName());
                LOG.error(msg);
                throw new LdapNoPermissionException(msg);
            }
        }
    }

    @Override
    public EntryFilteringCursor search(NextInterceptor nextInterceptor, SearchOperationContext searchContext) throws LdapException {
        EntryFilteringCursor cursor = nextInterceptor.search(searchContext);
        if (searchContext.getSession().getDirectoryService().isAccessControlEnabled()) {
            return cursor;
        }
        cursor.addEntryFilter(new DefaultAuthorizationSearchFilter());
        return cursor;
    }

    @Override
    public EntryFilteringCursor list(NextInterceptor nextInterceptor, ListOperationContext listContext) throws LdapException {
        EntryFilteringCursor cursor = nextInterceptor.list(listContext);
        if (listContext.getSession().getDirectoryService().isAccessControlEnabled()) {
            return cursor;
        }
        cursor.addEntryFilter(new DefaultAuthorizationSearchFilter());
        return cursor;
    }

    private boolean isSearchable(OperationContext opContext, Entry entry) throws Exception {
        Dn principalDn = opContext.getSession().getEffectivePrincipal().getDn();
        Dn dn = entry.getDn();
        if (!dn.isSchemaAware()) {
            dn.apply(opContext.getSession().getDirectoryService().getSchemaManager());
        }
        if (this.isAnAdministrator(principalDn)) {
            return true;
        }
        boolean isSelfRead = dn.equals(principalDn);
        if (isSelfRead) {
            return true;
        }
        if (dn.size() > 2 && (dn.isDescendantOf(ADMIN_SYSTEM_DN) || dn.isDescendantOf(GROUP_BASE_DN))) {
            return false;
        }
        return !this.isTheAdministrator(dn);
    }

    private class DefaultAuthorizationSearchFilter
    implements EntryFilter {
        private DefaultAuthorizationSearchFilter() {
        }

        @Override
        public boolean accept(SearchingOperationContext operation, Entry entry) throws Exception {
            return DefaultAuthorizationInterceptor.this.isSearchable(operation, entry);
        }
    }
}

