/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.authn;

import java.net.SocketAddress;
import org.apache.directory.server.core.LdapPrincipal;
import org.apache.directory.server.core.authn.AbstractAuthenticator;
import org.apache.directory.server.core.interceptor.context.BindOperationContext;
import org.apache.directory.shared.ldap.model.constants.AuthenticationLevel;
import org.apache.directory.shared.ldap.model.exception.LdapAuthenticationException;
import org.apache.mina.core.session.IoSession;

public class StrongAuthenticator
extends AbstractAuthenticator {
    public StrongAuthenticator() {
        super(AuthenticationLevel.STRONG);
    }

    @Override
    public LdapPrincipal authenticate(BindOperationContext bindContext) throws LdapAuthenticationException {
        LdapPrincipal principal = new LdapPrincipal(this.getDirectoryService().getSchemaManager(), bindContext.getDn(), AuthenticationLevel.STRONG);
        IoSession session = bindContext.getIoSession();
        if (session != null) {
            SocketAddress clientAddress = session.getRemoteAddress();
            principal.setClientAddress(clientAddress);
            SocketAddress serverAddress = session.getServiceAddress();
            principal.setServerAddress(serverAddress);
        }
        return principal;
    }
}

