/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.ldap.client.api;

import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.ldap.client.api.AbstractPoolableLdapConnectionFactory;
import org.apache.directory.ldap.client.api.DefaultLdapConnectionFactory;
import org.apache.directory.ldap.client.api.LdapConnection;
import org.apache.directory.ldap.client.api.LdapConnectionConfig;
import org.apache.directory.ldap.client.api.LdapConnectionFactory;
import org.apache.directory.ldap.client.api.MonitoringLdapConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidatingPoolableLdapConnectionFactory
extends AbstractPoolableLdapConnectionFactory {
    private static final Logger LOG = LoggerFactory.getLogger(ValidatingPoolableLdapConnectionFactory.class);

    public ValidatingPoolableLdapConnectionFactory(LdapConnectionConfig config) {
        this(new DefaultLdapConnectionFactory(config));
    }

    public ValidatingPoolableLdapConnectionFactory(LdapConnectionConfig config, Class<? extends LdapConnectionFactory> connectionFactoryClass) {
        this(ValidatingPoolableLdapConnectionFactory.newLdapConnectionFactory(config, connectionFactoryClass));
    }

    public ValidatingPoolableLdapConnectionFactory(LdapConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    @Override
    public void activateObject(LdapConnection connection) throws LdapException {
        LOG.debug("Activating {}", (Object)connection);
        super.activateObject(connection);
        ((MonitoringLdapConnection)connection).resetMonitors();
    }

    @Override
    public MonitoringLdapConnection makeObject() throws LdapException {
        LOG.debug("Creating a LDAP connection");
        return new MonitoringLdapConnection(this.connectionFactory.newLdapConnection());
    }

    @Override
    public void passivateObject(LdapConnection connection) throws LdapException {
        LOG.debug("Passivating {}", (Object)connection);
        if (!connection.isConnected() || !connection.isAuthenticated() || ((MonitoringLdapConnection)connection).bindCalled()) {
            LOG.debug("rebind due to bind on connection {}", (Object)connection);
            this.connectionFactory.bindConnection(connection);
        }
        if (((MonitoringLdapConnection)connection).startTlsCalled()) {
            LOG.debug("unbind/rebind due to startTls on {}", (Object)connection);
            connection.unBind();
            this.connectionFactory.bindConnection(connection);
        }
        this.connectionFactory.configureConnection(connection);
    }
}

