/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.integration.http;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Set;
import java.util.UUID;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.server.bridge.http.HttpDirectoryService;
import org.apache.directory.server.core.api.DirectoryService;
import org.apache.directory.server.core.security.TlsKeyGenerator;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.integration.http.WebApp;
import org.apache.directory.server.protocol.shared.transport.TcpTransport;
import org.bouncycastle.jce.provider.X509CertParser;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.handler.ContextHandler;
import org.mortbay.jetty.nio.SelectChannelConnector;
import org.mortbay.jetty.security.SslSocketConnector;
import org.mortbay.jetty.webapp.WebAppContext;
import org.mortbay.xml.XmlConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpServer {
    private Server jetty;
    private String confFile;
    private Set<WebApp> webApps;
    private TcpTransport httpTransport = null;
    private TcpTransport httpsTransport = null;
    public static final String HTTP_TRANSPORT_ID = "http";
    public static final String HTTPS_TRANSPORT_ID = "https";
    private boolean configured = false;
    private static final Logger LOG = LoggerFactory.getLogger(HttpServer.class);
    private DirectoryService dirService;

    public void start(DirectoryService dirService) throws Exception {
        this.dirService = dirService;
        XmlConfiguration jettyConf = null;
        if (this.confFile != null) {
            jettyConf = new XmlConfiguration(new FileInputStream(this.confFile));
            LOG.info("configuring jetty http server from the configuration file {}", (Object)this.confFile);
            try {
                this.jetty = new Server();
                jettyConf.configure(this.jetty);
                this.configured = true;
            }
            catch (Exception e) {
                LOG.error(I18n.err(I18n.ERR_120, new Object[0]));
                throw e;
            }
        } else {
            LOG.info("No configuration file set, looking for web apps");
            this.configureServerThroughCode();
        }
        if (this.configured) {
            Handler[] handlers;
            for (Handler h : handlers = this.jetty.getHandlers()) {
                if (!(h instanceof ContextHandler)) continue;
                ContextHandler ch = (ContextHandler)h;
                ch.setAttribute(HttpDirectoryService.KEY, new HttpDirectoryService(dirService));
            }
            LOG.info("starting jetty http server");
            this.jetty.start();
        } else {
            this.jetty = null;
            LOG.warn("Error while configuring the http server, skipping the http server startup");
        }
    }

    private void configureServerThroughCode() {
        try {
            this.jetty = new Server();
            if (this.httpTransport != null) {
                SelectChannelConnector httpConnector = new SelectChannelConnector();
                httpConnector.setPort(this.httpTransport.getPort());
                httpConnector.setHost(this.httpTransport.getAddress());
                this.jetty.addConnector(httpConnector);
            }
            if (this.httpsTransport != null) {
                Dn adminDn = this.dirService.getDnFactory().create("uid=admin,ou=system");
                Entry adminEntry = this.dirService.getAdminSession().lookup(adminDn, "*", "+");
                File confDir = this.dirService.getInstanceLayout().getConfDirectory();
                File ksFile = new File(confDir, "httpserver.generated.ks");
                String password = UUID.randomUUID().toString();
                KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
                ks.load(null, null);
                X509CertParser parser = new X509CertParser();
                parser.engineInit(new ByteArrayInputStream(adminEntry.get("userCertificate").getBytes()));
                X509Certificate cert = (X509Certificate)parser.engineRead();
                ks.setCertificateEntry("cert", cert);
                KeyPair keyPair = TlsKeyGenerator.getKeyPair(adminEntry);
                ks.setKeyEntry("privatekey", keyPair.getPrivate(), password.toCharArray(), new Certificate[]{cert});
                try (FileOutputStream stream = new FileOutputStream(ksFile);){
                    ks.store(stream, password.toCharArray());
                }
                SslSocketConnector httpsConnector = new SslSocketConnector();
                httpsConnector.setPort(this.httpsTransport.getPort());
                httpsConnector.setHost(this.httpsTransport.getAddress());
                httpsConnector.setKeystoreType(ks.getType());
                httpsConnector.setKeystore(ksFile.getAbsolutePath());
                httpsConnector.setPassword(password);
                httpsConnector.setKeyPassword(password);
                this.jetty.addConnector(httpsConnector);
            }
            ArrayList<WebAppContext> handlers = new ArrayList<WebAppContext>();
            for (WebApp w : this.webApps) {
                WebAppContext webapp = new WebAppContext();
                webapp.setWar(w.getWarFile());
                webapp.setContextPath(w.getContextPath());
                handlers.add(webapp);
                webapp.setParentLoaderPriority(true);
            }
            File webAppDir = new File(this.dirService.getInstanceLayout().getInstanceDirectory(), "webapps");
            FilenameFilter webAppFilter = new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.endsWith(".war");
                }
            };
            if (webAppDir.exists()) {
                File[] appList;
                for (File app : appList = webAppDir.listFiles(webAppFilter)) {
                    WebAppContext webapp = new WebAppContext();
                    webapp.setWar(app.getAbsolutePath());
                    String ctxName = app.getName();
                    int pos = ctxName.indexOf(46);
                    if (pos > 0) {
                        ctxName = ctxName.substring(0, pos);
                    }
                    webapp.setContextPath("/" + ctxName);
                    handlers.add(webapp);
                    webapp.setParentLoaderPriority(true);
                }
            }
            this.jetty.setHandlers(handlers.toArray(new Handler[handlers.size()]));
            this.configured = true;
        }
        catch (Exception e) {
            LOG.error(I18n.err(I18n.ERR_121, new Object[0]), e);
        }
    }

    public void stop() throws Exception {
        if (this.jetty != null && this.jetty.isStarted()) {
            LOG.info("stopping jetty http server");
            this.jetty.stop();
        }
    }

    public void setConfFile(String confFile) {
        this.confFile = confFile;
    }

    public Set<WebApp> getWebApps() {
        return this.webApps;
    }

    public void setWebApps(Set<WebApp> webapps) {
        this.webApps = webapps;
    }

    public TcpTransport getHttpTransport() {
        return this.httpTransport;
    }

    public void setHttpTransport(TcpTransport httpTransport) {
        this.httpTransport = httpTransport;
    }

    public TcpTransport getHttpsTransport() {
        return this.httpsTransport;
    }

    public void setHttpsTransport(TcpTransport httpsTransport) {
        this.httpsTransport = httpsTransport;
    }
}

