/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.schema.syntaxCheckers;

import org.apache.directory.api.ldap.model.schema.SyntaxChecker;
import org.apache.directory.api.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TelexNumberSyntaxChecker
extends SyntaxChecker {
    private static final Logger LOG = LoggerFactory.getLogger(TelexNumberSyntaxChecker.class);

    public TelexNumberSyntaxChecker() {
        super("1.3.6.1.4.1.1466.115.121.1.52");
    }

    @Override
    public boolean isValidSyntax(Object value) {
        String strValue = null;
        if (value == null) {
            LOG.debug("Syntax invalid for 'null'");
            return false;
        }
        strValue = value instanceof String ? (String)value : (value instanceof byte[] ? Strings.utf8ToString((byte[])value) : value.toString());
        if (strValue.length() == 0) {
            LOG.debug("Syntax invalid for '{}'", value);
            return false;
        }
        int dollar = strValue.indexOf(36);
        if (dollar <= 0) {
            LOG.debug("Syntax invalid for '{}'", value);
            return false;
        }
        String actualNumber = strValue.substring(0, dollar);
        if (actualNumber.length() == 0) {
            LOG.debug("Syntax invalid for '{}'", value);
            return false;
        }
        if (!Strings.isPrintableString(actualNumber)) {
            LOG.debug("Syntax invalid for '{}'", value);
            return false;
        }
        int dollar2 = strValue.indexOf(36, dollar + 1);
        if (dollar2 == -1) {
            LOG.debug("Syntax invalid for '{}'", value);
            return false;
        }
        String countryCode = strValue.substring(dollar + 1, dollar2);
        if (countryCode.length() == 0) {
            LOG.debug("Syntax invalid for '{}'", value);
            return false;
        }
        if (!Strings.isPrintableString(countryCode)) {
            LOG.debug("Syntax invalid for '{}'", value);
            return false;
        }
        if (dollar2 + 1 == strValue.length()) {
            LOG.debug("Syntax invalid for '{}'", value);
            return false;
        }
        String answerBack = strValue.substring(dollar2 + 1);
        if (!Strings.isPrintableString(answerBack)) {
            LOG.debug("Syntax invalid for '{}'", value);
            return false;
        }
        boolean result = Strings.isPrintableString(answerBack);
        if (result) {
            LOG.debug("Syntax valid for '{}'", value);
        } else {
            LOG.debug("Syntax invalid for '{}'", value);
        }
        return result;
    }
}

