/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.extras.controls.syncrepl_impl;

import org.apache.directory.shared.asn1.DecoderException;
import org.apache.directory.shared.asn1.ber.grammar.AbstractGrammar;
import org.apache.directory.shared.asn1.ber.grammar.Grammar;
import org.apache.directory.shared.asn1.ber.grammar.GrammarAction;
import org.apache.directory.shared.asn1.ber.grammar.GrammarTransition;
import org.apache.directory.shared.asn1.ber.tlv.BooleanDecoder;
import org.apache.directory.shared.asn1.ber.tlv.BooleanDecoderException;
import org.apache.directory.shared.asn1.ber.tlv.IntegerDecoder;
import org.apache.directory.shared.asn1.ber.tlv.IntegerDecoderException;
import org.apache.directory.shared.asn1.ber.tlv.UniversalTag;
import org.apache.directory.shared.asn1.ber.tlv.Value;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.extras.controls.SynchronizationModeEnum;
import org.apache.directory.shared.ldap.extras.controls.syncrepl_impl.SyncRequestValueContainer;
import org.apache.directory.shared.ldap.extras.controls.syncrepl_impl.SyncRequestValueStatesEnum;
import org.apache.directory.shared.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SyncRequestValueGrammar
extends AbstractGrammar {
    static final Logger LOG = LoggerFactory.getLogger(SyncRequestValueGrammar.class);
    static final boolean IS_DEBUG = LOG.isDebugEnabled();
    private static Grammar instance = new SyncRequestValueGrammar();

    private SyncRequestValueGrammar() {
        this.setName(SyncRequestValueGrammar.class.getName());
        this.transitions = new GrammarTransition[SyncRequestValueStatesEnum.LAST_SYNC_REQUEST_VALUE_STATE.ordinal()][256];
        this.transitions[SyncRequestValueStatesEnum.START_STATE.ordinal()][UniversalTag.SEQUENCE.getValue()] = new GrammarTransition(SyncRequestValueStatesEnum.START_STATE, SyncRequestValueStatesEnum.SYNC_REQUEST_VALUE_SEQUENCE_STATE, UniversalTag.SEQUENCE.getValue(), null);
        this.transitions[SyncRequestValueStatesEnum.SYNC_REQUEST_VALUE_SEQUENCE_STATE.ordinal()][UniversalTag.ENUMERATED.getValue()] = new GrammarTransition<SyncRequestValueContainer>(SyncRequestValueStatesEnum.SYNC_REQUEST_VALUE_SEQUENCE_STATE, SyncRequestValueStatesEnum.MODE_STATE, UniversalTag.ENUMERATED.getValue(), new GrammarAction<SyncRequestValueContainer>("Set SyncRequestValueControl mode"){

            @Override
            public void action(SyncRequestValueContainer container) throws DecoderException {
                Value value = container.getCurrentTLV().getValue();
                try {
                    int mode = IntegerDecoder.parse(value, SynchronizationModeEnum.UNUSED.getValue(), SynchronizationModeEnum.REFRESH_AND_PERSIST.getValue());
                    SynchronizationModeEnum modeEnum = SynchronizationModeEnum.getSyncMode(mode);
                    if (IS_DEBUG) {
                        LOG.debug("Mode = " + (Object)((Object)modeEnum));
                    }
                    container.getSyncRequestValueControl().setMode(modeEnum);
                    container.setGrammarEndAllowed(true);
                }
                catch (IntegerDecoderException e) {
                    String msg = I18n.err(I18n.ERR_04028, new Object[0]);
                    LOG.error(msg, e);
                    throw new DecoderException(msg);
                }
            }
        });
        this.transitions[SyncRequestValueStatesEnum.MODE_STATE.ordinal()][UniversalTag.OCTET_STRING.getValue()] = new GrammarTransition<SyncRequestValueContainer>(SyncRequestValueStatesEnum.MODE_STATE, SyncRequestValueStatesEnum.COOKIE_STATE, UniversalTag.OCTET_STRING.getValue(), new GrammarAction<SyncRequestValueContainer>("Set SyncRequestValueControl cookie"){

            @Override
            public void action(SyncRequestValueContainer container) throws DecoderException {
                Value value = container.getCurrentTLV().getValue();
                byte[] cookie = value.getData();
                if (IS_DEBUG) {
                    LOG.debug("cookie = " + Strings.dumpBytes(cookie));
                }
                container.getSyncRequestValueControl().setCookie(cookie);
                container.setGrammarEndAllowed(true);
            }
        });
        this.transitions[SyncRequestValueStatesEnum.MODE_STATE.ordinal()][UniversalTag.BOOLEAN.getValue()] = new GrammarTransition<SyncRequestValueContainer>(SyncRequestValueStatesEnum.MODE_STATE, SyncRequestValueStatesEnum.RELOAD_HINT_STATE, UniversalTag.BOOLEAN.getValue(), new GrammarAction<SyncRequestValueContainer>("Set SyncRequestValueControl reloadHint flag"){

            @Override
            public void action(SyncRequestValueContainer container) throws DecoderException {
                Value value = container.getCurrentTLV().getValue();
                try {
                    boolean reloadHint = BooleanDecoder.parse(value);
                    if (IS_DEBUG) {
                        LOG.debug("reloadHint = " + reloadHint);
                    }
                    container.getSyncRequestValueControl().setReloadHint(reloadHint);
                    container.setGrammarEndAllowed(true);
                }
                catch (BooleanDecoderException e) {
                    String msg = I18n.err(I18n.ERR_04029, new Object[0]);
                    LOG.error(msg, e);
                    throw new DecoderException(msg);
                }
            }
        });
        this.transitions[SyncRequestValueStatesEnum.COOKIE_STATE.ordinal()][UniversalTag.BOOLEAN.getValue()] = new GrammarTransition<SyncRequestValueContainer>(SyncRequestValueStatesEnum.COOKIE_STATE, SyncRequestValueStatesEnum.RELOAD_HINT_STATE, UniversalTag.BOOLEAN.getValue(), new GrammarAction<SyncRequestValueContainer>("Set SyncRequestValueControl reloadHint flag"){

            @Override
            public void action(SyncRequestValueContainer container) throws DecoderException {
                Value value = container.getCurrentTLV().getValue();
                try {
                    boolean reloadHint = BooleanDecoder.parse(value);
                    if (IS_DEBUG) {
                        LOG.debug("reloadHint = " + reloadHint);
                    }
                    container.getSyncRequestValueControl().setReloadHint(reloadHint);
                    container.setGrammarEndAllowed(true);
                }
                catch (BooleanDecoderException e) {
                    String msg = I18n.err(I18n.ERR_04029, new Object[0]);
                    LOG.error(msg, e);
                    throw new DecoderException(msg);
                }
            }
        });
    }

    public static Grammar getInstance() {
        return instance;
    }
}

