/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.extras.controls.ppolicy;

import java.nio.ByteBuffer;
import org.apache.directory.shared.asn1.Asn1Object;
import org.apache.directory.shared.asn1.DecoderException;
import org.apache.directory.shared.asn1.EncoderException;
import org.apache.directory.shared.asn1.ber.Asn1Decoder;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.asn1.ber.tlv.UniversalTag;
import org.apache.directory.shared.asn1.ber.tlv.Value;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.codec.api.ControlDecorator;
import org.apache.directory.shared.ldap.codec.api.LdapApiService;
import org.apache.directory.shared.ldap.extras.controls.ppolicy.PasswordPolicy;
import org.apache.directory.shared.ldap.extras.controls.ppolicy.PasswordPolicyContainer;
import org.apache.directory.shared.ldap.extras.controls.ppolicy.PasswordPolicyImpl;
import org.apache.directory.shared.ldap.extras.controls.ppolicy.PasswordPolicyResponse;
import org.apache.directory.shared.ldap.extras.controls.ppolicy.PasswordPolicyTags;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PasswordPolicyDecorator
extends ControlDecorator<PasswordPolicy>
implements PasswordPolicy {
    private static final Asn1Decoder decoder = new Asn1Decoder();
    private int valueLength = 0;
    private int ppolicySeqLength = 0;
    private int warningLength = 0;
    private int timeBeforeExpirationTagLength;
    private int graceAuthNsRemainingTagLength;

    public PasswordPolicyDecorator(LdapApiService codec) {
        super(codec, new PasswordPolicyImpl());
    }

    public PasswordPolicyDecorator(LdapApiService codec, boolean hasResponse) {
        super(codec, new PasswordPolicyImpl(hasResponse));
    }

    public PasswordPolicyDecorator(LdapApiService codec, PasswordPolicy policy) {
        super(codec, policy);
    }

    @Override
    public void setValue(byte[] value) {
        if (value == null || value.length == 0) {
            this.setResponse(null);
        }
        if (value != null && !this.hasResponse()) {
            this.setResponse(true);
        }
        super.setValue(value);
    }

    @Override
    public int computeLength() {
        this.valueLength = 0;
        this.ppolicySeqLength = 0;
        this.warningLength = 0;
        this.timeBeforeExpirationTagLength = 0;
        this.graceAuthNsRemainingTagLength = 0;
        if (!this.hasResponse()) {
            return 0;
        }
        if (this.getResponse().getTimeBeforeExpiration() >= 0) {
            this.timeBeforeExpirationTagLength = TLV.getNbBytes(this.getResponse().getTimeBeforeExpiration());
            this.warningLength = 1 + TLV.getNbBytes(this.timeBeforeExpirationTagLength) + this.timeBeforeExpirationTagLength;
        } else if (this.getResponse().getGraceAuthNsRemaining() >= 0) {
            this.graceAuthNsRemainingTagLength = TLV.getNbBytes(this.getResponse().getGraceAuthNsRemaining());
            this.warningLength = 1 + TLV.getNbBytes(this.graceAuthNsRemainingTagLength) + this.graceAuthNsRemainingTagLength;
        }
        if (this.warningLength != 0) {
            this.ppolicySeqLength = 1 + TLV.getNbBytes(this.warningLength) + this.warningLength;
        }
        if (this.getResponse().getPasswordPolicyError() != null) {
            this.ppolicySeqLength += 3;
        }
        if (this.ppolicySeqLength > 0) {
            this.valueLength = 1 + TLV.getNbBytes(this.ppolicySeqLength) + this.ppolicySeqLength;
        }
        return this.valueLength;
    }

    @Override
    public ByteBuffer encode(ByteBuffer buffer) throws EncoderException {
        if (!this.hasResponse()) {
            return buffer;
        }
        if (buffer == null) {
            throw new EncoderException(I18n.err(I18n.ERR_04023, new Object[0]));
        }
        if (this.getResponse().getTimeBeforeExpiration() < 0 && this.getResponse().getGraceAuthNsRemaining() < 0 && this.getResponse().getPasswordPolicyError() == null) {
            return buffer;
        }
        buffer.put(UniversalTag.SEQUENCE.getValue());
        buffer.put(TLV.getBytes(this.ppolicySeqLength));
        if (this.warningLength > 0) {
            buffer.put((byte)PasswordPolicyTags.PPOLICY_WARNING_TAG.getValue());
            buffer.put(TLV.getBytes(this.warningLength));
            if (this.getResponse().getTimeBeforeExpiration() >= 0) {
                buffer.put((byte)PasswordPolicyTags.TIME_BEFORE_EXPIRATION_TAG.getValue());
                buffer.put(TLV.getBytes(this.timeBeforeExpirationTagLength));
                buffer.put(Value.getBytes(this.getResponse().getTimeBeforeExpiration()));
            } else if (this.getResponse().getGraceAuthNsRemaining() >= 0) {
                buffer.put((byte)PasswordPolicyTags.GRACE_AUTHNS_REMAINING_TAG.getValue());
                buffer.put(TLV.getBytes(this.graceAuthNsRemainingTagLength));
                buffer.put(Value.getBytes(this.getResponse().getGraceAuthNsRemaining()));
            }
        }
        if (this.getResponse().getPasswordPolicyError() != null) {
            buffer.put((byte)PasswordPolicyTags.PPOLICY_ERROR_TAG.getValue());
            buffer.put((byte)1);
            buffer.put(Value.getBytes(this.getResponse().getPasswordPolicyError().getValue()));
        }
        return buffer;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("  PasswordPolicyResponse control :\n");
        sb.append("   oid          : '").append(this.getOid()).append('\n');
        if (this.hasResponse() && this.getResponse().getTimeBeforeExpiration() >= 0) {
            sb.append("   timeBeforeExpiration          : '").append(this.getResponse().getTimeBeforeExpiration()).append('\n');
        } else if (this.hasResponse() && this.getResponse().getGraceAuthNsRemaining() >= 0) {
            sb.append("   graceAuthNsRemaining          : '").append(this.getResponse().getGraceAuthNsRemaining()).append('\n');
        }
        if (this.hasResponse() && this.getResponse().getPasswordPolicyError() != null) {
            sb.append("   ppolicyError          : '").append(this.getResponse().getPasswordPolicyError().toString()).append('\n');
        }
        return sb.toString();
    }

    @Override
    public Asn1Object decode(byte[] controlBytes) throws DecoderException {
        if (!this.hasResponse()) {
            return this;
        }
        ByteBuffer bb = ByteBuffer.wrap(controlBytes);
        PasswordPolicyContainer container = new PasswordPolicyContainer(this.getCodecService(), this);
        decoder.decode(bb, container);
        return this;
    }

    @Override
    public boolean hasResponse() {
        return ((PasswordPolicy)this.getDecorated()).hasResponse();
    }

    @Override
    public void setResponse(PasswordPolicyResponse response) {
        ((PasswordPolicy)this.getDecorated()).setResponse(response);
    }

    @Override
    public PasswordPolicyResponse setResponse(boolean hasResponse) {
        return ((PasswordPolicy)this.getDecorated()).setResponse(hasResponse);
    }

    @Override
    public PasswordPolicyResponse getResponse() {
        return ((PasswordPolicy)this.getDecorated()).getResponse();
    }
}

