/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.xdbm.search.impl;

import java.util.Comparator;
import java.util.Iterator;
import org.apache.directory.server.xdbm.IndexEntry;
import org.apache.directory.server.xdbm.Store;
import org.apache.directory.server.xdbm.search.impl.LeafEvaluator;
import org.apache.directory.shared.ldap.model.entry.Attribute;
import org.apache.directory.shared.ldap.model.entry.Entry;
import org.apache.directory.shared.ldap.model.entry.Value;
import org.apache.directory.shared.ldap.model.filter.EqualityNode;
import org.apache.directory.shared.ldap.model.schema.AttributeType;
import org.apache.directory.shared.ldap.model.schema.MatchingRule;
import org.apache.directory.shared.ldap.model.schema.SchemaManager;
import org.apache.directory.shared.ldap.model.schema.comparators.ByteArrayComparator;
import org.apache.directory.shared.ldap.model.schema.comparators.StringComparator;
import org.apache.directory.shared.ldap.model.schema.normalizers.NoOpNormalizer;
import org.apache.directory.shared.util.Strings;

public class EqualityEvaluator<T, ID extends Comparable<ID>>
extends LeafEvaluator<T, ID> {
    private static final Comparator<byte[]> BINARY_COMPARATOR = new ByteArrayComparator(null);
    private static final Comparator<String> STRING_COMPARATOR = new StringComparator(null);

    public EqualityEvaluator(EqualityNode<T> node, Store<Entry, ID> db, SchemaManager schemaManager) throws Exception {
        super(node, db, schemaManager);
        if (db.hasIndexOn(this.attributeType)) {
            this.idx = db.getIndex(this.attributeType);
            this.normalizer = null;
            this.ldapComparator = null;
        } else {
            this.idx = null;
            MatchingRule mr = this.attributeType.getEquality();
            if (mr == null) {
                this.normalizer = new NoOpNormalizer(this.attributeType.getOid());
                this.ldapComparator = null;
            } else {
                this.normalizer = mr.getNormalizer();
                this.ldapComparator = mr.getLdapComparator();
            }
        }
    }

    @Override
    public EqualityNode<T> getExpression() {
        return (EqualityNode)this.node;
    }

    @Override
    public boolean evaluate(IndexEntry<?, Entry, ID> indexEntry) throws Exception {
        if (this.idx != null) {
            return this.idx.forward(this.node.getValue().getValue(), indexEntry.getId());
        }
        Entry entry = indexEntry.getObject();
        if (null == entry) {
            entry = this.db.lookup((Comparable)indexEntry.getId());
            indexEntry.setObject(entry);
        }
        return this.evaluateEntry(entry);
    }

    @Override
    public boolean evaluateEntry(Entry entry) throws Exception {
        Attribute attr = entry.get(this.attributeType);
        if (attr != null && this.evaluate(attr)) {
            return true;
        }
        if (this.schemaManager.getAttributeTypeRegistry().hasDescendants(this.attributeType)) {
            Iterator<AttributeType> descendants = this.schemaManager.getAttributeTypeRegistry().descendants(this.attributeType);
            while (descendants.hasNext()) {
                AttributeType descendant = descendants.next();
                attr = entry.get(descendant);
                if (attr == null || !this.evaluate(attr)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean evaluateId(ID id) throws Exception {
        if (this.idx != null) {
            return this.idx.reverse(id);
        }
        return this.evaluateEntry(this.db.lookup(id));
    }

    private boolean evaluate(Attribute attribute) throws Exception {
        for (Value value : attribute) {
            Object nodeValue;
            Object serverValue;
            if (value.isHumanReadable()) {
                serverValue = (String)value.getNormValue();
                nodeValue = null;
                nodeValue = this.node.getValue().isHumanReadable() ? (Object)((String)this.node.getValue().getNormValue()) : (Object)Strings.utf8ToString((byte[])this.node.getValue().getNormValue());
                if (!(this.ldapComparator != null ? this.ldapComparator.compare(serverValue, nodeValue) == 0 : STRING_COMPARATOR.compare((String)serverValue, (String)nodeValue) == 0)) continue;
                return true;
            }
            serverValue = (byte[])value.getNormValue();
            nodeValue = (byte[])this.node.getValue().getNormValue();
            if (!(this.ldapComparator != null ? this.ldapComparator.compare(serverValue, nodeValue) == 0 : BINARY_COMPARATOR.compare((byte[])serverValue, (byte[])nodeValue) == 0)) continue;
            return true;
        }
        return false;
    }
}

