/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.xdbm.search.impl;

import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.xdbm.AbstractIndexCursor;
import org.apache.directory.server.xdbm.Index;
import org.apache.directory.server.xdbm.IndexCursor;
import org.apache.directory.server.xdbm.IndexEntry;
import org.apache.directory.server.xdbm.Store;
import org.apache.directory.server.xdbm.search.impl.EqualityEvaluator;
import org.apache.directory.shared.ldap.model.cursor.InvalidCursorPositionException;
import org.apache.directory.shared.ldap.model.entry.Entry;
import org.apache.directory.shared.ldap.model.entry.Value;
import org.apache.directory.shared.ldap.model.filter.LeafNode;
import org.apache.directory.shared.ldap.model.filter.SimpleNode;
import org.apache.directory.shared.ldap.model.schema.AttributeType;

public class EqualityCursor<V, ID extends Comparable<ID>>
extends AbstractIndexCursor<V, Entry, ID> {
    private static final String UNSUPPORTED_MSG = I18n.err(I18n.ERR_714, new Object[0]);
    private final EqualityEvaluator equalityEvaluator;
    private final IndexCursor<V, Entry, ID> userIdxCursor;
    private final IndexCursor<String, Entry, ID> uuidIdxCursor;
    private boolean available = false;

    public EqualityCursor(Store<Entry, ID> db, EqualityEvaluator<V, ID> equalityEvaluator) throws Exception {
        this.equalityEvaluator = equalityEvaluator;
        AttributeType attributeType = ((LeafNode)equalityEvaluator.getExpression()).getAttributeType();
        Value value = ((SimpleNode)equalityEvaluator.getExpression()).getValue();
        if (db.hasIndexOn(attributeType)) {
            Index<?, Entry, ID> userIndex = db.getIndex(attributeType);
            this.userIdxCursor = userIndex.forwardCursor(value.getValue());
            this.uuidIdxCursor = null;
        } else {
            this.uuidIdxCursor = db.getEntryUuidIndex().forwardCursor();
            this.userIdxCursor = null;
        }
    }

    @Override
    public boolean available() {
        if (this.userIdxCursor != null) {
            return this.userIdxCursor.available();
        }
        return this.available;
    }

    @Override
    public void beforeValue(ID id, V value) throws Exception {
        this.checkNotClosed("beforeValue()");
        if (this.userIdxCursor == null) {
            throw new UnsupportedOperationException(UNSUPPORTED_MSG);
        }
        this.userIdxCursor.beforeValue(id, value);
    }

    @Override
    public void before(IndexEntry<V, Entry, ID> element) throws Exception {
        this.checkNotClosed("before()");
        if (this.userIdxCursor == null) {
            throw new UnsupportedOperationException(UNSUPPORTED_MSG);
        }
        this.userIdxCursor.before((Entry)((Object)element));
    }

    @Override
    public void afterValue(ID id, V key) throws Exception {
        this.checkNotClosed("afterValue()");
        if (this.userIdxCursor == null) {
            throw new UnsupportedOperationException(UNSUPPORTED_MSG);
        }
        this.userIdxCursor.afterValue(id, key);
    }

    @Override
    public void after(IndexEntry<V, Entry, ID> element) throws Exception {
        this.checkNotClosed("after()");
        if (this.userIdxCursor == null) {
            throw new UnsupportedOperationException(UNSUPPORTED_MSG);
        }
        this.userIdxCursor.after((Entry)((Object)element));
    }

    @Override
    public void beforeFirst() throws Exception {
        this.checkNotClosed("beforeFirst()");
        if (this.userIdxCursor != null) {
            this.userIdxCursor.beforeFirst();
        } else {
            this.uuidIdxCursor.beforeFirst();
        }
        this.available = false;
    }

    @Override
    public void afterLast() throws Exception {
        this.checkNotClosed("afterLast()");
        if (this.userIdxCursor != null) {
            this.userIdxCursor.afterLast();
        } else {
            this.uuidIdxCursor.afterLast();
        }
        this.available = false;
    }

    @Override
    public boolean first() throws Exception {
        this.beforeFirst();
        return this.next();
    }

    @Override
    public boolean last() throws Exception {
        this.afterLast();
        return this.previous();
    }

    @Override
    public boolean previous() throws Exception {
        if (this.userIdxCursor != null) {
            return this.userIdxCursor.previous();
        }
        while (this.uuidIdxCursor.previous()) {
            this.checkNotClosed("previous()");
            IndexEntry candidate = (IndexEntry)this.uuidIdxCursor.get();
            if (!this.equalityEvaluator.evaluate(candidate)) continue;
            this.available = true;
            return true;
        }
        this.available = false;
        return false;
    }

    @Override
    public boolean next() throws Exception {
        if (this.userIdxCursor != null) {
            return this.userIdxCursor.next();
        }
        while (this.uuidIdxCursor.next()) {
            this.checkNotClosed("next()");
            IndexEntry candidate = (IndexEntry)this.uuidIdxCursor.get();
            if (!this.equalityEvaluator.evaluate(candidate)) continue;
            this.available = true;
            return true;
        }
        this.available = false;
        return false;
    }

    @Override
    public IndexEntry<V, Entry, ID> get() throws Exception {
        this.checkNotClosed("get()");
        if (this.userIdxCursor != null) {
            return (IndexEntry)this.userIdxCursor.get();
        }
        if (this.available) {
            return (IndexEntry)this.uuidIdxCursor.get();
        }
        throw new InvalidCursorPositionException(I18n.err(I18n.ERR_708, new Object[0]));
    }

    @Override
    public void close() throws Exception {
        super.close();
        if (this.userIdxCursor != null) {
            this.userIdxCursor.close();
        } else {
            this.uuidIdxCursor.close();
        }
    }
}

