/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.xdbm;

import java.util.Iterator;
import org.apache.directory.server.xdbm.IndexCursor;
import org.apache.directory.server.xdbm.IndexEntry;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.model.cursor.ClosureMonitor;
import org.apache.directory.shared.ldap.model.cursor.CursorIterator;
import org.apache.directory.shared.ldap.model.cursor.DefaultClosureMonitor;

public abstract class AbstractIndexCursor<K, E, ID>
implements IndexCursor<K, E, ID> {
    private ClosureMonitor monitor = new DefaultClosureMonitor();

    @Override
    public final void setClosureMonitor(ClosureMonitor monitor) {
        if (monitor == null) {
            throw new IllegalArgumentException("monitor");
        }
        this.monitor = monitor;
    }

    protected final void checkNotClosed(String operation) throws Exception {
        this.monitor.checkNotClosed();
    }

    @Override
    public final boolean isClosed() {
        return this.monitor.isClosed();
    }

    @Override
    public void close() throws Exception {
        this.monitor.close();
    }

    @Override
    public void close(Exception cause) throws Exception {
        this.monitor.close(cause);
    }

    @Override
    public Iterator<IndexEntry<K, E, ID>> iterator() {
        return new CursorIterator<IndexEntry<K, E, ID>>(this);
    }

    @Override
    public boolean isAfterLast() throws Exception {
        throw new UnsupportedOperationException(I18n.err(I18n.ERR_02014_UNSUPPORTED_OPERATION, this.getClass().getName().concat(".").concat("isAfterLast()")));
    }

    @Override
    public boolean isBeforeFirst() throws Exception {
        throw new UnsupportedOperationException(I18n.err(I18n.ERR_02014_UNSUPPORTED_OPERATION, this.getClass().getName().concat(".").concat("isBeforeFirst()")));
    }

    @Override
    public boolean isFirst() throws Exception {
        throw new UnsupportedOperationException(I18n.err(I18n.ERR_02014_UNSUPPORTED_OPERATION, this.getClass().getName().concat(".").concat("isFirst()")));
    }

    @Override
    public boolean isLast() throws Exception {
        throw new UnsupportedOperationException(I18n.err(I18n.ERR_02014_UNSUPPORTED_OPERATION, this.getClass().getName().concat(".").concat("isLast()")));
    }
}

