/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.sp;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.directory.server.core.DirectoryService;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.shared.ldap.model.cursor.Cursor;
import org.apache.directory.shared.ldap.model.entry.Attribute;
import org.apache.directory.shared.ldap.model.entry.Entry;
import org.apache.directory.shared.ldap.model.entry.StringValue;
import org.apache.directory.shared.ldap.model.entry.Value;
import org.apache.directory.shared.ldap.model.exception.LdapException;
import org.apache.directory.shared.ldap.model.filter.AndNode;
import org.apache.directory.shared.ldap.model.filter.EqualityNode;
import org.apache.directory.shared.ldap.model.message.AliasDerefMode;
import org.apache.directory.shared.ldap.model.message.SearchScope;
import org.apache.directory.shared.ldap.model.name.Dn;
import org.apache.directory.shared.ldap.model.schema.AttributeType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LdapClassLoader
extends ClassLoader {
    private static final Logger LOG = LoggerFactory.getLogger(LdapClassLoader.class);
    public static final String DEFAULT_SEARCH_CONTEXTS_CONFIG = "cn=classLoaderDefaultSearchContext,ou=configuration,ou=system";
    private Dn defaultSearchDn;
    private DirectoryService directoryService;
    private AttributeType OBJECT_CLASS_AT;

    public LdapClassLoader(DirectoryService directoryService) throws LdapException {
        super(LdapClassLoader.class.getClassLoader());
        this.directoryService = directoryService;
        this.defaultSearchDn = directoryService.getDnFactory().create(DEFAULT_SEARCH_CONTEXTS_CONFIG);
        this.OBJECT_CLASS_AT = directoryService.getSchemaManager().getAttributeType("objectClass");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] findClassInDIT(List<Dn> searchContexts, String name) throws ClassNotFoundException {
        AndNode filter = new AndNode();
        AttributeType fqjcnAt = this.directoryService.getSchemaManager().getAttributeType("fullyQualifiedJavaClassName");
        filter.addNode(new EqualityNode<String>(fqjcnAt, new StringValue(name)));
        filter.addNode(new EqualityNode<String>(this.OBJECT_CLASS_AT, new StringValue("javaClass")));
        try {
            Iterator<Dn> i$ = searchContexts.iterator();
            while (i$.hasNext()) {
                Dn base = i$.next();
                Cursor cursor = null;
                try {
                    cursor = this.directoryService.getAdminSession().search(base, SearchScope.SUBTREE, filter, AliasDerefMode.DEREF_ALWAYS, null);
                    cursor.beforeFirst();
                    if (!cursor.next()) continue;
                    LOG.debug("Class {} found under {} search context.", (Object)name, (Object)base);
                    Entry classEntry = (Entry)cursor.get();
                    if (cursor.next()) {
                        Entry other = (Entry)cursor.get();
                        LOG.warn("More than one class found on classpath at locations: {} \n\tand {}", classEntry, (Object)other);
                    }
                    byte[] byArray = classEntry.get("javaClassByteCode").getBytes();
                    return byArray;
                }
                finally {
                    if (cursor == null) continue;
                    cursor.close();
                }
            }
            throw new ClassNotFoundException();
        }
        catch (Exception e) {
            LOG.error(I18n.err(I18n.ERR_69, name), e);
        }
        throw new ClassNotFoundException();
    }

    @Override
    public Class<?> findClass(String name) throws ClassNotFoundException {
        byte[] classBytes = null;
        try {
            Dn dn;
            Entry configEntry = null;
            try {
                configEntry = this.directoryService.getAdminSession().lookup(this.defaultSearchDn);
            }
            catch (LdapException e) {
                LOG.debug("No configuration data found for class loader default search contexts.");
            }
            if (configEntry != null) {
                ArrayList<Dn> searchContexts = new ArrayList<Dn>();
                Attribute attr = configEntry.get("classLoaderDefaultSearchContext");
                for (Value val : attr) {
                    dn = this.directoryService.getDnFactory().create(val.getString());
                    searchContexts.add(dn);
                }
                try {
                    classBytes = this.findClassInDIT(searchContexts, name);
                    LOG.debug("Class " + name + " found under default search contexts.");
                }
                catch (ClassNotFoundException e) {
                    LOG.debug("Class " + name + " could not be found under default search contexts.");
                }
            }
            if (classBytes == null) {
                ArrayList<Dn> namingContexts = new ArrayList<Dn>();
                Set<String> suffixes = this.directoryService.getPartitionNexus().listSuffixes();
                for (String suffix : suffixes) {
                    dn = this.directoryService.getDnFactory().create(suffix);
                    namingContexts.add(dn);
                }
                classBytes = this.findClassInDIT(namingContexts, name);
            }
        }
        catch (ClassNotFoundException e) {
            String msg = I18n.err(I18n.ERR_293, name);
            LOG.debug(msg);
            throw new ClassNotFoundException(msg);
        }
        catch (Exception e) {
            String msg = I18n.err(I18n.ERR_70, name);
            LOG.error(msg, e);
            throw new ClassNotFoundException(msg);
        }
        return this.defineClass(name, classBytes, 0, classBytes.length);
    }
}

