/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.schema;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.directory.server.core.filtering.EntryFilteringCursor;
import org.apache.directory.server.core.interceptor.context.EntryOperationContext;
import org.apache.directory.server.core.interceptor.context.ListOperationContext;
import org.apache.directory.server.core.interceptor.context.SearchOperationContext;
import org.apache.directory.server.core.normalization.FilterNormalizingVisitor;
import org.apache.directory.server.core.partition.Partition;
import org.apache.directory.server.core.schema.SchemaPartitionDao;
import org.apache.directory.server.core.schema.SchemaPartitionDaoImpl;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.shared.ldap.model.entry.Attribute;
import org.apache.directory.shared.ldap.model.entry.Entry;
import org.apache.directory.shared.ldap.model.exception.LdapException;
import org.apache.directory.shared.ldap.model.exception.LdapInvalidDnException;
import org.apache.directory.shared.ldap.model.exception.LdapOtherException;
import org.apache.directory.shared.ldap.model.filter.ExprNode;
import org.apache.directory.shared.ldap.model.filter.FilterParser;
import org.apache.directory.shared.ldap.model.message.SearchScope;
import org.apache.directory.shared.ldap.model.name.Dn;
import org.apache.directory.shared.ldap.model.schema.AttributeType;
import org.apache.directory.shared.ldap.model.schema.SchemaManager;
import org.apache.directory.shared.ldap.model.schema.normalizers.ConcreteNameComponentNormalizer;
import org.apache.directory.shared.ldap.model.schema.registries.AbstractSchemaLoader;
import org.apache.directory.shared.ldap.model.schema.registries.Registries;
import org.apache.directory.shared.ldap.model.schema.registries.Schema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PartitionSchemaLoader
extends AbstractSchemaLoader {
    private static final Logger LOG = LoggerFactory.getLogger(PartitionSchemaLoader.class);
    private final SchemaPartitionDao dao;
    private Partition partition;
    private SchemaManager schemaManager;
    private final AttributeType cnAT;

    public PartitionSchemaLoader(Partition partition, SchemaManager schemaManager) throws Exception {
        this.partition = partition;
        this.schemaManager = schemaManager;
        this.dao = new SchemaPartitionDaoImpl(this.partition, schemaManager);
        this.cnAT = schemaManager.getAttributeType("cn");
        this.initializeSchemas();
    }

    private void initializeSchemas() throws Exception {
        Dn dn = new Dn(this.schemaManager, "ou=schema");
        if (!this.partition.hasEntry(new EntryOperationContext(null, dn))) {
            return;
        }
        LOG.debug("Loading schemas");
        SearchOperationContext searchCtx = new SearchOperationContext(null);
        searchCtx.setDn(dn);
        searchCtx.setScope(SearchScope.ONELEVEL);
        ExprNode filter = FilterParser.parse(this.schemaManager, "(objectClass=metaSchema)");
        ConcreteNameComponentNormalizer ncn = new ConcreteNameComponentNormalizer(this.schemaManager);
        FilterNormalizingVisitor visitor = new FilterNormalizingVisitor(ncn, this.schemaManager);
        filter.accept(visitor);
        searchCtx.setFilter(filter);
        EntryFilteringCursor list = this.partition.search(searchCtx);
        while (list.next()) {
            Entry entry = (Entry)list.get();
            Schema schema = this.getSchema(entry);
            this.schemaMap.put(schema.getSchemaName(), schema);
        }
    }

    private Dn getBaseDN(String path, Schema schema) throws LdapInvalidDnException {
        Dn dn = new Dn(this.schemaManager, path, "cn=" + schema.getSchemaName(), "ou=schema");
        return dn;
    }

    public Set<String> listDependentSchemaNames(String schemaName) throws Exception {
        HashSet<String> dependees = new HashSet<String>();
        Set<Entry> results = this.dao.listSchemaDependents(schemaName);
        if (results.isEmpty()) {
            return dependees;
        }
        for (Entry sr : results) {
            Attribute cn = sr.get(this.cnAT);
            dependees.add(cn.getString());
        }
        return dependees;
    }

    public Set<String> listEnabledDependentSchemaNames(String schemaName) throws Exception {
        HashSet<String> dependees = new HashSet<String>();
        Set<Entry> results = this.dao.listEnabledSchemaDependents(schemaName);
        if (results.isEmpty()) {
            return dependees;
        }
        for (Entry sr : results) {
            Attribute cn = sr.get(this.cnAT);
            dependees.add(cn.getString());
        }
        return dependees;
    }

    public Map<String, Schema> getSchemas() throws Exception {
        return this.dao.getSchemas();
    }

    public Set<String> getSchemaNames() throws Exception {
        return this.dao.getSchemaNames();
    }

    @Override
    public Schema getSchema(String schemaName) {
        try {
            return this.dao.getSchema(schemaName);
        }
        catch (Exception e) {
            return null;
        }
    }

    public final void load(Schema schema, Registries targetRegistries, boolean isDepLoad) throws Exception {
        if (schema.isDisabled() && isDepLoad) {
            this.dao.enableSchema(schema.getSchemaName());
        }
        if (targetRegistries.isSchemaLoaded(schema.getSchemaName())) {
            LOG.debug("schema {} already seems to be loaded", (Object)schema.getSchemaName());
            return;
        }
        LOG.debug("loading {} schema ...", (Object)schema.getSchemaName());
        this.loadComparators(schema);
        this.loadNormalizers(schema);
        this.loadSyntaxCheckers(schema);
        this.loadSyntaxes(schema);
        this.loadMatchingRules(schema);
        this.loadAttributeTypes(schema);
        this.loadObjectClasses(schema);
        this.loadMatchingRuleUses(schema);
        this.loadDitContentRules(schema);
        this.loadNameForms(schema);
        this.loadDitStructureRules(schema);
        this.notifyListenerOrRegistries(schema, targetRegistries);
    }

    @Override
    public List<Entry> loadAttributeTypes(Schema ... schemas) throws LdapException {
        ArrayList<Entry> attributeTypeList = new ArrayList<Entry>();
        for (Schema schema : schemas) {
            Dn dn = this.getBaseDN("ou=attributetypes", schema);
            if (!this.partition.hasEntry(new EntryOperationContext(null, dn))) {
                return attributeTypeList;
            }
            LOG.debug("{} schema: loading attributeTypes", (Object)schema.getSchemaName());
            EntryFilteringCursor list = this.partition.list(new ListOperationContext(null, dn));
            try {
                while (list.next()) {
                    Entry result = (Entry)list.get();
                    attributeTypeList.add(result);
                }
            }
            catch (Exception e) {
                throw new LdapOtherException(e.getMessage(), e);
            }
        }
        return attributeTypeList;
    }

    @Override
    public List<Entry> loadComparators(Schema ... schemas) throws LdapException {
        ArrayList<Entry> comparatorList = new ArrayList<Entry>();
        if (schemas == null) {
            return comparatorList;
        }
        for (Schema schema : schemas) {
            Dn dn = this.getBaseDN("ou=comparators", schema);
            if (!this.partition.hasEntry(new EntryOperationContext(null, dn))) {
                return comparatorList;
            }
            LOG.debug("{} schema: loading comparators", (Object)schema.getSchemaName());
            EntryFilteringCursor list = this.partition.list(new ListOperationContext(null, dn));
            try {
                while (list.next()) {
                    Entry entry = (Entry)list.get();
                    comparatorList.add(entry);
                }
            }
            catch (Exception e) {
                throw new LdapOtherException(e.getMessage(), e);
            }
        }
        return comparatorList;
    }

    @Override
    public List<Entry> loadDitContentRules(Schema ... schemas) throws LdapException {
        LOG.error(I18n.err(I18n.ERR_86, new Object[0]));
        ArrayList<Entry> ditContentRuleList = new ArrayList<Entry>();
        return ditContentRuleList;
    }

    @Override
    public List<Entry> loadDitStructureRules(Schema ... schemas) throws LdapException {
        LOG.error(I18n.err(I18n.ERR_87, new Object[0]));
        ArrayList<Entry> ditStructureRuleList = new ArrayList<Entry>();
        return ditStructureRuleList;
    }

    @Override
    public List<Entry> loadMatchingRules(Schema ... schemas) throws LdapException {
        ArrayList<Entry> matchingRuleList = new ArrayList<Entry>();
        if (schemas == null) {
            return matchingRuleList;
        }
        for (Schema schema : schemas) {
            Dn dn = this.getBaseDN("ou=matchingrules", schema);
            if (!this.partition.hasEntry(new EntryOperationContext(null, dn))) {
                return matchingRuleList;
            }
            LOG.debug("{} schema: loading matchingRules", (Object)schema.getSchemaName());
            EntryFilteringCursor list = this.partition.list(new ListOperationContext(null, dn));
            try {
                while (list.next()) {
                    Entry entry = (Entry)list.get();
                    matchingRuleList.add(entry);
                }
            }
            catch (Exception e) {
                throw new LdapOtherException(e.getMessage(), e);
            }
        }
        return matchingRuleList;
    }

    @Override
    public List<Entry> loadMatchingRuleUses(Schema ... schemas) throws LdapException {
        LOG.error(I18n.err(I18n.ERR_88, new Object[0]));
        ArrayList<Entry> matchingRuleUsesList = new ArrayList<Entry>();
        return matchingRuleUsesList;
    }

    @Override
    public List<Entry> loadNameForms(Schema ... schemas) throws LdapException {
        LOG.error(I18n.err(I18n.ERR_89, new Object[0]));
        ArrayList<Entry> nameFormList = new ArrayList<Entry>();
        return nameFormList;
    }

    @Override
    public List<Entry> loadNormalizers(Schema ... schemas) throws LdapException {
        ArrayList<Entry> normalizerList = new ArrayList<Entry>();
        if (schemas == null) {
            return normalizerList;
        }
        for (Schema schema : schemas) {
            Dn dn = this.getBaseDN("ou=normalizers", schema);
            if (!this.partition.hasEntry(new EntryOperationContext(null, dn))) {
                return normalizerList;
            }
            LOG.debug("{} schema: loading normalizers", (Object)schema.getSchemaName());
            EntryFilteringCursor list = this.partition.list(new ListOperationContext(null, dn));
            try {
                while (list.next()) {
                    Entry entry = (Entry)list.get();
                    normalizerList.add(entry);
                }
            }
            catch (Exception e) {
                throw new LdapOtherException(e.getMessage(), e);
            }
        }
        return normalizerList;
    }

    @Override
    public List<Entry> loadObjectClasses(Schema ... schemas) throws LdapException {
        ArrayList<Entry> objectClassList = new ArrayList<Entry>();
        if (schemas == null) {
            return objectClassList;
        }
        for (Schema schema : schemas) {
            Dn dn = this.getBaseDN("ou=objectclasses", schema);
            if (!this.partition.hasEntry(new EntryOperationContext(null, dn))) {
                return objectClassList;
            }
            LOG.debug("{} schema: loading objectClasses", (Object)schema.getSchemaName());
            EntryFilteringCursor list = this.partition.list(new ListOperationContext(null, dn));
            try {
                while (list.next()) {
                    Entry entry = (Entry)list.get();
                    objectClassList.add(entry);
                }
            }
            catch (Exception e) {
                throw new LdapOtherException(e.getMessage(), e);
            }
        }
        return objectClassList;
    }

    @Override
    public List<Entry> loadSyntaxes(Schema ... schemas) throws LdapException {
        ArrayList<Entry> syntaxList = new ArrayList<Entry>();
        if (schemas == null) {
            return syntaxList;
        }
        for (Schema schema : schemas) {
            Dn dn = this.getBaseDN("ou=syntaxes", schema);
            if (!this.partition.hasEntry(new EntryOperationContext(null, dn))) {
                return syntaxList;
            }
            LOG.debug("{} schema: loading syntaxes", (Object)schema.getSchemaName());
            EntryFilteringCursor list = this.partition.list(new ListOperationContext(null, dn));
            try {
                while (list.next()) {
                    Entry entry = (Entry)list.get();
                    syntaxList.add(entry);
                }
            }
            catch (Exception e) {
                throw new LdapOtherException(e.getMessage(), e);
            }
        }
        return syntaxList;
    }

    @Override
    public List<Entry> loadSyntaxCheckers(Schema ... schemas) throws LdapException {
        ArrayList<Entry> syntaxCheckerList = new ArrayList<Entry>();
        if (schemas == null) {
            return syntaxCheckerList;
        }
        for (Schema schema : schemas) {
            Dn dn = this.getBaseDN("ou=syntaxcheckers", schema);
            if (!this.partition.hasEntry(new EntryOperationContext(null, dn))) {
                return syntaxCheckerList;
            }
            LOG.debug("{} schema: loading syntaxCsheckers", (Object)schema.getSchemaName());
            EntryFilteringCursor list = this.partition.list(new ListOperationContext(null, dn));
            try {
                while (list.next()) {
                    Entry entry = (Entry)list.get();
                    syntaxCheckerList.add(entry);
                }
            }
            catch (Exception e) {
                throw new LdapOtherException(e.getMessage(), e);
            }
        }
        return syntaxCheckerList;
    }

    @Override
    public SchemaPartitionDao getDao() {
        return this.dao;
    }
}

