/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.operational;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.apache.directory.server.core.DirectoryService;
import org.apache.directory.server.core.entry.ClonedServerEntry;
import org.apache.directory.server.core.filtering.EntryFilter;
import org.apache.directory.server.core.filtering.EntryFilteringCursor;
import org.apache.directory.server.core.interceptor.BaseInterceptor;
import org.apache.directory.server.core.interceptor.NextInterceptor;
import org.apache.directory.server.core.interceptor.context.AddOperationContext;
import org.apache.directory.server.core.interceptor.context.ListOperationContext;
import org.apache.directory.server.core.interceptor.context.LookupOperationContext;
import org.apache.directory.server.core.interceptor.context.ModifyOperationContext;
import org.apache.directory.server.core.interceptor.context.MoveAndRenameOperationContext;
import org.apache.directory.server.core.interceptor.context.MoveOperationContext;
import org.apache.directory.server.core.interceptor.context.RenameOperationContext;
import org.apache.directory.server.core.interceptor.context.SearchOperationContext;
import org.apache.directory.server.core.interceptor.context.SearchingOperationContext;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.shared.ldap.model.entry.Attribute;
import org.apache.directory.shared.ldap.model.entry.DefaultAttribute;
import org.apache.directory.shared.ldap.model.entry.DefaultModification;
import org.apache.directory.shared.ldap.model.entry.Entry;
import org.apache.directory.shared.ldap.model.entry.Modification;
import org.apache.directory.shared.ldap.model.entry.ModificationOperation;
import org.apache.directory.shared.ldap.model.entry.Value;
import org.apache.directory.shared.ldap.model.exception.LdapException;
import org.apache.directory.shared.ldap.model.exception.LdapNoPermissionException;
import org.apache.directory.shared.ldap.model.exception.LdapSchemaViolationException;
import org.apache.directory.shared.ldap.model.message.ResultCodeEnum;
import org.apache.directory.shared.ldap.model.name.Ava;
import org.apache.directory.shared.ldap.model.name.Dn;
import org.apache.directory.shared.ldap.model.name.Rdn;
import org.apache.directory.shared.ldap.model.schema.AttributeType;
import org.apache.directory.shared.ldap.model.schema.UsageEnum;
import org.apache.directory.shared.util.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OperationalAttributeInterceptor
extends BaseInterceptor {
    private static Logger LOG = LoggerFactory.getLogger(OperationalAttributeInterceptor.class);
    private final EntryFilter DENORMALIZING_SEARCH_FILTER = new OperationalAttributeDenormalizingSearchFilter();
    private final EntryFilter SEARCH_FILTER = new OperationalAttributeSearchFilter();
    private Dn subschemaSubentryDn;
    private Dn adminDn;

    @Override
    public void init(DirectoryService directoryService) throws LdapException {
        super.init(directoryService);
        Value<?> subschemaSubentry = directoryService.getPartitionNexus().getRootDSE(null).get("subschemaSubentry").get();
        this.subschemaSubentryDn = directoryService.getDnFactory().create(subschemaSubentry.getString());
        this.adminDn = directoryService.getDnFactory().create("uid=admin,ou=system");
    }

    @Override
    public void destroy() {
    }

    private boolean checkAddOperationalAttribute(boolean isAdmin, Entry entry, String attribute) throws LdapException {
        if (entry.containsAttribute(attribute)) {
            if (!isAdmin) {
                String message = I18n.err(I18n.ERR_30, attribute);
                LOG.error(message);
                throw new LdapNoPermissionException(message);
            }
            return true;
        }
        return false;
    }

    @Override
    public void add(NextInterceptor nextInterceptor, AddOperationContext addContext) throws LdapException {
        String principal = OperationalAttributeInterceptor.getPrincipal().getName();
        Entry entry = addContext.getEntry();
        boolean isAdmin = addContext.getSession().getAuthenticatedPrincipal().getName().equals("0.9.2342.19200300.100.1.1=admin,2.5.4.11=system");
        if (!this.checkAddOperationalAttribute(isAdmin, entry, "entryUUID")) {
            entry.put("entryUUID", UUID.randomUUID().toString());
        }
        if (!this.checkAddOperationalAttribute(isAdmin, entry, "entryCSN")) {
            entry.put("entryCSN", this.directoryService.getCSN().toString());
        }
        if (!this.checkAddOperationalAttribute(isAdmin, entry, "creatorsName")) {
            entry.put("creatorsName", principal);
        }
        if (!this.checkAddOperationalAttribute(isAdmin, entry, "createTimestamp")) {
            entry.put("createTimestamp", DateUtils.getGeneralizedTime());
        }
        this.checkAddOperationalAttribute(isAdmin, entry, "accessControlSubentries");
        this.checkAddOperationalAttribute(isAdmin, entry, "collectiveAttributeSubentries");
        this.checkAddOperationalAttribute(isAdmin, entry, "triggerExecutionSubentries");
        this.checkAddOperationalAttribute(isAdmin, entry, "subschemaSubentry");
        nextInterceptor.add(addContext);
    }

    @Override
    public void modify(NextInterceptor nextInterceptor, ModifyOperationContext modifyContext) throws LdapException {
        DefaultAttribute attribute;
        List<Modification> mods = modifyContext.getModItems();
        boolean isAdmin = modifyContext.getSession().getAuthenticatedPrincipal().getDn().equals(this.adminDn);
        boolean modifierAtPresent = false;
        boolean modifiedTimeAtPresent = false;
        boolean entryCsnAtPresent = false;
        for (Modification modification : mods) {
            AttributeType attributeType = modification.getAttribute().getAttributeType();
            if (attributeType.equals(MODIFIERS_NAME_AT)) {
                if (!isAdmin) {
                    String message = I18n.err(I18n.ERR_31, new Object[0]);
                    LOG.error(message);
                    throw new LdapSchemaViolationException(ResultCodeEnum.INSUFFICIENT_ACCESS_RIGHTS, message);
                }
                modifierAtPresent = true;
            }
            if (attributeType.equals(MODIFY_TIMESTAMP_AT)) {
                if (!isAdmin) {
                    String message = I18n.err(I18n.ERR_32, new Object[0]);
                    LOG.error(message);
                    throw new LdapSchemaViolationException(ResultCodeEnum.INSUFFICIENT_ACCESS_RIGHTS, message);
                }
                modifiedTimeAtPresent = true;
            }
            if (attributeType.equals(ENTRY_CSN_AT)) {
                if (!isAdmin) {
                    String message = I18n.err(I18n.ERR_32, new Object[0]);
                    LOG.error(message);
                    throw new LdapSchemaViolationException(ResultCodeEnum.INSUFFICIENT_ACCESS_RIGHTS, message);
                }
                entryCsnAtPresent = true;
            }
            if (!PWD_POLICY_STATE_ATTRIBUTE_TYPES.contains(attributeType) || isAdmin) continue;
            String message = I18n.err(I18n.ERR_32, new Object[0]);
            LOG.error(message);
            throw new LdapSchemaViolationException(ResultCodeEnum.INSUFFICIENT_ACCESS_RIGHTS, message);
        }
        if (!modifierAtPresent) {
            attribute = new DefaultAttribute(MODIFIERS_NAME_AT, OperationalAttributeInterceptor.getPrincipal().getName());
            DefaultModification modifiersName = new DefaultModification(ModificationOperation.REPLACE_ATTRIBUTE, attribute);
            mods.add(modifiersName);
        }
        if (!modifiedTimeAtPresent) {
            attribute = new DefaultAttribute(MODIFY_TIMESTAMP_AT, DateUtils.getGeneralizedTime());
            DefaultModification timestamp = new DefaultModification(ModificationOperation.REPLACE_ATTRIBUTE, attribute);
            mods.add(timestamp);
        }
        if (!entryCsnAtPresent) {
            String csn = this.directoryService.getCSN().toString();
            DefaultAttribute attribute2 = new DefaultAttribute(ENTRY_CSN_AT, csn);
            DefaultModification updatedCsn = new DefaultModification(ModificationOperation.REPLACE_ATTRIBUTE, attribute2);
            mods.add(updatedCsn);
        }
        nextInterceptor.modify(modifyContext);
    }

    @Override
    public void rename(NextInterceptor nextInterceptor, RenameOperationContext renameContext) throws LdapException {
        Entry entry = ((ClonedServerEntry)renameContext.getEntry()).getClonedEntry();
        entry.put("modifiersName", OperationalAttributeInterceptor.getPrincipal().getName());
        entry.put("modifyTimestamp", DateUtils.getGeneralizedTime());
        Entry modifiedEntry = renameContext.getOriginalEntry().clone();
        modifiedEntry.put("modifiersName", OperationalAttributeInterceptor.getPrincipal().getName());
        modifiedEntry.put("modifyTimestamp", DateUtils.getGeneralizedTime());
        renameContext.setModifiedEntry(modifiedEntry);
        nextInterceptor.rename(renameContext);
    }

    @Override
    public void move(NextInterceptor nextInterceptor, MoveOperationContext moveContext) throws LdapException {
        Entry modifiedEntry = moveContext.getOriginalEntry().clone();
        modifiedEntry.put("modifiersName", OperationalAttributeInterceptor.getPrincipal().getName());
        modifiedEntry.put("modifyTimestamp", DateUtils.getGeneralizedTime());
        modifiedEntry.setDn(moveContext.getNewDn());
        moveContext.setModifiedEntry(modifiedEntry);
        nextInterceptor.move(moveContext);
    }

    @Override
    public void moveAndRename(NextInterceptor nextInterceptor, MoveAndRenameOperationContext moveAndRenameContext) throws LdapException {
        Entry modifiedEntry = moveAndRenameContext.getOriginalEntry().clone();
        modifiedEntry.put("modifiersName", OperationalAttributeInterceptor.getPrincipal().getName());
        modifiedEntry.put("modifyTimestamp", DateUtils.getGeneralizedTime());
        modifiedEntry.setDn(moveAndRenameContext.getNewDn());
        moveAndRenameContext.setModifiedEntry(modifiedEntry);
        nextInterceptor.moveAndRename(moveAndRenameContext);
    }

    @Override
    public Entry lookup(NextInterceptor nextInterceptor, LookupOperationContext lookupContext) throws LdapException {
        Entry result = nextInterceptor.lookup(lookupContext);
        if (lookupContext.getAttrsId() == null) {
            this.filterOperationalAttributes(result);
        } else if (!lookupContext.hasAllOperational()) {
            this.filter(lookupContext, result);
        }
        this.denormalizeEntryOpAttrs(result);
        return result;
    }

    @Override
    public EntryFilteringCursor list(NextInterceptor nextInterceptor, ListOperationContext listContext) throws LdapException {
        EntryFilteringCursor cursor = nextInterceptor.list(listContext);
        cursor.addEntryFilter(this.SEARCH_FILTER);
        return cursor;
    }

    @Override
    public EntryFilteringCursor search(NextInterceptor nextInterceptor, SearchOperationContext searchContext) throws LdapException {
        EntryFilteringCursor cursor = nextInterceptor.search(searchContext);
        if (searchContext.isAllOperationalAttributes() || searchContext.getReturningAttributes() != null && !searchContext.getReturningAttributes().isEmpty()) {
            if (this.directoryService.isDenormalizeOpAttrsEnabled()) {
                cursor.addEntryFilter(this.DENORMALIZING_SEARCH_FILTER);
            }
            return cursor;
        }
        cursor.addEntryFilter(this.SEARCH_FILTER);
        return cursor;
    }

    private boolean filterOperationalAttributes(Entry attributes) throws LdapException {
        HashSet<AttributeType> removedAttributes = new HashSet<AttributeType>();
        for (AttributeType attributeType : attributes.getAttributeTypes()) {
            if (attributeType.getUsage() == UsageEnum.USER_APPLICATIONS) continue;
            removedAttributes.add(attributeType);
        }
        for (AttributeType attributeType : removedAttributes) {
            attributes.removeAttributes(attributeType);
        }
        return true;
    }

    private void filter(LookupOperationContext lookupContext, Entry entry) throws LdapException {
        Dn dn = lookupContext.getDn();
        List<String> ids = lookupContext.getAttrsId();
        if (ids == null || ids.isEmpty()) {
            this.filterOperationalAttributes(entry);
            return;
        }
        Set<AttributeType> attributeTypes = entry.getAttributeTypes();
        if (dn.size() == 0) {
            for (AttributeType attributeType : attributeTypes) {
                if (ids.contains(attributeType.getOid())) continue;
                entry.removeAttributes(attributeType);
            }
        }
        this.denormalizeEntryOpAttrs(entry);
    }

    public void denormalizeEntryOpAttrs(Entry entry) throws LdapException {
        if (this.directoryService.isDenormalizeOpAttrsEnabled()) {
            Dn modifiersName;
            Attribute attr = entry.get("creatorsName");
            if (attr != null) {
                Dn creatorsName = this.directoryService.getDnFactory().create(attr.getString());
                attr.clear();
                attr.add(this.denormalizeTypes(creatorsName).getName());
            }
            if ((attr = entry.get("modifiersName")) != null) {
                modifiersName = this.directoryService.getDnFactory().create(attr.getString());
                attr.clear();
                attr.add(this.denormalizeTypes(modifiersName).getName());
            }
            if ((attr = entry.get("schemaModifiersName")) != null) {
                modifiersName = this.directoryService.getDnFactory().create(attr.getString());
                attr.clear();
                attr.add(this.denormalizeTypes(modifiersName).getName());
            }
        }
    }

    private Dn denormalizeTypes(Dn dn) throws LdapException {
        Dn newDn = new Dn(this.schemaManager);
        int size = dn.size();
        for (int pos = 0; pos < size; ++pos) {
            Rdn rdn = dn.getRdn(size - 1 - pos);
            if (rdn.size() == 0) {
                newDn = newDn.add(new Rdn());
                continue;
            }
            if (rdn.size() == 1) {
                String name = this.schemaManager.lookupAttributeTypeRegistry(rdn.getNormType()).getName();
                String value = rdn.getNormValue().getString();
                newDn = newDn.add(new Rdn(name, value));
                continue;
            }
            StringBuffer buf = new StringBuffer();
            Iterator<Ava> atavs = rdn.iterator();
            while (atavs.hasNext()) {
                Ava atav = atavs.next();
                String type = this.schemaManager.lookupAttributeTypeRegistry(rdn.getNormType()).getName();
                buf.append(type).append('=').append(atav.getNormValue());
                if (!atavs.hasNext()) continue;
                buf.append('+');
            }
            newDn = newDn.add(new Rdn(buf.toString()));
        }
        return newDn;
    }

    private boolean filterDenormalized(Entry entry) throws Exception {
        this.denormalizeEntryOpAttrs(entry);
        return true;
    }

    private class OperationalAttributeSearchFilter
    implements EntryFilter {
        private OperationalAttributeSearchFilter() {
        }

        @Override
        public boolean accept(SearchingOperationContext operation, Entry entry) throws Exception {
            return operation.getSearchControls().getReturningAttributes() != null || OperationalAttributeInterceptor.this.filterOperationalAttributes(entry);
        }
    }

    private class OperationalAttributeDenormalizingSearchFilter
    implements EntryFilter {
        private OperationalAttributeDenormalizingSearchFilter() {
        }

        @Override
        public boolean accept(SearchingOperationContext operation, Entry entry) throws Exception {
            if (operation.getSearchControls().getReturningAttributes() == null) {
                return true;
            }
            return OperationalAttributeInterceptor.this.filterDenormalized(entry);
        }
    }
}

