/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.logger;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.directory.server.core.DirectoryService;
import org.apache.directory.server.core.filtering.EntryFilteringCursor;
import org.apache.directory.server.core.interceptor.Interceptor;
import org.apache.directory.server.core.interceptor.NextInterceptor;
import org.apache.directory.server.core.interceptor.context.AddOperationContext;
import org.apache.directory.server.core.interceptor.context.BindOperationContext;
import org.apache.directory.server.core.interceptor.context.CompareOperationContext;
import org.apache.directory.server.core.interceptor.context.DeleteOperationContext;
import org.apache.directory.server.core.interceptor.context.EntryOperationContext;
import org.apache.directory.server.core.interceptor.context.GetRootDSEOperationContext;
import org.apache.directory.server.core.interceptor.context.ListOperationContext;
import org.apache.directory.server.core.interceptor.context.LookupOperationContext;
import org.apache.directory.server.core.interceptor.context.ModifyOperationContext;
import org.apache.directory.server.core.interceptor.context.MoveAndRenameOperationContext;
import org.apache.directory.server.core.interceptor.context.MoveOperationContext;
import org.apache.directory.server.core.interceptor.context.RenameOperationContext;
import org.apache.directory.server.core.interceptor.context.SearchOperationContext;
import org.apache.directory.server.core.interceptor.context.UnbindOperationContext;
import org.apache.directory.shared.ldap.model.entry.Entry;
import org.apache.directory.shared.ldap.model.exception.LdapException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimerInterceptor
implements Interceptor {
    private static final Logger OPERATION_STATS = LoggerFactory.getLogger("OPERATION_STATS");
    private static final Logger OPERATION_TIME = LoggerFactory.getLogger("OPERATION_TIME");
    private static final boolean IS_DEBUG_STATS = OPERATION_STATS.isDebugEnabled();
    private static final boolean IS_DEBUG_TIME = OPERATION_TIME.isDebugEnabled();
    private String name;
    private static AtomicLong totalAdd = new AtomicLong(0L);
    private static AtomicInteger nbAddCalls = new AtomicInteger(0);
    private static AtomicLong totalBind = new AtomicLong(0L);
    private static AtomicInteger nbBindCalls = new AtomicInteger(0);
    private static AtomicLong totalCompare = new AtomicLong(0L);
    private static AtomicInteger nbCompareCalls = new AtomicInteger(0);
    private static AtomicLong totalDelete = new AtomicLong(0L);
    private static AtomicInteger nbDeleteCalls = new AtomicInteger(0);
    private static AtomicLong totalGetRootDSE = new AtomicLong(0L);
    private static AtomicInteger nbGetRootDSECalls = new AtomicInteger(0);
    private static AtomicLong totalHasEntry = new AtomicLong(0L);
    private static AtomicInteger nbHasEntryCalls = new AtomicInteger(0);
    private static AtomicLong totalList = new AtomicLong(0L);
    private static AtomicInteger nbListCalls = new AtomicInteger(0);
    private static AtomicLong totalLookup = new AtomicLong(0L);
    private static AtomicInteger nbLookupCalls = new AtomicInteger(0);
    private static AtomicLong totalModify = new AtomicLong(0L);
    private static AtomicInteger nbModifyCalls = new AtomicInteger(0);
    private static AtomicLong totalMove = new AtomicLong(0L);
    private static AtomicInteger nbMoveCalls = new AtomicInteger(0);
    private static AtomicLong totalMoveAndRename = new AtomicLong(0L);
    private static AtomicInteger nbMoveAndRenameCalls = new AtomicInteger(0);
    private static AtomicLong totalRename = new AtomicLong(0L);
    private static AtomicInteger nbRenameCalls = new AtomicInteger(0);
    private static AtomicLong totalSearch = new AtomicLong(0L);
    private static AtomicInteger nbSearchCalls = new AtomicInteger(0);
    private static AtomicLong totalUnbind = new AtomicLong(0L);
    private static AtomicInteger nbUnbindCalls = new AtomicInteger(0);

    public TimerInterceptor(String name) {
        this.name = name;
    }

    @Override
    public void add(NextInterceptor next, AddOperationContext addContext) throws LdapException {
        long t0 = System.nanoTime();
        next.add(addContext);
        long delta = System.nanoTime() - t0;
        if (IS_DEBUG_STATS) {
            nbAddCalls.incrementAndGet();
            totalAdd.getAndAdd(delta);
            if (nbAddCalls.get() % 1000 == 0) {
                long average = totalAdd.get() / (long)(nbAddCalls.get() * 1000);
                OPERATION_STATS.debug(this.name + " : Average add = {} microseconds, nb adds = {}", average, (Object)nbAddCalls.get());
            }
        }
        if (IS_DEBUG_TIME) {
            OPERATION_TIME.debug("{} : Delta add = {}", (Object)this.name, (Object)delta);
        }
    }

    @Override
    public void bind(NextInterceptor next, BindOperationContext bindContext) throws LdapException {
        long t0 = System.nanoTime();
        next.bind(bindContext);
        long delta = System.nanoTime() - t0;
        if (IS_DEBUG_STATS) {
            nbBindCalls.incrementAndGet();
            totalBind.getAndAdd(delta);
            if (nbBindCalls.get() % 1000 == 0) {
                long average = totalBind.get() / (long)(nbBindCalls.get() * 1000);
                OPERATION_STATS.debug(this.name + " : Average bind = {} microseconds, nb binds = {}", average, (Object)nbBindCalls.get());
            }
        }
        if (IS_DEBUG_TIME) {
            OPERATION_TIME.debug("{} : Delta bind = {}", (Object)this.name, (Object)delta);
        }
    }

    @Override
    public boolean compare(NextInterceptor next, CompareOperationContext compareContext) throws LdapException {
        long t0 = System.nanoTime();
        boolean compare = next.compare(compareContext);
        long delta = System.nanoTime() - t0;
        if (IS_DEBUG_STATS) {
            nbCompareCalls.incrementAndGet();
            totalCompare.getAndAdd(delta);
            if (nbCompareCalls.get() % 1000 == 0) {
                long average = totalCompare.get() / (long)(nbCompareCalls.get() * 1000);
                OPERATION_STATS.debug(this.name + " : Average compare = {} microseconds, nb compares = {}", average, (Object)nbCompareCalls.get());
            }
        }
        if (IS_DEBUG_TIME) {
            OPERATION_TIME.debug("{} : Delta compare = {}", (Object)this.name, (Object)delta);
        }
        return compare;
    }

    @Override
    public void delete(NextInterceptor next, DeleteOperationContext deleteContext) throws LdapException {
        long t0 = System.nanoTime();
        next.delete(deleteContext);
        long delta = System.nanoTime() - t0;
        if (IS_DEBUG_STATS) {
            nbDeleteCalls.incrementAndGet();
            totalDelete.getAndAdd(delta);
            if (nbDeleteCalls.get() % 1000 == 0) {
                long average = totalDelete.get() / (long)(nbDeleteCalls.get() * 1000);
                OPERATION_STATS.debug(this.name + " : Average delete = {} microseconds, nb deletes = {}", average, (Object)nbDeleteCalls.get());
            }
        }
        if (IS_DEBUG_TIME) {
            OPERATION_TIME.debug("{} : Delta delete = {}", (Object)this.name, (Object)delta);
        }
    }

    @Override
    public void destroy() {
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Entry getRootDSE(NextInterceptor next, GetRootDSEOperationContext getRootDseContext) throws LdapException {
        long t0 = System.nanoTime();
        Entry rootDSE = next.getRootDSE(getRootDseContext);
        long delta = System.nanoTime() - t0;
        if (IS_DEBUG_STATS) {
            nbGetRootDSECalls.incrementAndGet();
            totalGetRootDSE.getAndAdd(delta);
            if (nbGetRootDSECalls.get() % 1000 == 0) {
                long average = totalGetRootDSE.get() / (long)(nbGetRootDSECalls.get() * 1000);
                OPERATION_STATS.debug(this.name + " : Average getRootDSE = {} microseconds, nb getRootDSEs = {}", average, (Object)nbGetRootDSECalls.get());
            }
        }
        if (IS_DEBUG_TIME) {
            OPERATION_TIME.debug("{} : Delta getRootDSE = {}", (Object)this.name, (Object)delta);
        }
        return rootDSE;
    }

    @Override
    public boolean hasEntry(NextInterceptor next, EntryOperationContext hasEntryContext) throws LdapException {
        long t0 = System.nanoTime();
        boolean hasEntry = next.hasEntry(hasEntryContext);
        long delta = System.nanoTime() - t0;
        if (IS_DEBUG_STATS) {
            nbHasEntryCalls.incrementAndGet();
            totalHasEntry.getAndAdd(delta);
            if (nbHasEntryCalls.get() % 1000 == 0) {
                long average = totalHasEntry.get() / (long)(nbHasEntryCalls.get() * 1000);
                OPERATION_STATS.debug(this.name + " : Average hasEntry = {} microseconds, nb hasEntrys = {}", average, (Object)nbHasEntryCalls.get());
            }
        }
        if (IS_DEBUG_TIME) {
            OPERATION_TIME.debug("{} : Delta hasEntry = {}", (Object)this.name, (Object)delta);
        }
        return hasEntry;
    }

    @Override
    public void init(DirectoryService directoryService) throws LdapException {
    }

    @Override
    public EntryFilteringCursor list(NextInterceptor next, ListOperationContext listContext) throws LdapException {
        long t0 = System.nanoTime();
        EntryFilteringCursor cursor = next.list(listContext);
        long delta = System.nanoTime() - t0;
        if (IS_DEBUG_STATS) {
            nbListCalls.incrementAndGet();
            totalList.getAndAdd(delta);
            if (nbListCalls.get() % 1000 == 0) {
                long average = totalList.get() / (long)(nbListCalls.get() * 1000);
                OPERATION_STATS.debug(this.name + " : Average list = {} microseconds, nb lists = {}", average, (Object)nbListCalls.get());
            }
        }
        if (IS_DEBUG_TIME) {
            OPERATION_TIME.debug("{} : Delta list = {}", (Object)this.name, (Object)delta);
        }
        return cursor;
    }

    @Override
    public Entry lookup(NextInterceptor next, LookupOperationContext lookupContext) throws LdapException {
        long t0 = System.nanoTime();
        Entry entry = next.lookup(lookupContext);
        long delta = System.nanoTime() - t0;
        if (IS_DEBUG_STATS) {
            nbLookupCalls.incrementAndGet();
            totalLookup.getAndAdd(delta);
            if (nbLookupCalls.get() % 1000 == 0) {
                long average = totalLookup.get() / (long)(nbLookupCalls.get() * 1000);
                OPERATION_STATS.debug(this.name + " : Average lookup = {} microseconds, nb lookups = {}", average, (Object)nbLookupCalls.get());
            }
        }
        if (IS_DEBUG_TIME) {
            OPERATION_TIME.debug("{} : Delta lookup = {}", (Object)this.name, (Object)delta);
        }
        return entry;
    }

    @Override
    public void modify(NextInterceptor next, ModifyOperationContext modifyContext) throws LdapException {
        long t0 = System.nanoTime();
        next.modify(modifyContext);
        long delta = System.nanoTime() - t0;
        if (IS_DEBUG_STATS) {
            nbModifyCalls.incrementAndGet();
            totalModify.getAndAdd(delta);
            if (nbModifyCalls.get() % 1000 == 0) {
                long average = totalModify.get() / (long)(nbModifyCalls.get() * 1000);
                OPERATION_STATS.debug(this.name + " : Average modify = {} microseconds, nb modifys = {}", average, (Object)nbModifyCalls.get());
            }
        }
        if (IS_DEBUG_TIME) {
            OPERATION_TIME.debug("{} : Delta modify = {}", (Object)this.name, (Object)delta);
        }
    }

    @Override
    public void move(NextInterceptor next, MoveOperationContext moveContext) throws LdapException {
        long t0 = System.nanoTime();
        next.move(moveContext);
        long delta = System.nanoTime() - t0;
        if (IS_DEBUG_STATS) {
            nbMoveCalls.incrementAndGet();
            totalMove.getAndAdd(delta);
            if (nbMoveCalls.get() % 1000 == 0) {
                long average = totalMove.get() / (long)(nbMoveCalls.get() * 1000);
                OPERATION_STATS.debug(this.name + " : Average move = {} microseconds, nb moves = {}", average, (Object)nbMoveCalls.get());
            }
        }
        if (IS_DEBUG_TIME) {
            OPERATION_TIME.debug("{} : Delta move = {}", (Object)this.name, (Object)delta);
        }
    }

    @Override
    public void moveAndRename(NextInterceptor next, MoveAndRenameOperationContext moveAndRenameContext) throws LdapException {
        long t0 = System.nanoTime();
        next.moveAndRename(moveAndRenameContext);
        long delta = System.nanoTime() - t0;
        if (IS_DEBUG_STATS) {
            nbMoveAndRenameCalls.incrementAndGet();
            totalMoveAndRename.getAndAdd(delta);
            if (nbMoveAndRenameCalls.get() % 1000 == 0) {
                long average = totalMoveAndRename.get() / (long)(nbMoveAndRenameCalls.get() * 1000);
                OPERATION_STATS.debug(this.name + " : Average moveAndRename = {} microseconds, nb moveAndRenames = {}", average, (Object)nbMoveAndRenameCalls.get());
            }
        }
        if (IS_DEBUG_TIME) {
            OPERATION_TIME.debug("{} : Delta moveAndRename = {}", (Object)this.name, (Object)delta);
        }
    }

    @Override
    public void rename(NextInterceptor next, RenameOperationContext renameContext) throws LdapException {
        long t0 = System.nanoTime();
        next.rename(renameContext);
        long delta = System.nanoTime() - t0;
        if (IS_DEBUG_STATS) {
            nbRenameCalls.incrementAndGet();
            totalRename.getAndAdd(delta);
            if (nbRenameCalls.get() % 1000 == 0) {
                long average = totalRename.get() / (long)(nbRenameCalls.get() * 1000);
                OPERATION_STATS.debug(this.name + " : Average rename = {} microseconds, nb renames = {}", average, (Object)nbRenameCalls.get());
            }
        }
        if (IS_DEBUG_TIME) {
            OPERATION_TIME.debug("{} : Delta rename = {}", (Object)this.name, (Object)delta);
        }
    }

    @Override
    public EntryFilteringCursor search(NextInterceptor next, SearchOperationContext searchContext) throws LdapException {
        long t0 = System.nanoTime();
        EntryFilteringCursor cursor = next.search(searchContext);
        long delta = System.nanoTime() - t0;
        if (IS_DEBUG_STATS) {
            nbSearchCalls.incrementAndGet();
            totalSearch.getAndAdd(delta);
            if (nbSearchCalls.get() % 1000 == 0) {
                long average = totalSearch.get() / (long)(nbSearchCalls.get() * 1000);
                OPERATION_STATS.debug(this.name + " : Average search = {} microseconds, nb searches = {}", average, (Object)nbSearchCalls.get());
            }
        }
        if (IS_DEBUG_TIME) {
            OPERATION_TIME.debug("{} : Delta search = {}", (Object)this.name, (Object)delta);
        }
        return cursor;
    }

    @Override
    public void unbind(NextInterceptor next, UnbindOperationContext unbindContext) throws LdapException {
        long t0 = System.nanoTime();
        next.unbind(unbindContext);
        long delta = System.nanoTime() - t0;
        if (IS_DEBUG_STATS) {
            nbUnbindCalls.incrementAndGet();
            totalUnbind.getAndAdd(delta);
            if (nbUnbindCalls.get() % 1000 == 0) {
                long average = totalUnbind.get() / (long)(nbUnbindCalls.get() * 1000);
                OPERATION_STATS.debug(this.name + " : Average unbind = {} microseconds, nb unbinds = {}", average, (Object)nbUnbindCalls.get());
            }
        }
        if (IS_DEBUG_TIME) {
            OPERATION_TIME.debug("{} : Delta unbind = {}", (Object)this.name, (Object)delta);
        }
    }
}

