/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.jndi;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.naming.Context;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.NoPermissionException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.directory.DirContext;
import javax.naming.directory.SchemaViolationException;
import javax.naming.directory.SearchControls;
import javax.naming.event.EventContext;
import javax.naming.event.NamingListener;
import javax.naming.ldap.Control;
import javax.naming.ldap.LdapName;
import javax.naming.spi.DirStateFactory;
import javax.naming.spi.DirectoryManager;
import org.apache.directory.server.core.CoreSession;
import org.apache.directory.server.core.DefaultCoreSession;
import org.apache.directory.server.core.DirectoryService;
import org.apache.directory.server.core.LdapPrincipal;
import org.apache.directory.server.core.OperationManager;
import org.apache.directory.server.core.entry.ServerEntryUtils;
import org.apache.directory.server.core.event.DirectoryListener;
import org.apache.directory.server.core.event.NotificationCriteria;
import org.apache.directory.server.core.filtering.BaseEntryFilteringCursor;
import org.apache.directory.server.core.filtering.EntryFilteringCursor;
import org.apache.directory.server.core.interceptor.context.AddOperationContext;
import org.apache.directory.server.core.interceptor.context.BindOperationContext;
import org.apache.directory.server.core.interceptor.context.CompareOperationContext;
import org.apache.directory.server.core.interceptor.context.DeleteOperationContext;
import org.apache.directory.server.core.interceptor.context.EntryOperationContext;
import org.apache.directory.server.core.interceptor.context.GetRootDSEOperationContext;
import org.apache.directory.server.core.interceptor.context.ListOperationContext;
import org.apache.directory.server.core.interceptor.context.LookupOperationContext;
import org.apache.directory.server.core.interceptor.context.ModifyOperationContext;
import org.apache.directory.server.core.interceptor.context.MoveAndRenameOperationContext;
import org.apache.directory.server.core.interceptor.context.MoveOperationContext;
import org.apache.directory.server.core.interceptor.context.OperationContext;
import org.apache.directory.server.core.interceptor.context.RenameOperationContext;
import org.apache.directory.server.core.interceptor.context.SearchOperationContext;
import org.apache.directory.server.core.jndi.ControlEnum;
import org.apache.directory.server.core.jndi.EventListenerAdapter;
import org.apache.directory.server.core.jndi.JavaLdapSupport;
import org.apache.directory.server.core.jndi.LdapJndiProperties;
import org.apache.directory.server.core.jndi.NamingEnumerationAdapter;
import org.apache.directory.server.core.jndi.ServerLdapContext;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.shared.asn1.DecoderException;
import org.apache.directory.shared.ldap.codec.controls.cascade.CascadeDecorator;
import org.apache.directory.shared.ldap.codec.controls.manageDsaIT.ManageDsaITDecorator;
import org.apache.directory.shared.ldap.codec.controls.search.entryChange.EntryChangeDecorator;
import org.apache.directory.shared.ldap.codec.controls.search.pagedSearch.PagedResultsDecorator;
import org.apache.directory.shared.ldap.codec.controls.search.persistentSearch.PersistentSearchDecorator;
import org.apache.directory.shared.ldap.codec.controls.search.subentries.SubentriesDecorator;
import org.apache.directory.shared.ldap.extras.controls.ppolicy.PasswordPolicyDecorator;
import org.apache.directory.shared.ldap.extras.controls.ppolicy.PasswordPolicyImpl;
import org.apache.directory.shared.ldap.extras.controls.ppolicy.PasswordPolicyResponseImpl;
import org.apache.directory.shared.ldap.extras.controls.syncrepl_impl.SyncDoneValueDecorator;
import org.apache.directory.shared.ldap.extras.controls.syncrepl_impl.SyncInfoValueDecorator;
import org.apache.directory.shared.ldap.extras.controls.syncrepl_impl.SyncModifyDnDecorator;
import org.apache.directory.shared.ldap.extras.controls.syncrepl_impl.SyncRequestValueDecorator;
import org.apache.directory.shared.ldap.extras.controls.syncrepl_impl.SyncStateValueDecorator;
import org.apache.directory.shared.ldap.model.cursor.EmptyCursor;
import org.apache.directory.shared.ldap.model.cursor.SingletonCursor;
import org.apache.directory.shared.ldap.model.entry.Attribute;
import org.apache.directory.shared.ldap.model.entry.AttributeUtils;
import org.apache.directory.shared.ldap.model.entry.DefaultEntry;
import org.apache.directory.shared.ldap.model.entry.Entry;
import org.apache.directory.shared.ldap.model.entry.Modification;
import org.apache.directory.shared.ldap.model.exception.LdapException;
import org.apache.directory.shared.ldap.model.exception.LdapInvalidAttributeTypeException;
import org.apache.directory.shared.ldap.model.exception.LdapInvalidDnException;
import org.apache.directory.shared.ldap.model.filter.EqualityNode;
import org.apache.directory.shared.ldap.model.filter.ExprNode;
import org.apache.directory.shared.ldap.model.filter.PresenceNode;
import org.apache.directory.shared.ldap.model.message.AliasDerefMode;
import org.apache.directory.shared.ldap.model.message.SearchScope;
import org.apache.directory.shared.ldap.model.message.controls.CascadeImpl;
import org.apache.directory.shared.ldap.model.message.controls.ManageDsaITImpl;
import org.apache.directory.shared.ldap.model.name.Ava;
import org.apache.directory.shared.ldap.model.name.Dn;
import org.apache.directory.shared.ldap.model.name.Rdn;
import org.apache.directory.shared.ldap.model.schema.AttributeType;
import org.apache.directory.shared.ldap.model.schema.SchemaManager;
import org.apache.directory.shared.ldap.util.JndiUtils;
import org.apache.directory.shared.util.Strings;

public abstract class ServerContext
implements EventContext {
    public static final String DELETE_OLD_RDN_PROP = "java.naming.ldap.deleteRDN";
    protected static final Control[] EMPTY_CONTROLS = new Control[0];
    private final DirectoryService service;
    protected SchemaManager schemaManager;
    protected AttributeType OBJECT_CLASS_AT;
    private final Hashtable<String, Object> env;
    private final Dn dn;
    private final Map<NamingListener, DirectoryListener> listeners = new HashMap<NamingListener, DirectoryListener>();
    protected Control[] requestControls = EMPTY_CONTROLS;
    protected Control[] responseControls = EMPTY_CONTROLS;
    protected Control[] connectControls = EMPTY_CONTROLS;
    private final CoreSession session;
    private static final Map<String, ControlEnum> ADS_CONTROLS = new HashMap<String, ControlEnum>();

    protected ServerContext(DirectoryService service, Hashtable<String, Object> env) throws Exception {
        this.service = service;
        this.env = env;
        LdapJndiProperties props = LdapJndiProperties.getLdapJndiProperties(this.env);
        this.dn = props.getProviderDn();
        BindOperationContext bindContext = this.doBindOperation(props.getBindDn(), props.getCredentials(), props.getSaslMechanism(), props.getSaslAuthId());
        this.session = bindContext.getSession();
        OperationManager operationManager = service.getOperationManager();
        if (!operationManager.hasEntry(new EntryOperationContext(this.session, this.dn))) {
            throw new NameNotFoundException(I18n.err(I18n.ERR_490, this.dn));
        }
        this.schemaManager = service.getSchemaManager();
        this.OBJECT_CLASS_AT = this.schemaManager.getAttributeType("objectClass");
    }

    public ServerContext(DirectoryService service, LdapPrincipal principal, Name name) throws Exception {
        this.service = service;
        this.dn = JndiUtils.fromName(name);
        this.env = new Hashtable();
        this.env.put("java.naming.provider.url", this.dn.toString());
        this.env.put(DirectoryService.JNDI_KEY, service);
        this.session = new DefaultCoreSession(principal, service);
        OperationManager operationManager = service.getOperationManager();
        if (!operationManager.hasEntry(new EntryOperationContext(this.session, this.dn))) {
            throw new NameNotFoundException(I18n.err(I18n.ERR_490, this.dn));
        }
        this.schemaManager = service.getSchemaManager();
        this.OBJECT_CLASS_AT = this.schemaManager.getAttributeType("objectClass");
    }

    public ServerContext(DirectoryService service, CoreSession session, Name name) throws Exception {
        this.service = service;
        this.dn = JndiUtils.fromName(name);
        this.env = new Hashtable();
        this.env.put("java.naming.provider.url", this.dn.toString());
        this.env.put(DirectoryService.JNDI_KEY, service);
        this.session = session;
        OperationManager operationManager = service.getOperationManager();
        if (!operationManager.hasEntry(new EntryOperationContext(session, this.dn))) {
            throw new NameNotFoundException(I18n.err(I18n.ERR_490, this.dn));
        }
        this.schemaManager = service.getSchemaManager();
        this.OBJECT_CLASS_AT = this.schemaManager.getAttributeType("objectClass");
    }

    protected void injectReferralControl(OperationContext opCtx) {
        if ("ignore".equalsIgnoreCase((String)this.env.get("java.naming.referral"))) {
            opCtx.ignoreReferral();
        } else if ("throw".equalsIgnoreCase((String)this.env.get("java.naming.referral"))) {
            opCtx.throwReferral();
        } else {
            opCtx.throwReferral();
        }
    }

    protected void doAddOperation(Dn target, Entry entry) throws Exception {
        AddOperationContext opCtx = new AddOperationContext(this.session, entry);
        opCtx.addRequestControls(this.convertControls(true, this.requestControls));
        this.injectReferralControl(opCtx);
        OperationManager operationManager = this.service.getOperationManager();
        operationManager.add(opCtx);
        this.requestControls = EMPTY_CONTROLS;
        this.responseControls = JndiUtils.toJndiControls(this.getDirectoryService().getLdapCodecService(), opCtx.getResponseControls());
    }

    protected void doDeleteOperation(Dn target) throws Exception {
        DeleteOperationContext opCtx = new DeleteOperationContext(this.session, target);
        opCtx.addRequestControls(this.convertControls(true, this.requestControls));
        this.injectReferralControl(opCtx);
        OperationManager operationManager = this.service.getOperationManager();
        operationManager.delete(opCtx);
        this.requestControls = EMPTY_CONTROLS;
        this.responseControls = JndiUtils.toJndiControls(this.getDirectoryService().getLdapCodecService(), opCtx.getResponseControls());
    }

    private org.apache.directory.shared.ldap.model.message.Control convertControl(boolean isRequest, Control jndiControl) throws DecoderException {
        String controlIDStr = jndiControl.getID();
        org.apache.directory.shared.ldap.model.message.Control control = null;
        ControlEnum controlId = ADS_CONTROLS.get(controlIDStr);
        switch (controlId) {
            case CASCADE_CONTROL: {
                control = new CascadeDecorator(this.getDirectoryService().getLdapCodecService(), new CascadeImpl());
                break;
            }
            case ENTRY_CHANGE_CONTROL: {
                control = new EntryChangeDecorator(this.getDirectoryService().getLdapCodecService());
                break;
            }
            case MANAGE_DSA_IT_CONTROL: {
                control = new ManageDsaITDecorator(this.getDirectoryService().getLdapCodecService(), new ManageDsaITImpl());
                break;
            }
            case PAGED_RESULTS_CONTROL: {
                control = new PagedResultsDecorator(this.getDirectoryService().getLdapCodecService());
                break;
            }
            case PASSWORD_POLICY_REQUEST_CONTROL: {
                if (isRequest) {
                    control = new PasswordPolicyDecorator(this.getDirectoryService().getLdapCodecService(), new PasswordPolicyImpl());
                    break;
                }
                control = new PasswordPolicyDecorator(this.getDirectoryService().getLdapCodecService(), new PasswordPolicyImpl(new PasswordPolicyResponseImpl()));
                break;
            }
            case PERSISTENT_SEARCH_CONTROL: {
                control = new PersistentSearchDecorator(this.getDirectoryService().getLdapCodecService());
                break;
            }
            case SUBENTRIES_CONTROL: {
                control = new SubentriesDecorator(this.getDirectoryService().getLdapCodecService());
                break;
            }
            case SYNC_DONE_VALUE_CONTROL: {
                control = new SyncDoneValueDecorator(this.getDirectoryService().getLdapCodecService());
                break;
            }
            case SYNC_INFO_VALUE_CONTROL: {
                control = new SyncInfoValueDecorator(this.getDirectoryService().getLdapCodecService());
                break;
            }
            case SYNC_MODIFY_DN_CONTROL: {
                control = new SyncModifyDnDecorator(this.getDirectoryService().getLdapCodecService());
                break;
            }
            case SYNC_REQUEST_VALUE_CONTROL: {
                control = new SyncRequestValueDecorator(this.getDirectoryService().getLdapCodecService());
                break;
            }
            case SYNC_STATE_VALUE_CONTROL: {
                control = new SyncStateValueDecorator(this.getDirectoryService().getLdapCodecService());
            }
        }
        control.setCritical(jndiControl.isCritical());
        control.setValue(jndiControl.getEncodedValue());
        byte[] value = jndiControl.getEncodedValue();
        if (!Strings.isEmpty(value)) {
            control.decode(value);
        }
        return control;
    }

    private org.apache.directory.shared.ldap.model.message.Control[] convertControls(boolean isRequest, Control[] jndiControls) throws DecoderException {
        if (jndiControls != null) {
            org.apache.directory.shared.ldap.model.message.Control[] controls = new org.apache.directory.shared.ldap.model.message.Control[jndiControls.length];
            int i = 0;
            for (Control jndiControl : jndiControls) {
                controls[i++] = this.convertControl(isRequest, jndiControl);
            }
            return controls;
        }
        return null;
    }

    protected EntryFilteringCursor doSearchOperation(Dn dn, AliasDerefMode aliasDerefMode, ExprNode filter, SearchControls searchControls) throws Exception {
        OperationManager operationManager = this.service.getOperationManager();
        EntryFilteringCursor results = null;
        Object typesOnlyObj = this.getEnvironment().get("java.naming.ldap.typesOnly");
        boolean typesOnly = false;
        if (typesOnlyObj != null) {
            typesOnly = Boolean.parseBoolean(typesOnlyObj.toString());
        }
        SearchOperationContext searchContext = null;
        if (searchControls.getSearchScope() == 0 && searchControls.getReturningAttributes() != null && searchControls.getReturningAttributes().length == 0 && filter instanceof EqualityNode) {
            CompareOperationContext compareContext = new CompareOperationContext(this.session, dn, ((EqualityNode)filter).getAttribute(), ((EqualityNode)filter).getValue());
            this.injectReferralControl(compareContext);
            boolean result = operationManager.compare(compareContext);
            searchContext = new SearchOperationContext(this.session, dn, filter, searchControls);
            searchContext.setAliasDerefMode(aliasDerefMode);
            searchContext.addRequestControls(this.convertControls(true, this.requestControls));
            searchContext.setTypesOnly(typesOnly);
            if (result) {
                DefaultEntry emptyEntry = new DefaultEntry(this.service.getSchemaManager(), Dn.EMPTY_DN);
                return new BaseEntryFilteringCursor(new SingletonCursor<Entry>(emptyEntry), searchContext);
            }
            return new BaseEntryFilteringCursor(new EmptyCursor<Entry>(), searchContext);
        }
        searchContext = new SearchOperationContext(this.session, dn, filter, searchControls);
        searchContext.setAliasDerefMode(aliasDerefMode);
        searchContext.addRequestControls(this.convertControls(true, this.requestControls));
        searchContext.setTypesOnly(typesOnly);
        this.injectReferralControl(searchContext);
        results = operationManager.search(searchContext);
        this.requestControls = EMPTY_CONTROLS;
        this.responseControls = JndiUtils.toJndiControls(this.getDirectoryService().getLdapCodecService(), searchContext.getResponseControls());
        return results;
    }

    protected EntryFilteringCursor doListOperation(Dn target) throws Exception {
        ListOperationContext listContext = new ListOperationContext(this.session, target);
        listContext.addRequestControls(this.convertControls(true, this.requestControls));
        OperationManager operationManager = this.service.getOperationManager();
        EntryFilteringCursor results = operationManager.list(listContext);
        this.requestControls = EMPTY_CONTROLS;
        this.responseControls = JndiUtils.toJndiControls(this.getDirectoryService().getLdapCodecService(), listContext.getResponseControls());
        return results;
    }

    protected Entry doGetRootDSEOperation(Dn target) throws Exception {
        GetRootDSEOperationContext getRootDseContext = new GetRootDSEOperationContext(this.session, target);
        getRootDseContext.addRequestControls(this.convertControls(true, this.requestControls));
        OperationManager operationManager = this.service.getOperationManager();
        return operationManager.getRootDSE(getRootDseContext);
    }

    protected Entry doLookupOperation(Dn target) throws Exception {
        LookupOperationContext lookupContext = new LookupOperationContext(this.session, target);
        lookupContext.addRequestControls(this.convertControls(true, this.requestControls));
        OperationManager operationManager = this.service.getOperationManager();
        Entry serverEntry = operationManager.lookup(lookupContext);
        this.requestControls = EMPTY_CONTROLS;
        this.responseControls = JndiUtils.toJndiControls(this.getDirectoryService().getLdapCodecService(), lookupContext.getResponseControls());
        return serverEntry;
    }

    protected Entry doLookupOperation(Dn target, String[] attrIds) throws Exception {
        LookupOperationContext lookupContext = new LookupOperationContext(this.session, target, attrIds);
        lookupContext.addRequestControls(this.convertControls(true, this.requestControls));
        OperationManager operationManager = this.service.getOperationManager();
        Entry serverEntry = operationManager.lookup(lookupContext);
        this.requestControls = EMPTY_CONTROLS;
        this.responseControls = JndiUtils.toJndiControls(this.getDirectoryService().getLdapCodecService(), lookupContext.getResponseControls());
        if (lookupContext.getAttrsId() != null && lookupContext.getAttrsId().size() != 0 && serverEntry.get("objectClass") != null && serverEntry.get("objectClass").size() == 0) {
            serverEntry.removeAttributes("objectClass");
        }
        return serverEntry;
    }

    protected BindOperationContext doBindOperation(Dn bindDn, byte[] credentials, String saslMechanism, String saslAuthId) throws Exception {
        BindOperationContext bindContext = new BindOperationContext(null);
        bindContext.setDn(bindDn);
        bindContext.setCredentials(credentials);
        bindContext.setSaslMechanism(saslMechanism);
        bindContext.setSaslAuthId(saslAuthId);
        bindContext.addRequestControls(this.convertControls(true, this.requestControls));
        OperationManager operationManager = this.service.getOperationManager();
        operationManager.bind(bindContext);
        this.requestControls = EMPTY_CONTROLS;
        this.responseControls = JndiUtils.toJndiControls(this.getDirectoryService().getLdapCodecService(), bindContext.getResponseControls());
        return bindContext;
    }

    protected void doMoveAndRenameOperation(Dn oldDn, Dn parent, Rdn newRdn, boolean delOldDn) throws Exception {
        MoveAndRenameOperationContext moveAndRenameContext = new MoveAndRenameOperationContext(this.session, oldDn, parent, new Rdn(newRdn), delOldDn);
        moveAndRenameContext.addRequestControls(this.convertControls(true, this.requestControls));
        this.injectReferralControl(moveAndRenameContext);
        OperationManager operationManager = this.service.getOperationManager();
        operationManager.moveAndRename(moveAndRenameContext);
        this.requestControls = EMPTY_CONTROLS;
        this.responseControls = JndiUtils.toJndiControls(this.getDirectoryService().getLdapCodecService(), moveAndRenameContext.getResponseControls());
    }

    protected void doModifyOperation(Dn dn, List<Modification> modifications) throws Exception {
        ModifyOperationContext modifyContext = new ModifyOperationContext(this.session, dn, modifications);
        modifyContext.addRequestControls(this.convertControls(true, this.requestControls));
        this.injectReferralControl(modifyContext);
        OperationManager operationManager = this.service.getOperationManager();
        operationManager.modify(modifyContext);
        this.requestControls = EMPTY_CONTROLS;
        this.responseControls = JndiUtils.toJndiControls(this.getDirectoryService().getLdapCodecService(), modifyContext.getResponseControls());
    }

    protected void doMove(Dn oldDn, Dn target) throws Exception {
        MoveOperationContext moveContext = new MoveOperationContext(this.session, oldDn, target);
        moveContext.addRequestControls(this.convertControls(true, this.requestControls));
        this.injectReferralControl(moveContext);
        OperationManager operationManager = this.service.getOperationManager();
        operationManager.move(moveContext);
        this.requestControls = EMPTY_CONTROLS;
        this.responseControls = JndiUtils.toJndiControls(this.getDirectoryService().getLdapCodecService(), moveContext.getResponseControls());
    }

    protected void doRename(Dn oldDn, Rdn newRdn, boolean delOldRdn) throws Exception {
        RenameOperationContext renameContext = new RenameOperationContext(this.session, oldDn, newRdn, delOldRdn);
        renameContext.addRequestControls(this.convertControls(true, this.requestControls));
        this.injectReferralControl(renameContext);
        OperationManager operationManager = this.service.getOperationManager();
        operationManager.rename(renameContext);
        this.requestControls = EMPTY_CONTROLS;
        this.responseControls = JndiUtils.toJndiControls(this.getDirectoryService().getLdapCodecService(), renameContext.getResponseControls());
    }

    public CoreSession getSession() {
        return this.session;
    }

    public DirectoryService getDirectoryService() {
        return this.service;
    }

    public abstract ServerContext getRootContext() throws NamingException;

    public DirectoryService getService() {
        return this.service;
    }

    protected Dn getDn() {
        return this.dn;
    }

    @Override
    public void close() throws NamingException {
        for (DirectoryListener listener : this.listeners.values()) {
            try {
                this.service.getEventService().removeListener(listener);
            }
            catch (Exception e) {
                JndiUtils.wrap(e);
            }
        }
        this.listeners.clear();
    }

    @Override
    public String getNameInNamespace() throws NamingException {
        return this.dn.getName();
    }

    public Hashtable<String, Object> getEnvironment() {
        return this.env;
    }

    @Override
    public Object addToEnvironment(String propName, Object propVal) throws NamingException {
        return this.env.put(propName, propVal);
    }

    @Override
    public Object removeFromEnvironment(String propName) throws NamingException {
        return this.env.remove(propName);
    }

    @Override
    public Context createSubcontext(String name) throws NamingException {
        return this.createSubcontext(new LdapName(name));
    }

    @Override
    public Context createSubcontext(Name name) throws NamingException {
        Dn target = this.buildTarget(JndiUtils.fromName(name));
        Entry serverEntry = null;
        try {
            serverEntry = this.service.newEntry(target);
        }
        catch (LdapException le) {
            throw new NamingException(le.getMessage());
        }
        try {
            serverEntry.add("objectClass", "top", "javaContainer");
        }
        catch (LdapException le) {
            throw new SchemaViolationException(I18n.err(I18n.ERR_491, name));
        }
        Rdn rdn = target.getRdn();
        if (rdn != null) {
            if (!"2.5.4.3".equals(rdn.getNormType())) {
                throw new SchemaViolationException(I18n.err(I18n.ERR_491, name));
            }
        } else {
            throw new SchemaViolationException(I18n.err(I18n.ERR_491, name));
        }
        serverEntry.put(rdn.getUpType(), rdn.getUpValue());
        try {
            this.doAddOperation(target, serverEntry);
        }
        catch (Exception e) {
            JndiUtils.wrap(e);
        }
        ServerLdapContext ctx = null;
        try {
            ctx = new ServerLdapContext(this.service, this.session.getEffectivePrincipal(), JndiUtils.toName(target));
        }
        catch (Exception e) {
            JndiUtils.wrap(e);
        }
        return ctx;
    }

    @Override
    public void destroySubcontext(String name) throws NamingException {
        this.destroySubcontext(new LdapName(name));
    }

    @Override
    public void destroySubcontext(Name name) throws NamingException {
        Dn target = this.buildTarget(JndiUtils.fromName(name));
        if (target.size() == 0) {
            throw new NoPermissionException(I18n.err(I18n.ERR_492, new Object[0]));
        }
        try {
            this.doDeleteOperation(target);
        }
        catch (Exception e) {
            JndiUtils.wrap(e);
        }
    }

    @Override
    public void bind(String name, Object obj) throws NamingException {
        this.bind(new LdapName(name), obj);
    }

    private void injectRdnAttributeValues(Dn target, Entry serverEntry) throws NamingException {
        Rdn rdn = target.getRdn();
        if (rdn.size() == 1) {
            serverEntry.put(rdn.getUpType(), rdn.getUpValue());
        } else {
            for (Ava atav : rdn) {
                serverEntry.put(atav.getUpType(), atav.getUpValue());
            }
        }
    }

    @Override
    public void bind(Name name, Object obj) throws NamingException {
        DirStateFactory.Result res = DirectoryManager.getStateToBind(obj, name, this, this.env, null);
        Dn target = this.buildTarget(JndiUtils.fromName(name));
        Entry outServerEntry = null;
        try {
            outServerEntry = ServerEntryUtils.toServerEntry(AttributeUtils.toCaseInsensitive(res.getAttributes()), target, this.service.getSchemaManager());
        }
        catch (LdapInvalidAttributeTypeException liate) {
            throw new NamingException(I18n.err(I18n.ERR_495, obj));
        }
        if (outServerEntry != null) {
            try {
                this.doAddOperation(target, outServerEntry);
            }
            catch (Exception e) {
                JndiUtils.wrap(e);
            }
            return;
        }
        if (obj instanceof Entry) {
            try {
                this.doAddOperation(target, (Entry)obj);
            }
            catch (Exception e) {
                JndiUtils.wrap(e);
            }
        } else {
            if (obj instanceof Referenceable) {
                throw new NamingException(I18n.err(I18n.ERR_493, new Object[0]));
            }
            if (obj instanceof Reference) {
                throw new NamingException(I18n.err(I18n.ERR_494, new Object[0]));
            }
            if (obj instanceof Serializable) {
                Entry serverEntry = null;
                try {
                    serverEntry = this.service.newEntry(target);
                }
                catch (LdapException le) {
                    throw new NamingException(I18n.err(I18n.ERR_495, obj));
                }
                if (outServerEntry != null && outServerEntry.size() > 0) {
                    for (Attribute serverAttribute : outServerEntry) {
                        try {
                            serverEntry.put(serverAttribute);
                        }
                        catch (LdapException le) {
                            throw new NamingException(I18n.err(I18n.ERR_495, obj));
                        }
                    }
                }
                this.injectRdnAttributeValues(target, serverEntry);
                try {
                    JavaLdapSupport.serialize(serverEntry, obj, this.service.getSchemaManager());
                }
                catch (LdapException le) {
                    throw new NamingException(I18n.err(I18n.ERR_495, obj));
                }
                try {
                    this.doAddOperation(target, serverEntry);
                }
                catch (Exception e) {
                    JndiUtils.wrap(e);
                }
            } else if (obj instanceof DirContext) {
                Entry serverEntry = null;
                try {
                    serverEntry = ServerEntryUtils.toServerEntry(((DirContext)obj).getAttributes(""), target, this.service.getSchemaManager());
                }
                catch (LdapInvalidAttributeTypeException liate) {
                    throw new NamingException(I18n.err(I18n.ERR_495, obj));
                }
                if (outServerEntry != null && outServerEntry.size() > 0) {
                    for (Attribute serverAttribute : outServerEntry) {
                        try {
                            serverEntry.put(serverAttribute);
                        }
                        catch (LdapException le) {
                            throw new NamingException(I18n.err(I18n.ERR_495, obj));
                        }
                    }
                }
                this.injectRdnAttributeValues(target, serverEntry);
                try {
                    this.doAddOperation(target, serverEntry);
                }
                catch (Exception e) {
                    JndiUtils.wrap(e);
                }
            } else {
                throw new NamingException(I18n.err(I18n.ERR_495, obj));
            }
        }
    }

    @Override
    public void rename(String oldName, String newName) throws NamingException {
        this.rename(new LdapName(oldName), new LdapName(newName));
    }

    @Override
    public void rename(Name oldName, Name newName) throws NamingException {
        Dn oldDn = this.buildTarget(JndiUtils.fromName(oldName));
        Dn newDn = this.buildTarget(JndiUtils.fromName(newName));
        if (oldDn.size() == 0) {
            throw new NoPermissionException(I18n.err(I18n.ERR_312, new Object[0]));
        }
        Dn oldParent = oldDn;
        oldParent = oldParent.getParent();
        Dn newParent = newDn;
        newParent = newParent.getParent();
        Rdn oldRdn = oldDn.getRdn();
        Rdn newRdn = newDn.getRdn();
        boolean delOldRdn = true;
        if (null != this.env.get(DELETE_OLD_RDN_PROP)) {
            String delOldRdnStr = (String)this.env.get(DELETE_OLD_RDN_PROP);
            boolean bl = delOldRdn = !delOldRdnStr.equalsIgnoreCase("false") && !delOldRdnStr.equalsIgnoreCase("no") && !delOldRdnStr.equals("0");
        }
        if (oldParent.equals(newParent)) {
            try {
                this.doRename(oldDn, newRdn, delOldRdn);
            }
            catch (Exception e) {
                JndiUtils.wrap(e);
            }
        } else if (newRdn.equals(oldRdn)) {
            try {
                this.doMove(oldDn, newParent);
            }
            catch (Exception e) {
                JndiUtils.wrap(e);
            }
        } else {
            try {
                this.doMoveAndRenameOperation(oldDn, newParent, newRdn, delOldRdn);
            }
            catch (Exception e) {
                JndiUtils.wrap(e);
            }
        }
    }

    @Override
    public void rebind(String name, Object obj) throws NamingException {
        this.rebind(new LdapName(name), obj);
    }

    @Override
    public void rebind(Name name, Object obj) throws NamingException {
        Dn target = this.buildTarget(JndiUtils.fromName(name));
        OperationManager operationManager = this.service.getOperationManager();
        try {
            if (operationManager.hasEntry(new EntryOperationContext(this.session, target))) {
                this.doDeleteOperation(target);
            }
        }
        catch (Exception e) {
            JndiUtils.wrap(e);
        }
        this.bind(name, obj);
    }

    @Override
    public void unbind(String name) throws NamingException {
        this.unbind(new LdapName(name));
    }

    @Override
    public void unbind(Name name) throws NamingException {
        try {
            this.doDeleteOperation(this.buildTarget(JndiUtils.fromName(name)));
        }
        catch (Exception e) {
            JndiUtils.wrap(e);
        }
    }

    @Override
    public Object lookup(String name) throws NamingException {
        if (Strings.isEmpty(name)) {
            return this.lookup(new LdapName(""));
        }
        return this.lookup(new LdapName(name));
    }

    @Override
    public Object lookup(Name name) throws NamingException {
        Object obj;
        Dn target = this.buildTarget(JndiUtils.fromName(name));
        Entry serverEntry = null;
        try {
            serverEntry = name.size() == 0 ? this.doGetRootDSEOperation(target) : this.doLookupOperation(target);
        }
        catch (Exception e) {
            JndiUtils.wrap(e);
        }
        try {
            obj = DirectoryManager.getObjectInstance(null, name, this, this.env, ServerEntryUtils.toBasicAttributes(serverEntry));
        }
        catch (Exception e) {
            String msg = I18n.err(I18n.ERR_497, target);
            NamingException ne = new NamingException(msg);
            ne.setRootCause(e);
            throw ne;
        }
        if (obj != null) {
            return obj;
        }
        if (serverEntry.get("javaClassName") != null) {
            return JavaLdapSupport.deserialize(serverEntry);
        }
        ServerLdapContext ctx = null;
        try {
            ctx = new ServerLdapContext(this.service, this.session.getEffectivePrincipal(), JndiUtils.toName(target));
        }
        catch (Exception e) {
            JndiUtils.wrap(e);
        }
        return ctx;
    }

    @Override
    public Object lookupLink(String name) throws NamingException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object lookupLink(Name name) throws NamingException {
        throw new UnsupportedOperationException();
    }

    @Override
    public NameParser getNameParser(String name) throws NamingException {
        return new NameParser(){

            @Override
            public Name parse(String name) throws NamingException {
                try {
                    return JndiUtils.toName(new Dn(name));
                }
                catch (LdapInvalidDnException lide) {
                    throw new InvalidNameException(lide.getMessage());
                }
            }
        };
    }

    @Override
    public NameParser getNameParser(final Name name) throws NamingException {
        return new NameParser(){

            @Override
            public Name parse(String n) throws NamingException {
                try {
                    return JndiUtils.toName(new Dn(name.toString()));
                }
                catch (LdapInvalidDnException lide) {
                    throw new InvalidNameException(lide.getMessage());
                }
            }
        };
    }

    public NamingEnumeration list(String name) throws NamingException {
        return this.list(new LdapName(name));
    }

    public NamingEnumeration list(Name name) throws NamingException {
        try {
            return new NamingEnumerationAdapter(this.doListOperation(this.buildTarget(JndiUtils.fromName(name))));
        }
        catch (Exception e) {
            JndiUtils.wrap(e);
            return null;
        }
    }

    public NamingEnumeration listBindings(String name) throws NamingException {
        return this.listBindings(new LdapName(name));
    }

    public NamingEnumeration listBindings(Name name) throws NamingException {
        Dn base = this.buildTarget(JndiUtils.fromName(name));
        PresenceNode filter = new PresenceNode(this.OBJECT_CLASS_AT);
        SearchControls ctls = new SearchControls();
        ctls.setSearchScope(1);
        AliasDerefMode aliasDerefMode = AliasDerefMode.getEnum(this.getEnvironment());
        try {
            return new NamingEnumerationAdapter(this.doSearchOperation(base, aliasDerefMode, filter, ctls));
        }
        catch (Exception e) {
            JndiUtils.wrap(e);
            return null;
        }
    }

    @Override
    public String composeName(String name, String prefix) throws NamingException {
        return this.composeName(new LdapName(name), new LdapName(prefix)).toString();
    }

    @Override
    public Name composeName(Name name, Name prefix) throws NamingException {
        if (prefix == null || prefix.size() == 0) {
            return name;
        }
        Dn fqn = this.buildTarget(JndiUtils.fromName(name));
        try {
            return JndiUtils.toName(JndiUtils.fromName(prefix).add(fqn));
        }
        catch (LdapInvalidDnException lide) {
            throw new InvalidNameException(lide.getMessage());
        }
    }

    @Override
    public void addNamingListener(Name name, int scope, NamingListener namingListener) throws NamingException {
        PresenceNode filter = new PresenceNode(this.OBJECT_CLASS_AT);
        try {
            EventListenerAdapter listener = new EventListenerAdapter((ServerLdapContext)this, namingListener);
            NotificationCriteria criteria = new NotificationCriteria();
            criteria.setFilter(filter);
            criteria.setScope(SearchScope.getSearchScope(scope));
            criteria.setAliasDerefMode(AliasDerefMode.getEnum(this.env));
            criteria.setBase(this.buildTarget(JndiUtils.fromName(name)));
            this.service.getEventService().addListener(listener, criteria);
            this.listeners.put(namingListener, listener);
        }
        catch (Exception e) {
            JndiUtils.wrap(e);
        }
    }

    @Override
    public void addNamingListener(String name, int scope, NamingListener namingListener) throws NamingException {
        this.addNamingListener(new LdapName(name), scope, namingListener);
    }

    @Override
    public void removeNamingListener(NamingListener namingListener) throws NamingException {
        try {
            DirectoryListener listener = this.listeners.remove(namingListener);
            if (listener != null) {
                this.service.getEventService().removeListener(listener);
            }
        }
        catch (Exception e) {
            JndiUtils.wrap(e);
        }
    }

    @Override
    public boolean targetMustExist() throws NamingException {
        return false;
    }

    protected Map<NamingListener, DirectoryListener> getListeners() {
        return this.listeners;
    }

    Dn buildTarget(Dn relativeName) throws NamingException {
        Dn target = this.dn;
        try {
            target = target.add(relativeName);
            target.apply(this.schemaManager);
        }
        catch (LdapInvalidDnException lide) {
            throw new InvalidNameException(lide.getMessage());
        }
        return target;
    }

    static {
        ADS_CONTROLS.put("1.3.6.1.4.1.18060.0.0.1", ControlEnum.CASCADE_CONTROL);
        ADS_CONTROLS.put("2.16.840.1.113730.3.4.7", ControlEnum.ENTRY_CHANGE_CONTROL);
        ADS_CONTROLS.put("2.16.840.1.113730.3.4.2", ControlEnum.MANAGE_DSA_IT_CONTROL);
        ADS_CONTROLS.put("1.2.840.113556.1.4.319", ControlEnum.PAGED_RESULTS_CONTROL);
        ADS_CONTROLS.put("1.3.6.1.4.1.42.2.27.8.5.1", ControlEnum.PASSWORD_POLICY_REQUEST_CONTROL);
        ADS_CONTROLS.put("2.16.840.1.113730.3.4.3", ControlEnum.PERSISTENT_SEARCH_CONTROL);
        ADS_CONTROLS.put("1.3.6.1.4.1.4203.1.10.1", ControlEnum.SUBENTRIES_CONTROL);
        ADS_CONTROLS.put("1.3.6.1.4.1.4203.1.9.1.3", ControlEnum.SYNC_DONE_VALUE_CONTROL);
        ADS_CONTROLS.put("1.3.6.1.4.1.4203.1.9.1.4", ControlEnum.SYNC_INFO_VALUE_CONTROL);
        ADS_CONTROLS.put("1.3.6.1.4.1.4203.1.9.1.5", ControlEnum.SYNC_MODIFY_DN_CONTROL);
        ADS_CONTROLS.put("1.3.6.1.4.1.4203.1.9.1.1", ControlEnum.SYNC_REQUEST_VALUE_CONTROL);
        ADS_CONTROLS.put("1.3.6.1.4.1.4203.1.9.1.2", ControlEnum.SYNC_STATE_VALUE_CONTROL);
    }
}

