/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.interceptor.context;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.directory.server.core.CoreSession;
import org.apache.directory.server.core.LdapPrincipal;
import org.apache.directory.server.core.interceptor.context.AddOperationContext;
import org.apache.directory.server.core.interceptor.context.DeleteOperationContext;
import org.apache.directory.server.core.interceptor.context.EntryOperationContext;
import org.apache.directory.server.core.interceptor.context.LookupOperationContext;
import org.apache.directory.server.core.interceptor.context.ModifyOperationContext;
import org.apache.directory.server.core.interceptor.context.OperationContext;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.shared.ldap.model.entry.Entry;
import org.apache.directory.shared.ldap.model.entry.Modification;
import org.apache.directory.shared.ldap.model.exception.LdapException;
import org.apache.directory.shared.ldap.model.message.Control;
import org.apache.directory.shared.ldap.model.name.Dn;

public abstract class AbstractOperationContext
implements OperationContext {
    protected static final Control[] EMPTY_CONTROLS = new Control[0];
    protected Dn dn;
    protected Entry entry;
    protected Entry originalEntry;
    protected Map<String, Control> requestControls = new HashMap<String, Control>(4);
    protected Map<String, Control> responseControls = new HashMap<String, Control>(4);
    protected Collection<String> byPassed;
    protected LdapPrincipal authorizedPrincipal;
    protected CoreSession session;
    protected OperationContext next;
    protected OperationContext previous;
    protected boolean throwReferral;

    public AbstractOperationContext(CoreSession session) {
        this.session = session;
    }

    public AbstractOperationContext(CoreSession session, Dn dn) {
        this.dn = dn;
        this.session = session;
        this.ignoreReferral();
    }

    @Override
    public CoreSession getSession() {
        return this.session;
    }

    public void setSession(CoreSession session) {
        this.session = session;
    }

    protected void setAuthorizedPrincipal(LdapPrincipal authorizedPrincipal) {
        this.authorizedPrincipal = authorizedPrincipal;
    }

    @Override
    public Dn getDn() {
        return this.dn;
    }

    @Override
    public void setDn(Dn dn) {
        this.dn = dn;
    }

    @Override
    public void addRequestControl(Control requestControl) {
        this.requestControls.put(requestControl.getOid(), requestControl);
    }

    @Override
    public Control getRequestControl(String numericOid) {
        return this.requestControls.get(numericOid);
    }

    @Override
    public boolean hasRequestControl(String numericOid) {
        return this.requestControls.containsKey(numericOid);
    }

    @Override
    public boolean hasRequestControls() {
        return !this.requestControls.isEmpty();
    }

    @Override
    public void addResponseControl(Control responseControl) {
        this.responseControls.put(responseControl.getOid(), responseControl);
    }

    @Override
    public Control getResponseControl(String numericOid) {
        return this.responseControls.get(numericOid);
    }

    @Override
    public boolean hasResponseControl(String numericOid) {
        return this.responseControls.containsKey(numericOid);
    }

    @Override
    public Control[] getResponseControls() {
        if (this.responseControls.isEmpty()) {
            return EMPTY_CONTROLS;
        }
        return this.responseControls.values().toArray(EMPTY_CONTROLS);
    }

    @Override
    public boolean hasResponseControls() {
        return !this.responseControls.isEmpty();
    }

    @Override
    public int getResponseControlCount() {
        return this.responseControls.size();
    }

    @Override
    public void addRequestControls(Control[] requestControls) {
        for (Control c : requestControls) {
            this.requestControls.put(c.getOid(), c);
        }
    }

    public void setRequestControls(Map<String, Control> requestControls) {
        this.requestControls = requestControls;
    }

    @Override
    public abstract String getName();

    public Entry getOriginalEntry() {
        return this.originalEntry;
    }

    public void setOriginalEntry(Entry originalEntry) {
        this.originalEntry = originalEntry;
    }

    @Override
    public Collection<String> getByPassed() {
        if (this.byPassed == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableCollection(this.byPassed);
    }

    @Override
    public void setByPassed(Collection<String> byPassed) {
        this.byPassed = byPassed;
    }

    @Override
    public boolean isBypassed(String interceptorName) {
        return this.byPassed != null && this.byPassed.contains(interceptorName);
    }

    @Override
    public boolean hasBypass() {
        return this.byPassed != null && !this.byPassed.isEmpty();
    }

    private void setup(AbstractOperationContext opContext) {
        opContext.setPreviousOperation(this);
        this.next = opContext;
        opContext.setByPassed(this.byPassed);
        opContext.setAuthorizedPrincipal(this.authorizedPrincipal);
    }

    @Override
    public boolean hasEntry(Dn dn, Collection<String> byPassed) throws LdapException {
        EntryOperationContext hasEntryContext = new EntryOperationContext(this.session, dn);
        this.setup(hasEntryContext);
        hasEntryContext.setByPassed(byPassed);
        return this.session.getDirectoryService().getOperationManager().hasEntry(hasEntryContext);
    }

    @Override
    public void add(Entry entry, Collection<String> byPassed) throws LdapException {
        AddOperationContext addContext = new AddOperationContext(this.session, entry);
        this.setup(addContext);
        addContext.setByPassed(byPassed);
        this.session.getDirectoryService().getOperationManager().add(addContext);
    }

    @Override
    public void delete(Dn dn, Collection<String> byPassed) throws LdapException {
        DeleteOperationContext deleteContext = new DeleteOperationContext(this.session, dn);
        this.setup(deleteContext);
        deleteContext.setByPassed(byPassed);
        this.session.getDirectoryService().getOperationManager().delete(deleteContext);
    }

    @Override
    public void modify(Dn dn, List<Modification> mods, Collection<String> byPassed) throws LdapException {
        ModifyOperationContext modifyContext = new ModifyOperationContext(this.session, dn, mods);
        this.setup(modifyContext);
        modifyContext.setByPassed(byPassed);
        this.session.getDirectoryService().getOperationManager().modify(modifyContext);
    }

    @Override
    public LookupOperationContext newLookupContext(Dn dn) {
        LookupOperationContext lookupContext = new LookupOperationContext(this.session, dn);
        this.setup(lookupContext);
        return lookupContext;
    }

    @Override
    public Entry lookup(LookupOperationContext lookupContext) throws LdapException {
        if (lookupContext != this.next) {
            throw new IllegalStateException(I18n.err(I18n.ERR_319, new Object[0]));
        }
        return this.session.getDirectoryService().getOperationManager().lookup(lookupContext);
    }

    @Override
    public Entry lookup(Dn dn, Collection<String> byPassed) throws LdapException {
        LookupOperationContext lookupContext = this.newLookupContext(dn);
        lookupContext.setByPassed(byPassed);
        return this.session.getDirectoryService().getOperationManager().lookup(lookupContext);
    }

    @Override
    public Entry lookup(Dn dn, Collection<String> byPassed, String ... attrIds) throws LdapException {
        LookupOperationContext lookupContext = this.newLookupContext(dn);
        lookupContext.setByPassed(byPassed);
        lookupContext.setAttrsId(attrIds);
        return this.session.getDirectoryService().getOperationManager().lookup(lookupContext);
    }

    @Override
    public LdapPrincipal getEffectivePrincipal() {
        if (this.authorizedPrincipal != null) {
            return this.authorizedPrincipal;
        }
        return this.session.getEffectivePrincipal();
    }

    @Override
    public boolean isFirstOperation() {
        return this.previous == null;
    }

    @Override
    public OperationContext getFirstOperation() {
        if (this.previous == null) {
            return this;
        }
        return this.previous.getFirstOperation();
    }

    @Override
    public OperationContext getLastOperation() {
        if (this.next == null) {
            return this;
        }
        return this.next.getLastOperation();
    }

    @Override
    public OperationContext getNextOperation() {
        return this.next;
    }

    protected void setNextOperation(OperationContext next) {
        this.next = next;
    }

    @Override
    public OperationContext getPreviousOperation() {
        return this.previous;
    }

    protected void setPreviousOperation(OperationContext previous) {
        this.previous = previous;
    }

    @Override
    public void setEntry(Entry entry) {
        this.entry = entry;
    }

    @Override
    public Entry getEntry() {
        return this.entry;
    }

    @Override
    public void throwReferral() {
        this.throwReferral = true;
    }

    @Override
    public boolean isReferralThrown() {
        return this.throwReferral;
    }

    @Override
    public void ignoreReferral() {
        this.throwReferral = false;
    }

    @Override
    public boolean isReferralIgnored() {
        return !this.throwReferral;
    }
}

