/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.hash;

import java.util.List;
import org.apache.directory.server.core.authn.PasswordUtil;
import org.apache.directory.server.core.interceptor.BaseInterceptor;
import org.apache.directory.server.core.interceptor.NextInterceptor;
import org.apache.directory.server.core.interceptor.context.AddOperationContext;
import org.apache.directory.server.core.interceptor.context.ModifyOperationContext;
import org.apache.directory.shared.ldap.model.constants.LdapSecurityConstants;
import org.apache.directory.shared.ldap.model.entry.Attribute;
import org.apache.directory.shared.ldap.model.entry.BinaryValue;
import org.apache.directory.shared.ldap.model.entry.Entry;
import org.apache.directory.shared.ldap.model.entry.Modification;
import org.apache.directory.shared.ldap.model.exception.LdapException;

public class PasswordHashingInterceptor
extends BaseInterceptor {
    private LdapSecurityConstants algorithm;

    public PasswordHashingInterceptor() {
        this(null);
    }

    public PasswordHashingInterceptor(LdapSecurityConstants algorithm) {
        this.algorithm = algorithm;
    }

    @Override
    public void add(NextInterceptor next, AddOperationContext addContext) throws LdapException {
        if (this.algorithm == null) {
            next.add(addContext);
            return;
        }
        Entry entry = addContext.getEntry();
        Attribute pwdAt = entry.get("userPassword");
        this.includeHashedPassword(pwdAt);
        next.add(addContext);
    }

    @Override
    public void modify(NextInterceptor next, ModifyOperationContext modifyContext) throws LdapException {
        if (this.algorithm == null) {
            next.modify(modifyContext);
            return;
        }
        List<Modification> mods = modifyContext.getModItems();
        for (Modification mod : mods) {
            String oid = mod.getAttribute().getAttributeType().getOid();
            if (!"2.5.4.35".equals(oid)) continue;
            this.includeHashedPassword(mod.getAttribute());
            break;
        }
        next.modify(modifyContext);
    }

    private void includeHashedPassword(Attribute pwdAt) throws LdapException {
        if (pwdAt == null) {
            return;
        }
        BinaryValue userPassword = (BinaryValue)pwdAt.get();
        LdapSecurityConstants existingAlgo = PasswordUtil.findAlgorithm(userPassword.getValue());
        if (existingAlgo == null) {
            byte[] hashedPassword = PasswordUtil.createStoragePassword(userPassword.getValue(), this.algorithm);
            pwdAt.clear();
            pwdAt.add(new byte[][]{hashedPassword});
        }
    }
}

