/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.changelog;

import java.util.Date;

public class Tag {
    private final long revision;
    private final String description;
    private Date tagDate;
    private Date revisionDate;

    public Tag(long revision, String description) {
        this.revision = revision;
        this.description = description;
        this.tagDate = new Date();
    }

    public Tag(long revision, String description, Date tagDate, Date revisionDate) {
        this.revision = revision;
        this.description = description;
        this.tagDate = tagDate;
        this.revisionDate = revisionDate;
    }

    public Tag(long revision, String description, long tagTime, long revisionTime) {
        this.revision = revision;
        this.description = description;
        this.tagDate = new Date(tagTime);
        if (revisionTime > 0L) {
            this.revisionDate = new Date(revisionTime);
        }
    }

    public long getRevision() {
        return this.revision;
    }

    public String getDescription() {
        return this.description;
    }

    public Date getTagDate() {
        return this.tagDate;
    }

    public Date getRevisionDate() {
        return this.revisionDate;
    }

    public int hashCode() {
        int hash = 37;
        if (this.description != null) {
            hash = hash * 17 + this.description.hashCode();
        }
        hash = hash * 17 + Long.valueOf(this.revision).hashCode();
        return hash;
    }

    public boolean equals(Object other) {
        if (other instanceof Tag) {
            Tag ot = (Tag)other;
            if (this.description != null && ot.getDescription() != null) {
                return this.revision == ot.getRevision() && this.description.equals(ot.getDescription());
            }
            if (this.description == null && ot.getDescription() == null) {
                return this.revision == ot.getRevision();
            }
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Tag { ");
        sb.append("revision = ").append(this.revision).append(", ");
        sb.append(" tagDate = ").append(this.tagDate).append(", ");
        sb.append(" revisionDate = ").append(this.revisionDate);
        sb.append(" }");
        return sb.toString();
    }
}

