/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server;

import java.io.File;
import org.apache.directory.server.core.AbstractLayout;

public class InstallationLayout
extends AbstractLayout {
    public InstallationLayout(File installationDirectory) {
        super(installationDirectory);
        this.init();
    }

    public InstallationLayout(String installationDirectoryPath) {
        super(installationDirectoryPath);
        this.init();
    }

    private void init() {
        File[] requiredDirectories = new File[]{this.getInstallationDirectory(), this.getBinDirectory(), this.getConfDirectory(), this.getLibDirectory()};
        this.setRequiredDirectories(requiredDirectories);
        File[] requiredFiles = new File[]{this.getScriptFile(), this.getWrapperFile(), this.getWrapperConfigurationFile()};
        this.setRequiredFiles(requiredFiles);
    }

    public File getBinDirectory() {
        return new File(this.getInstallationDirectory(), "bin");
    }

    public File getConfDirectory() {
        return new File(this.getInstallationDirectory(), "conf");
    }

    public File getInstallationDirectory() {
        return this.getDirectory();
    }

    public File getLibDirectory() {
        return new File(this.getInstallationDirectory(), "lib");
    }

    public File getLicenseFile() {
        return new File(this.getInstallationDirectory(), "LICENSE");
    }

    public File getNoticeFile() {
        return new File(this.getInstallationDirectory(), "NOTICE");
    }

    public File getScriptFile() {
        return new File(this.getBinDirectory(), "apacheds");
    }

    public File getWrapperConfigurationFile() {
        return new File(this.getConfDirectory(), "wrapper.conf");
    }

    public File getWrapperFile() {
        return new File(this.getBinDirectory(), "wrapper");
    }
}

