/*
 * Decompiled with CFR 0.152.
 */
package jdbm.btree;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import jdbm.btree.BTree;
import jdbm.helper.Serializer;
import jdbm.helper.Tuple;
import jdbm.helper.TupleBrowser;
import org.apache.directory.server.i18n.I18n;

public class BPage<K, V>
implements Serializer {
    private static final boolean DEBUG = false;
    static final long serialVersionUID = 1L;
    transient BTree<K, V> btree;
    protected transient long recordId;
    protected boolean isLeaf;
    protected K[] keys;
    protected V[] values;
    protected long[] children;
    protected int first;
    protected long previous;
    protected long next;

    public BPage() {
    }

    BPage(BTree btree, BPage<K, V> root, BPage<K, V> overflow) throws IOException {
        this.btree = btree;
        this.isLeaf = false;
        this.first = btree.pageSize - 2;
        this.keys = new Object[btree.pageSize];
        this.keys[btree.pageSize - 2] = overflow.getLargestKey();
        this.keys[btree.pageSize - 1] = root.getLargestKey();
        this.children = new long[btree.pageSize];
        this.children[btree.pageSize - 2] = overflow.recordId;
        this.children[btree.pageSize - 1] = root.recordId;
        this.recordId = btree.recordManager.insert(this, this);
    }

    BPage(BTree btree, K key, V value) throws IOException {
        this.btree = btree;
        this.isLeaf = true;
        this.first = btree.pageSize - 2;
        this.keys = new Object[btree.pageSize];
        this.keys[btree.pageSize - 2] = key;
        this.keys[btree.pageSize - 1] = null;
        this.values = new Object[btree.pageSize];
        this.values[btree.pageSize - 2] = value;
        this.values[btree.pageSize - 1] = null;
        this.recordId = btree.recordManager.insert(this, this);
    }

    BPage(BTree btree, boolean isLeaf) throws IOException {
        this.btree = btree;
        this.isLeaf = isLeaf;
        this.first = btree.pageSize / 2;
        this.keys = new Object[btree.pageSize];
        if (isLeaf) {
            this.values = new Object[btree.pageSize];
        } else {
            this.children = new long[btree.pageSize];
        }
        this.recordId = btree.recordManager.insert(this, this);
    }

    K getLargestKey() {
        return this.keys[this.btree.pageSize - 1];
    }

    public long getRecordId() {
        return this.recordId;
    }

    public void setRecordId(long recordId) {
        this.recordId = recordId;
    }

    boolean isEmpty() {
        if (this.isLeaf) {
            return this.first == this.values.length - 1;
        }
        return this.first == this.children.length - 1;
    }

    boolean isFull() {
        return this.first == 0;
    }

    TupleBrowser<K, V> find(int height, K key) throws IOException {
        int index = this.findChildren(key);
        if (index < 0) {
            index = -(index + 1);
        }
        BPage<K, V> child = this;
        while (!child.isLeaf) {
            if ((index = super.findChildren(key)) >= 0) continue;
            index = -(index + 1);
        }
        return new Browser(child, index);
    }

    TupleBrowser<K, V> findFirst() throws IOException {
        if (this.isLeaf) {
            return new Browser(this, this.first);
        }
        BPage<K, V> child = this.childBPage(this.first);
        return child.findFirst();
    }

    InsertResult<K, V> insert(int height, K key, V value, boolean replace) throws IOException {
        long overflow;
        InsertResult result;
        boolean keyExists;
        int index = this.findChildren(key);
        boolean bl = keyExists = index < 0;
        if (index < 0) {
            index = -(index + 1);
        }
        if (--height == 0) {
            result = new InsertResult();
            overflow = -1L;
            if (keyExists) {
                result.existing = this.values[index];
                if (replace) {
                    this.values[index] = value;
                    this.btree.recordManager.update(this.recordId, this, this);
                }
                return result;
            }
        } else {
            BPage<K, V> child = this.childBPage(index);
            result = child.insert(height, key, value, replace);
            if (result.existing != null) {
                return result;
            }
            if (result.overflow == null) {
                return result;
            }
            key = result.overflow.getLargestKey();
            overflow = result.overflow.recordId;
            this.keys[index] = child.getLargestKey();
            result.overflow = null;
        }
        if (!this.isFull()) {
            if (height == 0) {
                this.insertEntry(this, index - 1, key, value);
            } else {
                this.insertChild(this, index - 1, key, overflow);
            }
            this.btree.recordManager.update(this.recordId, this, this);
            return result;
        }
        int half = this.btree.pageSize >> 1;
        BPage<K, V> newPage = new BPage<K, V>(this.btree, this.isLeaf);
        if (index < half) {
            if (height == 0) {
                this.copyEntries(this, 0, newPage, half, index);
                this.setEntry(newPage, half + index, key, value);
                this.copyEntries(this, index, newPage, half + index + 1, half - index - 1);
            } else {
                this.copyChildren(this, 0, newPage, half, index);
                this.setChild(newPage, half + index, key, overflow);
                this.copyChildren(this, index, newPage, half + index + 1, half - index - 1);
            }
        } else if (height == 0) {
            this.copyEntries(this, 0, newPage, half, half);
            this.copyEntries(this, half, this, half - 1, index - half);
            this.setEntry(this, index - 1, key, value);
        } else {
            this.copyChildren(this, 0, newPage, half, half);
            this.copyChildren(this, half, this, half - 1, index - half);
            this.setChild(this, index - 1, key, overflow);
        }
        this.first = half - 1;
        for (int i = 0; i < this.first; ++i) {
            if (height == 0) {
                this.setEntry(this, i, null, null);
                continue;
            }
            this.setChild(this, i, null, -1L);
        }
        if (this.isLeaf) {
            newPage.previous = this.previous;
            newPage.next = this.recordId;
            if (this.previous != 0L) {
                BPage<K, V> previousBPage = this.loadBPage(this.previous);
                previousBPage.next = newPage.recordId;
                this.btree.recordManager.update(this.previous, previousBPage, this);
            }
            this.previous = newPage.recordId;
        }
        this.btree.recordManager.update(this.recordId, this, this);
        this.btree.recordManager.update(newPage.recordId, newPage, this);
        result.overflow = newPage;
        return result;
    }

    RemoveResult<V> remove(int height, K key) throws IOException {
        RemoveResult result;
        boolean keyExists;
        int half = this.btree.pageSize / 2;
        int index = this.findChildren(key);
        boolean bl = keyExists = index < 0;
        if (index < 0) {
            index = -(index + 1);
        }
        if (--height == 0) {
            if (!keyExists) {
                throw new IllegalArgumentException(I18n.err(I18n.ERR_514, key));
            }
            result = new RemoveResult();
            result.value = this.values[index];
            this.removeEntry(this, index);
            this.btree.recordManager.update(this.recordId, this, this);
        } else {
            BPage<K, V> child = this.childBPage(index);
            result = child.remove(height, key);
            this.keys[index] = child.getLargestKey();
            this.btree.recordManager.update(this.recordId, this, this);
            if (result.underflow) {
                if (child.first != half + 1) {
                    throw new IllegalStateException(I18n.err(I18n.ERR_513, "1"));
                }
                if (index < this.children.length - 1) {
                    BPage<K, V> brother = this.childBPage(index + 1);
                    int bfirst = brother.first;
                    if (bfirst < half) {
                        int steal = (half - bfirst + 1) / 2;
                        brother.first += steal;
                        child.first -= steal;
                        if (child.isLeaf) {
                            this.copyEntries(child, half + 1, child, half + 1 - steal, half - 1);
                            this.copyEntries(brother, bfirst, child, 2 * half - steal, steal);
                        } else {
                            this.copyChildren(child, half + 1, child, half + 1 - steal, half - 1);
                            this.copyChildren(brother, bfirst, child, 2 * half - steal, steal);
                        }
                        for (int i = bfirst; i < bfirst + steal; ++i) {
                            if (brother.isLeaf) {
                                this.setEntry(brother, i, null, null);
                                continue;
                            }
                            this.setChild(brother, i, null, -1L);
                        }
                        this.keys[index] = child.getLargestKey();
                        this.btree.recordManager.update(this.recordId, this, this);
                        this.btree.recordManager.update(brother.recordId, brother, this);
                        this.btree.recordManager.update(child.recordId, child, this);
                    } else {
                        if (brother.first != half) {
                            throw new IllegalStateException(I18n.err(I18n.ERR_513, "2"));
                        }
                        brother.first = 1;
                        if (child.isLeaf) {
                            this.copyEntries(child, half + 1, brother, 1, half - 1);
                        } else {
                            this.copyChildren(child, half + 1, brother, 1, half - 1);
                        }
                        this.btree.recordManager.update(brother.recordId, brother, this);
                        if (this.isLeaf) {
                            this.copyEntries(this, this.first, this, this.first + 1, index - this.first);
                            this.setEntry(this, this.first, null, null);
                        } else {
                            this.copyChildren(this, this.first, this, this.first + 1, index - this.first);
                            this.setChild(this, this.first, null, -1L);
                        }
                        ++this.first;
                        this.btree.recordManager.update(this.recordId, this, this);
                        if (child.previous != 0L) {
                            BPage<K, V> prev = this.loadBPage(child.previous);
                            prev.next = child.next;
                            this.btree.recordManager.update(prev.recordId, prev, this);
                        }
                        if (child.next != 0L) {
                            BPage<K, V> next = this.loadBPage(child.next);
                            next.previous = child.previous;
                            this.btree.recordManager.update(next.recordId, next, this);
                        }
                        this.btree.recordManager.delete(child.recordId);
                    }
                } else {
                    BPage<K, V> brother = this.childBPage(index - 1);
                    int bfirst = brother.first;
                    if (bfirst < half) {
                        int steal = (half - bfirst + 1) / 2;
                        brother.first += steal;
                        child.first -= steal;
                        if (child.isLeaf) {
                            this.copyEntries(brother, 2 * half - steal, child, half + 1 - steal, steal);
                            this.copyEntries(brother, bfirst, brother, bfirst + steal, 2 * half - bfirst - steal);
                        } else {
                            this.copyChildren(brother, 2 * half - steal, child, half + 1 - steal, steal);
                            this.copyChildren(brother, bfirst, brother, bfirst + steal, 2 * half - bfirst - steal);
                        }
                        for (int i = bfirst; i < bfirst + steal; ++i) {
                            if (brother.isLeaf) {
                                this.setEntry(brother, i, null, null);
                                continue;
                            }
                            this.setChild(brother, i, null, -1L);
                        }
                        this.keys[index - 1] = brother.getLargestKey();
                        this.btree.recordManager.update(this.recordId, this, this);
                        this.btree.recordManager.update(brother.recordId, brother, this);
                        this.btree.recordManager.update(child.recordId, child, this);
                    } else {
                        if (brother.first != half) {
                            throw new IllegalStateException(I18n.err(I18n.ERR_513, "3"));
                        }
                        child.first = 1;
                        if (child.isLeaf) {
                            this.copyEntries(brother, half, child, 1, half);
                        } else {
                            this.copyChildren(brother, half, child, 1, half);
                        }
                        this.btree.recordManager.update(child.recordId, child, this);
                        if (this.isLeaf) {
                            this.copyEntries(this, this.first, this, this.first + 1, index - 1 - this.first);
                            this.setEntry(this, this.first, null, null);
                        } else {
                            this.copyChildren(this, this.first, this, this.first + 1, index - 1 - this.first);
                            this.setChild(this, this.first, null, -1L);
                        }
                        ++this.first;
                        this.btree.recordManager.update(this.recordId, this, this);
                        if (brother.previous != 0L) {
                            BPage<K, V> prev = this.loadBPage(brother.previous);
                            prev.next = brother.next;
                            this.btree.recordManager.update(prev.recordId, prev, this);
                        }
                        if (brother.next != 0L) {
                            BPage<K, V> next = this.loadBPage(brother.next);
                            next.previous = brother.previous;
                            this.btree.recordManager.update(next.recordId, next, this);
                        }
                        this.btree.recordManager.delete(brother.recordId);
                    }
                }
            }
        }
        result.underflow = this.first > half;
        return result;
    }

    private int findChildren(K key) {
        int left = this.first;
        int right = this.btree.pageSize - 1;
        while (left < right) {
            int middle = left + right >>> 1;
            int comp = this.compare(this.keys[middle], key);
            if (comp < 0) {
                left = middle + 1;
                continue;
            }
            if (comp > 0) {
                right = middle;
                continue;
            }
            return -middle - 1;
        }
        if (left == right && this.compare(this.keys[left], key) == 0) {
            return -right - 1;
        }
        return right;
    }

    private void insertEntry(BPage<K, V> page, int index, K key, V value) {
        K[] keys = page.keys;
        V[] values = page.values;
        int start = page.first;
        int count = index - page.first + 1;
        System.arraycopy(keys, start, keys, start - 1, count);
        System.arraycopy(values, start, values, start - 1, count);
        --page.first;
        keys[index] = key;
        values[index] = value;
    }

    private void insertChild(BPage<K, V> page, int index, K key, long child) {
        K[] keys = page.keys;
        long[] children = page.children;
        int start = page.first;
        int count = index - page.first + 1;
        System.arraycopy(keys, start, keys, start - 1, count);
        System.arraycopy(children, start, children, start - 1, count);
        --page.first;
        keys[index] = key;
        children[index] = child;
    }

    private void removeEntry(BPage<K, V> page, int index) {
        K[] keys = page.keys;
        V[] values = page.values;
        int start = page.first;
        int count = index - page.first;
        System.arraycopy(keys, start, keys, start + 1, count);
        keys[start] = null;
        System.arraycopy(values, start, values, start + 1, count);
        values[start] = null;
        ++page.first;
    }

    private void setEntry(BPage<K, V> page, int index, K key, V value) {
        page.keys[index] = key;
        page.values[index] = value;
    }

    private void setChild(BPage<K, V> page, int index, K key, long recid) {
        page.keys[index] = key;
        page.children[index] = recid;
    }

    private void copyEntries(BPage<K, V> source, int indexSource, BPage<K, V> dest, int indexDest, int count) {
        System.arraycopy(source.keys, indexSource, dest.keys, indexDest, count);
        System.arraycopy(source.values, indexSource, dest.values, indexDest, count);
    }

    private void copyChildren(BPage<K, V> source, int indexSource, BPage<K, V> dest, int indexDest, int count) {
        System.arraycopy(source.keys, indexSource, dest.keys, indexDest, count);
        System.arraycopy(source.children, indexSource, dest.children, indexDest, count);
    }

    BPage<K, V> childBPage(int index) throws IOException {
        return this.loadBPage(this.children[index]);
    }

    private BPage<K, V> loadBPage(long recid) throws IOException {
        BPage child = (BPage)this.btree.recordManager.fetch(recid, this);
        child.recordId = recid;
        child.btree = this.btree;
        return child;
    }

    private final int compare(K value1, K value2) {
        if (value1 == value2) {
            return 0;
        }
        if (value1 == null) {
            return 1;
        }
        if (value2 == null) {
            return -1;
        }
        return this.btree.getComparator().compare(value1, value2);
    }

    static byte[] readByteArray(ObjectInput in) throws IOException {
        int len = in.readInt();
        if (len < 0) {
            return null;
        }
        byte[] buf = new byte[len];
        in.readFully(buf);
        return buf;
    }

    static void writeByteArray(ObjectOutput out, byte[] buf) throws IOException {
        if (buf == null) {
            out.writeInt(-1);
        } else {
            out.writeInt(buf.length);
            out.write(buf);
        }
    }

    private void dump(int height) {
        int i;
        String prefix = "";
        for (i = 0; i < height; ++i) {
            prefix = prefix + "    ";
        }
        System.out.println(prefix + "-------------------------------------- BPage recordId=" + this.recordId);
        System.out.println(prefix + "first=" + this.first);
        for (i = 0; i < this.btree.pageSize; ++i) {
            if (this.isLeaf) {
                System.out.println(prefix + "BPage [" + i + "] " + this.keys[i] + " " + this.values[i]);
                continue;
            }
            System.out.println(prefix + "BPage [" + i + "] " + this.keys[i] + " " + this.children[i]);
        }
        System.out.println(prefix + "--------------------------------------");
    }

    void dumpRecursive(int height, int level) throws IOException {
        ++level;
        if (--height > 0) {
            for (int i = this.first; i < this.btree.pageSize && this.keys[i] != null; ++i) {
                BPage<K, V> child = this.childBPage(i);
                super.dump(level);
                child.dumpRecursive(height, level);
            }
        }
    }

    private void assertConsistency() {
        for (int i = this.first; i < this.btree.pageSize - 1; ++i) {
            if (this.compare(this.keys[i], this.keys[i + 1]) < 0) continue;
            this.dump(0);
            throw new Error(I18n.err(I18n.ERR_515, new Object[0]));
        }
    }

    void assertConsistencyRecursive(int height) throws IOException {
        this.assertConsistency();
        if (--height > 0) {
            for (int i = this.first; i < this.btree.pageSize && this.keys[i] != null; ++i) {
                BPage<K, V> child = this.childBPage(i);
                if (this.compare(this.keys[i], child.getLargestKey()) != 0) {
                    this.dump(0);
                    super.dump(0);
                    throw new Error(I18n.err(I18n.ERR_516, new Object[0]));
                }
                child.assertConsistencyRecursive(height);
            }
        }
    }

    @Override
    public BPage<K, V> deserialize(byte[] serialized) throws IOException {
        int i;
        BPage<K, V> bpage = new BPage<K, V>();
        ByteArrayInputStream bais = new ByteArrayInputStream(serialized);
        ObjectInputStream ois = new ObjectInputStream(bais);
        bpage.isLeaf = ois.readBoolean();
        if (bpage.isLeaf) {
            bpage.previous = ois.readLong();
            bpage.next = ois.readLong();
        }
        bpage.first = ois.readInt();
        bpage.keys = new Object[this.btree.pageSize];
        try {
            for (i = bpage.first; i < this.btree.pageSize; ++i) {
                if (this.btree.keySerializer == null) {
                    bpage.keys[i] = ois.readObject();
                    continue;
                }
                serialized = BPage.readByteArray(ois);
                if (serialized == null) continue;
                bpage.keys[i] = this.btree.keySerializer.deserialize(serialized);
            }
        }
        catch (ClassNotFoundException except) {
            throw new IOException(except.getLocalizedMessage());
        }
        if (bpage.isLeaf) {
            bpage.values = new Object[this.btree.pageSize];
            try {
                for (i = bpage.first; i < this.btree.pageSize; ++i) {
                    if (this.btree.valueSerializer == null) {
                        bpage.values[i] = ois.readObject();
                        continue;
                    }
                    serialized = BPage.readByteArray(ois);
                    if (serialized == null) continue;
                    bpage.values[i] = this.btree.valueSerializer.deserialize(serialized);
                }
            }
            catch (ClassNotFoundException except) {
                throw new IOException(except.getLocalizedMessage());
            }
        } else {
            bpage.children = new long[this.btree.pageSize];
            for (i = bpage.first; i < this.btree.pageSize; ++i) {
                bpage.children[i] = ois.readLong();
            }
        }
        ois.close();
        bais.close();
        return bpage;
    }

    @Override
    public byte[] serialize(Object obj) throws IOException {
        byte[] serialized;
        int i;
        BPage bpage = (BPage)obj;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeBoolean(bpage.isLeaf);
        if (bpage.isLeaf) {
            oos.writeLong(bpage.previous);
            oos.writeLong(bpage.next);
        }
        oos.writeInt(bpage.first);
        for (i = bpage.first; i < this.btree.pageSize; ++i) {
            if (this.btree.keySerializer == null) {
                oos.writeObject(bpage.keys[i]);
                continue;
            }
            if (bpage.keys[i] != null) {
                serialized = this.btree.keySerializer.serialize(bpage.keys[i]);
                BPage.writeByteArray(oos, serialized);
                continue;
            }
            BPage.writeByteArray(oos, null);
        }
        if (bpage.isLeaf) {
            for (i = bpage.first; i < this.btree.pageSize; ++i) {
                if (this.btree.valueSerializer == null) {
                    oos.writeObject(bpage.values[i]);
                    continue;
                }
                if (bpage.values[i] != null) {
                    serialized = this.btree.valueSerializer.serialize(bpage.values[i]);
                    BPage.writeByteArray(oos, serialized);
                    continue;
                }
                BPage.writeByteArray(oos, null);
            }
        } else {
            for (i = bpage.first; i < this.btree.pageSize; ++i) {
                oos.writeLong(bpage.children[i]);
            }
        }
        oos.flush();
        byte[] data = baos.toByteArray();
        oos.close();
        baos.close();
        return data;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.isLeaf) {
            sb.append("Leaf(");
        } else {
            sb.append("Node(");
        }
        sb.append(this.keys.length);
        sb.append(") : [");
        if (this.isLeaf) {
            boolean isFirst = true;
            int index = 0;
            for (K key : this.keys) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    sb.append(", ");
                }
                sb.append("<");
                sb.append(String.valueOf(key));
                sb.append("/");
                sb.append(this.values[index]);
                sb.append(">");
                ++index;
            }
        } else {
            boolean isFirst = true;
            for (K key : this.keys) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    sb.append(", ");
                }
                sb.append("<");
                sb.append(key);
                sb.append(">");
            }
        }
        sb.append("]\n");
        return sb.toString();
    }

    class Browser
    extends TupleBrowser<K, V> {
        private BPage<K, V> page;
        private int index;

        Browser(BPage<K, V> page, int index) {
            this.page = page;
            this.index = index;
        }

        @Override
        public boolean getNext(Tuple<K, V> tuple) throws IOException {
            if (this.index < this.page.btree.pageSize) {
                if (this.page.keys[this.index] == null) {
                    return false;
                }
            } else if (this.page.next != 0L) {
                this.page = this.page.loadBPage(this.page.next);
                this.index = this.page.first;
            }
            tuple.setKey(this.page.keys[this.index]);
            tuple.setValue(this.page.values[this.index]);
            ++this.index;
            return true;
        }

        @Override
        public boolean getPrevious(Tuple<K, V> tuple) throws IOException {
            if (this.index == this.page.first) {
                if (this.page.previous != 0L) {
                    this.page = this.page.loadBPage(this.page.previous);
                    this.index = this.page.btree.pageSize;
                } else {
                    return false;
                }
            }
            --this.index;
            tuple.setKey(this.page.keys[this.index]);
            tuple.setValue(this.page.values[this.index]);
            return true;
        }
    }

    static class RemoveResult<V> {
        boolean underflow;
        V value;

        RemoveResult() {
        }
    }

    static class InsertResult<K, V> {
        BPage<K, V> overflow;
        V existing;

        InsertResult() {
        }
    }
}

