/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.codec.actions.searchResultEntry;

import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.asn1.ber.grammar.GrammarAction;
import org.apache.directory.api.asn1.ber.tlv.TLV;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.codec.api.LdapMessageContainer;
import org.apache.directory.api.ldap.codec.decorators.SearchResultEntryDecorator;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddAttributeType
extends GrammarAction<LdapMessageContainer<SearchResultEntryDecorator>> {
    private static final Logger LOG = LoggerFactory.getLogger(AddAttributeType.class);
    private static final boolean IS_DEBUG = LOG.isDebugEnabled();

    public AddAttributeType() {
        super("Store the AttributeType");
    }

    @Override
    public void action(LdapMessageContainer<SearchResultEntryDecorator> container) throws DecoderException {
        SearchResultEntryDecorator searchResultEntry = container.getMessage();
        TLV tlv = container.getCurrentTLV();
        if (tlv.getLength() == 0) {
            String msg = I18n.err(I18n.ERR_04081, new Object[0]);
            LOG.error(msg);
            throw new DecoderException(msg);
        }
        try {
            searchResultEntry.addAttribute(tlv.getValue().getData());
        }
        catch (LdapException ine) {
            String type = Strings.utf8ToString(tlv.getValue().getData());
            String msg = "The Attribute type " + type + "is invalid : " + ine.getMessage();
            LOG.error("{} : {}", (Object)msg, (Object)ine.getMessage());
            throw new DecoderException(msg, ine);
        }
        if (IS_DEBUG) {
            String type = Strings.utf8ToString(tlv.getValue().getData());
            LOG.debug("Attribute type : {}", (Object)type);
        }
    }
}

