/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.mavibot.btree.serializer;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Comparator;
import org.apache.directory.mavibot.btree.comparator.ByteArrayComparator;
import org.apache.directory.mavibot.btree.exception.SerializerCreationException;
import org.apache.directory.mavibot.btree.serializer.AbstractElementSerializer;
import org.apache.directory.mavibot.btree.serializer.BufferHandler;
import org.apache.directory.mavibot.btree.serializer.IntSerializer;

public class ByteArraySerializer
extends AbstractElementSerializer<byte[]> {
    public ByteArraySerializer() {
        super(new ByteArrayComparator());
    }

    public ByteArraySerializer(Comparator<byte[]> comparator) {
        super(comparator);
    }

    @Override
    public byte[] serialize(byte[] element) {
        int len = -1;
        if (element != null) {
            len = element.length;
        }
        byte[] bytes = null;
        switch (len) {
            case 0: {
                bytes = new byte[]{0, 0, 0, 0};
                break;
            }
            case -1: {
                bytes = new byte[]{-1, -1, -1, -1};
                break;
            }
            default: {
                bytes = new byte[len + 4];
                System.arraycopy(element, 0, bytes, 4, len);
                bytes[0] = (byte)(len >>> 24);
                bytes[1] = (byte)(len >>> 16);
                bytes[2] = (byte)(len >>> 8);
                bytes[3] = (byte)len;
            }
        }
        return bytes;
    }

    public static byte[] serialize(byte[] buffer, int start, byte[] element) {
        int len = -1;
        if (element != null) {
            len = element.length;
        }
        switch (len) {
            case 0: {
                buffer[start] = 0;
                buffer[start + 1] = 0;
                buffer[start + 2] = 0;
                buffer[start + 3] = 0;
                break;
            }
            case -1: {
                buffer[start] = -1;
                buffer[start + 1] = -1;
                buffer[start + 2] = -1;
                buffer[start + 3] = -1;
                break;
            }
            default: {
                buffer[start] = (byte)(len >>> 24);
                buffer[start + 1] = (byte)(len >>> 16);
                buffer[start + 2] = (byte)(len >>> 8);
                buffer[start + 3] = (byte)len;
                System.arraycopy(element, 0, buffer, 4 + start, len);
            }
        }
        return buffer;
    }

    public static byte[] deserialize(byte[] in) {
        if (in == null || in.length < 4) {
            throw new SerializerCreationException("Cannot extract a byte[] from a buffer with not enough bytes");
        }
        int len = IntSerializer.deserialize(in);
        switch (len) {
            case 0: {
                return new byte[0];
            }
            case -1: {
                return null;
            }
        }
        byte[] result = new byte[len];
        System.arraycopy(in, 4, result, 0, len);
        return result;
    }

    public static byte[] deserialize(byte[] in, int start) {
        if (in == null || in.length < 4 + start) {
            throw new SerializerCreationException("Cannot extract a byte[] from a buffer with not enough bytes");
        }
        int len = IntSerializer.deserialize(in, start);
        switch (len) {
            case 0: {
                return new byte[0];
            }
            case -1: {
                return null;
            }
        }
        byte[] result = new byte[len];
        System.arraycopy(in, 4 + start, result, 0, len);
        return result;
    }

    @Override
    public byte[] fromBytes(byte[] in) {
        if (in == null || in.length < 4) {
            throw new SerializerCreationException("Cannot extract a byte[] from a buffer with not enough bytes");
        }
        int len = IntSerializer.deserialize(in);
        switch (len) {
            case 0: {
                return new byte[0];
            }
            case -1: {
                return null;
            }
        }
        byte[] result = new byte[len];
        System.arraycopy(in, 4, result, 0, len);
        return result;
    }

    @Override
    public byte[] fromBytes(byte[] in, int start) {
        if (in == null || in.length < 4 + start) {
            throw new SerializerCreationException("Cannot extract a byte[] from a buffer with not enough bytes");
        }
        int len = IntSerializer.deserialize(in, start);
        switch (len) {
            case 0: {
                return new byte[0];
            }
            case -1: {
                return null;
            }
        }
        byte[] result = new byte[len];
        System.arraycopy(in, 4 + start, result, 0, len);
        return result;
    }

    @Override
    public byte[] deserialize(BufferHandler bufferHandler) throws IOException {
        byte[] in = bufferHandler.read(4);
        int len = IntSerializer.deserialize(in);
        switch (len) {
            case 0: {
                return new byte[0];
            }
            case -1: {
                return null;
            }
        }
        in = bufferHandler.read(len);
        return in;
    }

    @Override
    public byte[] deserialize(ByteBuffer buffer) throws IOException {
        int len = buffer.getInt();
        switch (len) {
            case 0: {
                return new byte[0];
            }
            case -1: {
                return null;
            }
        }
        byte[] bytes = new byte[len];
        buffer.get(bytes);
        return bytes;
    }
}

