/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.mavibot.btree;

import java.io.IOException;
import java.lang.reflect.Array;
import java.util.Comparator;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.directory.mavibot.btree.BTree;
import org.apache.directory.mavibot.btree.BTreeHeader;
import org.apache.directory.mavibot.btree.BTreeTypeEnum;
import org.apache.directory.mavibot.btree.InsertResult;
import org.apache.directory.mavibot.btree.ModifyResult;
import org.apache.directory.mavibot.btree.Page;
import org.apache.directory.mavibot.btree.ParentPos;
import org.apache.directory.mavibot.btree.ReadTransaction;
import org.apache.directory.mavibot.btree.Tuple;
import org.apache.directory.mavibot.btree.TupleCursor;
import org.apache.directory.mavibot.btree.ValueCursor;
import org.apache.directory.mavibot.btree.WriteTransaction;
import org.apache.directory.mavibot.btree.exception.KeyNotFoundException;
import org.apache.directory.mavibot.btree.serializer.ElementSerializer;

abstract class AbstractBTree<K, V>
implements BTree<K, V> {
    protected long readTimeOut = 10000L;
    protected BTreeHeader btreeHeader;
    protected volatile Page<K, V> rootPage;
    protected ElementSerializer<K> keySerializer;
    protected ElementSerializer<V> valueSerializer;
    protected ConcurrentLinkedQueue<ReadTransaction<K, V>> readTransactions;
    protected int writeBufferSize;
    protected ReentrantLock writeLock;
    private boolean allowDuplicates;
    protected Thread readTransactionsThread;
    private BTreeTypeEnum type;
    protected WriteTransaction writeTransaction;

    AbstractBTree() {
    }

    protected ReadTransaction<K, V> beginReadTransaction() {
        ReadTransaction<K, V> readTransaction = new ReadTransaction<K, V>(this.rootPage, this.btreeHeader.getRevision() - 1L, System.currentTimeMillis());
        this.readTransactions.add(readTransaction);
        return readTransaction;
    }

    @Override
    public TupleCursor<K, V> browse() throws IOException {
        ReadTransaction<K, V> transaction = this.beginReadTransaction();
        ParentPos[] stack = (ParentPos[])Array.newInstance(ParentPos.class, 32);
        TupleCursor<K, V> cursor = this.rootPage.browse(transaction, stack, 0);
        cursor.beforeFirst();
        return cursor;
    }

    @Override
    public TupleCursor<K, V> browse(long revision) throws IOException, KeyNotFoundException {
        ReadTransaction<K, V> transaction = this.beginReadTransaction();
        Page<K, V> revisionRootPage = this.getRootPage(revision);
        ParentPos[] stack = (ParentPos[])Array.newInstance(ParentPos.class, 32);
        TupleCursor cursor = revisionRootPage.browse(transaction, stack, 0);
        return cursor;
    }

    @Override
    public TupleCursor<K, V> browseFrom(K key) throws IOException {
        ReadTransaction<K, V> transaction = this.beginReadTransaction();
        ParentPos[] stack = (ParentPos[])Array.newInstance(ParentPos.class, 32);
        TupleCursor<K, V> cursor = this.rootPage.browse(key, transaction, stack, 0);
        return cursor;
    }

    @Override
    public TupleCursor<K, V> browseFrom(long revision, K key) throws IOException, KeyNotFoundException {
        ReadTransaction<K, V> transaction = this.beginReadTransaction();
        Page<K, V> revisionRootPage = this.getRootPage(revision);
        ParentPos[] stack = (ParentPos[])Array.newInstance(ParentPos.class, 32);
        TupleCursor cursor = revisionRootPage.browse(key, transaction, stack, 0);
        return cursor;
    }

    @Override
    public boolean contains(K key, V value) throws IOException {
        return this.rootPage.contains(key, value);
    }

    @Override
    public boolean contains(long revision, K key, V value) throws IOException, KeyNotFoundException {
        Page<K, V> revisionRootPage = this.getRootPage(revision);
        return revisionRootPage.contains(key, value);
    }

    @Override
    public Tuple<K, V> delete(K key) throws IOException {
        if (key == null) {
            throw new IllegalArgumentException("Key must not be null");
        }
        long revision = this.generateRevision();
        Tuple<K, V> deleted = this.delete(key, revision);
        return deleted;
    }

    @Override
    public Tuple<K, V> delete(K key, V value) throws IOException {
        if (key == null) {
            throw new IllegalArgumentException("Key must not be null");
        }
        if (value == null) {
            throw new IllegalArgumentException("Value must not be null");
        }
        long revision = this.generateRevision();
        Tuple<K, V> deleted = this.delete(key, value, revision);
        return deleted;
    }

    @Override
    Tuple<K, V> delete(K key, long revision) throws IOException {
        return this.delete(key, null, revision);
    }

    abstract Tuple<K, V> delete(K var1, V var2, long var3) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V insert(K key, V value) throws IOException {
        long revision = this.generateRevision();
        V existingValue = null;
        try {
            InsertResult<K, V> result;
            if (this.writeTransaction == null) {
                this.writeLock.lock();
            }
            if ((result = this.insert(key, value, revision)) instanceof ModifyResult) {
                existingValue = ((ModifyResult)result).getModifiedValue();
            }
        }
        finally {
            if (this.writeTransaction == null) {
                this.writeLock.unlock();
            }
        }
        return existingValue;
    }

    abstract InsertResult<K, V> insert(K var1, V var2, long var3) throws IOException;

    @Override
    public void flush() throws IOException {
    }

    @Override
    public V get(K key) throws IOException, KeyNotFoundException {
        return this.rootPage.get(key);
    }

    @Override
    public V get(long revision, K key) throws IOException, KeyNotFoundException {
        Page revisionRootPage = this.getRootPage(revision);
        return revisionRootPage.get(key);
    }

    @Override
    public Page<K, V> getRootPage() {
        return this.rootPage;
    }

    void setRootPage(Page<K, V> root) {
        this.rootPage = root;
    }

    @Override
    public ValueCursor<V> getValues(K key) throws IOException, KeyNotFoundException {
        return this.rootPage.getValues(key);
    }

    @Override
    public boolean hasKey(K key) throws IOException {
        if (key == null) {
            return false;
        }
        return this.rootPage.hasKey(key);
    }

    @Override
    public boolean hasKey(long revision, K key) throws IOException, KeyNotFoundException {
        if (key == null) {
            return false;
        }
        Page revisionRootPage = this.getRootPage(revision);
        return revisionRootPage.hasKey(key);
    }

    @Override
    public ElementSerializer<K> getKeySerializer() {
        return this.keySerializer;
    }

    @Override
    public void setKeySerializer(ElementSerializer<K> keySerializer) {
        this.keySerializer = keySerializer;
        this.btreeHeader.setKeySerializerFQCN(keySerializer.getClass().getName());
    }

    @Override
    public String getKeySerializerFQCN() {
        return this.btreeHeader.getKeySerializerFQCN();
    }

    @Override
    public ElementSerializer<V> getValueSerializer() {
        return this.valueSerializer;
    }

    @Override
    public void setValueSerializer(ElementSerializer<V> valueSerializer) {
        this.valueSerializer = valueSerializer;
        this.btreeHeader.setValueSerializerFQCN(valueSerializer.getClass().getName());
    }

    @Override
    public String getValueSerializerFQCN() {
        return this.btreeHeader.getValueSerializerFQCN();
    }

    @Override
    public long getRevision() {
        return this.btreeHeader.getRevision();
    }

    void setRevision(long revision) {
        this.btreeHeader.setRevision(revision);
    }

    long generateRevision() {
        return this.btreeHeader.incrementRevision();
    }

    @Override
    public long getReadTimeOut() {
        return this.readTimeOut;
    }

    @Override
    public void setReadTimeOut(long readTimeOut) {
        this.readTimeOut = readTimeOut;
    }

    @Override
    public long getNbElems() {
        return this.btreeHeader.getNbElems();
    }

    void setNbElems(long nbElems) {
        this.btreeHeader.setNbElems(nbElems);
    }

    @Override
    public int getPageSize() {
        return this.btreeHeader.getPageSize();
    }

    @Override
    public void setPageSize(int pageSize) {
        if (pageSize <= 2) {
            this.btreeHeader.setPageSize(16);
        } else {
            this.btreeHeader.setPageSize(this.getPowerOf2(pageSize));
        }
    }

    @Override
    public String getName() {
        return this.btreeHeader.getName();
    }

    @Override
    public void setName(String name) {
        this.btreeHeader.setName(name);
    }

    @Override
    public Comparator<K> getComparator() {
        return this.keySerializer.getComparator();
    }

    @Override
    public int getWriteBufferSize() {
        return this.writeBufferSize;
    }

    @Override
    public void setWriteBufferSize(int writeBufferSize) {
        this.writeBufferSize = writeBufferSize;
    }

    @Override
    public boolean isAllowDuplicates() {
        return this.btreeHeader.isAllowDuplicates();
    }

    @Override
    public void setAllowDuplicates(boolean allowDuplicates) {
        this.btreeHeader.setAllowDuplicates(allowDuplicates);
    }

    @Override
    public BTreeTypeEnum getType() {
        return this.type;
    }

    public void setType(BTreeTypeEnum type) {
        this.type = type;
    }

    private int getPowerOf2(int size) {
        int newSize = --size;
        newSize |= newSize >> 1;
        newSize |= newSize >> 2;
        newSize |= newSize >> 4;
        newSize |= newSize >> 8;
        newSize |= newSize >> 16;
        return ++newSize;
    }

    void createTransactionManager() {
        Runnable readTransactionTask = new Runnable(){

            @Override
            public void run() {
                try {
                    ReadTransaction transaction = null;
                    while (!Thread.currentThread().isInterrupted()) {
                        long timeoutDate = System.currentTimeMillis() - AbstractBTree.this.readTimeOut;
                        long t0 = System.currentTimeMillis();
                        int nbTxns = 0;
                        while ((transaction = AbstractBTree.this.readTransactions.peek()) != null) {
                            ++nbTxns;
                            if (transaction.isClosed()) {
                                AbstractBTree.this.readTransactions.poll();
                                continue;
                            }
                            if (transaction.getCreationDate() >= timeoutDate) break;
                            transaction.close();
                            AbstractBTree.this.readTransactions.poll();
                        }
                        long t1 = System.currentTimeMillis();
                        if (nbTxns > 0) {
                            System.out.println("Processing old txn : " + nbTxns + ", " + (t1 - t0) + "ms");
                        }
                        Thread.sleep(AbstractBTree.this.readTimeOut);
                    }
                }
                catch (InterruptedException ie) {
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        };
        this.readTransactionsThread = new Thread(readTransactionTask);
        this.readTransactionsThread.setDaemon(true);
        this.readTransactionsThread.start();
    }
}

