/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.ldap.handlers.extended;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.directory.api.ldap.extras.extended.PwdModifyRequest;
import org.apache.directory.api.ldap.extras.extended.PwdModifyResponse;
import org.apache.directory.api.ldap.extras.extended.PwdModifyResponseImpl;
import org.apache.directory.api.ldap.model.entry.DefaultModification;
import org.apache.directory.api.ldap.model.entry.Modification;
import org.apache.directory.api.ldap.model.entry.ModificationOperation;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.exception.LdapInvalidDnException;
import org.apache.directory.api.ldap.model.message.ResultCodeEnum;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.util.Strings;
import org.apache.directory.server.core.api.CoreSession;
import org.apache.directory.server.core.api.DirectoryService;
import org.apache.directory.server.core.api.interceptor.context.BindOperationContext;
import org.apache.directory.server.core.api.interceptor.context.HasEntryOperationContext;
import org.apache.directory.server.core.api.interceptor.context.ModifyOperationContext;
import org.apache.directory.server.ldap.ExtendedOperationHandler;
import org.apache.directory.server.ldap.LdapServer;
import org.apache.directory.server.ldap.LdapSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PwdModifyHandler
implements ExtendedOperationHandler<PwdModifyRequest, PwdModifyResponse> {
    private static final Logger LOG = LoggerFactory.getLogger(PwdModifyHandler.class);
    public static final Set<String> EXTENSION_OIDS;

    @Override
    public String getOid() {
        return "1.3.6.1.4.1.4203.1.11.1";
    }

    private void modifyUserPassword(LdapSession requestor, Dn userDn, byte[] oldPassword, byte[] newPassword, PwdModifyRequest req) {
        DirectoryService service = requestor.getLdapServer().getDirectoryService();
        CoreSession adminSession = service.getAdminSession();
        try {
            HasEntryOperationContext hasEntryContext = new HasEntryOperationContext(adminSession);
            hasEntryContext.setDn(userDn);
            if (!service.getOperationManager().hasEntry(hasEntryContext)) {
                LOG.error("Cannot find an entry for DN " + userDn);
                requestor.getIoSession().write(new PwdModifyResponseImpl(req.getMessageId(), ResultCodeEnum.NO_SUCH_OBJECT, "Cannot find an entry for DN " + userDn));
                return;
            }
        }
        catch (LdapException le) {
            LOG.error("Cannot find an entry for DN " + userDn + ", exception : " + le.getMessage());
            requestor.getIoSession().write(new PwdModifyResponseImpl(req.getMessageId(), ResultCodeEnum.NO_SUCH_OBJECT, "Cannot find an entry for DN " + userDn + ", exception : " + le.getMessage()));
            return;
        }
        ModifyOperationContext modifyContext = new ModifyOperationContext(adminSession);
        modifyContext.setDn(userDn);
        ArrayList<Modification> modifications = new ArrayList<Modification>();
        DefaultModification modification = null;
        if (oldPassword != null) {
            modification = new DefaultModification(ModificationOperation.REMOVE_ATTRIBUTE, "userPassword", (byte[][])new byte[][]{oldPassword});
            modifications.add(modification);
        }
        if (newPassword == null) {
            LOG.error("Cannot create a new password for user " + userDn + ", exception : " + userDn);
            requestor.getIoSession().write(new PwdModifyResponseImpl(req.getMessageId(), ResultCodeEnum.UNWILLING_TO_PERFORM, "Cannot generate a new password for user " + userDn));
            return;
        }
        modification = oldPassword == null ? new DefaultModification(ModificationOperation.REPLACE_ATTRIBUTE, "userPassword", (byte[][])new byte[][]{newPassword}) : new DefaultModification(ModificationOperation.ADD_ATTRIBUTE, "userPassword", (byte[][])new byte[][]{newPassword});
        modifications.add(modification);
        modifyContext.setModItems(modifications);
        try {
            service.getOperationManager().modify(modifyContext);
            LOG.debug("Password modified for user " + userDn);
            requestor.getIoSession().write(new PwdModifyResponseImpl(req.getMessageId(), ResultCodeEnum.SUCCESS));
        }
        catch (LdapException le) {
            LOG.error("Cannot modify the password for user " + userDn + ", exception : " + le.getMessage());
            requestor.getIoSession().write(new PwdModifyResponseImpl(req.getMessageId(), ResultCodeEnum.INVALID_CREDENTIALS, "Cannot modify the password for user " + userDn + ", exception : " + le.getMessage()));
            return;
        }
    }

    private void modifyOwnPassword(LdapSession requestor, Dn principalDn, byte[] oldPassword, byte[] newPassword, PwdModifyRequest req) {
        DirectoryService service = requestor.getLdapServer().getDirectoryService();
        CoreSession adminSession = service.getAdminSession();
        ModifyOperationContext modifyContext = new ModifyOperationContext(adminSession);
        modifyContext.setDn(principalDn);
        ArrayList<Modification> modifications = new ArrayList<Modification>();
        DefaultModification modification = null;
        if (oldPassword != null) {
            modification = new DefaultModification(ModificationOperation.REMOVE_ATTRIBUTE, "userPassword", (byte[][])new byte[][]{oldPassword});
            modifications.add(modification);
        } else {
            modification = new DefaultModification(ModificationOperation.REMOVE_ATTRIBUTE, "userPassword");
            modifications.add(modification);
        }
        if (newPassword != null) {
            modification = new DefaultModification(ModificationOperation.ADD_ATTRIBUTE, "userPassword", (byte[][])new byte[][]{newPassword});
            modifications.add(modification);
        }
        modifyContext.setModItems(modifications);
        try {
            service.getOperationManager().modify(modifyContext);
            LOG.debug("Password modified for user " + principalDn);
            requestor.getIoSession().write(new PwdModifyResponseImpl(req.getMessageId(), ResultCodeEnum.SUCCESS));
        }
        catch (LdapException le) {
            LOG.error("Cannot modify the password for user " + principalDn + ", exception : " + le.getMessage());
            requestor.getIoSession().write(new PwdModifyResponseImpl(req.getMessageId(), ResultCodeEnum.INVALID_CREDENTIALS, "Cannot modify the password for user " + principalDn + ", exception : " + le.getMessage()));
            return;
        }
    }

    @Override
    public void handleExtendedOperation(LdapSession requestor, PwdModifyRequest req) throws Exception {
        LOG.debug("Password modification requested");
        DirectoryService service = requestor.getLdapServer().getDirectoryService();
        CoreSession adminSession = service.getAdminSession();
        String userIdentity = Strings.utf8ToString(req.getUserIdentity());
        Dn userDn = null;
        if (!Strings.isEmpty(userIdentity)) {
            try {
                userDn = service.getDnFactory().create(userIdentity);
            }
            catch (LdapInvalidDnException lide) {
                LOG.error("The user DN is invalid : " + userDn);
                requestor.getIoSession().write(new PwdModifyResponseImpl(req.getMessageId(), ResultCodeEnum.INVALID_DN_SYNTAX, "The user DN is invalid : " + userDn));
                return;
            }
        }
        byte[] oldPassword = req.getOldPassword();
        byte[] newPassword = req.getNewPassword();
        if (requestor.isAuthenticated()) {
            Dn principalDn = requestor.getCoreSession().getEffectivePrincipal().getDn();
            LOG.debug("Trying to modify password for user " + principalDn);
            if (userDn != null && !userDn.equals(principalDn)) {
                if (!requestor.getCoreSession().isAdministrator()) {
                    LOG.error("Cannot access to another user's password to modify it");
                    requestor.getIoSession().write(new PwdModifyResponseImpl(req.getMessageId(), ResultCodeEnum.INSUFFICIENT_ACCESS_RIGHTS, "Cannot access to another user's password to modify it"));
                } else {
                    this.modifyUserPassword(requestor, userDn, oldPassword, newPassword, req);
                }
            } else {
                this.modifyOwnPassword(requestor, principalDn, oldPassword, newPassword, req);
            }
        } else {
            BindOperationContext bindContext = new BindOperationContext(adminSession);
            bindContext.setDn(userDn);
            bindContext.setCredentials(oldPassword);
            try {
                service.getOperationManager().bind(bindContext);
            }
            catch (LdapException le) {
                requestor.getIoSession().write(new PwdModifyResponseImpl(req.getMessageId(), ResultCodeEnum.INVALID_CREDENTIALS));
                return;
            }
            ModifyOperationContext modifyContext = new ModifyOperationContext(adminSession);
            modifyContext.setDn(userDn);
            ArrayList<Modification> modifications = new ArrayList<Modification>();
            DefaultModification modification = new DefaultModification(ModificationOperation.REPLACE_ATTRIBUTE, "userPassword", (byte[][])new byte[][]{newPassword});
            modifications.add(modification);
            modifyContext.setModItems(modifications);
            try {
                service.getOperationManager().modify(modifyContext);
                requestor.getIoSession().write(new PwdModifyResponseImpl(req.getMessageId(), ResultCodeEnum.SUCCESS));
            }
            catch (LdapException le) {
                requestor.getIoSession().write(new PwdModifyResponseImpl(req.getMessageId(), ResultCodeEnum.UNWILLING_TO_PERFORM, "Cannot modify the password, exception : " + le.getMessage()));
                return;
            }
        }
    }

    public static PwdModifyResponse getPwdModifyResponse() {
        return new PwdModifyResponseImpl();
    }

    @Override
    public Set<String> getExtensionOids() {
        return EXTENSION_OIDS;
    }

    @Override
    public void setLdapServer(LdapServer ldapServer) {
    }

    static {
        HashSet<String> set = new HashSet<String>(2);
        set.add("1.3.6.1.4.1.4203.1.11.1");
        set.add("1.3.6.1.4.1.4203.1.11.1");
        EXTENSION_OIDS = Collections.unmodifiableSet(set);
    }
}

