/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.hash;

import java.util.List;
import org.apache.directory.api.ldap.model.constants.LdapSecurityConstants;
import org.apache.directory.api.ldap.model.entry.Attribute;
import org.apache.directory.api.ldap.model.entry.BinaryValue;
import org.apache.directory.api.ldap.model.entry.DefaultAttribute;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.entry.Modification;
import org.apache.directory.api.ldap.model.entry.Value;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.password.PasswordUtil;
import org.apache.directory.server.core.api.interceptor.BaseInterceptor;
import org.apache.directory.server.core.api.interceptor.context.AddOperationContext;
import org.apache.directory.server.core.api.interceptor.context.ModifyOperationContext;

public abstract class PasswordHashingInterceptor
extends BaseInterceptor {
    private LdapSecurityConstants algorithm;

    protected PasswordHashingInterceptor(String name, LdapSecurityConstants algorithm) {
        super(name);
        this.algorithm = algorithm;
    }

    @Override
    public void add(AddOperationContext addContext) throws LdapException {
        if (this.algorithm == null) {
            this.next(addContext);
            return;
        }
        Entry entry = addContext.getEntry();
        Attribute pwdAt = entry.get("userPassword");
        this.includeHashedPassword(pwdAt);
        this.next(addContext);
    }

    @Override
    public void modify(ModifyOperationContext modifyContext) throws LdapException {
        if (this.algorithm == null) {
            this.next(modifyContext);
            return;
        }
        List<Modification> mods = modifyContext.getModItems();
        for (Modification mod : mods) {
            String oid = mod.getAttribute().getAttributeType().getOid();
            if (!"2.5.4.35".equals(oid)) continue;
            Attribute newPwd = this.includeHashedPassword(mod.getAttribute());
            if (newPwd == null) break;
            mod.setAttribute(newPwd);
            break;
        }
        this.next(modifyContext);
    }

    private Attribute includeHashedPassword(Attribute pwdAt) throws LdapException {
        if (pwdAt == null) {
            return null;
        }
        DefaultAttribute newPwd = new DefaultAttribute(pwdAt.getAttributeType());
        for (Value userPassword : pwdAt) {
            if (userPassword.getValue() == null) continue;
            LdapSecurityConstants existingAlgo = PasswordUtil.findAlgorithm(((BinaryValue)userPassword).getValue());
            if (existingAlgo == null) {
                byte[] hashedPassword = PasswordUtil.createStoragePassword(((BinaryValue)userPassword).getValue(), this.algorithm);
                newPwd.add(new byte[][]{hashedPassword});
                continue;
            }
            newPwd.add(new byte[][]{((BinaryValue)userPassword).getValue()});
        }
        return newPwd;
    }
}

