/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.bridge.http;

import org.apache.directory.api.ldap.model.message.BindRequest;
import org.apache.directory.api.ldap.model.message.BindResponse;
import org.apache.directory.api.ldap.model.message.BindResponseImpl;
import org.apache.directory.api.ldap.model.message.LdapResult;
import org.apache.directory.api.ldap.model.message.ResultCodeEnum;
import org.apache.directory.api.ldap.model.schema.SchemaManager;
import org.apache.directory.server.bridge.http.BindResponseHolder;
import org.apache.directory.server.core.api.DirectoryService;
import org.apache.directory.server.core.api.LdapCoreSessionConnection;

public class HttpDirectoryService {
    private final DirectoryService dirService;
    public static final String KEY = HttpDirectoryService.class.getName();

    public HttpDirectoryService(DirectoryService dirService) {
        this.dirService = dirService;
    }

    public BindResponseHolder bind(BindRequest bindReq) {
        BindResponseHolder holder = null;
        BindResponse resp = null;
        try {
            LdapCoreSessionConnection connection = new LdapCoreSessionConnection(this.dirService);
            resp = connection.bind(bindReq);
            holder = new BindResponseHolder(resp, connection);
        }
        catch (Exception e) {
            resp = new BindResponseImpl();
            LdapResult result = resp.getLdapResult();
            result.setDiagnosticMessage(e.getMessage());
            result.setResultCode(ResultCodeEnum.getResultCode(e));
            holder = new BindResponseHolder(resp, null);
        }
        return holder;
    }

    public SchemaManager getSchemaManager() {
        return this.dirService.getSchemaManager();
    }

    public DirectoryService getDirService() {
        return this.dirService;
    }
}

