/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.schema.comparators;

import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.model.schema.LdapComparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComparableComparator<T>
extends LdapComparator<Comparable<T>> {
    private static final long serialVersionUID = 2L;
    private static final Logger LOG = LoggerFactory.getLogger(ComparableComparator.class);

    public ComparableComparator(String oid) {
        super(oid);
    }

    @Override
    public int compare(Comparable<T> o1, Comparable<T> o2) {
        LOG.debug("comparing objects '{}' with '{}'", (Object)o1, (Object)o2);
        if (o1 == null && o2 == null) {
            return 0;
        }
        if (o1 instanceof Comparable) {
            if (o2 == null) {
                return -1;
            }
            return o1.compareTo(o2);
        }
        if (o2 == null) {
            return 1;
        }
        if (o2 instanceof Comparable) {
            if (o1 == null) {
                return -1;
            }
            return -o2.compareTo(o1);
        }
        throw new IllegalArgumentException(I18n.err(I18n.ERR_04217, o1, o2));
    }
}

