/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.xdbm.search.cursor;

import java.io.IOException;
import org.apache.directory.api.ldap.model.constants.Loggers;
import org.apache.directory.api.ldap.model.cursor.Cursor;
import org.apache.directory.api.ldap.model.cursor.CursorException;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.server.core.partition.impl.btree.IndexCursorAdaptor;
import org.apache.directory.server.xdbm.AbstractIndexCursor;
import org.apache.directory.server.xdbm.IndexEntry;
import org.apache.directory.server.xdbm.Store;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AllEntriesCursor
extends AbstractIndexCursor<String> {
    private static final Logger LOG_CURSOR = LoggerFactory.getLogger(Loggers.CURSOR_LOG.getName());
    private static final boolean IS_DEBUG = LOG_CURSOR.isDebugEnabled();
    private IndexEntry<String, String> indexEntry = new IndexEntry();
    private final Cursor<IndexEntry<String, String>> wrapped;

    @Override
    protected String getUnsupportedMessage() {
        return "Unsupported operation";
    }

    public AllEntriesCursor(Store store) throws Exception {
        if (IS_DEBUG) {
            LOG_CURSOR.debug("Creating AllEntriesCursor {}", (Object)this);
        }
        this.wrapped = new IndexCursorAdaptor<String>(store.getMasterTable().cursor(), true);
    }

    @Override
    public void after(IndexEntry<String, String> indexEntry) throws LdapException, CursorException, IOException {
        this.checkNotClosed("after()");
    }

    @Override
    public void afterLast() throws LdapException, CursorException, IOException {
        this.checkNotClosed("afterLast()");
        this.wrapped.afterLast();
    }

    @Override
    public boolean available() {
        return this.wrapped.available();
    }

    @Override
    public void before(IndexEntry<String, String> indexEntry) throws LdapException, CursorException, IOException {
        this.checkNotClosed("before()");
    }

    @Override
    public void beforeFirst() throws LdapException, CursorException, IOException {
        this.checkNotClosed("beforeFirst()");
        this.wrapped.beforeFirst();
    }

    @Override
    public boolean first() throws LdapException, CursorException, IOException {
        this.checkNotClosed("first()");
        return this.wrapped.first();
    }

    @Override
    public IndexEntry<String, String> get() throws CursorException, IOException {
        this.checkNotClosed("get()");
        IndexEntry<String, String> wrappedEntry = this.wrapped.get();
        this.indexEntry.setId(wrappedEntry.getKey());
        this.indexEntry.setKey(wrappedEntry.getKey());
        this.indexEntry.setEntry(null);
        return this.indexEntry;
    }

    @Override
    public boolean last() throws LdapException, CursorException, IOException {
        this.checkNotClosed("last()");
        return this.wrapped.last();
    }

    @Override
    public boolean next() throws LdapException, CursorException, IOException {
        this.checkNotClosed("next()");
        return this.wrapped.next();
    }

    @Override
    public boolean previous() throws LdapException, CursorException, IOException {
        this.checkNotClosed("previous()");
        return this.wrapped.previous();
    }

    @Override
    public void close() {
        if (IS_DEBUG) {
            LOG_CURSOR.debug("Closing AllEntriesCursor {}", (Object)this);
        }
        this.wrapped.close();
    }

    @Override
    public void close(Exception cause) {
        if (IS_DEBUG) {
            LOG_CURSOR.debug("Closing AllEntriesCursor {}", (Object)this);
        }
        this.wrapped.close(cause);
    }

    @Override
    public String toString(String tabs) {
        StringBuilder sb = new StringBuilder();
        sb.append(tabs).append("AllEntriesCursor (");
        if (this.available()) {
            sb.append("available)");
        } else {
            sb.append("absent)");
        }
        sb.append(" :\n");
        sb.append(this.wrapped.toString(tabs + "    "));
        return sb.toString();
    }

    public String toString() {
        return this.toString("");
    }
}

