/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.authn;

import java.util.Collections;
import java.util.Date;
import org.apache.directory.api.ldap.extras.controls.ppolicy.PasswordPolicyErrorEnum;
import org.apache.directory.api.ldap.model.constants.AuthenticationLevel;
import org.apache.directory.api.ldap.model.entry.Attribute;
import org.apache.directory.api.ldap.model.entry.DefaultModification;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.entry.ModificationOperation;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.ldap.model.password.PasswordUtil;
import org.apache.directory.api.util.DateUtils;
import org.apache.directory.server.core.api.DirectoryService;
import org.apache.directory.server.core.api.InterceptorEnum;
import org.apache.directory.server.core.api.authn.ppolicy.PasswordPolicyConfiguration;
import org.apache.directory.server.core.api.authn.ppolicy.PasswordPolicyException;
import org.apache.directory.server.core.api.interceptor.context.ModifyOperationContext;
import org.apache.directory.server.core.authn.AuthenticationInterceptor;
import org.apache.directory.server.core.authn.Authenticator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAuthenticator
implements Authenticator {
    protected static final Logger LOG = LoggerFactory.getLogger(AbstractAuthenticator.class);
    private DirectoryService directoryService;
    private final AuthenticationLevel authenticatorType;

    protected AbstractAuthenticator(AuthenticationLevel type) {
        this.authenticatorType = type;
    }

    public DirectoryService getDirectoryService() {
        return this.directoryService;
    }

    @Override
    public AuthenticationLevel getAuthenticatorType() {
        return this.authenticatorType;
    }

    @Override
    public final void init(DirectoryService directoryService) throws LdapException {
        this.directoryService = directoryService;
        this.doInit();
    }

    protected void doInit() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void destroy() {
        try {
            this.doDestroy();
        }
        finally {
            this.directoryService = null;
        }
    }

    protected void doDestroy() {
    }

    @Override
    public void invalidateCache(Dn bindDn) {
    }

    @Override
    public void checkPwdPolicy(Entry userEntry) throws LdapException {
        Attribute pwdLastSuccessTimeAttr;
        Attribute pwdEndTimeAttr;
        Attribute pwdStartTimeAttr;
        if (!this.directoryService.isPwdPolicyEnabled()) {
            return;
        }
        AuthenticationInterceptor authenticationInterceptor = (AuthenticationInterceptor)this.directoryService.getInterceptor(InterceptorEnum.AUTHENTICATION_INTERCEPTOR.getName());
        PasswordPolicyConfiguration pPolicyConfig = authenticationInterceptor.getPwdPolicy(userEntry);
        if (pPolicyConfig.isPwdLockout()) {
            LOG.debug("checking if account with the Dn {} is locked", (Object)userEntry.getDn());
            Attribute accountLockAttr = userEntry.get("pwdAccountLockedTime");
            if (accountLockAttr != null) {
                Date now;
                String lockedTime = accountLockAttr.getString();
                if (lockedTime.equals("000001010000Z")) {
                    throw new PasswordPolicyException("account was permanently locked", PasswordPolicyErrorEnum.ACCOUNT_LOCKED.getValue());
                }
                Date lockedDate = DateUtils.getDate(lockedTime);
                long unlockTime = (long)pPolicyConfig.getPwdLockoutDuration() * 1000L;
                Date unlockDate = new Date(unlockTime += lockedDate.getTime());
                if (unlockDate.after(now = DateUtils.getDate(DateUtils.getGeneralizedTime()))) {
                    throw new PasswordPolicyException("account will remain locked till " + unlockDate, PasswordPolicyErrorEnum.ACCOUNT_LOCKED.getValue());
                }
                DefaultModification pwdAccountLockMod = new DefaultModification(ModificationOperation.REMOVE_ATTRIBUTE, accountLockAttr);
                ModifyOperationContext modContext = new ModifyOperationContext(this.directoryService.getAdminSession());
                modContext.setDn(userEntry.getDn());
                modContext.setModItems(Collections.singletonList(pwdAccountLockMod));
                this.directoryService.getPartitionNexus().modify(modContext);
            }
        }
        if ((pwdStartTimeAttr = userEntry.get("pwdStartTime")) != null) {
            Date pwdStartTime = DateUtils.getDate(pwdStartTimeAttr.getString());
            if (System.currentTimeMillis() < pwdStartTime.getTime()) {
                throw new PasswordPolicyException("account is locked, will be activated after " + pwdStartTime, PasswordPolicyErrorEnum.ACCOUNT_LOCKED.getValue());
            }
        }
        if ((pwdEndTimeAttr = userEntry.get("pwdEndTime")) != null) {
            Date pwdEndTime = DateUtils.getDate(pwdEndTimeAttr.getString());
            if (System.currentTimeMillis() >= pwdEndTime.getTime()) {
                throw new PasswordPolicyException("password end time reached, will be locked till administrator activates it", PasswordPolicyErrorEnum.ACCOUNT_LOCKED.getValue());
            }
        }
        if (pPolicyConfig.getPwdMaxIdle() > 0 && (pwdLastSuccessTimeAttr = userEntry.get("pwdLastSuccess")) != null) {
            long time = (long)pPolicyConfig.getPwdMaxIdle() * 1000L;
            if (System.currentTimeMillis() >= (time += DateUtils.getDate(pwdLastSuccessTimeAttr.getString()).getTime())) {
                throw new PasswordPolicyException("account locked due to the max idle time of the password was exceeded", PasswordPolicyErrorEnum.ACCOUNT_LOCKED.getValue());
            }
        }
        if (pPolicyConfig.getPwdMaxAge() > 0) {
            if (pPolicyConfig.getPwdGraceAuthNLimit() > 0) {
                Attribute pwdGraceUseAttr = userEntry.get("pwdGraceUseTime");
                if (pwdGraceUseAttr != null && pwdGraceUseAttr.size() >= pPolicyConfig.getPwdGraceAuthNLimit()) {
                    throw new PasswordPolicyException("paasword expired and max grace logins were used", PasswordPolicyErrorEnum.PASSWORD_EXPIRED.getValue());
                }
            } else {
                boolean expired;
                Attribute pwdChangeTimeAttr = userEntry.get("pwdChangedTime");
                if (pwdChangeTimeAttr != null && (expired = PasswordUtil.isPwdExpired(pwdChangeTimeAttr.getString(), pPolicyConfig.getPwdMaxAge()))) {
                    throw new PasswordPolicyException("paasword expired", PasswordPolicyErrorEnum.PASSWORD_EXPIRED.getValue());
                }
            }
        }
    }
}

