/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.constructs.nonstop;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.HashSet;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NonstopThreadPool {
    private static final long POLL_TIME_MILLIS = 1000L;
    private static final long NUM_OF_POLLS_BEFORE_CHECK_THREADS_ALIVE = 100L;
    private final ThreadFactory threadFactory;
    private final Map<Thread, WorkerThreadLocal> workers = new WeakHashMap<Thread, WorkerThreadLocal>();
    private final Object workersLock = new Object();
    private final AtomicReference<State> state = new AtomicReference<State>(State.RUNNING);
    private final ReferenceQueue<Thread> gcedThreadsReferenceQueue = new ReferenceQueue();
    private final ThreadLocal<WorkerThreadLocal> workerThreadLocal = new ThreadLocal<WorkerThreadLocal>(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected WorkerThreadLocal initialValue() {
            WorkerThreadLocal local = new WorkerThreadLocal(NonstopThreadPool.this.threadFactory, NonstopThreadPool.this.gcedThreadsReferenceQueue);
            Object object = NonstopThreadPool.this.workersLock;
            synchronized (object) {
                if (NonstopThreadPool.this.state.get() == State.SHUTDOWN) {
                    NonstopThreadPool.this.rejectExecutionAfterShutdown();
                }
                NonstopThreadPool.this.workers.put(Thread.currentThread(), local);
            }
            return local;
        }
    };

    public NonstopThreadPool(ThreadFactory threadFactory) {
        this.threadFactory = threadFactory;
        this.startReaperThread();
    }

    private void startReaperThread() {
        Thread reaperThread = new Thread((Runnable)new ReaperThread(), "non stop reaper thread");
        reaperThread.start();
    }

    private void rejectExecutionAfterShutdown() {
        throw new RejectedExecutionException("The thread pool has already shut down.");
    }

    public <T> Future<T> submit(Callable<T> task) {
        if (task == null) {
            throw new NullPointerException("Task cannot be null");
        }
        return this.workerThreadLocal.get().submit(task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdownNow() {
        this.state.set(State.SHUTDOWN);
        Object object = this.workersLock;
        synchronized (object) {
            for (WorkerThreadLocal worker : this.workers.values()) {
                worker.shutdownNow();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum State {
        RUNNING,
        SHUTDOWN;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class WeakWorkerReference
    extends WeakReference<Thread> {
        private final Worker worker;

        public WeakWorkerReference(Worker worker, Thread referent, ReferenceQueue<? super Thread> q) {
            super(referent, q);
            this.worker = worker;
        }

        public Worker getWorker() {
            return this.worker;
        }
    }

    private static class WorkerTaskHolder {
        private Runnable task;

        private WorkerTaskHolder() {
        }

        public synchronized void addTask(Runnable runnable) {
            this.task = runnable;
        }

        public synchronized Runnable consumeTask() {
            if (this.task == null) {
                return null;
            }
            Runnable rv = this.task;
            this.task = null;
            return rv;
        }

        public synchronized boolean isTaskAvailable() {
            return this.task != null;
        }
    }

    private static class Worker
    implements Runnable {
        private final WorkerTaskHolder workerTaskHolder = new WorkerTaskHolder();
        private volatile boolean shutdown;
        private volatile Thread workerThread;
        private volatile boolean runningTask;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            this.workerThread = Thread.currentThread();
            while (!this.shutdown) {
                this.waitUntilTaskAvailable();
                if (this.shutdown) break;
                Runnable task = this.workerTaskHolder.consumeTask();
                if (task == null) continue;
                Worker worker = this;
                synchronized (worker) {
                    this.runningTask = true;
                    if (this.shutdown) {
                        break;
                    }
                }
                task.run();
                worker = this;
                synchronized (worker) {
                    this.runningTask = false;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void shutdownNow() {
            this.shutdown = true;
            Worker worker = this;
            synchronized (worker) {
                this.notifyAll();
                if (this.runningTask) {
                    this.workerThread.interrupt();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addTask(Runnable runnable) {
            Worker worker = this;
            synchronized (worker) {
                this.workerTaskHolder.addTask(runnable);
                this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void waitUntilTaskAvailable() {
            Worker worker = this;
            synchronized (worker) {
                while (!this.workerTaskHolder.isTaskAvailable()) {
                    if (this.shutdown) {
                        return;
                    }
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class WorkerThreadLocal {
        private final Worker worker = new Worker();
        private final WeakWorkerReference appThreadReference;

        public WorkerThreadLocal(ThreadFactory threadFactory, ReferenceQueue<Thread> gcedThreadsReferenceQueue) {
            threadFactory.newThread(this.worker).start();
            this.appThreadReference = new WeakWorkerReference(this.worker, Thread.currentThread(), gcedThreadsReferenceQueue);
        }

        public void shutdownNow() {
            this.worker.shutdownNow();
        }

        public <T> Future<T> submit(Callable<T> task) {
            FutureTask<T> ftask = new FutureTask<T>(task);
            this.worker.addTask(ftask);
            return ftask;
        }
    }

    private class ReaperThread
    implements Runnable {
        private ReaperThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            int pollCount = 0;
            while (NonstopThreadPool.this.state.get() != State.SHUTDOWN) {
                WeakWorkerReference gcedThreadReference;
                block8: {
                    gcedThreadReference = null;
                    try {
                        gcedThreadReference = (WeakWorkerReference)NonstopThreadPool.this.gcedThreadsReferenceQueue.remove(1000L);
                        if ((long)(++pollCount) != 100L) break block8;
                        HashSet deadThreads = new HashSet();
                        pollCount = 0;
                        Object object = NonstopThreadPool.this.workersLock;
                        synchronized (object) {
                            for (Map.Entry entry : NonstopThreadPool.this.workers.entrySet()) {
                                if (((Thread)entry.getKey()).isAlive()) continue;
                                ((WorkerThreadLocal)entry.getValue()).shutdownNow();
                                deadThreads.add(entry.getKey());
                            }
                            for (Thread th : deadThreads) {
                                NonstopThreadPool.this.workers.remove(th);
                            }
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                if (gcedThreadReference == null) continue;
                gcedThreadReference.getWorker().shutdownNow();
            }
        }
    }
}

