/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.partition.impl.btree.jdbm;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import jdbm.helper.Serializer;
import org.apache.directory.api.ldap.model.name.Rdn;
import org.apache.directory.api.ldap.model.schema.SchemaManager;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.xdbm.ParentIdAndRdn;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParentIdAndRdnSerializer
implements Serializer {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(ParentIdAndRdnSerializer.class);
    private static final boolean IS_DEBUG = LOG.isDebugEnabled();
    private transient SchemaManager schemaManager;

    public ParentIdAndRdnSerializer(SchemaManager schemaManager) {
        this.schemaManager = schemaManager;
    }

    @Override
    public byte[] serialize(Object object) throws IOException {
        ParentIdAndRdn parentIdAndRdn = (ParentIdAndRdn)object;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(baos);
        Rdn[] rdns = parentIdAndRdn.getRdns();
        if (rdns == null || rdns.length == 0) {
            out.writeByte(0);
        } else {
            out.writeByte(rdns.length);
            for (Rdn rdn : rdns) {
                rdn.writeExternal(out);
            }
        }
        out.writeUTF(parentIdAndRdn.getParentId());
        out.writeInt(parentIdAndRdn.getNbChildren());
        out.writeInt(parentIdAndRdn.getNbDescendants());
        out.flush();
        if (IS_DEBUG) {
            LOG.debug(">------------------------------------------------");
            LOG.debug("Serialize " + parentIdAndRdn);
        }
        return baos.toByteArray();
    }

    @Override
    public Object deserialize(byte[] bytes) throws IOException {
        ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(bytes));
        try {
            ParentIdAndRdn parentIdAndRdn = new ParentIdAndRdn();
            int nbRdns = in.readByte();
            if (nbRdns == 0) {
                parentIdAndRdn.setRdns(new Rdn[0]);
            } else {
                Rdn[] rdns = new Rdn[nbRdns];
                for (int i = 0; i < nbRdns; ++i) {
                    Rdn rdn = new Rdn(this.schemaManager);
                    rdn.readExternal(in);
                    rdns[i] = rdn;
                }
                parentIdAndRdn.setRdns(rdns);
            }
            String uuid = in.readUTF();
            parentIdAndRdn.setParentId(uuid);
            int nbChildren = in.readInt();
            int nbDescendants = in.readInt();
            parentIdAndRdn.setNbChildren(nbChildren);
            parentIdAndRdn.setNbDescendants(nbDescendants);
            return parentIdAndRdn;
        }
        catch (ClassNotFoundException cnfe) {
            LOG.error(I18n.err(I18n.ERR_134, cnfe.getLocalizedMessage()));
            throw new IOException(cnfe.getLocalizedMessage());
        }
    }
}

