/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.kerberos.codec.etypeInfo2Entry.actions;

import org.apache.directory.shared.asn1.DecoderException;
import org.apache.directory.shared.asn1.ber.grammar.GrammarAction;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.asn1.ber.tlv.Value;
import org.apache.directory.shared.kerberos.codec.etypeInfo2Entry.ETypeInfo2EntryContainer;
import org.apache.directory.shared.kerberos.components.ETypeInfo2Entry;
import org.apache.directory.shared.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StoreSalt
extends GrammarAction<ETypeInfo2EntryContainer> {
    private static final Logger LOG = LoggerFactory.getLogger(StoreSalt.class);
    private static final boolean IS_DEBUG = LOG.isDebugEnabled();

    public StoreSalt() {
        super("ETYPE-INFO2-ENTRY salt");
    }

    @Override
    public void action(ETypeInfo2EntryContainer eTypeInfo2EntryContainer) throws DecoderException {
        Value value;
        TLV tlv = eTypeInfo2EntryContainer.getCurrentTLV();
        ETypeInfo2Entry etypeInfo2Entry = eTypeInfo2EntryContainer.getETypeInfo2Entry();
        if (tlv.getLength() != 0 && (value = tlv.getValue()).getData() != null) {
            String salt = Strings.utf8ToString(value.getData());
            etypeInfo2Entry.setSalt(salt);
        }
        if (IS_DEBUG) {
            LOG.debug("salt : {}", (Object)etypeInfo2Entry.getSalt());
        }
        eTypeInfo2EntryContainer.setGrammarEndAllowed(true);
    }
}

