/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.kerberos.codec.actions;

import org.apache.directory.shared.asn1.DecoderException;
import org.apache.directory.shared.asn1.ber.Asn1Container;
import org.apache.directory.shared.asn1.ber.Asn1Decoder;
import org.apache.directory.shared.asn1.ber.grammar.GrammarAction;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.kerberos.codec.encryptionKey.EncryptionKeyContainer;
import org.apache.directory.shared.kerberos.components.EncryptionKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractReadEncryptionKey<E extends Asn1Container>
extends GrammarAction<E> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractReadEncryptionKey.class);
    private static final boolean IS_DEBUG = LOG.isDebugEnabled();

    public AbstractReadEncryptionKey(String name) {
        super(name);
    }

    protected abstract void setEncryptionKey(EncryptionKey var1, E var2);

    @Override
    public final void action(E container) throws DecoderException {
        TLV tlv = container.getCurrentTLV();
        if (tlv.getLength() == 0) {
            LOG.error(I18n.err(I18n.ERR_04066, new Object[0]));
            throw new DecoderException(I18n.err(I18n.ERR_04067, new Object[0]));
        }
        Asn1Decoder encryptionKeyDecoder = new Asn1Decoder();
        EncryptionKeyContainer encryptionKeyContainer = new EncryptionKeyContainer();
        encryptionKeyDecoder.decode(container.getStream(), encryptionKeyContainer);
        EncryptionKey encryptionKey = encryptionKeyContainer.getEncryptionKey();
        if (IS_DEBUG) {
            LOG.debug("EncryptionKey : " + encryptionKey);
        }
        this.setEncryptionKey(encryptionKey, container);
        tlv.setExpectedLength(tlv.getExpectedLength() - tlv.getLength());
        container.updateParent();
    }
}

