/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.xdbm.search.impl;

import java.util.Iterator;
import org.apache.directory.server.xdbm.Index;
import org.apache.directory.server.xdbm.IndexEntry;
import org.apache.directory.server.xdbm.Store;
import org.apache.directory.server.xdbm.search.Evaluator;
import org.apache.directory.shared.ldap.model.entry.Attribute;
import org.apache.directory.shared.ldap.model.entry.Entry;
import org.apache.directory.shared.ldap.model.filter.PresenceNode;
import org.apache.directory.shared.ldap.model.schema.AttributeType;
import org.apache.directory.shared.ldap.model.schema.SchemaManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PresenceEvaluator<ID extends Comparable<ID>>
implements Evaluator<PresenceNode, Entry, ID> {
    private final PresenceNode node;
    private final Store<Entry, ID> db;
    private final AttributeType attributeType;
    private final SchemaManager schemaManager;
    private final Index<String, Entry, ID> idx;

    public PresenceEvaluator(PresenceNode node, Store<Entry, ID> db, SchemaManager schemaManager) throws Exception {
        this.db = db;
        this.node = node;
        this.schemaManager = schemaManager;
        this.attributeType = node.getAttributeType();
        this.idx = db.hasUserIndexOn(this.attributeType) ? db.getPresenceIndex() : null;
    }

    @Override
    public PresenceNode getExpression() {
        return this.node;
    }

    public AttributeType getAttributeType() {
        return this.attributeType;
    }

    @Override
    public boolean evaluate(IndexEntry<?, Entry, ID> indexEntry) throws Exception {
        if (this.idx != null) {
            return this.idx.forward(this.attributeType.getOid(), indexEntry.getId());
        }
        Entry entry = indexEntry.getObject();
        if (null == entry) {
            entry = this.db.lookup((Comparable)indexEntry.getId());
            indexEntry.setObject(entry);
        }
        return this.evaluateEntry(entry);
    }

    @Override
    public boolean evaluateId(ID id) throws Exception {
        if (this.idx != null) {
            return this.idx.forward(this.attributeType.getOid(), id);
        }
        return this.evaluateEntry(this.db.lookup(id));
    }

    @Override
    public boolean evaluateEntry(Entry entry) throws Exception {
        if (this.db.hasSystemIndexOn(this.attributeType)) {
            return true;
        }
        Attribute attr = entry.get(this.attributeType);
        if (attr != null) {
            return true;
        }
        if (this.schemaManager.getAttributeTypeRegistry().hasDescendants(this.attributeType)) {
            Iterator<AttributeType> descendants = this.schemaManager.getAttributeTypeRegistry().descendants(this.attributeType);
            do {
                AttributeType descendant;
                if ((attr = entry.get(descendant = descendants.next())) == null) continue;
                return true;
            } while (descendants.hasNext());
        }
        return false;
    }
}

